/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.vaquaclient;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FileChooserUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VSheet {
    private VSheet() {
    }

    public static void showOptionPane(@Nullable Component component, @NotNull JOptionPane jOptionPane, @Nullable String string, @Nullable Consumer<Integer> consumer) throws HeadlessException {
        JDialog jDialog = jOptionPane.createDialog(component, string);
        if (component != null) {
            try {
                VSheet.tryShowOptionPane(jDialog, jOptionPane, consumer);
                return;
            }
            catch (HeadlessException headlessException) {
                throw headlessException;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        jDialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        jDialog.setVisible(true);
        jDialog.dispose();
        if (consumer != null) {
            consumer.accept(VSheet.getOption(jOptionPane));
        }
    }

    private static void tryShowOptionPane(@NotNull JDialog jDialog, @NotNull JOptionPane jOptionPane, @Nullable Consumer<Integer> consumer) throws HeadlessException {
        Runnable runnable;
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel != null) {
            try {
                Method method = lookAndFeel.getClass().getMethod("showOptionPaneAsSheet", JDialog.class, JOptionPane.class, Consumer.class);
                method.invoke((Object)lookAndFeel, jDialog, jOptionPane, consumer);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof UnsupportedOperationException) {
                    throw (UnsupportedOperationException)throwable;
                }
                throw new UnsupportedOperationException("Unable to display as sheet because of an internal error", throwable);
            }
            catch (Exception exception) {
                throw new UnsupportedOperationException("Unable to display as sheet because of an internal error", exception);
            }
            runnable = null;
            if (consumer != null) {
                runnable = () -> consumer.accept(VSheet.getOption(jOptionPane));
            }
        } else {
            throw new UnsupportedOperationException("Unable to display as sheet: VAqua look and feel is not installed");
        }
        VSheet.displayAsSheet(lookAndFeel, jDialog, runnable);
    }

    private static int getOption(@NotNull JOptionPane jOptionPane) {
        Object object = jOptionPane.getValue();
        if (object == null) {
            return -1;
        }
        Object[] objectArray = jOptionPane.getOptions();
        if (objectArray == null) {
            if (object instanceof Integer) {
                return (Integer)object;
            }
            return -1;
        }
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            if (!objectArray[i].equals(object)) continue;
            return i;
        }
        return -1;
    }

    public static void showOpenDialog(@Nullable Component component, @NotNull JFileChooser jFileChooser, @Nullable Consumer<Integer> consumer) throws HeadlessException {
        jFileChooser.setDialogType(0);
        VSheet.showFileChooserDialog(component, jFileChooser, consumer);
    }

    public static void showSaveDialog(@Nullable Component component, @NotNull JFileChooser jFileChooser, @Nullable Consumer<Integer> consumer) throws HeadlessException {
        jFileChooser.setDialogType(1);
        VSheet.showFileChooserDialog(component, jFileChooser, consumer);
    }

    public static void showFileChooserDialog(@Nullable Component component, @NotNull JFileChooser jFileChooser, @Nullable Consumer<Integer> consumer) throws HeadlessException {
        if (component != null) {
            try {
                VSheet.tryShowFileChooserAsSheet(component, jFileChooser, consumer);
                return;
            }
            catch (HeadlessException headlessException) {
                throw headlessException;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int n = jFileChooser.showDialog(component, null);
        if (consumer != null) {
            consumer.accept(n);
        }
    }

    private static void tryShowFileChooserAsSheet(@Nullable Component component, @NotNull JFileChooser jFileChooser, @Nullable Consumer<Integer> consumer) throws HeadlessException, UnsupportedOperationException {
        Window window;
        if (component == null || (window = VSheet.getWindow(component)) == null) {
            throw new UnsupportedOperationException("Unable to display as sheet: no owner window");
        }
        if (!window.isVisible()) {
            throw new UnsupportedOperationException("Unable to display as sheet: owner window is not visible");
        }
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel != null) {
            try {
                Method method = lookAndFeel.getClass().getMethod("showFileChooserAsSheet", Window.class, JFileChooser.class, Consumer.class);
                method.invoke((Object)lookAndFeel, window, jFileChooser, consumer);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof UnsupportedOperationException) {
                    throw (UnsupportedOperationException)throwable;
                }
                throw new UnsupportedOperationException("Unable to display as sheet because of an internal error", throwable);
            }
            catch (Exception exception) {
                throw new UnsupportedOperationException("Unable to display as sheet because of an internal error", exception);
            }
            FileChooserUI fileChooserUI = jFileChooser.getUI();
            String string = fileChooserUI.getDialogTitle(jFileChooser);
            jFileChooser.putClientProperty("AccessibleDescription", string);
            JDialog jDialog = window instanceof Frame ? new JDialog((Window)((Frame)window), string, Dialog.ModalityType.MODELESS) : new JDialog((Window)((Dialog)window), string, Dialog.ModalityType.MODELESS);
            jDialog.setComponentOrientation(jFileChooser.getComponentOrientation());
            Container container = jDialog.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)jFileChooser, "Center");
            jDialog.pack();
            jDialog.setLocationRelativeTo(window);
            FileChooserActionListener fileChooserActionListener = new FileChooserActionListener(jDialog);
            jFileChooser.addActionListener(fileChooserActionListener);
            jFileChooser.rescanCurrentDirectory();
            Runnable runnable = () -> {
                int n = fileChooserActionListener.returnValue;
                jFileChooser.removeActionListener(fileChooserActionListener);
                jDialog.getContentPane().removeAll();
                jDialog.dispose();
                if (consumer != null) {
                    consumer.accept(n);
                }
            };
            try {
                VSheet.displayAsSheet(lookAndFeel, jDialog, runnable);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                jDialog.getContentPane().removeAll();
                jDialog.dispose();
                throw unsupportedOperationException;
            }
        }
        throw new UnsupportedOperationException("Unable to display as sheet: VAqua look and feel is not installed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showDialog(@NotNull JDialog jDialog, @Nullable Runnable runnable) throws IllegalArgumentException, HeadlessException {
        if (jDialog.isVisible()) {
            throw new IllegalArgumentException("Unable to display dialog: the dialog is already visible");
        }
        Window window = jDialog.getOwner();
        if (window == null) {
            throw new IllegalArgumentException("Unable to display dialog: the dialog has no owner");
        }
        if (!window.isVisible()) {
            throw new IllegalArgumentException("Unable to display dialog: the dialog owner is not visible");
        }
        Dialog.ModalityType modalityType = jDialog.getModalityType();
        try {
            try {
                VSheet.displayAsSheet(jDialog, runnable);
            }
            catch (HeadlessException headlessException) {
                throw headlessException;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                jDialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
                jDialog.setVisible(true);
                if (runnable != null) {
                    runnable.run();
                }
            }
        }
        finally {
            jDialog.setModalityType(modalityType);
        }
    }

    public static void displayAsSheet(@NotNull Window window, @Nullable Runnable runnable) throws UnsupportedOperationException {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel == null) {
            throw new UnsupportedOperationException("Unable to display as sheet: VAqua look and feel is not installed");
        }
        VSheet.displayAsSheet(lookAndFeel, window, runnable);
    }

    private static void displayAsSheet(@NotNull LookAndFeel lookAndFeel, @NotNull Window window, @Nullable Runnable runnable) {
        try {
            Method method = lookAndFeel.getClass().getMethod("displayAsSheet", Window.class, Runnable.class);
            method.invoke((Object)lookAndFeel, window, runnable);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string = lookAndFeel.getClass().getName();
            if (!string.contains("VAqua")) {
                throw new UnsupportedOperationException("Unable to display as sheet: VAqua look and feel is not installed");
            }
            throw new UnsupportedOperationException("Unable to display as sheet because of an internal error", noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof UnsupportedOperationException) {
                throw (UnsupportedOperationException)throwable;
            }
            throw new UnsupportedOperationException("Unable to display as sheet because of an internal error", throwable);
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("Unable to display as sheet because of an internal error", exception);
        }
    }

    @Nullable
    private static Window getWindow(@NotNull Component component) {
        if (component instanceof Window) {
            return (Window)component;
        }
        return SwingUtilities.getWindowAncestor(component);
    }

    private static class FileChooserActionListener
    implements ActionListener {
        @NotNull
        private final JDialog d;
        int returnValue = -1;

        public FileChooserActionListener(@NotNull JDialog jDialog) {
            this.d = jDialog;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ApproveSelection")) {
                this.returnValue = 0;
                this.d.setVisible(false);
            } else if (string.equals("CancelSelection")) {
                this.returnValue = 1;
                this.d.setVisible(false);
            }
        }
    }
}

