/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.vaquaclient;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public class VAquaClient {
    private VAquaClient() {
    }

    @NotNull
    public static String getReleaseName() {
        return VAquaClient.getStringResource("RELEASE.txt");
    }

    @NotNull
    public static String getBuildID() {
        return VAquaClient.getStringResource("BUILD.txt");
    }

    public static void showVersion() {
        System.err.println("VAquaClient: release " + VAquaClient.getReleaseName() + ", build " + VAquaClient.getBuildID());
    }

    public static boolean isVAquaInstalled() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        return lookAndFeel != null && lookAndFeel.getClass().getName().startsWith("org.violetlib.aqua.");
    }

    public static boolean isAquaInstalled() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel != null) {
            String string = lookAndFeel.getClass().getName();
            return string.startsWith("com.apple.laf.") || string.startsWith("org.violetlib.aqua.");
        }
        return false;
    }

    @NotNull
    private static String getStringResource(@NotNull String string) {
        InputStream inputStream = VAquaClient.class.getResourceAsStream(string);
        if (inputStream != null) {
            try {
                int n;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                StringBuilder stringBuilder = new StringBuilder();
                while ((n = bufferedReader.read()) >= 0) {
                    stringBuilder.append((char)n);
                }
                return stringBuilder.toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return "Unknown";
    }
}

