/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.vaquaclient;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class JTableWithMargins
extends JTable {
    public static final String INSET_VIEW_MARGIN_KEY = "Aqua.insetViewMargin";
    public static final String INSET_VIEW_VERTICAL_MARGIN_KEY = "Aqua.insetViewVerticalMargin";
    private final TableLayoutManager layoutManager = new TableLayoutManager(this);
    private final MyPropertyChangeListener propertyChangeListener = new MyPropertyChangeListener();
    private int margin;
    private int verticalMargin;

    public JTableWithMargins() {
        this.initialize();
    }

    public JTableWithMargins(TableModel tableModel) {
        super(tableModel);
        this.initialize();
    }

    public JTableWithMargins(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        this.initialize();
    }

    public JTableWithMargins(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        this.initialize();
    }

    public JTableWithMargins(int n, int n2) {
        super(n, n2);
        this.initialize();
    }

    public JTableWithMargins(Vector<? extends Vector> vector, Vector<?> vector2) {
        super(vector, vector2);
        this.initialize();
    }

    public JTableWithMargins(@NotNull Object[][] objectArray, @NotNull Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.initialize();
    }

    private void initialize() {
        this.addPropertyChangeListener(this.propertyChangeListener);
        this.updateMargins();
    }

    private void updateMargins() {
        int n = this.getSpecifiedMargin();
        int n2 = this.getSpecifiedVerticalMargin();
        if (n != this.margin || n2 != this.verticalMargin) {
            this.installMargin(n, n2);
        }
    }

    private void installMargin(int n, int n2) {
        this.margin = n;
        this.verticalMargin = n2;
        this.revalidate();
        this.repaint();
        JTableHeader jTableHeader = this.getTableHeader();
        if (jTableHeader != null) {
            jTableHeader.revalidate();
            jTableHeader.repaint();
        }
        this.marginChanged(this.margin, this.verticalMargin);
    }

    protected void marginChanged(int n, int n2) {
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        if (this.isMinimumSizeSet()) {
            return dimension;
        }
        return this.fixSize(dimension);
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.isPreferredSizeSet()) {
            return dimension;
        }
        return this.fixSize(dimension);
    }

    @Override
    @NotNull
    public Dimension getMaximumSize() {
        Dimension dimension = super.getMaximumSize();
        if (this.isMaximumSizeSet()) {
            return dimension;
        }
        return this.fixSize(dimension);
    }

    @NotNull
    private Dimension fixSize(@NotNull Dimension dimension) {
        int n = this.getSpecifiedMargin();
        int n2 = this.getSpecifiedVerticalMargin();
        if (n == 0 && n2 == 0) {
            return dimension;
        }
        if (this.isVAquaInsetView()) {
            return dimension;
        }
        return new Dimension(dimension.width + 2 * n, dimension.height + 2 * n2);
    }

    private int getSpecifiedMargin() {
        Object object = this.getClientProperty(INSET_VIEW_MARGIN_KEY);
        return Math.max(0, object instanceof Integer ? (Integer)object : 0);
    }

    private int getSpecifiedVerticalMargin() {
        Object object = this.getClientProperty(INSET_VIEW_VERTICAL_MARGIN_KEY);
        return Math.max(0, object instanceof Integer ? (Integer)object : 0);
    }

    private boolean isVAquaInsetView() {
        Object object = this.getClientProperty("JTable.viewStyle");
        if (!"inset".equals(object)) {
            return false;
        }
        String string = System.getProperty("os.version");
        return string.startsWith("10.16") || !string.startsWith("10.");
    }

    @Override
    public void doLayout() {
        this.layoutManager.doLayout();
    }

    @Override
    public void sizeColumnsToFit(int n) {
        this.layoutManager.sizeColumnsToFit(n);
    }

    @Override
    public int columnAtPoint(@NotNull Point point) {
        if (this.margin > 0) {
            point = new Point(point.x - this.margin, point.y);
        }
        return super.columnAtPoint(point);
    }

    @Override
    @NotNull
    public Rectangle getCellRect(int n, int n2, boolean bl) {
        Rectangle rectangle = super.getCellRect(n, n2, bl);
        if ((this.margin > 0 || this.verticalMargin > 0) && this.columnModel.getColumnCount() > 0) {
            rectangle.x += this.margin;
            rectangle.y += this.verticalMargin;
        }
        return rectangle;
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new TableHeaderWithMargins(this.columnModel);
    }

    private static class TableLayoutManager {
        private final JTableWithMargins table;

        public TableLayoutManager(JTableWithMargins jTableWithMargins) {
            this.table = jTableWithMargins;
        }

        public void doLayout() {
            TableColumn tableColumn = this.getResizingColumn();
            if (tableColumn == null) {
                this.setWidthsFromPreferredWidths(false);
            } else {
                int n = this.viewIndexForColumn(tableColumn);
                int n2 = this.getAvailableWidth() - this.table.getColumnModel().getTotalColumnWidth();
                this.accommodateDelta(n, n2);
                n2 = this.getAvailableWidth() - this.table.getColumnModel().getTotalColumnWidth();
                if (n2 != 0) {
                    tableColumn.setWidth(tableColumn.getWidth() + n2);
                }
                this.setWidthsFromPreferredWidths(true);
            }
        }

        public void sizeColumnsToFit(int n) {
            if (n == -1) {
                this.setWidthsFromPreferredWidths(false);
            } else if (this.table.getAutoResizeMode() == 0) {
                TableColumn tableColumn = this.table.getColumnModel().getColumn(n);
                tableColumn.setPreferredWidth(tableColumn.getWidth());
            } else {
                int n2 = this.getAvailableWidth() - this.table.getColumnModel().getTotalColumnWidth();
                this.accommodateDelta(n, n2);
                this.setWidthsFromPreferredWidths(true);
            }
        }

        public int getAvailableWidth() {
            return this.table.getWidth() - 2 * this.table.margin;
        }

        public int getPreferredAvailableWidth() {
            return this.table.getPreferredSize().width - 2 * this.table.margin;
        }

        private TableColumn getResizingColumn() {
            JTableHeader jTableHeader = this.table.getTableHeader();
            return jTableHeader == null ? null : jTableHeader.getResizingColumn();
        }

        private void setWidthsFromPreferredWidths(final boolean bl) {
            int n = this.getAvailableWidth();
            int n2 = this.getPreferredAvailableWidth();
            int n3 = !bl ? n : n2;
            final TableColumnModel tableColumnModel = this.table.getColumnModel();
            Resizable3 resizable3 = new Resizable3(){

                @Override
                public int getElementCount() {
                    return tableColumnModel.getColumnCount();
                }

                @Override
                public int getLowerBoundAt(int n) {
                    return tableColumnModel.getColumn(n).getMinWidth();
                }

                @Override
                public int getUpperBoundAt(int n) {
                    return tableColumnModel.getColumn(n).getMaxWidth();
                }

                @Override
                public int getMidPointAt(int n) {
                    if (!bl) {
                        return tableColumnModel.getColumn(n).getPreferredWidth();
                    }
                    return tableColumnModel.getColumn(n).getWidth();
                }

                @Override
                public void setSizeAt(int n, int n2) {
                    if (!bl) {
                        tableColumnModel.getColumn(n2).setWidth(n);
                    } else {
                        tableColumnModel.getColumn(n2).setPreferredWidth(n);
                    }
                }
            };
            this.adjustSizes((long)n3, resizable3, bl);
        }

        private void accommodateDelta(int n, int n2) {
            int n3;
            int n4 = this.table.getColumnCount();
            int n5 = n;
            switch (this.table.getAutoResizeMode()) {
                case 1: {
                    n3 = Math.min(++n5 + 1, n4);
                    break;
                }
                case 2: {
                    ++n5;
                    n3 = n4;
                    break;
                }
                case 3: {
                    n5 = n4 - 1;
                    n3 = n5 + 1;
                    break;
                }
                case 4: {
                    n5 = 0;
                    n3 = n4;
                    break;
                }
                default: {
                    return;
                }
            }
            final int n6 = n5;
            final int n7 = n3;
            final TableColumnModel tableColumnModel = this.table.getColumnModel();
            Resizable3 resizable3 = new Resizable3(){

                @Override
                public int getElementCount() {
                    return n7 - n6;
                }

                @Override
                public int getLowerBoundAt(int n) {
                    return tableColumnModel.getColumn(n + n6).getMinWidth();
                }

                @Override
                public int getUpperBoundAt(int n) {
                    return tableColumnModel.getColumn(n + n6).getMaxWidth();
                }

                @Override
                public int getMidPointAt(int n) {
                    return tableColumnModel.getColumn(n + n6).getWidth();
                }

                @Override
                public void setSizeAt(int n, int n2) {
                    tableColumnModel.getColumn(n2 + n6).setWidth(n);
                }
            };
            int n8 = 0;
            for (int i = n5; i < n3; ++i) {
                TableColumn tableColumn = this.table.getColumnModel().getColumn(i);
                int n9 = tableColumn.getWidth();
                n8 += n9;
            }
            this.adjustSizes((long)(n8 + n2), resizable3, false);
        }

        private void adjustSizes(long l, final Resizable3 resizable3, boolean bl) {
            int n;
            int n2 = resizable3.getElementCount();
            long l2 = 0L;
            for (n = 0; n < n2; ++n) {
                l2 += (long)resizable3.getMidPointAt(n);
            }
            if (l == l2) {
                for (n = 0; n < n2; ++n) {
                    int n3 = resizable3.getMidPointAt(n);
                    resizable3.setSizeAt(n3, n);
                }
                return;
            }
            Resizable2 resizable2 = l < l2 == !bl ? new Resizable2(){

                @Override
                public int getElementCount() {
                    return resizable3.getElementCount();
                }

                @Override
                public int getLowerBoundAt(int n) {
                    return resizable3.getLowerBoundAt(n);
                }

                @Override
                public int getUpperBoundAt(int n) {
                    return resizable3.getMidPointAt(n);
                }

                @Override
                public void setSizeAt(int n, int n2) {
                    resizable3.setSizeAt(n, n2);
                }
            } : new Resizable2(){

                @Override
                public int getElementCount() {
                    return resizable3.getElementCount();
                }

                @Override
                public int getLowerBoundAt(int n) {
                    return resizable3.getMidPointAt(n);
                }

                @Override
                public int getUpperBoundAt(int n) {
                    return resizable3.getUpperBoundAt(n);
                }

                @Override
                public void setSizeAt(int n, int n2) {
                    resizable3.setSizeAt(n, n2);
                }
            };
            this.adjustSizes(l, resizable2, !bl);
        }

        private void adjustSizes(long l, Resizable2 resizable2, boolean bl) {
            int n;
            long l2 = 0L;
            long l3 = 0L;
            for (n = 0; n < resizable2.getElementCount(); ++n) {
                l2 += (long)resizable2.getLowerBoundAt(n);
                l3 += (long)resizable2.getUpperBoundAt(n);
            }
            if (bl) {
                l = Math.min(Math.max(l2, l), l3);
            }
            for (n = 0; n < resizable2.getElementCount(); ++n) {
                int n2;
                int n3 = resizable2.getLowerBoundAt(n);
                int n4 = resizable2.getUpperBoundAt(n);
                if (l2 == l3) {
                    n2 = n3;
                } else {
                    double d = (double)(l - l2) / (double)(l3 - l2);
                    n2 = (int)Math.round((double)n3 + d * (double)(n4 - n3));
                }
                resizable2.setSizeAt(n2, n);
                l -= (long)n2;
                l2 -= (long)n3;
                l3 -= (long)n4;
            }
        }

        private int viewIndexForColumn(TableColumn tableColumn) {
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
                if (tableColumnModel.getColumn(i) != tableColumn) continue;
                return i;
            }
            return -1;
        }

        private static interface Resizable3
        extends Resizable2 {
            public int getMidPointAt(int var1);
        }

        private static interface Resizable2 {
            public int getElementCount();

            public int getLowerBoundAt(int var1);

            public int getUpperBoundAt(int var1);

            public void setSizeAt(int var1, int var2);
        }
    }

    private class MyPropertyChangeListener
    implements PropertyChangeListener {
        private MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == null || string.equals(JTableWithMargins.INSET_VIEW_MARGIN_KEY) || string.equals(JTableWithMargins.INSET_VIEW_VERTICAL_MARGIN_KEY)) {
                JTableWithMargins.this.updateMargins();
            }
        }
    }

    public static class TableHeaderWithMargins
    extends JTableHeader {
        public TableHeaderWithMargins(@NotNull TableColumnModel tableColumnModel) {
            super(tableColumnModel);
        }

        @Override
        public int columnAtPoint(Point point) {
            int n = this.getLeftMargin();
            if (n > 0) {
                point = new Point(point.x - n, point.y);
            }
            return super.columnAtPoint(point);
        }

        @Override
        public Rectangle getHeaderRect(int n) {
            Rectangle rectangle = super.getHeaderRect(n);
            int n2 = this.columnModel.getColumnCount() - 1;
            if (n2 >= 0) {
                int n3 = this.getLeftMargin();
                rectangle.x += n3;
            }
            return rectangle;
        }

        private int getLeftMargin() {
            if (this.table instanceof JTableWithMargins) {
                JTableWithMargins jTableWithMargins = (JTableWithMargins)this.table;
                return jTableWithMargins.margin;
            }
            return 0;
        }
    }
}

