/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.vaquaclient;

import java.awt.Color;
import java.lang.reflect.Method;
import java.util.Map;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppearanceSupport {
    @Nullable
    private static Class<?> vAppearancesClass;
    private static boolean hasFailed;
    private static boolean hasWarned;

    private AppearanceSupport() {
    }

    @Nullable
    public static Boolean isEffectiveAppearanceDark() {
        Object object = AppearanceSupport.getEffectiveAppearance();
        return object != null ? AppearanceSupport.isDark(object) : null;
    }

    @Nullable
    public static Color getEffectiveAppearanceSystemColor(@NotNull String string) {
        Object object = AppearanceSupport.getEffectiveAppearance();
        return object != null ? AppearanceSupport.getSystemColor(object, string) : null;
    }

    @Nullable
    private static Boolean isDark(@NotNull Object object) {
        try {
            Method method = AppearanceSupport.findInterfaceMethod(object.getClass().getMethod("isDark", new Class[0]));
            return (Boolean)method.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    private static Color getSystemColor(@NotNull Object object, @NotNull String string) {
        try {
            Map<?, ?> map = AppearanceSupport.getColors(object);
            return map != null ? (Color)map.get(string) : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    private static Map<?, ?> getColors(@NotNull Object object) {
        try {
            Method method = AppearanceSupport.findInterfaceMethod(object.getClass().getMethod("getColors", new Class[0]));
            return (Map)method.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @NotNull
    private static Method findInterfaceMethod(@Nullable Method method) throws NoSuchMethodException {
        if (method != null) {
            for (Class<?> clazz : method.getDeclaringClass().getInterfaces()) {
                try {
                    return clazz.getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
        }
        throw new NoSuchMethodException();
    }

    @Nullable
    private static Object getEffectiveAppearance() {
        Class<?> clazz = AppearanceSupport.getVAppearances();
        return clazz != null ? AppearanceSupport.getEffectiveAppearance(clazz) : null;
    }

    @Nullable
    private static Object getEffectiveAppearance(@NotNull Class<?> clazz) {
        try {
            Method method = clazz.getMethod("getApplicationEffectiveAppearance", new Class[0]);
            return method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    private static Class<?> getVAppearances() {
        if (vAppearancesClass != null || hasFailed) {
            return vAppearancesClass;
        }
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel != null) {
            if (lookAndFeel.getClass().getName().equals("org.violetlib.aqua.AquaLookAndFeel")) {
                ClassLoader classLoader = lookAndFeel.getClass().getClassLoader();
                try {
                    vAppearancesClass = Class.forName("org.violetlib.vappearances.VAppearances", true, classLoader);
                    System.err.println("Loaded VAppearances using VAqua class loader");
                    return vAppearancesClass;
                }
                catch (Exception exception) {
                    System.err.println("Did not find VAppearances using VAqua class loader");
                    hasFailed = true;
                    return null;
                }
            }
            try {
                vAppearancesClass = Class.forName("org.violetlib.vappearances.VAppearances");
                System.err.println("Loaded VAppearances because look and feel is " + lookAndFeel.getName());
                return vAppearancesClass;
            }
            catch (Exception exception) {
                System.err.println("Did not find VAppearances using application class loader");
                hasFailed = true;
                return null;
            }
        }
        if (!hasWarned) {
            hasWarned = true;
            System.err.println("VAquaClient: attempt to access VAppearances before a LAF has been installed");
            new Exception().printStackTrace();
        }
        return null;
    }
}

