/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.aqua.ComboBoxConfiguration;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.GradientConfiguration;
import org.violetlib.jnr.aqua.GroupBoxConfiguration;
import org.violetlib.jnr.aqua.IndeterminateProgressIndicatorConfiguration;
import org.violetlib.jnr.aqua.ListBoxConfiguration;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.aqua.ProgressIndicatorConfiguration;
import org.violetlib.jnr.aqua.ScrollBarConfiguration;
import org.violetlib.jnr.aqua.ScrollColumnSizerConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.aqua.SliderLayoutConfiguration;
import org.violetlib.jnr.aqua.SliderThumbLayoutConfiguration;
import org.violetlib.jnr.aqua.SpinnerArrowsConfiguration;
import org.violetlib.jnr.aqua.SplitPaneDividerConfiguration;
import org.violetlib.jnr.aqua.TableColumnHeaderConfiguration;
import org.violetlib.jnr.aqua.TextFieldConfiguration;
import org.violetlib.jnr.aqua.TitleBarConfiguration;
import org.violetlib.jnr.aqua.ToolBarItemWellConfiguration;
import org.violetlib.jnr.aqua.impl.AquaNativeSegmentedControlPainter;
import org.violetlib.jnr.aqua.impl.AquaUIPainterBase;
import org.violetlib.jnr.aqua.impl.NativeSupport;
import org.violetlib.jnr.aqua.impl.SliderTickConfiguration;
import org.violetlib.jnr.aqua.impl.TitleBarLayoutInfo;
import org.violetlib.jnr.aqua.impl.ViewRendererDescriptions;
import org.violetlib.jnr.impl.BasicRenderer;
import org.violetlib.jnr.impl.JNRPlatformUtils;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.RendererDebugInfo;
import org.violetlib.jnr.impl.RendererDescription;
import org.violetlib.vappearances.VAppearance;

public class AquaNativePainter
extends AquaUIPainterBase
implements AquaUIPainter {
    protected static final int NSRoundedBezelStyle = 1;
    protected static final int NSRegularSquareBezelStyle = 2;
    protected static final int NSThickSquareBezelStyle = 3;
    protected static final int NSThickerSquareBezelStyle = 4;
    protected static final int NSDisclosureBezelStyle = 5;
    protected static final int NSShadowlessSquareBezelStyle = 6;
    protected static final int NSCircularBezelStyle = 7;
    protected static final int NSTexturedSquareBezelStyle = 8;
    protected static final int NSHelpButtonBezelStyle = 9;
    protected static final int NSSmallSquareBezelStyle = 10;
    protected static final int NSTexturedRoundedBezelStyle = 11;
    protected static final int NSRoundRectBezelStyle = 12;
    protected static final int NSRecessedBezelStyle = 13;
    protected static final int NSRoundedDisclosureBezelStyle = 14;
    protected static final int NSInlineBezelStyle = 15;
    protected static final int NSCircularBezelStyle_Toolbar = 1007;
    protected static final int NSTexturedRoundedBezelStyle_Toolbar = 1011;
    protected static final int NSMomentaryLightButton = 0;
    protected static final int NSPushOnPushOffButton = 1;
    protected static final int NSToggleButton = 2;
    protected static final int NSSwitchButton = 3;
    protected static final int NSRadioButton = 4;
    protected static final int NSMomentaryChangeButton = 5;
    protected static final int NSOnOffButton = 6;
    protected static final int NSMomentaryPushInButton = 7;
    protected static final int NSAcceleratorButton = 8;
    protected static final int NSMultiLevelAcceleratorButton = 9;
    protected static final int NSGradientNone = 0;
    protected static final int NSGradientConcaveWeak = 1;
    protected static final int NSGradientConcaveStrong = 2;
    protected static final int NSGradientConvexWeak = 3;
    protected static final int NSGradientConvexStrong = 4;
    protected static final int TextFieldNormal = 0;
    protected static final int TextFieldRound = 1;
    protected static final int TextFieldSearch = 2;
    protected static final int TextFieldSearchWithCancel = 3;
    protected static final int TextFieldSearchWithMenu = 4;
    protected static final int TextFieldSearchWithMenuAndCancel = 5;
    protected static final int TextFieldRound_Toolbar = 1001;
    protected static final int TextFieldSearch_Toolbar = 1002;
    protected static final int TextFieldSearchWithCancel_Toolbar = 1003;
    protected static final int TextFieldSearchWithMenu_Toolbar = 1004;
    protected static final int TextFieldSearchWithMenuAndCancel_Toolbar = 1005;
    protected static final int NSSegmentStyleAutomatic = 0;
    protected static final int NSSegmentStyleRounded = 1;
    protected static final int NSSegmentStyleTexturedRounded = 2;
    protected static final int NSSegmentStyleRoundRect = 3;
    protected static final int NSSegmentStyleTexturedSquare = 4;
    protected static final int NSSegmentStyleCapsule = 5;
    protected static final int NSSegmentStyleSmallSquare = 6;
    protected static final int NSSegmentStyleSeparated = 8;
    protected static final int NSSegmentStyleSeparated_Rounded = 80;
    protected static final int NSSegmentStyleSeparated_Textured = 81;
    protected static final int NSSegmentStyleSlider = 82;
    protected static final int NSSegmentStyleTexturedSquare_Toolbar = 1004;
    protected static final int NSSegmentStyleSeparated_Toolbar = 1081;
    protected static final int NSSegmentSwitchTrackingSelectOne = 0;
    protected static final int NSSegmentSwitchTrackingSelectAny = 1;
    protected static final int NSNoTitle = 0;
    protected static final int NSAboveTop = 1;
    protected static final int NSAtTop = 2;
    protected static final int NSBelowTop = 3;
    protected static final int NSAboveBottom = 4;
    protected static final int NSAtBottom = 5;
    protected static final int NSBelowBottom = 6;
    protected static final int NSLinearSlider = 0;
    protected static final int NSCircularSlider = 1;
    protected static final int NSLinearSliderRightToLeft = 1002;
    protected static final int NSLinearSliderUpsideDown = 1003;
    protected static final int NSTickMarkBelow = 0;
    protected static final int NSTickMarkAbove = 1;
    protected static final int NSTickMarkLeft = 1;
    protected static final int NSTickMarkRight = 0;
    protected static final int NSSplitViewDividerStyleThick = 1;
    protected static final int NSSplitViewDividerStyleThin = 2;
    protected static final int NSSplitViewDividerStylePaneSplitter = 3;
    protected static final int ActiveState = 0;
    protected static final int InactiveState = 1;
    protected static final int DisabledState = 2;
    protected static final int PressedState = 3;
    protected static final int DefaultState = 4;
    protected static final int RolloverState = 5;
    protected static final int DisabledInactiveState = 6;
    protected static final int DocumentWindowType = 0;
    protected static final int UtilityWindowType = 1;
    protected static final int LegacyScrollBar = 0;
    protected static final int OverlayScrollBar = 1;
    protected static final int RolloverOverlayScrollBar = 2;
    @Nullable
    protected static TitleBarLayoutInfo titleBarLayoutInfo;
    @NotNull
    private static final ViewRendererDescriptions rendererDescriptions;
    @NotNull
    protected final AquaNativeSegmentedControlPainter segmentedControlPainter = new AquaNativeSegmentedControlPainter();

    @NotNull
    public static TitleBarLayoutInfo getTitleBarLayoutInfo() {
        if (titleBarLayoutInfo == null) {
            titleBarLayoutInfo = AquaNativePainter.obtainTitleBarLayoutInfo();
        }
        return titleBarLayoutInfo;
    }

    public AquaNativePainter() {
        super(rendererDescriptions);
    }

    @Override
    @NotNull
    public AquaNativePainter copy() {
        return new AquaNativePainter();
    }

    @Override
    public void configureAppearance(@NotNull VAppearance vAppearance) {
        super.configureAppearance(vAppearance);
        AquaNativePainter.configureNativeAppearance(vAppearance);
    }

    @Override
    @NotNull
    protected Renderer getButtonRenderer(@NotNull ButtonConfiguration buttonConfiguration) {
        AquaUIPainter.ButtonWidget buttonWidget = buttonConfiguration.getButtonWidget();
        AquaUIPainter.State state = buttonConfiguration.getState();
        AquaUIPainter.ButtonState buttonState = buttonConfiguration.getButtonState();
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_TOOLBAR_ITEM) {
            if (buttonState != AquaUIPainter.ButtonState.ON) {
                return NULL_RENDERER;
            }
            ToolBarItemWellConfiguration toolBarItemWellConfiguration = new ToolBarItemWellConfiguration(state, false);
            return this.getToolBarItemWellRenderer(toolBarItemWellConfiguration);
        }
        RendererDescription rendererDescription = rendererDescriptions.getButtonRendererDescription(buttonConfiguration);
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL) {
            int n = AquaNativePainter.toState(state);
            BasicRenderer basicRenderer = (nArray, n2, n3, f, f2) -> AquaNativePainter.nativePaintColorWell(nArray, n2, n3, f, f2, n);
            return Renderer.create(basicRenderer, rendererDescription);
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_RECESSED && !this.shouldPaintRecessedBackground(state, buttonState)) {
            return NULL_RENDERER;
        }
        AquaUIPainter.ButtonWidget buttonWidget2 = this.toCanonicalButtonStyle(buttonWidget);
        int n = AquaNativePainter.toSize(buttonConfiguration.getSize());
        int n4 = AquaNativePainter.toState(state);
        int n5 = this.toButtonValue(buttonState);
        int n6 = this.toButtonType(buttonWidget2);
        int n9 = this.toBezelStyle(buttonWidget2);
        int n10 = this.toUILayoutDirection(buttonConfiguration.getLayoutDirection());
        BasicRenderer basicRenderer = (nArray, n7, n8, f, f2) -> AquaNativePainter.nativePaintButton(nArray, n7, n8, f, f2, n6, n9, n, n4, buttonConfiguration.isFocused(), n5, n10);
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getScrollColumnSizerRenderer(@NotNull ScrollColumnSizerConfiguration scrollColumnSizerConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getScrollColumnSizerRendererDescription(scrollColumnSizerConfiguration);
        return Renderer.createCompositeRenderer(new Renderer[0]);
    }

    @Override
    @NotNull
    protected Renderer getScrollBarRenderer(@NotNull ScrollBarConfiguration scrollBarConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getScrollBarRendererDescription(scrollBarConfiguration);
        AquaUIPainter.ScrollBarWidget scrollBarWidget = scrollBarConfiguration.getWidget();
        if (scrollBarWidget == AquaUIPainter.ScrollBarWidget.OVERLAY || scrollBarWidget == AquaUIPainter.ScrollBarWidget.OVERLAY_ROLLOVER) {
            throw new UnsupportedOperationException();
        }
        int n = AquaNativePainter.toScrollBarType(scrollBarWidget);
        int n2 = AquaNativePainter.toSize(scrollBarConfiguration.getSize());
        int n3 = AquaNativePainter.toState(scrollBarConfiguration.getState());
        BasicRenderer basicRenderer = (nArray, n4, n5, f, f2) -> AquaNativePainter.nativePaintScrollBar(nArray, n4, n5, f, f2, n, n2, n3, scrollBarConfiguration.getThumbPosition(), scrollBarConfiguration.getThumbExtent());
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getToolBarItemWellRenderer(@NotNull ToolBarItemWellConfiguration toolBarItemWellConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getToolBarItemWellRendererDescription(toolBarItemWellConfiguration);
        int n = AquaNativePainter.toState(toolBarItemWellConfiguration.getState());
        BasicRenderer basicRenderer = (nArray, n2, n3, f, f2) -> AquaNativePainter.nativePaintToolBarItemWell(nArray, n2, n3, f, f2, n, toolBarItemWellConfiguration.isFrameOnly());
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getGroupBoxRenderer(@NotNull GroupBoxConfiguration groupBoxConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getGroupBoxRendererDescription(groupBoxConfiguration);
        int n = AquaNativePainter.toState(groupBoxConfiguration.getState());
        BasicRenderer basicRenderer = (nArray, n2, n3, f, f2) -> AquaNativePainter.nativePaintGroupBox(nArray, n2, n3, f, f2, 0, n, groupBoxConfiguration.isFrameOnly());
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getListBoxRenderer(@NotNull ListBoxConfiguration listBoxConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getListBoxRendererDescription(listBoxConfiguration);
        int n = AquaNativePainter.toState(listBoxConfiguration.getState());
        BasicRenderer basicRenderer = (nArray, n2, n3, f, f2) -> AquaNativePainter.nativePaintListBox(nArray, n2, n3, f, f2, n, listBoxConfiguration.isFocused(), listBoxConfiguration.isFrameOnly());
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getTextFieldRenderer(@NotNull TextFieldConfiguration textFieldConfiguration) {
        int n;
        RendererDescription rendererDescription = rendererDescriptions.getTextFieldRendererDescription(textFieldConfiguration);
        switch (textFieldConfiguration.getWidget()) {
            case TEXT_FIELD: {
                n = 0;
                break;
            }
            case TEXT_FIELD_ROUND: {
                n = 1;
                break;
            }
            case TEXT_FIELD_SEARCH: {
                n = 2;
                break;
            }
            case TEXT_FIELD_SEARCH_WITH_CANCEL: {
                n = 3;
                break;
            }
            case TEXT_FIELD_SEARCH_WITH_MENU: {
                n = 4;
                break;
            }
            case TEXT_FIELD_SEARCH_WITH_MENU_AND_CANCEL: {
                n = 5;
                break;
            }
            case TEXT_FIELD_ROUND_TOOLBAR: {
                n = 1001;
                break;
            }
            case TEXT_FIELD_SEARCH_TOOLBAR: {
                n = 1002;
                break;
            }
            case TEXT_FIELD_SEARCH_WITH_CANCEL_TOOLBAR: {
                n = 1003;
                break;
            }
            case TEXT_FIELD_SEARCH_WITH_MENU_TOOLBAR: {
                n = 1004;
                break;
            }
            case TEXT_FIELD_SEARCH_WITH_MENU_AND_CANCEL_TOOLBAR: {
                n = 1005;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        int n2 = AquaNativePainter.toSize(textFieldConfiguration.getSize());
        int n3 = AquaNativePainter.toState(textFieldConfiguration.getState());
        BasicRenderer basicRenderer = (nArray, n4, n5, f, f2) -> AquaNativePainter.nativePaintTextField(nArray, n4, n5, f, f2, n2, n3, n);
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getComboBoxButtonRenderer(@NotNull ComboBoxConfiguration comboBoxConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getComboBoxRendererDescription(comboBoxConfiguration);
        int n = AquaNativePainter.toSize(comboBoxConfiguration.getSize());
        int n2 = AquaNativePainter.toState(comboBoxConfiguration.getState());
        int n3 = this.toComboBoxType(comboBoxConfiguration.getWidget());
        int n4 = this.toBezelStyle(comboBoxConfiguration.getWidget());
        int n5 = this.toUILayoutDirection(comboBoxConfiguration.getLayoutDirection());
        BasicRenderer basicRenderer = (nArray, n6, n7, f, f2) -> AquaNativePainter.nativePaintComboBox(nArray, n6, n7, f, f2, n3, n, n2, n4, n5);
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getPopupButtonRenderer(@NotNull PopupButtonConfiguration popupButtonConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getPopupButtonRendererDescription(popupButtonConfiguration);
        AquaUIPainter.PopupButtonWidget popupButtonWidget = popupButtonConfiguration.getPopupButtonWidget();
        boolean bl = popupButtonConfiguration.isPopUp();
        int n = AquaNativePainter.toSize(popupButtonConfiguration.getSize());
        int n2 = AquaNativePainter.toState(popupButtonConfiguration.getState());
        int n3 = this.toUILayoutDirection(popupButtonConfiguration.getLayoutDirection());
        int n4 = this.toBezelStyle(popupButtonWidget);
        BasicRenderer basicRenderer = (nArray, n5, n6, f, f2) -> AquaNativePainter.nativePaintPopUpButton(nArray, n5, n6, f, f2, bl, n, n2, n4, n3);
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getTitleBarRenderer(@NotNull TitleBarConfiguration titleBarConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getTitleBarRendererDescription(titleBarConfiguration);
        int n = AquaNativePainter.toWindowType(titleBarConfiguration.getWidget());
        int n2 = this.toActiveState(titleBarConfiguration.getTitleBarState());
        int n3 = AquaNativePainter.toState(titleBarConfiguration.getCloseButtonState());
        int n4 = AquaNativePainter.toState(titleBarConfiguration.getMinimizeButtonState());
        int n5 = AquaNativePainter.toState(titleBarConfiguration.getResizeButtonState());
        TitleBarConfiguration.ResizeAction resizeAction = titleBarConfiguration.getResizeAction();
        boolean bl = resizeAction == TitleBarConfiguration.ResizeAction.FULL_SCREEN_ENTER || resizeAction == TitleBarConfiguration.ResizeAction.FULL_SCREEN_EXIT;
        BasicRenderer basicRenderer = (nArray, n6, n7, f, f2) -> AquaNativePainter.nativePaintTitleBar(nArray, n6, n7, f, f2, n, n2, n3, n4, n5, bl, titleBarConfiguration.isDirty());
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getIndeterminateProgressIndicatorRenderer(@NotNull IndeterminateProgressIndicatorConfiguration indeterminateProgressIndicatorConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getIndeterminateProgressIndicatorRendererDescription(indeterminateProgressIndicatorConfiguration);
        boolean bl = indeterminateProgressIndicatorConfiguration.getWidget() == AquaUIPainter.ProgressWidget.INDETERMINATE_SPINNER;
        AquaUIPainter.Size size = indeterminateProgressIndicatorConfiguration.getSize();
        if (bl && size != AquaUIPainter.Size.SMALL) {
            size = AquaUIPainter.Size.LARGE;
        }
        int n = AquaNativePainter.toSize(size);
        int n2 = AquaNativePainter.toState(indeterminateProgressIndicatorConfiguration.getState());
        int n3 = this.toOrientation(indeterminateProgressIndicatorConfiguration.getOrientation());
        BasicRenderer basicRenderer = (nArray, n4, n5, f, f2) -> AquaNativePainter.nativePaintIndeterminateProgressIndicator(nArray, n4, n5, f, f2, n, n2, n3, bl, indeterminateProgressIndicatorConfiguration.getAnimationFrame());
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getProgressIndicatorRenderer(@NotNull ProgressIndicatorConfiguration progressIndicatorConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getProgressIndicatorRendererDescription(progressIndicatorConfiguration);
        boolean bl = progressIndicatorConfiguration.getWidget() == AquaUIPainter.ProgressWidget.SPINNER;
        AquaUIPainter.Size size = progressIndicatorConfiguration.getSize();
        if (bl && size != AquaUIPainter.Size.SMALL) {
            size = AquaUIPainter.Size.LARGE;
        }
        int n = AquaNativePainter.toSize(progressIndicatorConfiguration.getSize());
        int n2 = this.toActiveState(progressIndicatorConfiguration.getState());
        int n3 = this.toOrientation(progressIndicatorConfiguration.getOrientation());
        BasicRenderer basicRenderer = (nArray, n4, n5, f, f2) -> AquaNativePainter.nativePaintProgressIndicator(nArray, n4, n5, f, f2, n, n2, n3, progressIndicatorConfiguration.getValue());
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getSliderRenderer(@NotNull SliderConfiguration sliderConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getSliderRendererDescription(sliderConfiguration);
        int n = JNRPlatformUtils.getPlatformVersion();
        AquaUIPainter.SliderWidget sliderWidget = sliderConfiguration.getWidget();
        AquaUIPainter.Size size = sliderConfiguration.getSize();
        if (sliderConfiguration.getSize() == AquaUIPainter.Size.MINI && n < 101400) {
            size = AquaUIPainter.Size.SMALL;
        }
        if (sliderWidget == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL || sliderWidget == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL_RIGHT_TO_LEFT) {
            if (this.h >= this.w) {
                this.h = Math.max(0, this.w - 1);
            }
        } else if (sliderWidget == AquaUIPainter.SliderWidget.SLIDER_VERTICAL || sliderWidget == AquaUIPainter.SliderWidget.SLIDER_UPSIDE_DOWN) {
            if (this.w >= this.h) {
                this.w = Math.max(0, this.h - 1);
            }
            this.forceVertical = true;
        }
        int n2 = this.toSliderType(sliderWidget);
        int n3 = AquaNativePainter.toSize(size);
        int n4 = AquaNativePainter.toState(sliderConfiguration.getState());
        int n7 = this.toTickMarkPosition(sliderConfiguration.getTickMarkPosition());
        BasicRenderer basicRenderer = (nArray, n5, n6, f, f2) -> AquaNativePainter.nativePaintSlider(nArray, n5, n6, f, f2, n2, n3, n4, sliderConfiguration.isFocused(), sliderConfiguration.getValue(), sliderConfiguration.getNumberOfTickMarks(), n7);
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @NotNull
    protected Shape getSliderThumbOutline(@NotNull Rectangle2D rectangle2D, @NotNull SliderThumbLayoutConfiguration sliderThumbLayoutConfiguration) {
        SliderLayoutConfiguration sliderLayoutConfiguration = sliderThumbLayoutConfiguration.getSliderLayoutConfiguration();
        double d = sliderThumbLayoutConfiguration.getThumbPosition();
        double d2 = rectangle2D.getX();
        double d3 = rectangle2D.getY();
        double d4 = rectangle2D.getWidth();
        double d5 = rectangle2D.getHeight();
        AquaUIPainter.SliderWidget sliderWidget = sliderLayoutConfiguration.getWidget();
        if (sliderWidget == AquaUIPainter.SliderWidget.SLIDER_CIRCULAR) {
            int n = this.toSliderType(sliderWidget);
            int n2 = AquaNativePainter.toSize(sliderLayoutConfiguration.getSize());
            int n3 = this.toTickMarkPosition(sliderLayoutConfiguration.getTickMarkPosition());
            float[] fArray = new float[4];
            int n4 = (int)Math.ceil(d4);
            int n5 = (int)Math.ceil(d5);
            AquaNativePainter.nativeGetSliderThumbBounds(fArray, n4, n5, n, n2, d, sliderLayoutConfiguration.getNumberOfTickMarks(), n3);
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            float f4 = fArray[3];
            return new Rectangle2D.Double(f, f2, f3, f4);
        }
        return super.getOutline(rectangle2D, sliderThumbLayoutConfiguration);
    }

    @Override
    @NotNull
    protected Renderer getSliderThumbRenderer(@NotNull SliderConfiguration sliderConfiguration) {
        return NULL_RENDERER;
    }

    @Override
    @NotNull
    protected Renderer getSliderTickRenderer(@NotNull SliderTickConfiguration sliderTickConfiguration) {
        return NULL_RENDERER;
    }

    @Override
    @NotNull
    protected Renderer getSpinnerArrowsRenderer(@NotNull SpinnerArrowsConfiguration spinnerArrowsConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getSpinnerArrowsRendererDescription(spinnerArrowsConfiguration);
        int n = AquaNativePainter.toSize(spinnerArrowsConfiguration.getSize());
        int n2 = AquaNativePainter.toState(spinnerArrowsConfiguration.getState());
        BasicRenderer basicRenderer = (nArray, n3, n4, f, f2) -> AquaNativePainter.nativePaintSpinnerArrows(nArray, n3, n4, f, f2, n, n2, spinnerArrowsConfiguration.isFocused(), spinnerArrowsConfiguration.isPressedTop());
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getSplitPaneDividerRenderer(@NotNull SplitPaneDividerConfiguration splitPaneDividerConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getSplitPaneDividerRendererDescription(splitPaneDividerConfiguration);
        int n = this.toDividerType(splitPaneDividerConfiguration.getWidget());
        int n2 = AquaNativePainter.toState(splitPaneDividerConfiguration.getState());
        int n3 = this.toOrientation(splitPaneDividerConfiguration.getOrientation());
        BasicRenderer basicRenderer = (nArray, n4, n5, f, f2) -> AquaNativePainter.nativePaintSplitPaneDivider(nArray, n4, n5, f, f2, n, n2, n3, splitPaneDividerConfiguration.getThickness());
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @Override
    @NotNull
    protected Renderer getGradientRenderer(@NotNull GradientConfiguration gradientConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getGradientRendererDescription(gradientConfiguration);
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected Renderer getSegmentedButtonRenderer(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration) {
        return this.segmentedControlPainter.createSegmentedButtonRenderer(segmentedButtonConfiguration);
    }

    @Override
    @NotNull
    public Renderer getTableColumnHeaderRenderer(@NotNull TableColumnHeaderConfiguration tableColumnHeaderConfiguration) {
        RendererDescription rendererDescription = rendererDescriptions.getTableColumnHeaderRendererDescription(tableColumnHeaderConfiguration);
        int n = AquaNativePainter.toState(tableColumnHeaderConfiguration.getState());
        int n2 = this.toDirection(tableColumnHeaderConfiguration.getSortArrowDirection());
        int n3 = this.toUILayoutDirection(tableColumnHeaderConfiguration.getLayoutDirection());
        BasicRenderer basicRenderer = (nArray, n4, n5, f, f2) -> AquaNativePainter.nativePaintTableColumnHeader(nArray, n4, n5, f, f2, n, n2, tableColumnHeaderConfiguration.isSelected(), n3);
        return Renderer.create(basicRenderer, rendererDescription);
    }

    @Override
    @Nullable
    public RendererDebugInfo getRendererDebugInfo(@NotNull Configuration configuration, int n, int n2, int n3) {
        if (configuration instanceof SegmentedButtonConfiguration) {
            SegmentedButtonConfiguration segmentedButtonConfiguration = (SegmentedButtonConfiguration)configuration;
            return this.segmentedControlPainter.getSegmentedButtonRendererDebugInfo(segmentedButtonConfiguration, n, n2, n3);
        }
        return null;
    }

    protected static int toSize(@NotNull AquaUIPainter.Size size) {
        switch (size) {
            case MINI: {
                return 0;
            }
            case SMALL: {
                return 1;
            }
            case REGULAR: {
                return 2;
            }
            case LARGE: {
                return 3;
            }
        }
        throw new UnsupportedOperationException();
    }

    protected static int toState(@NotNull AquaUIPainter.State state) {
        switch (state) {
            case ACTIVE: {
                return 0;
            }
            case INACTIVE: {
                return 1;
            }
            case DISABLED: {
                return 2;
            }
            case DISABLED_INACTIVE: {
                return 6;
            }
            case PRESSED: {
                return 3;
            }
            case ACTIVE_DEFAULT: {
                return 4;
            }
            case ROLLOVER: {
                return 5;
            }
        }
        throw new UnsupportedOperationException();
    }

    protected int toActiveState(@NotNull AquaUIPainter.State state) {
        switch (state) {
            case ACTIVE: {
                return 0;
            }
            case INACTIVE: 
            case DISABLED: 
            case DISABLED_INACTIVE: {
                return 1;
            }
        }
        return 0;
    }

    protected int toDirection(@NotNull AquaUIPainter.ColumnSortArrowDirection columnSortArrowDirection) {
        switch (columnSortArrowDirection) {
            case NONE: {
                return 0;
            }
            case UP: {
                return 1;
            }
            case DOWN: {
                return 2;
            }
        }
        throw new IllegalArgumentException();
    }

    protected int toDirection(@NotNull AquaUIPainter.Direction direction) {
        switch (direction) {
            case NONE: {
                return 0;
            }
            case UP: {
                return 1;
            }
            case DOWN: {
                return 2;
            }
            case LEFT: {
                return 3;
            }
            case RIGHT: {
                return 4;
            }
        }
        throw new IllegalArgumentException();
    }

    protected int toOrientation(@NotNull AquaUIPainter.Orientation orientation) {
        switch (orientation) {
            case HORIZONTAL: {
                return 0;
            }
            case VERTICAL: {
                return 1;
            }
        }
        throw new UnsupportedOperationException();
    }

    public int getSideInset(@NotNull AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget) {
        int n = AquaNativePainter.toSegmentedStyle(segmentedButtonWidget);
        return this.getSideInsetFromSegmentStyle(n);
    }

    public int getDividerWidth(@NotNull AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget) {
        int n = AquaNativePainter.toSegmentedStyle(segmentedButtonWidget);
        return this.getDividerWidthFromSegmentStyle(n);
    }

    protected int getSideInsetFromSegmentStyle(int n) {
        switch (n) {
            case 2: 
            case 4: {
                return 1;
            }
            case 6: {
                return 1;
            }
        }
        return 3;
    }

    protected int getDividerWidthFromSegmentStyle(int n) {
        switch (n) {
            case 2: {
                return 2;
            }
            case 6: {
                return 1;
            }
        }
        return 1;
    }

    protected static int toSegmentedStyle(@NotNull AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget) {
        switch (segmentedButtonWidget) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: {
                return 1;
            }
            case BUTTON_SEGMENTED_INSET: {
                return 3;
            }
            case BUTTON_SEGMENTED_SCURVE: {
                return 5;
            }
            case BUTTON_SEGMENTED_TEXTURED: {
                return 4;
            }
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR_ICONS: {
                return 1004;
            }
            case BUTTON_SEGMENTED_TOOLBAR: {
                return 2;
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                return 6;
            }
            case BUTTON_SEGMENTED_SEPARATED: {
                return 80;
            }
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: {
                return 81;
            }
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR_ICONS: {
                return 1081;
            }
            case BUTTON_SEGMENTED_SLIDER: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR_ICONS: {
                return 1;
            }
        }
        throw new UnsupportedOperationException();
    }

    protected int toBezelStyle(@NotNull AquaUIPainter.ComboBoxWidget comboBoxWidget) {
        switch (comboBoxWidget) {
            case BUTTON_COMBO_BOX: {
                return 1;
            }
            case BUTTON_COMBO_BOX_CELL: {
                return 0;
            }
            case BUTTON_COMBO_BOX_TEXTURED: {
                return 11;
            }
            case BUTTON_COMBO_BOX_TEXTURED_TOOLBAR: {
                return 1011;
            }
        }
        throw new UnsupportedOperationException();
    }

    protected int toBezelStyle(@NotNull AquaUIPainter.PopupButtonWidget popupButtonWidget) {
        switch (popupButtonWidget) {
            case BUTTON_POP_DOWN: 
            case BUTTON_POP_UP: {
                return 1;
            }
            case BUTTON_POP_DOWN_CELL: 
            case BUTTON_POP_UP_CELL: {
                return 0;
            }
            case BUTTON_POP_DOWN_BEVEL: 
            case BUTTON_POP_UP_BEVEL: {
                return 2;
            }
            case BUTTON_POP_DOWN_ROUND_RECT: 
            case BUTTON_POP_UP_ROUND_RECT: {
                return 12;
            }
            case BUTTON_POP_DOWN_RECESSED: 
            case BUTTON_POP_UP_RECESSED: {
                return 13;
            }
            case BUTTON_POP_DOWN_TEXTURED: 
            case BUTTON_POP_UP_TEXTURED: {
                return 11;
            }
            case BUTTON_POP_DOWN_TEXTURED_TOOLBAR: 
            case BUTTON_POP_UP_TEXTURED_TOOLBAR: {
                return 1011;
            }
            case BUTTON_POP_DOWN_GRADIENT: 
            case BUTTON_POP_UP_GRADIENT: {
                return 10;
            }
            case BUTTON_POP_DOWN_SQUARE: 
            case BUTTON_POP_UP_SQUARE: {
                return 6;
            }
        }
        throw new UnsupportedOperationException();
    }

    protected int toBezelStyle(@NotNull AquaUIPainter.ButtonWidget buttonWidget) {
        int n = JNRPlatformUtils.getPlatformVersion();
        switch (buttonWidget) {
            case BUTTON_PUSH: {
                return 1;
            }
            case BUTTON_BEVEL: {
                return 6;
            }
            case BUTTON_BEVEL_ROUND: {
                return 2;
            }
            case BUTTON_CHECK_BOX: {
                return 3;
            }
            case BUTTON_RADIO: {
                return 4;
            }
            case BUTTON_DISCLOSURE: {
                return 14;
            }
            case BUTTON_DISCLOSURE_TRIANGLE: {
                return 5;
            }
            case BUTTON_HELP: {
                return 9;
            }
            case BUTTON_GRADIENT: {
                return 10;
            }
            case BUTTON_RECESSED: {
                return 13;
            }
            case BUTTON_INLINE: {
                return 15;
            }
            case BUTTON_ROUNDED_RECT: {
                return 12;
            }
            case BUTTON_TEXTURED: {
                return 11;
            }
            case BUTTON_TEXTURED_TOOLBAR: 
            case BUTTON_TEXTURED_TOOLBAR_ICONS: {
                return 1011;
            }
            case BUTTON_ROUND: {
                return 7;
            }
            case BUTTON_ROUND_TEXTURED: 
            case BUTTON_ROUND_TEXTURED_TOOLBAR: {
                return n >= 101100 ? 1007 : 7;
            }
        }
        throw new UnsupportedOperationException();
    }

    protected int toButtonType(@NotNull AquaUIPainter.ButtonWidget buttonWidget) {
        switch (buttonWidget) {
            case BUTTON_CHECK_BOX: {
                return 3;
            }
            case BUTTON_RADIO: {
                return 4;
            }
            case BUTTON_DISCLOSURE: 
            case BUTTON_DISCLOSURE_TRIANGLE: 
            case BUTTON_RECESSED: 
            case BUTTON_INLINE: {
                return 1;
            }
        }
        return 0;
    }

    protected int toButtonValue(@NotNull AquaUIPainter.ButtonState buttonState) {
        switch (buttonState) {
            case ON: {
                return 1;
            }
            case MIXED: {
                return 2;
            }
        }
        return 0;
    }

    protected static int toTracking(@NotNull AquaUIPainter.SwitchTracking switchTracking) {
        if (switchTracking == AquaUIPainter.SwitchTracking.SELECT_ANY) {
            return 1;
        }
        return 0;
    }

    protected int toUILayoutDirection(@NotNull AquaUIPainter.UILayoutDirection uILayoutDirection) {
        switch (uILayoutDirection) {
            case LEFT_TO_RIGHT: {
                return 0;
            }
            case RIGHT_TO_LEFT: {
                return 1;
            }
        }
        return 0;
    }

    protected int toSliderType(@NotNull AquaUIPainter.SliderWidget sliderWidget) {
        switch (sliderWidget) {
            case SLIDER_HORIZONTAL: {
                return 0;
            }
            case SLIDER_HORIZONTAL_RIGHT_TO_LEFT: {
                return 1002;
            }
            case SLIDER_VERTICAL: {
                return 0;
            }
            case SLIDER_UPSIDE_DOWN: {
                return 1003;
            }
            case SLIDER_CIRCULAR: {
                return 1;
            }
        }
        return 0;
    }

    protected int toTickMarkPosition(@NotNull AquaUIPainter.TickMarkPosition tickMarkPosition) {
        switch (tickMarkPosition) {
            case LEFT: {
                return 1;
            }
            case RIGHT: {
                return 0;
            }
            case BELOW: {
                return 0;
            }
            case ABOVE: {
                return 1;
            }
        }
        return 1;
    }

    protected int toDividerType(@NotNull AquaUIPainter.DividerWidget dividerWidget) {
        switch (dividerWidget) {
            case PANE_SPLITTER: {
                return 3;
            }
            case THIN_DIVIDER: {
                return 2;
            }
            case THICK_DIVIDER: {
                return 1;
            }
        }
        return 3;
    }

    protected int toComboBoxType(@NotNull AquaUIPainter.ComboBoxWidget comboBoxWidget) {
        switch (comboBoxWidget) {
            default: {
                return 0;
            }
            case BUTTON_COMBO_BOX_CELL: 
        }
        return 2;
    }

    protected static int toWindowType(@NotNull AquaUIPainter.TitleBarWidget titleBarWidget) {
        switch (titleBarWidget) {
            case DOCUMENT_WINDOW: {
                return 0;
            }
            case UTILITY_WINDOW: {
                return 1;
            }
        }
        throw new UnsupportedOperationException();
    }

    protected static int toScrollBarType(@NotNull AquaUIPainter.ScrollBarWidget scrollBarWidget) {
        switch (scrollBarWidget) {
            case LEGACY: {
                return 0;
            }
            case OVERLAY: {
                return 1;
            }
            case OVERLAY_ROLLOVER: {
                return 2;
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    private static TitleBarLayoutInfo obtainTitleBarLayoutInfo() {
        Rectangle[] rectangleArray = AquaNativePainter.obtainTitleBarButtonLayoutInfo(AquaUIPainter.TitleBarWidget.DOCUMENT_WINDOW);
        Rectangle[] rectangleArray2 = AquaNativePainter.obtainTitleBarButtonLayoutInfo(AquaUIPainter.TitleBarWidget.UTILITY_WINDOW);
        return new TitleBarLayoutInfo(rectangleArray, rectangleArray2);
    }

    @NotNull
    private static Rectangle[] obtainTitleBarButtonLayoutInfo(@NotNull AquaUIPainter.TitleBarWidget titleBarWidget) {
        int n = AquaNativePainter.toWindowType(titleBarWidget);
        int[] nArray = AquaNativePainter.nativeGetTitleBarButtonLayoutInfo(n);
        if (nArray != null) {
            Rectangle rectangle = new Rectangle(nArray[0], nArray[1], nArray[2], nArray[3]);
            Rectangle rectangle2 = new Rectangle(nArray[4], nArray[5], nArray[6], nArray[7]);
            Rectangle rectangle3 = new Rectangle(nArray[8], nArray[9], nArray[10], nArray[11]);
            return new Rectangle[]{rectangle, rectangle2, rectangle3};
        }
        int n2 = titleBarWidget == AquaUIPainter.TitleBarWidget.DOCUMENT_WINDOW ? 7 : 5;
        int n3 = titleBarWidget == AquaUIPainter.TitleBarWidget.DOCUMENT_WINDOW ? 6 : 5;
        int n4 = titleBarWidget == AquaUIPainter.TitleBarWidget.DOCUMENT_WINDOW ? 14 : 13;
        int n5 = titleBarWidget == AquaUIPainter.TitleBarWidget.DOCUMENT_WINDOW ? 16 : 14;
        int n6 = 3;
        Rectangle rectangle = new Rectangle(n2, n6, n4, n5);
        Rectangle rectangle4 = new Rectangle(n2 += n4 + n3, n6, n4, n5);
        Rectangle rectangle5 = new Rectangle(n2 += n4 + n3, n6, n4, n5);
        return new Rectangle[]{rectangle, rectangle4, rectangle5};
    }

    @NotNull
    public String toString() {
        return "NSView";
    }

    private static native void nativePaintIndeterminateProgressIndicator(int[] var0, int var1, int var2, float var3, float var4, int var5, int var6, int var7, boolean var8, int var9);

    private static native void nativePaintProgressIndicator(int[] var0, int var1, int var2, float var3, float var4, int var5, int var6, int var7, double var8);

    private static native void nativePaintButton(int[] var0, int var1, int var2, float var3, float var4, int var5, int var6, int var7, int var8, boolean var9, int var10, int var11);

    private static native void nativePaintColorWell(int[] var0, int var1, int var2, float var3, float var4, int var5);

    private static native void nativePaintToolBarItemWell(int[] var0, int var1, int var2, float var3, float var4, int var5, boolean var6);

    private static native void nativePaintGroupBox(int[] var0, int var1, int var2, float var3, float var4, int var5, int var6, boolean var7);

    private static native void nativePaintListBox(int[] var0, int var1, int var2, float var3, float var4, int var5, boolean var6, boolean var7);

    private static native void nativePaintTextField(int[] var0, int var1, int var2, float var3, float var4, int var5, int var6, int var7);

    private static native void nativePaintComboBox(int[] var0, int var1, int var2, float var3, float var4, int var5, int var6, int var7, int var8, int var9);

    private static native void nativePaintPopUpButton(int[] var0, int var1, int var2, float var3, float var4, boolean var5, int var6, int var7, int var8, int var9);

    private static native void nativePaintTableColumnHeader(int[] var0, int var1, int var2, float var3, float var4, int var5, int var6, boolean var7, int var8);

    private static native void nativePaintSlider(int[] var0, int var1, int var2, float var3, float var4, int var5, int var6, int var7, boolean var8, double var9, int var11, int var12);

    private static native void nativePaintSpinnerArrows(int[] var0, int var1, int var2, float var3, float var4, int var5, int var6, boolean var7, boolean var8);

    private static native void nativePaintSplitPaneDivider(int[] var0, int var1, int var2, float var3, float var4, int var5, int var6, int var7, int var8);

    private static native void nativePaintTitleBar(int[] var0, int var1, int var2, float var3, float var4, int var5, int var6, int var7, int var8, int var9, boolean var10, boolean var11);

    private static native void nativePaintScrollBar(int[] var0, int var1, int var2, float var3, float var4, int var5, int var6, int var7, float var8, float var9);

    private static native int[] nativeGetTitleBarButtonLayoutInfo(int var0);

    private static native void nativeGetSliderThumbBounds(float[] var0, float var1, float var2, int var3, int var4, double var5, int var7, int var8);

    public static native boolean isLayerPaintingEnabled();

    public static native void setLayerPaintingEnabled(boolean var0);

    public static native int nativeDetermineSliderRenderingVersion();

    private static native int nativeDetermineButtonFixedHeight(int var0, int var1, int var2);

    private static native int nativeDetermineButtonFixedWidth(int var0, int var1, int var2);

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                NativeSupport.load();
                return null;
            }
        });
        rendererDescriptions = new ViewRendererDescriptions();
    }
}

