/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.io.File;
import java.io.Serializable;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.fc.AquaFileIcon;
import org.violetlib.aqua.fc.AquaFileSystemView;
import org.violetlib.aqua.fc.ArrayUtil;
import org.violetlib.aqua.fc.ConcurrentDispatcher;
import org.violetlib.aqua.fc.FileAttributes;
import org.violetlib.aqua.fc.FileInfo;
import org.violetlib.aqua.fc.IteratorEnumeration;
import org.violetlib.aqua.fc.OSXCollator;
import org.violetlib.aqua.fc.OSXFile;
import org.violetlib.aqua.fc.SequentialDispatcher;
import org.violetlib.aqua.fc.Worker;

public class FileSystemTreeModel
implements TreeModel {
    protected static final boolean DEBUG = false;
    public static final int INVALID = 0;
    public static final int VALIDATING = 1;
    public static final int VALID = 2;
    protected EventListenerList listenerList = new EventListenerList();
    @NotNull
    private final JFileChooser fileChooser;
    @NotNull
    private final FileAttributes fileAttributes;
    protected Node root;
    private Comparator nodeComparator;
    private boolean isAutoValidate = true;
    private boolean isResolveAliasesToFiles = true;
    private boolean isResolveFileLabels = true;
    private static Collator collator;
    private SequentialDispatcher fileInfoDispatcher;
    private ConcurrentDispatcher directoryDispatcher;
    private SequentialDispatcher aliasResolutionDispatcher;

    public FileSystemTreeModel(JFileChooser jFileChooser) {
        this.fileChooser = jFileChooser;
        this.fileAttributes = new FileAttributes(jFileChooser);
        File file = new File("/");
        FileSystemView fileSystemView = jFileChooser.getFileSystemView();
        if (fileSystemView instanceof AquaFileSystemView) {
            AquaFileSystemView aquaFileSystemView = (AquaFileSystemView)fileSystemView;
            file = aquaFileSystemView.getComputer();
        }
        this.root = new RootNode(file);
        this.fileInfoDispatcher = new SequentialDispatcher();
        this.directoryDispatcher = new ConcurrentDispatcher();
        this.aliasResolutionDispatcher = new SequentialDispatcher();
    }

    public void dispatchAliasResolution(Runnable runnable) {
        this.aliasResolutionDispatcher.dispatch(runnable);
    }

    private void clear() {
        int n = this.root.getChildCount();
        if (n > 0) {
            int[] nArray = new int[n];
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = i;
                objectArray[i] = this.root.getChildAt(0);
                this.root.remove(0);
            }
            this.fireTreeNodesRemoved(this, new Object[]{this.root}, nArray, objectArray);
        }
    }

    public void dispose() {
        this.stopValidation();
        this.clear();
    }

    public Node getPrototypeValue() {
        return new Node(new File(AquaUtils.getProperty("user.home")), "Prototype", false);
    }

    @Override
    public Object getChild(Object object, int n) {
        return ((Node)object).getChildAt(n);
    }

    @Override
    public int getChildCount(Object object) {
        return ((Node)object).getChildCount();
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        return ((Node)object).getIndex((Node)object2);
    }

    private int getIndexOfChildForFile(Node node, File file) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            Node node2 = (Node)node.getChildAt(i);
            if (!node2.getFile().equals(file) && !node2.getResolvedFile().equals(file)) continue;
            return i;
        }
        return -1;
    }

    private Comparator getNodeComparator() {
        if (this.nodeComparator == null) {
            this.nodeComparator = UIManager.getBoolean("FileChooser.orderByType") ? new FoldersFirstComparator() : new ByNameComparator();
        }
        return this.nodeComparator;
    }

    public static Collator getCollator(Component component) {
        if (collator == null) {
            Locale locale = Locale.getDefault();
            if (component != null) {
                try {
                    locale = component.getLocale();
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    // empty catch block
                }
            }
            collator = new OSXCollator(locale);
        }
        return collator;
    }

    private int getInsertionIndexForNode(Node node, Node node2) {
        int n;
        Comparator comparator = this.getNodeComparator();
        for (n = 0; n < node.getChildCount(); ++n) {
            if (comparator.compare(node.getChildAt(n), node2) < 0) continue;
            return n;
        }
        return n;
    }

    private void insertNodeInto(Node node, Node node2, int n) {
        node2.insert(node, n);
        int[] nArray = new int[]{n};
        this.fireTreeNodesInserted(this, node2.getPath(), nArray, new Object[]{node});
    }

    @Override
    public Node getRoot() {
        return this.root;
    }

    private AquaFileSystemView getFileSystemView() {
        FileSystemView fileSystemView = this.fileChooser.getFileSystemView();
        if (fileSystemView instanceof AquaFileSystemView) {
            return (AquaFileSystemView)fileSystemView;
        }
        return AquaFileSystemView.getAquaFileSystemView();
    }

    protected Node createNode(File file) {
        Node node;
        boolean bl;
        File file2 = null;
        int n = OSXFile.getFileType(file);
        boolean bl2 = false;
        boolean bl3 = this.getFileSystemView().isHiddenFile(file);
        boolean bl4 = bl = n == 2;
        if (bl) {
            file2 = OSXFile.resolveAlias(file, false);
            bl2 = file2.isDirectory();
            if (!this.isResolveAliasesToFiles() && !bl2) {
                bl = false;
                file2 = file;
            }
        } else {
            file2 = file;
            bl2 = n == 1;
        }
        boolean bl5 = this.fileChooser.isTraversable(file2);
        if (bl) {
            if (bl2) {
                node = new AliasDirectoryNode(file, file2, bl3);
                node.setTraversable(bl5);
            } else {
                node = new AliasNode(file, file2, bl3);
            }
        } else if (bl2) {
            node = new DirectoryNode(file, bl3);
            node.setTraversable(bl5);
        } else {
            node = new Node(file, bl3);
        }
        return node;
    }

    public TreePath toPath(File file, TreePath treePath) {
        Object object;
        int n;
        AquaFileSystemView aquaFileSystemView;
        if ((file = OSXFile.getAbsoluteFile(file)).equals((aquaFileSystemView = this.getFileSystemView()).getComputer())) {
            return new TreePath(this.getRoot());
        }
        LinkedList<File> linkedList = new LinkedList<File>();
        File file2 = file;
        boolean bl = false;
        do {
            if (!(bl |= (file2 = aquaFileSystemView.canonicalize(file2)).exists())) continue;
            linkedList.addFirst(file2);
        } while (!aquaFileSystemView.isRoot(file2) && (file2 = bl ? aquaFileSystemView.getParentDirectory(file2) : file2.getParentFile()) != null);
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        linkedList2.add(this.getRoot());
        int n2 = 0;
        if (treePath != null) {
            block1: for (n = linkedList.size() - 1; n >= 0; --n) {
                object = (File)linkedList.get(n);
                for (int i = treePath.getPathCount() - 1; i >= 1; --i) {
                    Node node = (Node)treePath.getPathComponent(i);
                    if (!node.getResolvedFile().equals(object) && !node.getFile().equals(object)) continue;
                    for (int j = 1; j <= i; ++j) {
                        linkedList2.add(treePath.getPathComponent(j));
                    }
                    n2 = n + 1;
                    break block1;
                }
            }
        }
        for (n = n2; n < linkedList.size() && ((Node)(object = (Node)linkedList2.getLast())).getAllowsChildren(); ++n) {
            File file3;
            File file4 = (File)linkedList.get(n);
            int n3 = this.getIndexOfChildForFile((Node)object, file4);
            if (n3 == -1 && !(file3 = OSXFile.resolve(file4)).equals(file4)) {
                n3 = this.getIndexOfChildForFile((Node)object, file3);
            }
            if (n3 == -1) {
                Node node = this.createNode(file4);
                this.insertNodeInto(node, (Node)object, this.getInsertionIndexForNode((Node)object, node));
                object = node;
            } else {
                object = (Node)((Node)object).getChildAt(n3);
            }
            linkedList2.add(object);
        }
        return new TreePath(linkedList2.toArray());
    }

    public TreePath toPath0(File file) {
        file = OSXFile.getAbsoluteFile(file);
        LinkedList<File> linkedList = new LinkedList<File>();
        AquaFileSystemView aquaFileSystemView = this.getFileSystemView();
        File file2 = file;
        boolean bl = false;
        do {
            boolean bl2 = bl = bl || file2.exists();
            if (!bl) continue;
            linkedList.addFirst(file2);
        } while (!((FileSystemView)aquaFileSystemView).isRoot(file2) && (file2 = bl ? ((FileSystemView)aquaFileSystemView).getParentDirectory(file2) : file2.getParentFile()) != null);
        LinkedList<Node> linkedList2 = new LinkedList<Node>();
        Node node = this.getRoot();
        for (int i = 0; i < linkedList.size() && !node.isLeaf() && !node.isAlias(); ++i) {
            linkedList2.add(node);
            File file3 = (File)linkedList.get(i);
            int n = this.getIndexOfChildForFile(node, file3);
            if (n == -1) {
                Node node2 = this.createNode(file3);
                this.insertNodeInto(node2, node, this.getInsertionIndexForNode(node, node2));
                node = node2;
                continue;
            }
            node = (Node)node.getChildAt(n);
        }
        linkedList2.add(node);
        return new TreePath(linkedList2.toArray());
    }

    @Override
    public boolean isLeaf(Object object) {
        return ((Node)object).isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public void setAutoValidate(boolean bl) {
        this.isAutoValidate = bl;
    }

    public boolean isAutoValidate() {
        return this.isAutoValidate;
    }

    public void setResolveAliasesToFiles(boolean bl) {
        if (this.isResolveAliasesToFiles != bl) {
            this.isResolveAliasesToFiles = bl;
            this.invalidateAll();
        }
    }

    public boolean isResolveAliasesToFiles() {
        return this.isResolveAliasesToFiles;
    }

    public void invalidatePath(TreePath treePath) {
        if (treePath != null) {
            for (int i = 0; i < treePath.getPathCount(); ++i) {
                Node node = (Node)treePath.getPathComponent(i);
                node.invalidateChildren();
            }
            if (treePath.getPathComponent(0) != this.root) {
                this.root.invalidateChildren();
            }
        }
    }

    public void invalidateAll() {
        this.root.invalidateTree();
    }

    public void stopValidation() {
        this.root.stopValidationSubtree();
        this.aliasResolutionDispatcher.stop();
        this.fileInfoDispatcher.stop();
        this.directoryDispatcher.stop();
    }

    public void lazyInvalidatePath(TreePath treePath) {
        if (treePath != null && this.isAutoValidate) {
            this.root.lazyInvalidateChildren();
            if (treePath.getPathComponent(0) != this.root) {
                ((Node)treePath.getPathComponent(0)).lazyInvalidateChildren();
            }
            if (treePath.getPathCount() > 1) {
                ((Node)treePath.getPathComponent(treePath.getPathCount() - 1)).lazyInvalidateChildren();
                if (treePath.getPathCount() > 2) {
                    ((Node)treePath.getPathComponent(treePath.getPathCount() - 2)).lazyInvalidateChildren();
                }
            }
        }
    }

    public void validatePath(TreePath treePath) {
        for (int i = 0; i < treePath.getPathCount(); ++i) {
            Node node = (Node)treePath.getPathComponent(i);
            node.validateChildren();
        }
        if (treePath.getPathComponent(0) != this.root) {
            this.root.validateChildren();
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(TreeModelListener.class, treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(TreeModelListener.class, treeModelListener);
    }

    protected void fireTreeNodeChanged(Node node) {
        Node node2 = (Node)node.getParent();
        if (node2 != null) {
            this.fireTreeNodesChanged(this, node2.getPath(), new int[]{node2.getIndex(node)}, new Object[]{node});
        }
    }

    protected void fireTreeNodesChanged(TreeModel treeModel, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent((Object)treeModel, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesChanged(treeModelEvent);
        }
    }

    protected void fireTreeNodesInserted(TreeModel treeModel, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent((Object)treeModel, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesInserted(treeModelEvent);
        }
    }

    protected void fireTreeNodesRemoved(TreeModel treeModel, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent((Object)treeModel, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesRemoved(treeModelEvent);
        }
    }

    protected void fireTreeStructureChanged(TreeModel treeModel, Object[] objectArray) {
        Object[] objectArray2 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray2.length - 2; i >= 0; i -= 2) {
            if (objectArray2[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent((Object)treeModel, objectArray);
            }
            ((TreeModelListener)objectArray2[i + 1]).treeStructureChanged(treeModelEvent);
        }
    }

    private void fireTreeStructureChanged(TreeModel treeModel, TreePath treePath) {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent((Object)treeModel, treePath);
            }
            ((TreeModelListener)objectArray[i + 1]).treeStructureChanged(treeModelEvent);
        }
    }

    private boolean accept(FileInfo fileInfo) {
        File file = fileInfo.getFile();
        if (this.fileChooser.getDialogType() == 1) {
            return false;
        }
        if (!this.fileChooser.accept(file)) {
            return false;
        }
        File file2 = fileInfo.getResolvedFile();
        if (OSXFile.isVirtualFile(file2)) {
            return this.fileChooser.isFileSelectionEnabled();
        }
        int n = OSXFile.getFileType(file2);
        if (n == 1) {
            return this.fileChooser.isDirectorySelectionEnabled();
        }
        if (n == 0) {
            return this.fileChooser.isFileSelectionEnabled();
        }
        return false;
    }

    private class RootNode
    extends DirectoryNode {
        public RootNode(File file) {
            super(file, false);
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public String toString() {
            return "Root#" + this.hashCode();
        }

        @Override
        protected long getDirectoryTTL() {
            return 1000L;
        }

        @Override
        protected File[] getFiles() {
            LinkedList<File> linkedList = new LinkedList<File>();
            File[] fileArray = FileSystemTreeModel.this.getFileSystemView().getRoots();
            for (int i = 0; i < fileArray.length; ++i) {
                linkedList.add(fileArray[i]);
            }
            return linkedList.toArray(new File[linkedList.size()]);
        }

        @Override
        public void validateChildren() {
            super.validateChildren();
        }

        @Override
        public Icon getIcon() {
            this.validateInfo();
            return UIManager.getIcon("FileView.computerIcon");
        }
    }

    public class Node
    implements MutableTreeNode,
    FileInfo,
    ChangeListener {
        protected TreeNode parent;
        protected File file;
        protected String userName;
        protected CollationKey collationKey;
        protected String fileKind;
        protected int fileLabel = -1;
        protected AquaFileIcon icon;
        protected int infoState = 0;
        protected Boolean isAcceptable;
        protected boolean isHidden;

        public Node(File file, boolean bl) {
            this(file, null, bl);
        }

        public Node(File file, String string, boolean bl) {
            this.file = file;
            this.userName = string;
            this.isHidden = bl;
        }

        @Override
        public File lazyGetResolvedFile() {
            return this.file;
        }

        @Override
        public File getFile() {
            return this.file;
        }

        public JFileChooser getFileChooser() {
            return FileSystemTreeModel.this.fileChooser;
        }

        @Override
        public long getFileLength() {
            if (this.lazyGetResolvedFile() == null) {
                return -1L;
            }
            return this.getResolvedFile().isDirectory() ? -1L : this.file.length();
        }

        @Override
        @NotNull
        public String getUserName() {
            if (this.userName == null) {
                this.userName = FileSystemTreeModel.this.fileChooser.getName(this.file);
            }
            return this.userName;
        }

        @Override
        public int getFileLabel() {
            this.validateInfo();
            return this.fileLabel;
        }

        @Override
        public Icon getIcon() {
            this.validateInfo();
            return this.icon;
        }

        public CollationKey getCollationKey() {
            if (this.collationKey == null) {
                this.collationKey = FileSystemTreeModel.getCollator(FileSystemTreeModel.this.fileChooser).getCollationKey(this.getUserName());
            }
            return this.collationKey;
        }

        @Override
        public boolean isAlias() {
            return false;
        }

        public void setTraversable(boolean bl) {
        }

        @Override
        public boolean isAcceptable() {
            if (this.isAcceptable == null) {
                this.isAcceptable = FileSystemTreeModel.this.accept(this) ? Boolean.TRUE : Boolean.FALSE;
            }
            return this.isAcceptable;
        }

        @Override
        public boolean isHidden() {
            return this.isHidden;
        }

        @Override
        @NotNull
        public String getFileKind() {
            if (this.fileKind == null) {
                this.fileKind = FileSystemTreeModel.this.fileAttributes.getKind(this.file);
            }
            return this.fileKind;
        }

        public void invalidateInfo() {
            if (this.infoState == 2) {
                if (this.isMonitoringInfoValidation(this.file)) {
                    AquaUtils.logDebug("Invaliding info for " + this.file);
                }
                this.userName = null;
                this.collationKey = null;
                this.isAcceptable = null;
                this.fileKind = null;
                this.infoState = 0;
            }
        }

        public void invokeWhenValid(Runnable runnable) {
            this.invokeWhenValid(runnable, 100);
        }

        protected void invokeWhenValid(Runnable runnable, int n) {
            if (n > 0) {
                if (this.infoState == 2) {
                    runnable.run();
                } else {
                    if (this.infoState == 0) {
                        this.validateInfo();
                    }
                    SwingUtilities.invokeLater(() -> this.invokeWhenValid(runnable, n - 1));
                }
            }
        }

        public void validateInfo() {
            if (this.infoState == 0) {
                if (this.icon != null) {
                    this.icon.removeChangeListener(this);
                    this.icon = null;
                }
                this.infoState = 2;
                this.fileLabel = FileSystemTreeModel.this.fileAttributes.getLabel(this.file);
                this.fileLabel = FileSystemTreeModel.this.fileAttributes.getLabel(this.file);
                this.icon = FileSystemTreeModel.this.fileAttributes.getIcon(this.file);
                this.icon.addChangeListener(this);
                this.fireChangeEvent();
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.fireChangeEvent();
        }

        protected void fireChangeEvent() {
            if (this.getRoot() == FileSystemTreeModel.this.getRoot()) {
                if (this.isMonitoringInfoValidation(this.file)) {
                    AquaUtils.logDebug("Change event generated for " + this.file);
                }
                FileSystemTreeModel.this.fireTreeNodeChanged(this);
            } else if (this.isMonitoringInfoValidation(this.file)) {
                AquaUtils.logDebug("No change event generated for " + this.file);
            }
        }

        private boolean isMonitoringInfoValidation(File file) {
            return false;
        }

        public void invalidateChildren() {
        }

        public void lazyInvalidateChildren() {
        }

        public void stopValidationSubtree() {
        }

        public void invalidateTree() {
            this.invalidateInfo();
        }

        public void validateChildren() {
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public void setParent(MutableTreeNode mutableTreeNode) {
            this.parent = mutableTreeNode;
        }

        @Override
        public void removeFromParent() {
            if (this.parent != null) {
                ((MutableTreeNode)this.parent).remove(this);
            }
        }

        @Override
        public void setUserObject(Object object) {
            this.file = (File)object;
        }

        public TreeNode[] getPath() {
            return this.getPathToRoot(this, 0);
        }

        protected TreeNode[] getPathToRoot(TreeNode treeNode, int n) {
            TreeNode[] treeNodeArray;
            if (treeNode == null) {
                if (n == 0) {
                    return null;
                }
                treeNodeArray = new TreeNode[n];
            } else {
                treeNodeArray = this.getPathToRoot(treeNode.getParent(), ++n);
                treeNodeArray[treeNodeArray.length - n] = treeNode;
            }
            return treeNodeArray;
        }

        public TreeNode getRoot() {
            Node node;
            TreeNode treeNode = this;
            do {
                node = treeNode;
            } while ((treeNode = treeNode.getParent()) != null);
            return node;
        }

        public boolean isNodeAncestor(TreeNode treeNode) {
            if (treeNode == null) {
                return false;
            }
            TreeNode treeNode2 = this;
            do {
                if (treeNode2 != treeNode) continue;
                return true;
            } while ((treeNode2 = treeNode2.getParent()) != null);
            return false;
        }

        public String toString() {
            return this.userName == null ? this.file.getName() : this.userName;
        }

        public Enumeration children() {
            return DefaultMutableTreeNode.EMPTY_ENUMERATION;
        }

        @Override
        public boolean getAllowsChildren() {
            return false;
        }

        @Override
        public TreeNode getChildAt(int n) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
        }

        @Override
        public int getChildCount() {
            return 0;
        }

        @Override
        public int getIndex(TreeNode treeNode) {
            return -1;
        }

        @Override
        public void insert(MutableTreeNode mutableTreeNode, int n) {
            throw new IllegalStateException("node does not allow children");
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public void remove(MutableTreeNode mutableTreeNode) {
            throw new IllegalArgumentException("argument is not a child");
        }

        @Override
        public void remove(int n) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
        }

        @Override
        public boolean isTraversable() {
            return !this.isLeaf();
        }

        @Override
        public File getResolvedFile() {
            return this.file;
        }
    }

    private static class FoldersFirstComparator
    implements Comparator,
    Serializable {
        private FoldersFirstComparator() {
        }

        public int compare(Object object, Object object2) {
            Node node = (Node)object;
            Node node2 = (Node)object2;
            if (node.isLeaf() == node2.isLeaf()) {
                return node.getCollationKey().compareTo(node2.getCollationKey());
            }
            return node.isLeaf() ? 1 : -1;
        }
    }

    public static class ByNameComparator
    implements Comparator,
    Serializable {
        public int compare(Object object, Object object2) {
            return ((Node)object).getCollationKey().compareTo(((Node)object2).getCollationKey());
        }
    }

    public class AliasDirectoryNode
    extends DirectoryNode {
        private File resolvedFile;
        private Worker<File> resolver;

        public AliasDirectoryNode(File file, File file2, boolean bl) {
            super(file, bl);
            this.resolvedFile = file2;
        }

        @Override
        @NotNull
        public String getFileKind() {
            return "alias";
        }

        @Override
        public boolean isAlias() {
            return true;
        }

        @Override
        public File lazyGetResolvedFile() {
            if (this.resolvedFile == null && this.resolver == null) {
                this.resolver = new Worker<File>(){

                    @Override
                    public File construct() {
                        return OSXFile.resolveAlias(AliasDirectoryNode.this.file, false);
                    }

                    @Override
                    public void done(File file) {
                        AliasDirectoryNode.this.resolvedFile = file;
                    }

                    @Override
                    public void finished() {
                        AliasDirectoryNode.this.resolver = null;
                        if (AliasDirectoryNode.this.getRoot() == FileSystemTreeModel.this.getRoot()) {
                            FileSystemTreeModel.this.fireTreeNodeChanged(AliasDirectoryNode.this);
                        }
                    }
                };
                FileSystemTreeModel.this.dispatchAliasResolution(this.resolver);
            }
            return this.resolvedFile;
        }

        @Override
        public File getResolvedFile() {
            if (this.resolvedFile == null) {
                this.resolvedFile = OSXFile.resolveAlias(this.file, false);
            }
            return this.resolvedFile == null ? this.file : this.resolvedFile;
        }

        @Override
        public boolean isValidatingChildren() {
            return super.isValidatingChildren() || this.resolver != null;
        }
    }

    public class AliasNode
    extends Node {
        private File resolvedFile;
        private Worker<File> resolver;

        public AliasNode(File file, File file2, boolean bl) {
            super(file, bl);
            this.resolvedFile = file2;
        }

        @Override
        public File lazyGetResolvedFile() {
            if (this.resolvedFile == null && this.resolver == null) {
                this.resolver = new Worker<File>(){

                    @Override
                    public File construct() {
                        return OSXFile.resolveAlias(AliasNode.this.file, false);
                    }

                    @Override
                    public void done(File file) {
                        AliasNode.this.resolvedFile = file;
                    }

                    @Override
                    public void finished() {
                        AliasNode.this.resolver = null;
                        if (AliasNode.this.getRoot() == FileSystemTreeModel.this.getRoot()) {
                            FileSystemTreeModel.this.fireTreeNodeChanged(AliasNode.this);
                            FileSystemTreeModel.this.fireTreeStructureChanged((TreeModel)FileSystemTreeModel.this, AliasNode.this.getPath());
                        }
                    }
                };
                FileSystemTreeModel.this.dispatchAliasResolution(this.resolver);
            }
            return this.resolvedFile;
        }

        @Override
        public File getResolvedFile() {
            if (this.resolvedFile == null) {
                this.resolvedFile = OSXFile.resolveAlias(this.file, false);
            }
            return this.resolvedFile == null ? this.file : this.resolvedFile;
        }

        @Override
        @NotNull
        public String getFileKind() {
            return "alias";
        }

        @Override
        public boolean isAlias() {
            return true;
        }
    }

    public class DirectoryNode
    extends Node {
        int childrenState;
        private ArrayList children;
        private Runnable validator;
        private Boolean isTraversable;
        private long bestBeforeTimeMillis;

        public DirectoryNode(File file, boolean bl) {
            super(file, bl);
            this.bestBeforeTimeMillis = 0L;
        }

        @Override
        public long getFileLength() {
            return -1L;
        }

        @Override
        @NotNull
        public String getFileKind() {
            return "directory";
        }

        @Override
        public void setTraversable(boolean bl) {
            this.isTraversable = bl;
        }

        @Override
        public void invalidateInfo() {
            super.invalidateInfo();
            this.isTraversable = null;
        }

        @Override
        public void invalidateChildren() {
            this.childrenState = 0;
            this.validator = null;
        }

        @Override
        public void lazyInvalidateChildren() {
            if (this.validator == null && this.bestBeforeTimeMillis < System.currentTimeMillis()) {
                this.childrenState = 0;
            }
        }

        public boolean isValidatingChildren() {
            return this.validator != null;
        }

        @Override
        public void stopValidationSubtree() {
            this.validator = null;
            Enumeration enumeration = super.children();
            while (enumeration.hasMoreElements()) {
                ((Node)enumeration.nextElement()).stopValidationSubtree();
            }
        }

        @Override
        public void invalidateTree() {
            this.invalidateInfo();
            if (this.childrenState == 2) {
                this.invalidateChildren();
            }
            if (this.children != null) {
                for (Object e : this.children) {
                    ((Node)e).invalidateTree();
                }
            }
        }

        @Override
        public void invokeWhenValid(Runnable runnable) {
            super.invokeWhenValid(() -> this.invokeWhenChildrenValid(runnable, 100));
        }

        private void invokeWhenChildrenValid(final Runnable runnable, final int n) {
            if (n > 0) {
                if (this.childrenState == 2) {
                    runnable.run();
                } else {
                    if (this.childrenState == 0) {
                        this.validateChildren();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DirectoryNode.this.invokeWhenChildrenValid(runnable, n - 1);
                        }
                    });
                }
            }
        }

        @Override
        public void validateChildren() {
            if (this.childrenState == 0) {
                this.childrenState = 1;
                this.validator = new DirectoryValidator();
                FileSystemTreeModel.this.directoryDispatcher.dispatch(this.validator, this.bestBeforeTimeMillis == 0L);
                Node node = (Node)this.getRoot();
                if (node == this.getRoot()) {
                    FileSystemTreeModel.this.fireTreeNodeChanged(this);
                }
                this.bestBeforeTimeMillis = System.currentTimeMillis() + this.getDirectoryTTL();
            }
        }

        public void autoValidateChildren() {
            if (FileSystemTreeModel.this.isAutoValidate && this.childrenState == 0 && FileSystemTreeModel.this.fileChooser.isDisplayable()) {
                this.validateChildren();
            }
        }

        @Override
        public Enumeration children() {
            this.autoValidateChildren();
            if (this.children == null) {
                return DefaultMutableTreeNode.EMPTY_ENUMERATION;
            }
            return new IteratorEnumeration(this.children.iterator());
        }

        private void removeAll(LinkedList linkedList) {
            this.children.removeAll(linkedList);
            for (Node node : linkedList) {
                node.parent = null;
            }
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public TreeNode getChildAt(int n) {
            if (this.children == null) {
                throw new IndexOutOfBoundsException(n + " >= 0");
            }
            this.autoValidateChildren();
            return (TreeNode)this.children.get(n);
        }

        @Override
        public int getChildCount() {
            this.autoValidateChildren();
            return this.children == null ? 0 : this.children.size();
        }

        @Override
        public int getIndex(TreeNode treeNode) {
            this.autoValidateChildren();
            return this.children == null ? -1 : this.children.indexOf(treeNode);
        }

        @Override
        public void insert(MutableTreeNode mutableTreeNode, int n) {
            this.invalidateChildren();
            if (mutableTreeNode == null) {
                throw new IllegalArgumentException("new child is null");
            }
            if (this.isNodeAncestor(mutableTreeNode)) {
                throw new IllegalArgumentException("new child is an ancestor");
            }
            MutableTreeNode mutableTreeNode2 = (MutableTreeNode)mutableTreeNode.getParent();
            if (mutableTreeNode2 != null) {
                mutableTreeNode2.remove(mutableTreeNode);
            }
            mutableTreeNode.setParent(this);
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(n, mutableTreeNode);
        }

        @Override
        public boolean isLeaf() {
            if (this.isTraversable == null) {
                File file = this.getResolvedFile();
                this.isTraversable = FileSystemTreeModel.this.fileChooser.isTraversable(file);
            }
            return this.isTraversable == false;
        }

        @Override
        public void remove(MutableTreeNode mutableTreeNode) {
            if (mutableTreeNode == null) {
                throw new IllegalArgumentException("argument is null");
            }
            if (mutableTreeNode.getParent() != this) {
                throw new IllegalArgumentException("argument is not a child");
            }
            this.remove(this.getIndex(mutableTreeNode));
        }

        @Override
        public void remove(int n) {
            this.invalidateChildren();
            MutableTreeNode mutableTreeNode = (MutableTreeNode)this.getChildAt(n);
            this.children.remove(n);
            mutableTreeNode.setParent(null);
        }

        protected File[] getFiles() {
            File[] fileArray = FileSystemTreeModel.this.getFileSystemView().getFiles(this.lazyGetResolvedFile(), FileSystemTreeModel.this.fileChooser.isFileHidingEnabled());
            return fileArray;
        }

        protected long getDirectoryTTL() {
            return 2000L;
        }

        private class DirectoryValidator
        implements Runnable {
            private DirectoryValidator() {
            }

            @Override
            public void run() {
                if (this != DirectoryNode.this.validator) {
                    return;
                }
                final long l = System.currentTimeMillis();
                final boolean bl = DirectoryNode.this.file != null && DirectoryNode.this.file.exists();
                final File[] fileArray = bl && DirectoryNode.this.isTraversable() ? DirectoryNode.this.getFiles() : new File[]{};
                if (this != DirectoryNode.this.validator) {
                    return;
                }
                ArrayList<Node> arrayList = new ArrayList<Node>(fileArray.length);
                boolean bl2 = FileSystemTreeModel.this.fileChooser.isFileHidingEnabled();
                AquaFileSystemView aquaFileSystemView = FileSystemTreeModel.this.getFileSystemView();
                for (int i = 0; i < fileArray.length; ++i) {
                    DirectoryNode directoryNode;
                    boolean bl3;
                    File file = fileArray[i];
                    int n = OSXFile.getFileType(file);
                    boolean bl4 = n == 1;
                    File file2 = null;
                    boolean bl5 = FileSystemTreeModel.this.isResolveAliasesToFiles() ? n == 2 : false;
                    if (bl5) {
                        file2 = OSXFile.resolveAlias(file, true);
                        if (file2 == null) {
                            bl3 = false;
                        } else {
                            bl3 = FileSystemTreeModel.this.fileChooser.isTraversable(file2);
                            n = OSXFile.getFileType(file2);
                            bl4 = n == 1;
                        }
                    } else {
                        bl3 = FileSystemTreeModel.this.fileChooser.isTraversable(file);
                        file2 = file;
                    }
                    boolean bl6 = aquaFileSystemView.isHiddenFile(file);
                    if (bl6 && bl4 && file2.getPath().equals("/Network")) {
                        bl6 = false;
                    }
                    if (bl2 && bl6) continue;
                    if (bl5) {
                        if (bl4) {
                            directoryNode = new AliasDirectoryNode(file, file2, bl6);
                            ((Node)directoryNode).setTraversable(bl3);
                            arrayList.add(directoryNode);
                            continue;
                        }
                        arrayList.add(new AliasNode(file, file2, bl6));
                        continue;
                    }
                    if (bl4) {
                        directoryNode = new DirectoryNode(file, bl6);
                        ((Node)directoryNode).setTraversable(bl3);
                        arrayList.add(directoryNode);
                        continue;
                    }
                    arrayList.add(new Node(file, bl6));
                }
                final Node[] nodeArray = arrayList.toArray(new Node[arrayList.size()]);
                if (this != DirectoryNode.this.validator) {
                    return;
                }
                Arrays.sort(nodeArray, FileSystemTreeModel.this.getNodeComparator());
                if (this != DirectoryNode.this.validator) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (DirectoryValidator.this != DirectoryNode.this.validator) {
                            return;
                        }
                        if (DirectoryNode.this.getRoot() != FileSystemTreeModel.this.getRoot()) {
                            return;
                        }
                        ArrayList<Node> arrayList = new ArrayList<Node>(fileArray.length);
                        LinkedList<Node> linkedList = new LinkedList<Node>();
                        int[] nArray = new int[fileArray.length];
                        LinkedList<Node> linkedList2 = new LinkedList<Node>();
                        int[] nArray2 = new int[DirectoryNode.this.getChildCount()];
                        Node[] nodeArray2 = DirectoryNode.this.children == null ? new Node[]{} : DirectoryNode.this.children.toArray(new Node[DirectoryNode.this.children.size()]);
                        int n = nodeArray.length + nodeArray2.length;
                        int n2 = 0;
                        int n3 = 0;
                        int n4 = 0;
                        int n5 = -1;
                        Object var13_12 = null;
                        Comparator comparator = FileSystemTreeModel.this.getNodeComparator();
                        for (int i = 0; i < n; ++i) {
                            Node node;
                            int n6;
                            if (n2 >= nodeArray.length) {
                                n6 = n3 >= nodeArray2.length ? 0 : 1;
                            } else if (n3 >= nodeArray2.length) {
                                n6 = -1;
                            } else {
                                n6 = comparator.compare(nodeArray[n2], nodeArray2[n3]);
                                if (n6 == 0 && nodeArray[n2].getAllowsChildren() != nodeArray2[n3].getAllowsChildren()) {
                                    n6 = -1;
                                }
                            }
                            if (n6 < 0) {
                                nArray[linkedList.size()] = n4++;
                                node = nodeArray[n2];
                                node.parent = DirectoryNode.this;
                                linkedList.add(node);
                                arrayList.add(node);
                                ++n2;
                                continue;
                            }
                            if (n6 == 0) {
                                if (n3 < nodeArray2.length) {
                                    node = nodeArray2[n3];
                                    arrayList.add(node);
                                }
                                ++n3;
                                ++n2;
                                ++n4;
                                continue;
                            }
                            nArray2[linkedList2.size()] = n4 + linkedList2.size() - linkedList.size();
                            linkedList2.add(nodeArray2[n3]);
                            ++n3;
                        }
                        if (!bl) {
                            Node node = DirectoryNode.this;
                            while ((node = (Node)node.getParent()) != null) {
                                node.lazyInvalidateChildren();
                                node.validateChildren();
                            }
                        }
                        if (linkedList.size() > 0 || linkedList2.size() > 0) {
                            for (Node node : linkedList2) {
                                node.parent = null;
                                node.invalidateChildren();
                            }
                            if (linkedList.size() > 0 && linkedList2.size() == 0) {
                                DirectoryNode.this.children = arrayList;
                                FileSystemTreeModel.this.fireTreeNodesInserted(FileSystemTreeModel.this, DirectoryNode.this.getPath(), ArrayUtil.truncate(nArray, 0, linkedList.size()), linkedList.toArray());
                            } else if (linkedList.size() == 0 && linkedList2.size() > 0) {
                                DirectoryNode.this.children = arrayList;
                                FileSystemTreeModel.this.fireTreeNodesRemoved(FileSystemTreeModel.this, DirectoryNode.this.getPath(), ArrayUtil.truncate(nArray2, 0, linkedList2.size()), linkedList2.toArray());
                            } else if (linkedList.size() > 0 && linkedList2.size() > 0) {
                                DirectoryNode.this.removeAll(linkedList2);
                                FileSystemTreeModel.this.fireTreeNodesRemoved(FileSystemTreeModel.this, DirectoryNode.this.getPath(), ArrayUtil.truncate(nArray2, 0, linkedList2.size()), linkedList2.toArray());
                                DirectoryNode.this.children = arrayList;
                                FileSystemTreeModel.this.fireTreeNodesInserted(FileSystemTreeModel.this, DirectoryNode.this.getPath(), ArrayUtil.truncate(nArray, 0, linkedList.size()), linkedList.toArray());
                            }
                        }
                        DirectoryNode.this.validator = null;
                        Node node = (Node)DirectoryNode.this.getRoot();
                        if (node == DirectoryNode.this.getRoot()) {
                            FileSystemTreeModel.this.fireTreeNodeChanged(DirectoryNode.this);
                        }
                        long l2 = System.currentTimeMillis();
                        DirectoryNode.this.bestBeforeTimeMillis = l2 + DirectoryNode.this.getDirectoryTTL() + (l2 - l) * 3L;
                        DirectoryNode.this.childrenState = 2;
                    }
                });
            }
        }
    }

    public static class ByKindComparator
    implements Comparator,
    Serializable {
        public int compare(Object object, Object object2) {
            String string = ((Node)object).getFileKind();
            String string2 = ((Node)object2).getFileKind();
            return string.compareTo(string2);
        }
    }

    public static class ByDateComparator
    implements Comparator,
    Serializable {
        public int compare(Object object, Object object2) {
            File file;
            long l;
            File file2 = ((Node)object).lazyGetResolvedFile();
            long l2 = file2 != null ? file2.lastModified() : 0L;
            long l3 = l2 - (l = (file = ((Node)object2).lazyGetResolvedFile()) != null ? file.lastModified() : 0L);
            return l3 > 0L ? 1 : (l3 < 0L ? -1 : 0);
        }
    }

    public static class BySizeComparator
    implements Comparator,
    Serializable {
        public int compare(Object object, Object object2) {
            long l = ((Node)object).getFileLength() - ((Node)object2).getFileLength();
            return l > 0L ? 1 : (l < 0L ? -1 : 0);
        }
    }
}

