/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.plaf.ColorUIResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.BasicColors;
import org.violetlib.aqua.BasicColorsBuilder;
import org.violetlib.aqua.Colors;
import org.violetlib.aqua.ColorsInstrumentation;
import org.violetlib.aqua.Logger;

public class ColorsBuilder {
    @NotNull
    private final Map<String, Color> colors = new HashMap<String, Color>();
    @NotNull
    private final Map<String, String> synonyms = new HashMap<String, String>();
    @NotNull
    protected final String context;
    @Nullable
    protected final ColorsInstrumentation instrumentation;
    @Nullable
    protected final ColorsInstrumentation.Access access;
    @NotNull
    protected final Logger log;

    public ColorsBuilder(@NotNull String string, @Nullable ColorsInstrumentation colorsInstrumentation, @NotNull Logger logger) {
        this.context = string;
        this.instrumentation = colorsInstrumentation;
        this.access = colorsInstrumentation != null ? new Access() : null;
        this.log = logger;
    }

    @NotNull
    public Colors getColors() {
        HashMap<String, Color> hashMap = new HashMap<String, Color>(this.colors);
        this.applySynonyms(hashMap, this.synonyms);
        return new Colors(Collections.unmodifiableMap(hashMap));
    }

    @Nullable
    public Color get(@NotNull String string) {
        return this.colors.get(string);
    }

    public void add(@NotNull String string, int n) {
        ColorUIResource colorUIResource = new ColorUIResource(n, n, n);
        this.internalAdd(string, colorUIResource);
    }

    public void add(@NotNull String string, int n, int n2, int n3) {
        ColorUIResource colorUIResource = new ColorUIResource(n, n2, n3);
        this.internalAdd(string, colorUIResource);
    }

    public void add(@NotNull String string, int n, int n2, int n3, int n4) {
        ColorUIResource colorUIResource = new ColorUIResource(new Color(n, n2, n3, n4));
        this.internalAdd(string, colorUIResource);
    }

    public void add(@NotNull String string, int n, int n2) {
        ColorUIResource colorUIResource = new ColorUIResource(new Color(n, n, n, n2));
        this.internalAdd(string, colorUIResource);
    }

    public void add(@NotNull String string, @NotNull Color color) {
        this.internalAdd(string, color);
    }

    public void addAll(@NotNull Map<String, Color> map) {
        for (String string : map.keySet()) {
            Color color = map.get(string);
            this.internalAdd(string, color);
        }
    }

    public void add(@NotNull String string, @NotNull String string2) {
        this.internalAdd(string, string2);
    }

    public void addAll(@NotNull String string, @NotNull String string2) {
        String string32;
        this.add(string, string2);
        for (String string32 : BasicColorsBuilder.getAllColorSuffixes()) {
            this.addDerived(string, string2, string32);
        }
        String string4 = AquaColors.createSelectedColorName(string);
        string32 = AquaColors.createSelectedColorName(string2);
        this.add(string4, string32);
        for (String string5 : BasicColorsBuilder.getAllColorSuffixes()) {
            this.addDerived(string4, string32, string5);
        }
    }

    private void addDerived(@NotNull String string, @NotNull String string2, @NotNull String string3) {
        this.add(string + string3, string2 + string3);
    }

    public void add(@NotNull BasicColors basicColors, @NotNull String string) {
        String string2 = this.context + "." + string;
        Map<String, Color> map = basicColors.colors;
        for (String object : map.keySet()) {
            Object object2 = map.get(object);
            this.internalAdd(string2, object, (Color)object2);
        }
        Map<String, String> map2 = basicColors.synonyms;
        for (Object object2 : map2.keySet()) {
            String string3 = (String)map2.get(object2);
            this.internalAdd(string2, (String)object2, string3);
        }
    }

    protected void internalAdd(@NotNull String string, @NotNull Color color) {
        this.internalAdd(this.context, string, color);
    }

    protected void internalAdd(@NotNull String string, @NotNull String string2, @NotNull Color color) {
        if (this.instrumentation != null) {
            assert (this.access != null);
            this.instrumentation.addingColor(string, string2, color, this.access);
        }
        this.synonyms.remove(string2);
        if (!(color instanceof ColorUIResource)) {
            color = new ColorUIResource(color);
        }
        this.colors.put(string2, color);
    }

    protected void internalAdd(@NotNull String string, @NotNull String string2) {
        this.internalAdd(this.context, string, string2);
    }

    protected void internalAdd(@NotNull String string, @NotNull String string2, @NotNull String string3) {
        if (this.instrumentation != null) {
            assert (this.access != null);
            this.instrumentation.addingSynonym(string, string2, string3, this.access);
        }
        this.colors.remove(string2);
        this.synonyms.put(string2, string3);
    }

    protected void applySynonyms(@NotNull Map<String, Color> map, @NotNull Map<String, String> map2) {
        Color color;
        HashMap<String, Color> hashMap = new HashMap<String, Color>();
        for (String string : map2.keySet()) {
            color = this.getIndirect(string, 5);
            if (this.instrumentation != null) {
                assert (this.access != null);
                this.instrumentation.applyingSynonym(this.context, string, color, this.access);
            }
            if (color == null) continue;
            hashMap.put(string, color);
        }
        for (String string : hashMap.keySet()) {
            color = (Color)hashMap.get(string);
            map.put(string, color);
        }
    }

    @Nullable
    protected Color getIndirect(@NotNull String string, int n) {
        if (n < 0) {
            return null;
        }
        String string2 = this.synonyms.get(string);
        if (string2 != null) {
            return this.getIndirect(string2, n - 1);
        }
        return this.colors.get(string);
    }

    private class Access
    implements ColorsInstrumentation.Access {
        private Access() {
        }

        @Override
        @NotNull
        public String[] getColorNames() {
            return ColorsBuilder.this.colors.keySet().toArray(new String[0]);
        }

        @Override
        @Nullable
        public Color getColor(@NotNull String string) {
            return (Color)ColorsBuilder.this.colors.get(string);
        }

        @Override
        @Nullable
        public String getSynonym(@NotNull String string) {
            return (String)ColorsBuilder.this.synonyms.get(string);
        }
    }
}

