/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceContext;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaComboBoxRenderer;
import org.violetlib.aqua.AquaComponentUI;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaListMouseBehavior;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.AquaViewStyleContainerUI;
import org.violetlib.aqua.ContainerContextualColors;
import org.violetlib.aqua.JListModel;
import org.violetlib.jnr.aqua.AquaUIPainter;

public class AquaListUI
extends BasicListUI
implements AquaComponentUI,
AquaViewStyleContainerUI {
    public static final String LIST_STYLE_KEY = "JList.style";
    public static final String QUAQUA_LIST_STYLE_KEY = "Quaqua.List.style";
    public static final String LIST_VIEW_STYLE_KEY = "JList.viewStyle";
    private boolean isStriped = false;
    private boolean isInset = false;
    private boolean isFocused = false;
    private boolean isMenu = false;
    @NotNull
    protected ContainerContextualColors colors = AquaColors.CONTAINER_COLORS;
    @Nullable
    protected AppearanceContext appearanceContext;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaListUI();
    }

    public void setMenu(boolean bl) {
        this.isMenu = bl;
    }

    public void setColors(@NotNull ContainerContextualColors containerContextualColors) {
        if (containerContextualColors != this.colors) {
            this.colors = containerContextualColors;
            this.configureAppearanceContext(null);
        }
    }

    @Override
    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new AquaListMouseBehavior(new JListModel(this.list));
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.list.putClientProperty("JComponent.isCellContainer", true);
        this.isStriped = this.getStripedValue();
        this.isInset = this.getInsetValue();
        this.updateOpaque();
        this.configureAppearanceContext(null);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        AppearanceManager.installListener(this.list);
        AquaUtils.installInsetViewListener(this.list);
    }

    @Override
    protected void uninstallListeners() {
        AquaUtils.uninstallInsetViewListener(this.list);
        AppearanceManager.uninstallListener(this.list);
        super.uninstallListeners();
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.list.getActionMap().put("aquaHome", new AquaHomeEndAction(true));
        this.list.getActionMap().put("aquaEnd", new AquaHomeEndAction(false));
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new AquaPropertyChangeHandler();
    }

    @NotNull
    public ContainerContextualColors getColors() {
        return this.colors;
    }

    @Override
    public void appearanceChanged(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
        this.configureAppearanceContext(aquaAppearance);
    }

    @Override
    public void activeStateChanged(@NotNull JComponent jComponent, boolean bl) {
        this.configureAppearanceContext(null);
    }

    protected void configureAppearanceContext(@Nullable AquaAppearance aquaAppearance) {
        if (aquaAppearance == null) {
            aquaAppearance = AppearanceManager.ensureAppearance(this.list);
        }
        AquaUIPainter.State state = this.getState();
        this.appearanceContext = new AppearanceContext(aquaAppearance, state, false, false);
        this.colors.configureForContainer();
        AquaColors.installColors(this.list, this.appearanceContext, this.colors);
        this.list.repaint();
    }

    protected AquaUIPainter.State getState() {
        return this.list.isEnabled() ? (this.isFocused ? AquaUIPainter.State.ACTIVE_DEFAULT : AquaUIPainter.State.ACTIVE) : AquaUIPainter.State.DISABLED;
    }

    private void updateStriped() {
        boolean bl = this.getStripedValue();
        if (bl != this.isStriped) {
            this.isStriped = bl;
            this.colors = this.isStriped ? AquaColors.STRIPED_CONTAINER_COLORS : AquaColors.CONTAINER_COLORS;
            this.updateOpaque();
            this.configureAppearanceContext(null);
        }
    }

    private boolean getStripedValue() {
        String string = this.getStyleProperty();
        return "striped".equals(string) && this.list.getLayoutOrientation() == 0 && this.isBackgroundClear();
    }

    @Override
    public void scrollPaneAncestorChanged(@Nullable JScrollPane jScrollPane) {
    }

    private void updateInset() {
        boolean bl = this.getInsetValue();
        if (bl != this.isInset) {
            this.isInset = bl;
            this.configureAppearanceContext(null);
            this.updateLayoutState();
        }
    }

    private boolean getInsetValue() {
        if (AquaUtils.isInsetViewSupported()) {
            String string = this.getViewStyleProperty();
            return "inset".equals(string);
        }
        return false;
    }

    private void updateOpaque() {
        this.list.setOpaque(!this.isStriped);
    }

    private boolean isBackgroundClear() {
        Color color = this.list.getBackground();
        return color.getAlpha() == 0 || color instanceof ColorUIResource;
    }

    public boolean isStriped() {
        return this.isStriped;
    }

    @Override
    public boolean isInset() {
        return this.isInset;
    }

    protected boolean isStyleProperty(String string) {
        return AquaUtils.isProperty(string, LIST_STYLE_KEY, QUAQUA_LIST_STYLE_KEY);
    }

    @Nullable
    protected String getStyleProperty() {
        return AquaUtils.getProperty(this.list, LIST_STYLE_KEY, QUAQUA_LIST_STYLE_KEY);
    }

    protected boolean isViewStyleProperty(String string) {
        return AquaUtils.isProperty(string, LIST_VIEW_STYLE_KEY);
    }

    @Nullable
    protected String getViewStyleProperty() {
        return AquaUtils.getProperty(this.list, LIST_VIEW_STYLE_KEY);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        AquaAppearance aquaAppearance = AppearanceManager.registerCurrentAppearance(jComponent);
        Color color = this.getBackgroundColor();
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        this.paint(graphics, jComponent);
        AppearanceManager.restoreCurrentAppearance(aquaAppearance);
    }

    @Nullable
    private Color getBackgroundColor() {
        if (this.list.isOpaque()) {
            return this.list.getBackground();
        }
        return null;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.appearanceContext != null) {
            this.paintStripes(graphics);
            super.paint(graphics, jComponent);
        }
    }

    public void paintStripes(Graphics graphics) {
        if (this.isStriped && this.list.getModel() != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            assert (this.appearanceContext != null);
            Dimension dimension = this.list.getSize();
            int n = this.list.getFixedCellHeight();
            int n2 = this.list.getModel().getSize();
            if (n <= 0) {
                n = n2 == 0 ? 12 : this.getCellBounds(this.list, (int)0, (int)0).height;
            }
            int n3 = (int)Math.ceil(Math.abs(dimension.getHeight() / (double)n));
            int n4 = 0;
            int n5 = 0;
            ListSelectionModel listSelectionModel = this.list.getSelectionModel();
            while (n4 < n3) {
                boolean bl = listSelectionModel.isSelectedIndex(n4);
                this.colors.configureForRow(n4, bl && !this.isInset);
                Color color = this.colors.getBackground(this.appearanceContext);
                graphics.setColor(color);
                if (this.isInset) {
                    AquaUtils.paintInsetStripedRow(graphics2D, 0, n5, dimension.width, n);
                } else {
                    graphics.fillRect(0, n5, dimension.width, n);
                }
                ++n4;
                n5 += n;
            }
        }
    }

    protected void paintCell(Graphics graphics, int n, Rectangle rectangle, ListCellRenderer listCellRenderer, ListModel listModel, ListSelectionModel listSelectionModel, int n2) {
        Object object;
        Object object2;
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        assert (this.appearanceContext != null);
        boolean bl = listSelectionModel.isSelectedIndex(n);
        boolean bl2 = this.list.isEnabled();
        boolean bl3 = bl2 && AquaFocusHandler.hasFocus(this.list);
        boolean bl4 = bl3 && n == n2;
        boolean bl5 = this.list.getLayoutOrientation() != 0;
        this.colors.configureForRow(n, bl);
        if (bl) {
            object2 = this.colors.getBackground(this.appearanceContext);
            graphics.setColor((Color)object2);
            if (this.isInset) {
                object = (Graphics2D)graphics;
                if (this.isMenu) {
                    AquaUtils.paintInsetMenuItemSelection((Graphics2D)object, n3, n4, n5, n6);
                } else if (bl5) {
                    AquaUtils.paintInsetCellSelection((Graphics2D)object, n3, n4, n5, n6);
                } else {
                    boolean bl6 = n > 0 && listSelectionModel.isSelectedIndex(n - 1);
                    boolean bl7 = n < this.list.getModel().getSize() - 1 && listSelectionModel.isSelectedIndex(n + 1);
                    AquaUtils.paintInsetCellSelection((Graphics2D)object, bl6, bl7, n3, n4, n5, n6);
                }
            } else if (!this.isStriped) {
                graphics.fillRect(n3, n4, n5, n6);
            }
        }
        if ((object = listCellRenderer.getListCellRendererComponent(this.list, object2 = listModel.getElementAt(n), n, bl, bl4)) instanceof JTextComponent) {
            ((JTextComponent)object).putClientProperty("Aqua.componentColors", AquaColors.CELL_TEXT_COLORS);
        }
        if (this.isInset && ((Component)object).isOpaque() && object instanceof JComponent) {
            JComponent jComponent = (JComponent)object;
            jComponent.setOpaque(false);
        }
        this.rendererPane.paintComponent(graphics, (Component)object, this.list, n3, n4, n5, n6, true);
        if (object instanceof JTextComponent) {
            ((JTextComponent)object).putClientProperty("Aqua.componentColors", null);
        }
    }

    protected void repaintCell(Object object, int n, boolean bl) {
        AquaComboBoxRenderer aquaComboBoxRenderer;
        Rectangle rectangle = this.getCellBounds(this.list, n, n);
        if (rectangle == null) {
            return;
        }
        ListCellRenderer<Object> listCellRenderer = this.list.getCellRenderer();
        if (listCellRenderer == null) {
            return;
        }
        Component component = listCellRenderer.getListCellRendererComponent(this.list, object, n, bl, true);
        if (component == null) {
            return;
        }
        AquaComboBoxRenderer aquaComboBoxRenderer2 = aquaComboBoxRenderer = listCellRenderer instanceof AquaComboBoxRenderer ? (AquaComboBoxRenderer)listCellRenderer : null;
        if (aquaComboBoxRenderer != null) {
            aquaComboBoxRenderer.setDrawCheckedItem(false);
        }
        this.rendererPane.paintComponent(this.list.getGraphics().create(), component, this.list, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        if (aquaComboBoxRenderer != null) {
            aquaComboBoxRenderer.setDrawCheckedItem(true);
        }
    }

    protected class FocusHandler
    implements FocusListener {
        protected FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.focusChanged();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.focusChanged();
        }

        private void focusChanged() {
            AquaListUI.this.isFocused = AquaFocusHandler.hasFocus(AquaListUI.this.list);
            AquaListUI.this.configureAppearanceContext(null);
        }
    }

    static class AquaHomeEndAction
    extends AbstractAction {
        private boolean fHomeAction;

        protected AquaHomeEndAction(boolean bl) {
            this.fHomeAction = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JList jList = (JList)actionEvent.getSource();
            if (this.fHomeAction) {
                jList.ensureIndexIsVisible(0);
            } else {
                int n = jList.getModel().getSize();
                jList.ensureIndexIsVisible(n - 1);
            }
        }
    }

    class AquaPropertyChangeHandler
    extends BasicListUI.PropertyChangeHandler {
        AquaPropertyChangeHandler() {
            super(AquaListUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("enabled".equals(string)) {
                AquaListUI.this.configureAppearanceContext(null);
            } else {
                if (AquaListUI.this.isStyleProperty(string)) {
                    AquaListUI.this.updateStriped();
                } else if ("layoutOrientation".equals(string)) {
                    AquaListUI.this.updateStriped();
                } else if (AquaListUI.this.isViewStyleProperty(string)) {
                    AquaListUI.this.updateInset();
                }
                super.propertyChange(propertyChangeEvent);
            }
        }
    }
}

