/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.impl.BasicImageSupport;
import org.violetlib.jnr.impl.BasicRenderer;
import org.violetlib.jnr.impl.JNRUtils;
import org.violetlib.jnr.impl.PainterExtension;

public class ReusableCompositor {
    @Nullable
    private int[] data;
    @Nullable
    private BufferedImage b;
    private boolean isConfigured;
    private boolean isEmpty;
    private int rasterWidth;
    private int rasterHeight;
    private int scaleFactor;

    public ReusableCompositor() {
    }

    public ReusableCompositor(@NotNull int[] nArray, int n, int n2, int n3) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Invalid negative raster width and/or height");
        }
        if (n3 < 1 || n3 > 8) {
            throw new IllegalArgumentException("Invalid or unsupported scale factor");
        }
        this.data = nArray;
        this.rasterWidth = n;
        this.rasterHeight = n2;
        this.scaleFactor = n3;
        this.isConfigured = true;
        this.isEmpty = true;
    }

    @NotNull
    public static ColorModel getColorModel() {
        return BasicImageSupport.getColorModel();
    }

    public int getRasterWidth() {
        return this.rasterWidth;
    }

    public int getRasterHeight() {
        return this.rasterHeight;
    }

    public int getScaleFactor() {
        return this.scaleFactor;
    }

    public float getWidth() {
        return (float)this.rasterWidth / (float)this.scaleFactor;
    }

    public float getHeight() {
        return (float)this.rasterHeight / (float)this.scaleFactor;
    }

    @NotNull
    public ReusableCompositor createSimilar() {
        ReusableCompositor reusableCompositor = new ReusableCompositor();
        reusableCompositor.reset(this.rasterWidth, this.rasterHeight, this.scaleFactor);
        return reusableCompositor;
    }

    @NotNull
    public ReusableCompositor createHorizontallyFlippedCopy() {
        ReusableCompositor reusableCompositor = this.createSimilar();
        reusableCompositor.copyHorizontallyFlippedFrom(this);
        return reusableCompositor;
    }

    public void reset(int n, int n2, int n3) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Invalid negative raster width and/or height");
        }
        if (n3 < 1 || n3 > 8) {
            throw new IllegalArgumentException("Invalid or unsupported scale factor");
        }
        this.rasterWidth = n;
        this.rasterHeight = n2;
        this.scaleFactor = n3;
        this.isEmpty = true;
    }

    protected void ensureConfigured() {
        if (!this.isConfigured) {
            this.isConfigured = true;
            int n = this.rasterWidth * this.rasterHeight;
            if (n > 0) {
                if (this.data == null || this.data.length < n) {
                    this.data = new int[n];
                    this.b = null;
                } else {
                    Arrays.fill(this.data, 0);
                }
            }
        }
    }

    public void render(@NotNull BasicRenderer basicRenderer, int n, int n2, int n3) {
        this.reset(n, n2, n3);
        this.ensureConfigured();
        if (this.data != null) {
            float f = (float)n / (float)n3;
            float f2 = (float)n2 / (float)n3;
            basicRenderer.render(this.data, n, n2, f, f2);
            this.isEmpty = false;
        }
    }

    public void compose(@NotNull Object object) {
        if (object instanceof BasicRenderer) {
            BasicRenderer basicRenderer = (BasicRenderer)object;
            this.composeRenderer(basicRenderer);
        } else if (object instanceof PainterExtension) {
            PainterExtension painterExtension = (PainterExtension)object;
            this.composePainter(painterExtension, 0.0f, 0.0f);
        } else if (object instanceof ReusableCompositor) {
            ReusableCompositor reusableCompositor = (ReusableCompositor)object;
            this.composeFrom(reusableCompositor, 0, 0, this.rasterWidth, this.rasterHeight);
        } else if (object instanceof PixelSource) {
            PixelSource pixelSource = (PixelSource)object;
            pixelSource.composeTo(this);
        } else {
            throw new UnsupportedOperationException("Unsupported pixel source");
        }
    }

    public void composeRenderer(@NotNull BasicRenderer basicRenderer) {
        this.ensureConfigured();
        if (this.data != null) {
            if (this.isEmpty) {
                float f = (float)this.rasterWidth / (float)this.scaleFactor;
                float f2 = (float)this.rasterHeight / (float)this.scaleFactor;
                basicRenderer.render(this.data, this.rasterWidth, this.rasterHeight, f, f2);
                this.isEmpty = false;
            } else {
                this.composeRenderer(basicRenderer, 0, 0, this.rasterWidth, this.rasterHeight);
            }
        }
    }

    public void composeRenderer(@NotNull BasicRenderer basicRenderer, int n, int n2, int n3, int n4) {
        if (n3 > 0 && n4 > 0) {
            ReusableCompositor reusableCompositor = new ReusableCompositor();
            reusableCompositor.render(basicRenderer, n3, n4, this.scaleFactor);
            this.composeFrom(reusableCompositor, n, n2, n3, n4);
        }
    }

    public void composePainter(@NotNull PainterExtension painterExtension, int n, int n2, int n3, int n4) {
        if (n3 > 0 && n4 > 0) {
            ReusableCompositor reusableCompositor = new ReusableCompositor();
            reusableCompositor.reset(n3, n4, this.scaleFactor);
            reusableCompositor.composePainter(painterExtension, 0.0f, 0.0f);
            this.composeFrom(reusableCompositor, n, n2, n3, n4);
        }
    }

    private void copyHorizontallyFlippedFrom(@NotNull ReusableCompositor reusableCompositor) {
        int[] nArray;
        this.ensureConfigured();
        if (this.data != null && (nArray = reusableCompositor.data) != null) {
            this.isEmpty = true;
            if (!reusableCompositor.isEmpty) {
                int n = reusableCompositor.getRasterWidth();
                for (int i = 0; i < this.rasterHeight; ++i) {
                    for (int j = 0; j < this.rasterWidth; ++j) {
                        int n2 = this.rasterWidth - j - 1;
                        int n3 = nArray[i * n + n2];
                        int n4 = n3 >> 24 & 0xFF;
                        if (n4 == 0) continue;
                        this.isEmpty = false;
                        this.data[i * this.rasterWidth + j] = n3;
                    }
                }
            }
        }
    }

    public void composeFrom(@NotNull ReusableCompositor reusableCompositor, int n, int n2, int n3, int n4) {
        int[] nArray;
        this.ensureConfigured();
        if (this.data != null && (nArray = reusableCompositor.data) != null) {
            this.isEmpty = false;
            int n5 = reusableCompositor.getRasterWidth();
            for (int i = 0; i < n4; ++i) {
                int n6 = n2 + i;
                if (n6 < 0 || n6 >= this.rasterHeight) continue;
                for (int j = 0; j < n3; ++j) {
                    int n7;
                    int n8;
                    int n9 = n + j;
                    if (n9 < 0 || n9 >= this.rasterWidth || (n8 = (n7 = nArray[i * n5 + j]) >> 24 & 0xFF) == 0) continue;
                    if (n8 != 255) {
                        n7 = JNRUtils.combine(this.data[n6 * this.rasterWidth + n9], n7);
                    }
                    this.data[n6 * this.rasterWidth + n9] = n7;
                }
            }
        }
    }

    public void composeFrom(@NotNull ReusableCompositor reusableCompositor, int n, int n2, int n3, int n4, int n5, int n6) {
        int[] nArray;
        this.ensureConfigured();
        if (this.data != null && (nArray = reusableCompositor.data) != null) {
            this.isEmpty = false;
            int n7 = reusableCompositor.getRasterWidth();
            int n8 = reusableCompositor.getRasterHeight();
            for (int i = 0; i < n6; ++i) {
                int n9 = n2 + i;
                int n10 = n4 + i;
                if (n10 < 0 || n10 >= this.rasterHeight || n9 < 0 || n9 >= n8) continue;
                for (int j = 0; j < n5; ++j) {
                    int n11;
                    int n12;
                    int n13 = n + j;
                    int n14 = n3 + j;
                    if (n14 < 0 || n14 >= this.rasterWidth || n13 < 0 || n13 >= n7 || (n12 = (n11 = nArray[n9 * n7 + n13]) >> 24 & 0xFF) == 0) continue;
                    if (n12 != 255) {
                        n11 = JNRUtils.combine(this.data[n10 * this.rasterWidth + n14], n11);
                    }
                    this.data[n10 * this.rasterWidth + n14] = n11;
                }
            }
        }
    }

    public void composePainter(@NotNull PainterExtension painterExtension, float f, float f2) {
        BufferedImage bufferedImage = this.getImage();
        if (bufferedImage != null) {
            this.isEmpty = false;
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.scale(this.scaleFactor, this.scaleFactor);
            graphics2D.translate(f, f2);
            float f3 = (float)this.rasterWidth / (float)this.scaleFactor;
            float f4 = (float)this.rasterHeight / (float)this.scaleFactor;
            painterExtension.paint(graphics2D, f3, f4);
        }
    }

    public void renderFrom(@NotNull BasicRenderer basicRenderer) {
        this.ensureConfigured();
        if (this.data != null) {
            this.isEmpty = false;
            float f = (float)this.rasterWidth / (float)this.scaleFactor;
            float f2 = (float)this.rasterHeight / (float)this.scaleFactor;
            basicRenderer.render(this.data, this.rasterWidth, this.rasterHeight, f, f2);
        }
    }

    public void blendFrom(@NotNull ReusableCompositor reusableCompositor, @NotNull PixelOperator pixelOperator) {
        this.blendFrom(reusableCompositor, pixelOperator, 0, 0, this.rasterWidth, this.rasterHeight);
    }

    public void blendFrom(@NotNull ReusableCompositor reusableCompositor, @NotNull PixelOperator pixelOperator, int n, int n2, int n3, int n4) {
        int[] nArray;
        this.ensureConfigured();
        if (this.data != null && (nArray = reusableCompositor.data) != null) {
            int n5 = reusableCompositor.getRasterWidth();
            for (int i = 0; i < n4; ++i) {
                int n6 = n2 + i;
                if (n6 < 0 || n6 >= this.rasterHeight) continue;
                for (int j = 0; j < n3; ++j) {
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    int n11;
                    int n12 = n + j;
                    if (n12 < 0 || n12 >= this.rasterWidth || (n11 = (n10 = pixelOperator.combine(n9 = this.data[n8 = n6 * this.rasterWidth + n12], n7 = nArray[i * n5 + j])) >> 24 & 0xFF) == 0) continue;
                    this.data[n8] = n10;
                    this.isEmpty = false;
                }
            }
        }
    }

    public void erase(int n, int n2, int n3, int n4) {
        if (n3 > 0 && n4 > 0) {
            this.ensureConfigured();
            if (this.data != null) {
                for (int i = 0; i < n4; ++i) {
                    int n5 = n2 + i;
                    if (n5 < 0 || n5 >= this.rasterHeight) continue;
                    for (int j = 0; j < n3; ++j) {
                        int n6 = n + j;
                        if (n6 < 0 || n6 >= this.rasterWidth) continue;
                        this.data[n5 * this.rasterWidth + n6] = 0;
                    }
                }
            }
        }
    }

    @Nullable
    public BufferedImage getImage() {
        this.ensureConfigured();
        if (this.b == null && this.data != null) {
            this.b = BasicImageSupport.createImage(this.data, this.rasterWidth, this.rasterHeight);
        }
        return this.b;
    }

    public void paint(@NotNull Graphics2D graphics2D) {
        BufferedImage bufferedImage = this.getImage();
        if (bufferedImage != null) {
            graphics2D.drawImage(bufferedImage, null, null);
        }
    }

    public static interface PixelSource {
        public void composeTo(@NotNull ReusableCompositor var1);
    }

    public static interface PixelOperator {
        public int combine(int var1, int var2);
    }
}

