/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.Image;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.fc.OSXFile;

public class SidebarTreeNode
extends DefaultMutableTreeNode {
    @NotNull
    private OSXFile.SystemItemInfo info;
    @NotNull
    private String name;
    @Nullable
    private File file;
    @NotNull
    private Icon icon;
    @Nullable
    private Icon darkIcon;

    public SidebarTreeNode(@NotNull OSXFile.SystemItemInfo systemItemInfo, @Nullable Icon icon) {
        this.info = systemItemInfo;
        this.name = systemItemInfo.getName();
        this.file = new File(systemItemInfo.getPath());
        this.icon = SidebarTreeNode.determineIcon(systemItemInfo.getIcon(), icon);
    }

    @NotNull
    private static Icon determineIcon(@Nullable Icon icon, @Nullable Icon icon2) {
        if (icon2 != null) {
            return icon2;
        }
        if (icon == null) {
            throw new IllegalArgumentException("Icon required");
        }
        return icon;
    }

    @Nullable
    public File getResolvedFile() {
        return this.file;
    }

    @NotNull
    String getUserName() {
        return this.name;
    }

    @NotNull
    Icon getIcon(@NotNull AquaAppearance aquaAppearance) {
        if (aquaAppearance.isDark()) {
            Image image;
            if (this.darkIcon == null && (image = AquaImageFactory.getProcessedImage(this.icon, AquaImageFactory.INVERT_FOR_DARK_MODE)) != null) {
                this.darkIcon = new ImageIcon(image);
            }
            if (this.darkIcon != null) {
                return this.darkIcon;
            }
        }
        return this.icon;
    }

    @NotNull
    Icon getBasicIcon() {
        return this.icon;
    }

    public void update(@NotNull OSXFile.SystemItemInfo systemItemInfo) {
        this.info = systemItemInfo;
        if (systemItemInfo.getIcon() != null) {
            this.icon = systemItemInfo.getIcon();
            this.darkIcon = null;
        }
    }

    public int getSequenceNumber() {
        return this.info.getSequenceNumber();
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }
}

