/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicToolBarUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceContext;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaButtonBorder;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaComponentUI;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.BasicContextualColors;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.LayoutConfiguration;

public class AquaToolBarUI
extends BasicToolBarUI
implements SwingConstants,
AquaComponentUI {
    private LayoutManager originalLayoutManager;
    @NotNull
    protected BasicContextualColors colors = AquaColors.CLEAR_CONTROL_COLORS;
    @Nullable
    protected AppearanceContext appearanceContext;
    protected boolean isRendering;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaToolBarUI();
    }

    public static Border getToolBarBorder(@NotNull JToolBar jToolBar) {
        AquaToolBarUI aquaToolBarUI = AquaUtils.getUI(jToolBar, AquaToolBarUI.class);
        return aquaToolBarUI != null ? aquaToolBarUI.createBorder() : null;
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        LookAndFeel.installProperty(jComponent, "opaque", false);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.installBorder();
        this.originalLayoutManager = this.toolBar.getLayout();
        if (this.originalLayoutManager instanceof UIResource) {
            this.toolBar.setLayout(new AquaToolBarLayout());
        }
        this.toolBar.setFloatable(false);
        this.configureAppearanceContext(null);
    }

    protected void installBorder() {
        Border border = this.toolBar.getBorder();
        if (border == null || border instanceof UIResource) {
            this.toolBar.setBorder(this.createBorder());
        }
    }

    @NotNull
    protected Border createBorder() {
        return new ToolBarBorder();
    }

    @Override
    protected void uninstallDefaults() {
        LayoutManager layoutManager = this.toolBar.getLayout();
        if (layoutManager instanceof AquaToolBarLayout) {
            this.toolBar.setLayout(this.originalLayoutManager);
        }
        super.uninstallDefaults();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        AppearanceManager.installListener(this.toolBar);
    }

    @Override
    protected void uninstallListeners() {
        AppearanceManager.uninstallListener(this.toolBar);
        super.uninstallListeners();
    }

    @Override
    public void appearanceChanged(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
        this.configureAppearanceContext(aquaAppearance);
    }

    @Override
    public void activeStateChanged(@NotNull JComponent jComponent, boolean bl) {
        this.configureAppearanceContext(null);
    }

    protected void configureAppearanceContext(@Nullable AquaAppearance aquaAppearance) {
        if (aquaAppearance == null) {
            aquaAppearance = AppearanceManager.ensureAppearance(this.toolBar);
        }
        AquaUIPainter.State state = this.getState();
        this.appearanceContext = new AppearanceContext(aquaAppearance, state, false, false);
        AquaColors.installColors(this.toolBar, this.appearanceContext, this.colors);
        this.toolBar.repaint();
    }

    protected AquaUIPainter.State getState() {
        return AquaFocusHandler.isActive(this.toolBar) ? AquaUIPainter.State.ACTIVE : AquaUIPainter.State.INACTIVE;
    }

    @Override
    protected void setBorderToNonRollover(Component component) {
    }

    @Override
    protected void setBorderToNormal(Component component) {
    }

    @Override
    protected void setBorderToRollover(Component component) {
    }

    @Override
    protected RootPaneContainer createFloatingWindow(JToolBar jToolBar) {
        RootPaneContainer rootPaneContainer = super.createFloatingWindow(jToolBar);
        rootPaneContainer.getRootPane().putClientProperty("Window.style", "small");
        return rootPaneContainer;
    }

    public static boolean isTallFormatToolBar(@NotNull JComponent jComponent) {
        int n = jComponent.getComponentCount();
        for (int i = 0; i < n; ++i) {
            AbstractButton abstractButton;
            Component component = jComponent.getComponent(i);
            if (!(component instanceof AbstractButton) || !AquaToolBarUI.isTallFormatButton(abstractButton = (AbstractButton)component)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isTallFormatButton(AbstractButton abstractButton) {
        AquaButtonBorder aquaButtonBorder;
        LayoutConfiguration layoutConfiguration;
        Border border = abstractButton.getBorder();
        if (border instanceof AquaButtonBorder && (layoutConfiguration = (aquaButtonBorder = (AquaButtonBorder)border).getLayoutConfiguration(abstractButton)) instanceof ButtonLayoutConfiguration) {
            ButtonLayoutConfiguration buttonLayoutConfiguration = (ButtonLayoutConfiguration)layoutConfiguration;
            AquaUIPainter.ButtonWidget buttonWidget = buttonLayoutConfiguration.getButtonWidget();
            return buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_TOOLBAR_ITEM;
        }
        return false;
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        AquaAppearance aquaAppearance = AppearanceManager.registerCurrentAppearance(jComponent);
        if (!this.isRendering && jComponent.isOpaque()) {
            Color color = jComponent.getBackground();
            AquaUtils.fillRect(graphics, jComponent, color, 3);
        }
        this.paint(graphics, jComponent);
        AppearanceManager.restoreCurrentAppearance(aquaAppearance);
    }

    @Override
    protected void paintDragWindow(Graphics graphics) {
        graphics.setColor(this.dragWindow.getBackground());
        int n = this.dragWindow.getWidth();
        int n2 = this.dragWindow.getHeight();
        graphics.fillRect(0, 0, n, n2);
        if (this.dragWindow.getOrientation() == this.toolBar.getOrientation()) {
            this.isRendering = true;
            this.toolBar.paint(graphics);
            this.isRendering = false;
        }
    }

    @Override
    protected MouseInputListener createDockingListener() {
        return new AquaDockingListener(this.toolBar);
    }

    protected void setDragOffset(Point point) {
        if (!GraphicsEnvironment.isHeadless()) {
            if (this.dragWindow == null) {
                this.dragWindow = this.createDragWindow(this.toolBar);
            }
            this.dragWindow.setOffset(point);
        }
    }

    @Override
    public Color getDockingColor() {
        return AquaUtils.getWindowBackground(this.toolBar);
    }

    @Override
    public Color getFloatingColor() {
        return this.getDockingColor();
    }

    private class AquaToolBarLayout
    implements LayoutManager2,
    Serializable,
    PropertyChangeListener,
    UIResource {
        GroupLayout gl;
        GroupLayout.SequentialGroup major;
        GroupLayout.ParallelGroup minor;
        boolean isConfigured;

        AquaToolBarLayout() {
        }

        private void configure() {
            if (!this.isConfigured) {
                this.isConfigured = true;
            }
            this.gl = new GroupLayout(AquaToolBarUI.this.toolBar);
            this.major = this.gl.createSequentialGroup();
            this.minor = this.gl.createParallelGroup(GroupLayout.Alignment.CENTER);
            int n = AquaToolBarUI.this.toolBar.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = AquaToolBarUI.this.toolBar.getComponent(i);
                if (i > 0) {
                    this.major.addGap(5);
                }
                this.major.addComponent(component);
                this.minor.addComponent(component);
            }
            if (AquaToolBarUI.this.toolBar.getOrientation() == 0) {
                this.gl.setHorizontalGroup(this.major);
                this.gl.setVerticalGroup(this.minor);
            } else {
                this.gl.setVerticalGroup(this.major);
                this.gl.setHorizontalGroup(this.minor);
            }
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
            this.invalidateLayout(AquaToolBarUI.this.toolBar);
        }

        @Override
        public void addLayoutComponent(Component component, Object object) {
            this.invalidateLayout(AquaToolBarUI.this.toolBar);
        }

        @Override
        public void removeLayoutComponent(Component component) {
            this.invalidateLayout(AquaToolBarUI.this.toolBar);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            this.configure();
            return this.gl.preferredLayoutSize(container);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            this.configure();
            return this.gl.minimumLayoutSize(container);
        }

        @Override
        public Dimension maximumLayoutSize(Container container) {
            this.configure();
            return this.gl.maximumLayoutSize(container);
        }

        @Override
        public void layoutContainer(Container container) {
            this.configure();
            this.gl.layoutContainer(container);
        }

        @Override
        public float getLayoutAlignmentX(Container container) {
            this.configure();
            return this.gl.getLayoutAlignmentX(container);
        }

        @Override
        public float getLayoutAlignmentY(Container container) {
            this.configure();
            return this.gl.getLayoutAlignmentY(container);
        }

        @Override
        public void invalidateLayout(Container container) {
            this.isConfigured = false;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("orientation")) {
                this.isConfigured = false;
            }
        }
    }

    private class ToolBarBorder
    extends AbstractBorder
    implements UIResource,
    SwingConstants {
        private ToolBarBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JToolBar jToolBar;
            graphics.translate(n, n2);
            if (!AquaToolBarUI.this.isRendering && component.isOpaque()) {
                AquaUtils.fillRect(graphics, component, 3, 0, 0, n3 - 1, n4 - 1);
            }
            if (component instanceof JToolBar && (jToolBar = (JToolBar)component).isFloatable()) {
                this.paintHandle(jToolBar, graphics, n3, n4);
            }
            graphics.translate(-n, -n2);
        }

        private void paintHandle(JToolBar jToolBar, Graphics graphics, int n, int n2) {
            boolean bl;
            Color color = graphics.getColor();
            ComponentOrientation componentOrientation = jToolBar.getComponentOrientation();
            boolean bl2 = bl = jToolBar.getOrientation() == 0;
            if (bl) {
                if (componentOrientation.isLeftToRight()) {
                    this.fillHandle(graphics, 2, 2, 10, n2 - 2, true);
                } else {
                    this.fillHandle(graphics, n - 10, 2, n - 2, n2 - 2, true);
                }
            } else {
                this.fillHandle(graphics, 2, 2, n - 2, 10, false);
            }
            graphics.setColor(color);
        }

        private void fillHandle(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
            graphics.setColor(UIManager.getColor("ToolBar.borderHandleColor"));
            if (bl) {
                int n5 = n4 - n2 - 2;
                graphics.fillRect(n + 2, n2 + 1, 1, n5);
                graphics.fillRect(n + 5, n2 + 1, 1, n5);
            } else {
                int n6 = n3 - n - 2;
                graphics.fillRect(n + 1, n2 + 2, n6, 1);
                graphics.fillRect(n + 1, n2 + 5, n6, 1);
            }
        }

        @Override
        public Insets getBorderInsets(Component component) {
            Insets insets = new Insets(5, 5, 5, 5);
            return this.getBorderInsets(component, insets);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2;
            JToolBar jToolBar = (JToolBar)component;
            boolean bl = AquaToolBarUI.isTallFormatToolBar(jToolBar);
            insets.left = 4;
            insets.right = 4;
            insets.top = 4;
            int n = insets.bottom = bl ? 0 : 4;
            if (jToolBar.isFloatable()) {
                if (jToolBar.getOrientation() == 0) {
                    insets.left = 12;
                } else {
                    insets.top = 12;
                }
            }
            if ((insets2 = jToolBar.getMargin()) != null) {
                insets.left += insets2.left;
                insets.top += insets2.top;
                insets.right += insets2.right;
                insets.bottom += insets2.bottom;
            }
            return insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    protected class AquaDockingListener
    extends BasicToolBarUI.DockingListener {
        private boolean pressedInBumps;

        public AquaDockingListener(JToolBar jToolBar) {
            super(AquaToolBarUI.this, jToolBar);
            this.pressedInBumps = false;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            if (!this.toolBar.isEnabled()) {
                return;
            }
            this.pressedInBumps = false;
            Rectangle rectangle = new Rectangle();
            if (this.toolBar.getOrientation() == 0) {
                int n = AquaUtils.isLeftToRight(this.toolBar) ? 0 : this.toolBar.getSize().width - 14;
                rectangle.setBounds(n, 0, 14, this.toolBar.getSize().height);
            } else {
                rectangle.setBounds(0, 0, this.toolBar.getSize().width, 14);
            }
            if (rectangle.contains(mouseEvent.getPoint())) {
                this.pressedInBumps = true;
                Point point = mouseEvent.getPoint();
                if (!AquaUtils.isLeftToRight(this.toolBar)) {
                    point.x -= this.toolBar.getSize().width - this.toolBar.getPreferredSize().width;
                }
                AquaToolBarUI.this.setDragOffset(point);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.pressedInBumps) {
                super.mouseDragged(mouseEvent);
            }
        }
    }
}

