/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.EventObject;
import javax.swing.CellRendererPane;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceContext;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaComponentUI;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.BasicTableUIPainter;
import org.violetlib.aqua.ContainerContextualColors;
import org.violetlib.aqua.SelectionRepaintable;
import org.violetlib.jnr.aqua.AquaUIPainter;

public class AquaTableUI
extends BasicTableUI
implements SelectionRepaintable,
AquaComponentUI {
    public static final String TABLE_STYLE_KEY = "JTable.style";
    public static final String QUAQUA_TABLE_STYLE_KEY = "Quaqua.Table.style";
    protected final PropertyChangeListener propertyChangeListener = new TablePropertyChangeListener();
    protected final ListSelectionListener selectionListener = new SelectionListener();
    @Nullable
    private CellEditorFocusManager cellEditorFocusManager = new CellEditorFocusManager();
    @Nullable
    private TableCellRenderer originalBooleanRenderer;
    @Nullable
    private TableCellEditor originalObjectEditor;
    @Nullable
    private TableCellEditor originalNumberEditor;
    @Nullable
    private TableCellEditor originalBooleanEditor;
    protected AquaTablePainter painter;
    private boolean isStriped = false;
    @NotNull
    protected ContainerContextualColors colors = AquaColors.CONTAINER_COLORS;
    @Nullable
    protected AppearanceContext appearanceContext;
    @Nullable
    protected Color actualTableBackground;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaTableUI();
    }

    @Override
    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.painter = new AquaTablePainter(this.table, this.rendererPane);
        this.table.putClientProperty("terminateEditOnFocusLost", true);
        this.table.putClientProperty("JTable.autoStartsEdit", false);
        this.table.putClientProperty("JComponent.isCellContainer", true);
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        LookAndFeel.installProperty(this.table, "rowHeight", 19);
        this.originalBooleanRenderer = this.installRendererIfPossible(Boolean.class, AquaBooleanRenderer.class);
        this.originalObjectEditor = this.installEditorIfPossible(Object.class, AquaObjectEditor.class);
        this.originalNumberEditor = this.installEditorIfPossible(Number.class, AquaNumberEditor.class);
        this.originalBooleanEditor = this.installEditorIfPossible(Boolean.class, AquaBooleanEditor.class);
        this.isStriped = this.getStripedValue();
        this.configureAppearanceContext(null);
    }

    @Override
    protected void uninstallDefaults() {
        TableCellEditor tableCellEditor;
        TableCellEditor tableCellEditor2;
        TableCellEditor tableCellEditor3;
        TableCellRenderer tableCellRenderer = this.table.getDefaultRenderer(Boolean.class);
        if (tableCellRenderer instanceof AquaBooleanRenderer) {
            this.table.setDefaultRenderer(Boolean.class, this.originalBooleanRenderer);
        }
        if ((tableCellEditor3 = this.table.getDefaultEditor(Object.class)) instanceof AquaObjectEditor) {
            this.table.setDefaultEditor(Object.class, this.originalObjectEditor);
        }
        if ((tableCellEditor2 = this.table.getDefaultEditor(Number.class)) instanceof AquaNumberEditor) {
            this.table.setDefaultEditor(Number.class, this.originalNumberEditor);
        }
        if ((tableCellEditor = this.table.getDefaultEditor(Boolean.class)) instanceof AquaBooleanEditor) {
            this.table.setDefaultEditor(Boolean.class, this.originalBooleanEditor);
        }
        this.painter = null;
        super.uninstallDefaults();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.table.addPropertyChangeListener(this.propertyChangeListener);
        this.updateSelectionListener(null);
        AppearanceManager.installListener(this.table);
    }

    @Override
    protected void uninstallListeners() {
        AppearanceManager.uninstallListener(this.table);
        this.table.getSelectionModel().removeListSelectionListener(this.selectionListener);
        this.table.removePropertyChangeListener(this.propertyChangeListener);
        this.cellEditorFocusManager.detach();
        super.uninstallListeners();
    }

    protected void updateSelectionListener(ListSelectionModel listSelectionModel) {
        if (listSelectionModel != null) {
            listSelectionModel.removeListSelectionListener(this.selectionListener);
        }
        this.table.getSelectionModel().addListSelectionListener(this.selectionListener);
    }

    @Override
    public void appearanceChanged(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
        this.configureAppearanceContext(aquaAppearance);
    }

    @Override
    public void activeStateChanged(@NotNull JComponent jComponent, boolean bl) {
        this.configureAppearanceContext(null);
    }

    protected void configureAppearanceContext(@Nullable AquaAppearance aquaAppearance) {
        if (aquaAppearance == null) {
            aquaAppearance = AppearanceManager.ensureAppearance(this.table);
        }
        AquaUIPainter.State state = this.getState();
        this.appearanceContext = new AppearanceContext(aquaAppearance, state, false, false);
        this.colors = this.isStriped ? AquaColors.STRIPED_CONTAINER_COLORS : AquaColors.CONTAINER_COLORS;
        this.colors.configureForContainer();
        this.actualTableBackground = this.colors.getBackground(this.appearanceContext);
        AquaColors.installColors(this.table, this.appearanceContext, this.colors);
        this.table.repaint();
    }

    protected AquaUIPainter.State getState() {
        return this.table.isEnabled() ? (this.shouldDisplayAsFocused() ? AquaUIPainter.State.ACTIVE_DEFAULT : AquaUIPainter.State.ACTIVE) : AquaUIPainter.State.DISABLED;
    }

    protected boolean shouldDisplayAsFocused() {
        return AquaFocusHandler.hasFocus(this.table) || this.table.isEditing() && AquaFocusHandler.isActive(this.table);
    }

    private void updateStriped() {
        boolean bl = this.getStripedValue();
        if (bl != this.isStriped) {
            this.isStriped = bl;
            this.configureAppearanceContext(null);
        }
    }

    private boolean getStripedValue() {
        String string = AquaTableUI.getStyleProperty(this.table);
        return "striped".equals(string) && this.isBackgroundClear();
    }

    private boolean isBackgroundClear() {
        Color color = this.table.getBackground();
        return color == null || color.getAlpha() == 0 || color instanceof ColorUIResource;
    }

    public boolean isStriped() {
        return this.isStriped;
    }

    protected boolean tableHasFocus() {
        if (this.table.isEditing()) {
            return AquaFocusHandler.isActive(this.table);
        }
        return AquaFocusHandler.hasFocus(this.table);
    }

    protected boolean isStyleProperty(String string) {
        return AquaUtils.isProperty(string, TABLE_STYLE_KEY, QUAQUA_TABLE_STYLE_KEY);
    }

    protected static String getStyleProperty(JTable jTable) {
        return AquaUtils.getProperty(jTable, TABLE_STYLE_KEY, QUAQUA_TABLE_STYLE_KEY);
    }

    @Override
    public void repaintSelection() {
        this.configureAppearanceContext(null);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        AquaAppearance aquaAppearance = AppearanceManager.registerCurrentAppearance(jComponent);
        Color color = this.getBackgroundColor();
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        this.paint(graphics, jComponent);
        AppearanceManager.restoreCurrentAppearance(aquaAppearance);
    }

    @Nullable
    private Color getBackgroundColor() {
        if (this.table.isOpaque()) {
            if (this.isStriped && this.actualTableBackground != null) {
                return this.actualTableBackground;
            }
            return this.table.getBackground();
        }
        return null;
    }

    public void repaintScrollPaneCorner() {
        JScrollPane jScrollPane;
        Component component;
        Container container;
        Container container2 = this.table.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane && (component = (jScrollPane = (JScrollPane)container).getCorner("UPPER_TRAILING_CORNER")) != null) {
            component.repaint();
        }
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.painter != null && this.appearanceContext != null) {
            this.painter.paint(graphics, jComponent);
        }
    }

    protected TableCellRenderer installRendererIfPossible(@NotNull Class<?> clazz, @NotNull Class<? extends TableCellRenderer> clazz2) {
        TableCellRenderer tableCellRenderer;
        TableCellRenderer tableCellRenderer2 = this.table.getDefaultRenderer(clazz);
        if (this.isDefault(clazz, tableCellRenderer2) && (tableCellRenderer = AquaUtils.instantiate(clazz2)) != null) {
            this.table.setDefaultRenderer(clazz, tableCellRenderer);
        }
        return tableCellRenderer2;
    }

    protected TableCellEditor installEditorIfPossible(@NotNull Class<?> clazz, @NotNull Class<? extends TableCellEditor> clazz2) {
        TableCellEditor tableCellEditor;
        TableCellEditor tableCellEditor2 = this.table.getDefaultEditor(clazz);
        if (this.isDefault(clazz, tableCellEditor2) && (tableCellEditor = AquaUtils.instantiate(clazz2)) != null) {
            this.table.setDefaultEditor(clazz, tableCellEditor);
        }
        return tableCellEditor2;
    }

    protected boolean isDefault(@NotNull Class<?> clazz, @Nullable Object object) {
        if (object instanceof UIResource) {
            return true;
        }
        if (object instanceof DefaultCellEditor) {
            DefaultCellEditor defaultCellEditor = (DefaultCellEditor)object;
            String string = defaultCellEditor.getClass().getName();
            if (clazz == Object.class) {
                return string.equals("javax.swing.JTable$GenericEditor");
            }
            if (clazz == Number.class) {
                return string.equals("javax.swing.JTable$NumberEditor");
            }
            if (clazz == Boolean.class) {
                return string.equals("javax.swing.JTable$BooleanEditor");
            }
        }
        return false;
    }

    protected class CellEditorFocusManager
    implements FocusListener {
        @Nullable
        private Component managedCellEditorComponent;

        protected CellEditorFocusManager() {
        }

        public void cellEditorChanged(@Nullable TableCellEditor tableCellEditor, @Nullable TableCellEditor tableCellEditor2) {
            this.detach();
            if (tableCellEditor2 != null) {
                this.managedCellEditorComponent = AquaTableUI.this.table.getEditorComponent();
                this.managedCellEditorComponent.requestFocus();
                this.managedCellEditorComponent.addFocusListener(this);
            }
        }

        public void detach() {
            if (this.managedCellEditorComponent != null) {
                this.managedCellEditorComponent.removeFocusListener(this);
                this.managedCellEditorComponent = null;
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            Component component;
            TableCellEditor tableCellEditor;
            if (!(focusEvent.isTemporary() || (tableCellEditor = AquaTableUI.this.table.getCellEditor()) == null || (component = focusEvent.getOppositeComponent()) != null && this.isPartOfEditor(AquaTableUI.this.table.getEditorComponent(), component) || tableCellEditor.stopCellEditing())) {
                tableCellEditor.cancelCellEditing();
            }
        }

        private boolean isPartOfEditor(@NotNull Component component, @NotNull Component component2) {
            while (component2 != null && component2 != AquaTableUI.this.table) {
                if (component2 == component) {
                    return true;
                }
                component2 = component2.getParent();
            }
            return false;
        }
    }

    protected class TablePropertyChangeListener
    implements PropertyChangeListener {
        protected TablePropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string != null) {
                Object object;
                if (string.equals("enabled")) {
                    AquaTableUI.this.configureAppearanceContext(null);
                    return;
                }
                if (string.equals("selectionModel")) {
                    object = (ListSelectionModel)propertyChangeEvent.getOldValue();
                    AquaTableUI.this.updateSelectionListener((ListSelectionModel)object);
                }
                if (AquaTableUI.this.isStyleProperty(string)) {
                    AquaTableUI.this.updateStriped();
                    AquaTableUI.this.table.repaint();
                }
                if (string.equals("background")) {
                    AquaTableUI.this.repaintScrollPaneCorner();
                }
                if (string.equals("tableCellEditor") && AquaTableUI.this.cellEditorFocusManager != null) {
                    object = (TableCellEditor)propertyChangeEvent.getOldValue();
                    TableCellEditor tableCellEditor = (TableCellEditor)propertyChangeEvent.getNewValue();
                    AquaTableUI.this.cellEditorFocusManager.cellEditorChanged((TableCellEditor)object, tableCellEditor);
                }
            }
        }
    }

    protected class SelectionListener
    implements ListSelectionListener {
        protected SelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (AquaTableUI.this.table.getRowCount() <= 0 || AquaTableUI.this.table.getColumnCount() <= 0) {
                return;
            }
            int n = this.limit(listSelectionEvent.getFirstIndex(), 0, AquaTableUI.this.table.getRowCount() - 1);
            int n2 = this.limit(listSelectionEvent.getLastIndex(), 0, AquaTableUI.this.table.getRowCount() - 1);
            Rectangle rectangle = AquaTableUI.this.table.getCellRect(n, 0, true);
            Rectangle rectangle2 = AquaTableUI.this.table.getCellRect(n2, 0, true);
            Rectangle rectangle3 = new Rectangle(rectangle.x, rectangle.y, AquaTableUI.this.table.getWidth(), rectangle2.y + rectangle2.height);
            AquaTableUI.this.table.repaint(rectangle3);
        }

        protected int limit(int n, int n2, int n3) {
            return Math.min(n3, Math.max(n, n2));
        }
    }

    public class FocusHandler
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.focusChanged();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.focusChanged();
        }

        private void focusChanged() {
            AquaTableUI.this.configureAppearanceContext(null);
        }
    }

    public class MouseInputHandler
    extends BasicTableUI.MouseInputHandler {
        public MouseInputHandler() {
            super(AquaTableUI.this);
        }
    }

    protected class AquaTablePainter
    extends BasicTableUIPainter {
        protected boolean tableHasFocus;

        public AquaTablePainter(JTable jTable, CellRendererPane cellRendererPane) {
            super(jTable, cellRendererPane);
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            assert (AquaTableUI.this.appearanceContext != null);
            this.tableHasFocus = AquaTableUI.this.tableHasFocus();
            boolean bl = this.table.getSelectedRowCount() > 0 && this.table.getRowSelectionAllowed() || this.table.getSelectedColumnCount() > 0 && this.table.getColumnSelectionAllowed();
            Rectangle rectangle = graphics.getClipBounds();
            Rectangle rectangle2 = this.table.getBounds();
            rectangle2.y = 0;
            rectangle2.x = 0;
            if (!rectangle2.intersects(rectangle)) {
                return;
            }
            boolean bl2 = this.table.getComponentOrientation().isLeftToRight();
            Point point = rectangle.getLocation();
            Point point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
            int n = this.table.rowAtPoint(point);
            int n2 = this.table.rowAtPoint(point2);
            boolean bl3 = false;
            if (n == -1) {
                n = 0;
            }
            if (n2 == -1) {
                n2 = this.table.getRowCount() - 1;
                bl3 = true;
            }
            int n3 = this.table.columnAtPoint(bl2 ? point : point2);
            int n4 = this.table.columnAtPoint(bl2 ? point2 : point);
            boolean bl4 = false;
            if (n3 == -1) {
                n3 = 0;
            }
            if (n4 == -1) {
                n4 = this.table.getColumnCount() - 1;
                bl4 = true;
            }
            AquaTableUI.this.colors.configureForContainer();
            if (AquaTableUI.this.isStriped || bl) {
                this.paintBackground(graphics, n, n2, n3, n4);
            }
            this.paintGrid(graphics, n, n2, n3, n4, bl3, bl4);
            this.paintCells(graphics, n, n2, n3, n4);
            AquaTableUI.this.colors.configureForContainer();
        }

        protected void paintBackground(Graphics graphics, int n, int n2, int n3, int n4) {
            int n5;
            Color color;
            int n6;
            int n7;
            boolean bl;
            Rectangle rectangle = graphics.getClipBounds();
            boolean bl2 = this.table.getSelectedRowCount() > 0 && this.table.getRowSelectionAllowed() && !this.table.getColumnSelectionAllowed();
            boolean bl3 = bl = this.table.getSelectedColumnCount() > 0 && this.table.getColumnSelectionAllowed() && !this.table.getRowSelectionAllowed();
            assert (AquaTableUI.this.appearanceContext != null);
            int n8 = 0;
            boolean bl4 = this.table.isEditing();
            int n9 = this.table.getEditingRow();
            int n10 = this.table.getEditingColumn();
            for (n7 = n; n7 <= n2; ++n7) {
                Serializable serializable;
                Rectangle rectangle2 = this.table.getCellRect(n7, n3, true);
                int n11 = n6 = bl2 && this.table.isRowSelected(n7) ? 1 : 0;
                if (AquaTableUI.this.isStriped) {
                    AquaTableUI.this.colors.configureForRow(n7, n6 != 0);
                } else {
                    AquaTableUI.this.colors.configureForRow(n6 != 0);
                }
                color = AquaTableUI.this.colors.getBackground(AquaTableUI.this.appearanceContext);
                if (!AquaTableUI.this.isStriped && n6 == 0 && AquaColors.isPriority(serializable = this.table.getBackground())) {
                    color = serializable;
                }
                graphics.setColor(color);
                if (n6 != 0 && bl4 && n9 == n7 && n10 >= n3 && n10 <= n4) {
                    serializable = this.table.getCellRect(n7, n10, true);
                    int n12 = ((Rectangle)serializable).x;
                    int n13 = n12 + ((Rectangle)serializable).width;
                    graphics.fillRect(rectangle.x, rectangle2.y, n12 - rectangle.x, rectangle2.height);
                    graphics.fillRect(n13, rectangle2.y, rectangle.x + rectangle.width - n13, rectangle2.height);
                    if (AquaTableUI.this.isStriped) {
                        AquaTableUI.this.colors.configureForRow(n7, false);
                        Color color2 = AquaTableUI.this.colors.getBackground(AquaTableUI.this.appearanceContext);
                        graphics.setColor(color2);
                        graphics.fillRect(n12, rectangle2.y, n13 - n12, rectangle2.height);
                    }
                } else {
                    graphics.fillRect(rectangle.x, rectangle2.y, rectangle.width, rectangle2.height);
                }
                n8 = rectangle2.y + rectangle2.height;
            }
            if (AquaTableUI.this.isStriped && n8 < (n7 = rectangle.y + rectangle.height) && (n5 = this.table.getRowHeight()) > 0) {
                n6 = n2 + 1;
                while (n8 < n7) {
                    AquaTableUI.this.colors.configureForRow(n6, false);
                    color = AquaTableUI.this.colors.getBackground(AquaTableUI.this.appearanceContext);
                    graphics.setColor(color);
                    graphics.fillRect(rectangle.x, n8, rectangle.width, n5);
                    ++n6;
                    n8 += n5;
                }
            }
        }

        protected void paintGrid(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
            block11: {
                int n5;
                Object object;
                assert (AquaTableUI.this.appearanceContext != null);
                Color color = AquaTableUI.this.colors.getGrid(AquaTableUI.this.appearanceContext);
                graphics.setColor(color);
                Rectangle rectangle = this.table.getCellRect(n, n3, true);
                Rectangle rectangle2 = this.table.getCellRect(n2, n4, true);
                Rectangle rectangle3 = rectangle.union(rectangle2);
                if (this.table.getShowHorizontalLines()) {
                    int n6;
                    if (bl2) {
                        object = graphics.getClipBounds();
                        n5 = rectangle3.y;
                        for (n6 = n; n6 <= n2; ++n6) {
                            graphics.fillRect(((Rectangle)object).x, (n5 += this.table.getRowHeight(n6)) - 1, ((Rectangle)object).width, 1);
                        }
                    } else {
                        int n7 = rectangle3.x + rectangle3.width;
                        n5 = rectangle3.y;
                        for (n6 = n; n6 <= n2; ++n6) {
                            graphics.fillRect(rectangle3.x, (n5 += this.table.getRowHeight(n6)) - 1, n7, 1);
                        }
                    }
                }
                if (!this.table.getShowVerticalLines()) break block11;
                object = this.table.getColumnModel();
                n5 = rectangle3.y + rectangle3.height;
                if (bl) {
                    Rectangle rectangle4 = graphics.getClipBounds();
                    n5 = rectangle4.y + rectangle4.height;
                }
                if (this.table.getComponentOrientation().isLeftToRight()) {
                    int n8 = rectangle3.x;
                    for (int i = n3; i <= n4; ++i) {
                        int n9 = object.getColumn(i).getWidth();
                        graphics.fillRect((n8 += n9) - 1, 0, 1, n5);
                    }
                } else {
                    int n10 = rectangle3.x;
                    for (int i = n4; i >= n3; --i) {
                        int n11 = object.getColumn(i).getWidth();
                        graphics.fillRect((n10 += n11) - 1, 0, 1, n5);
                    }
                }
            }
        }

        @Override
        protected void paintCell(Graphics graphics, Rectangle rectangle, int n, int n2) {
            if (this.table.isEditing() && this.table.getEditingRow() == n && this.table.getEditingColumn() == n2) {
                this.paintEditorCell(graphics, rectangle, n, n2);
            } else {
                this.paintRenderedCell(graphics, rectangle, n, n2);
            }
        }

        protected void paintEditorCell(@NotNull Graphics graphics, @NotNull Rectangle rectangle, int n, int n2) {
            Component component = this.table.getEditorComponent();
            component.setBounds(rectangle);
            component.validate();
        }

        protected void paintRenderedCell(@NotNull Graphics graphics, @NotNull Rectangle rectangle, int n, int n2) {
            TableCellRenderer tableCellRenderer = this.table.getCellRenderer(n, n2);
            Component component = this.table.prepareRenderer(tableCellRenderer, n, n2);
            this.rendererPane.paintComponent(graphics, component, this.table, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        }

        @Override
        protected void paintDraggedArea(Graphics graphics, int n, int n2, TableColumn tableColumn, int n3) {
            int n4;
            int n5;
            int n6 = this.viewIndexForColumn(tableColumn);
            Rectangle rectangle = this.table.getCellRect(n, n6, true);
            Rectangle rectangle2 = this.table.getCellRect(n2, n6, true);
            Rectangle rectangle3 = rectangle.union(rectangle2);
            graphics.setColor(this.table.getParent().getBackground());
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            rectangle3.x += n3;
            this.paintDraggedAreaBackground(graphics, rectangle3, n, n2);
            assert (AquaTableUI.this.appearanceContext != null);
            Color color = AquaTableUI.this.colors.getGrid(AquaTableUI.this.appearanceContext);
            if (this.table.getShowVerticalLines()) {
                graphics.setColor(color);
                n5 = rectangle3.x;
                int n7 = rectangle3.y;
                int n8 = n5 + rectangle3.width - 1;
                n4 = n7 + rectangle3.height - 1;
                graphics.drawLine(n5 - 1, n7, n5 - 1, n4);
                graphics.drawLine(n8, n7, n8, n4);
            }
            for (n5 = n; n5 <= n2; ++n5) {
                Rectangle rectangle4 = this.table.getCellRect(n5, n6, false);
                rectangle4.x += n3;
                this.paintCell(graphics, rectangle4, n5, n6);
                if (!this.table.getShowHorizontalLines()) continue;
                graphics.setColor(color);
                Rectangle rectangle5 = this.table.getCellRect(n5, n6, true);
                rectangle5.x += n3;
                n4 = rectangle5.x;
                int n9 = rectangle5.y;
                int n10 = n4 + rectangle5.width - 1;
                int n11 = n9 + rectangle5.height - 1;
                graphics.drawLine(n4, n11, n10, n11);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void paintDraggedAreaBackground(Graphics graphics, Rectangle rectangle, int n, int n2) {
            if (AquaTableUI.this.isStriped) {
                Graphics graphics2 = graphics.create();
                try {
                    graphics2.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    this.paintBackground(graphics2, n, n2, 0, this.table.getColumnCount() - 1);
                }
                finally {
                    graphics2.dispose();
                }
            } else {
                Color color = AquaTableUI.this.getBackgroundColor();
                if (color != null) {
                    graphics.setColor(color);
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            }
        }
    }

    protected static class AquaBooleanRenderer
    extends JCheckBox
    implements TableCellRenderer,
    UIResource {
        public AquaBooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(false);
            this.setOpaque(false);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setForeground(jTable.getForeground());
            }
            this.setBackground(AquaColors.CLEAR);
            this.setSelected(object != null && (Boolean)object != false);
            return this;
        }
    }

    protected static class AquaObjectEditor
    extends DefaultCellEditor
    implements UIResource {
        Class<?>[] argTypes = new Class[]{String.class};
        Constructor<?> constructor;
        Object value;

        public AquaObjectEditor() {
            super(new JTextField());
            this.getComponent().setName("Table.editor");
        }

        @Override
        public boolean stopCellEditing() {
            String string = (String)super.getCellEditorValue();
            try {
                if ("".equals(string)) {
                    if (this.constructor.getDeclaringClass() == String.class) {
                        this.value = string;
                    }
                    return super.stopCellEditing();
                }
                this.value = this.constructor.newInstance(string);
            }
            catch (Exception exception) {
                return false;
            }
            return super.stopCellEditing();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.value = null;
            try {
                Class<Object> clazz = jTable.getColumnClass(n2);
                if (clazz == Object.class) {
                    clazz = String.class;
                }
                this.constructor = clazz.getConstructor(this.argTypes);
            }
            catch (Exception exception) {
                return null;
            }
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }
    }

    protected static class AquaNumberEditor
    extends AquaObjectEditor {
        public AquaNumberEditor() {
            ((JTextField)this.getComponent()).setHorizontalAlignment(4);
        }
    }

    protected static class AquaBooleanEditor
    extends DefaultCellEditor {
        public AquaBooleanEditor() {
            super(new JCheckBox());
            JCheckBox jCheckBox = (JCheckBox)this.getComponent();
            jCheckBox.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.delegate.setValue(object);
            this.editorComponent.setOpaque(false);
            return this.editorComponent;
        }

        @Override
        public boolean shouldSelectCell(EventObject eventObject) {
            return false;
        }
    }
}

