/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.View;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceContext;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaButtonExtendedTypes;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaComponentUI;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaFullKeyboardFocusableHandler;
import org.violetlib.aqua.AquaGroupBorder;
import org.violetlib.aqua.AquaIcon;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaPainting;
import org.violetlib.aqua.AquaSegmentedButtonBorder;
import org.violetlib.aqua.AquaTabbedPaneCopyFromBasicUI;
import org.violetlib.aqua.AquaTabbedPaneTabState;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.BasicContextualColors;
import org.violetlib.aqua.FocusRingOutlineProvider;
import org.violetlib.aqua.JavaSupport;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.Painter;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonLayoutConfiguration;

public class AquaTabbedPaneUI
extends AquaTabbedPaneCopyFromBasicUI
implements AquaUtilControlSize.Sizeable,
FocusRingOutlineProvider,
AquaComponentUI {
    private static final double kNinetyDegrees = 1.5707963267948966;
    protected final AquaUIPainter.SegmentedButtonWidget buttonWidget = AquaUIPainter.SegmentedButtonWidget.BUTTON_TAB;
    protected final Insets currentContentDrawingInsets = new Insets(0, 0, 0, 0);
    protected final Insets currentContentBorderInsets = new Insets(0, 0, 0, 0);
    protected final Insets contentDrawingInsets = new Insets(0, 0, 0, 0);
    protected static final int LEFT_TAB_INDEX = -2;
    protected static final int RIGHT_TAB_INDEX = -1;
    protected static final int NO_TAB = -3;
    protected int pressedTab = -3;
    protected boolean popupSelectionChanged;
    protected Boolean isDefaultFocusReceiver = null;
    protected boolean hasAvoidedFirstFocus = false;
    protected final AquaTabbedPaneTabState visibleTabState = new AquaTabbedPaneTabState(this);
    protected final AquaUIPainter painter = AquaPainting.create();
    protected AquaUIPainter.Size sizeVariant = AquaUIPainter.Size.REGULAR;
    protected int fixedTabHeight = 0;
    protected int maxIconSize = 0;
    protected Insets onlyTabInsets;
    protected Insets leftTabInsets;
    protected Insets rightTabInsets;
    protected Insets middleTabInsets;
    protected boolean isLeftToRight;
    protected boolean isDark;
    @NotNull
    protected BasicContextualColors colors;
    @Nullable
    protected AppearanceContext appearanceContext;
    private Rectangle fContentRect = new Rectangle();
    private Rectangle fIconRect = new Rectangle();
    private Rectangle fTextRect = new Rectangle();
    private static boolean DEBUG_CUTOUT = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaTabbedPaneUI();
    }

    public AquaTabbedPaneUI() {
        this.colors = AquaColors.TAB_COLORS;
    }

    @Override
    protected void installDefaults() {
        Boolean bl;
        super.installDefaults();
        if (this.tabPane.getFont() instanceof UIResource && (bl = (Boolean)UIManager.get("TabbedPane.useSmallLayout")) != null && bl == Boolean.TRUE) {
            this.tabPane.setFont(UIManager.getFont("TabbedPane.smallFont"));
            this.sizeVariant = AquaUIPainter.Size.SMALL;
        }
        this.updateLayoutParameters();
        this.contentDrawingInsets.set(0, 10, 10, 10);
        LookAndFeel.installProperty(this.tabPane, "opaque", false);
        this.configureAppearanceContext(null, this.tabPane);
    }

    @Override
    protected void uninstallDefaults() {
        this.contentDrawingInsets.set(0, 0, 0, 0);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (this.mouseListener != null) {
            this.tabPane.addMouseMotionListener((MouseMotionListener)((Object)this.mouseListener));
        }
        AquaUtilControlSize.addSizePropertyListener(this.tabPane);
        AquaFullKeyboardFocusableHandler.addListener(this.tabPane);
        AppearanceManager.installListener(this.tabPane);
    }

    @Override
    protected void uninstallListeners() {
        if (this.mouseListener != null) {
            this.tabPane.removeMouseMotionListener((MouseMotionListener)((Object)this.mouseListener));
        }
        AppearanceManager.uninstallListener(this.tabPane);
        AquaUtilControlSize.removeSizePropertyListener(this.tabPane);
        AquaFullKeyboardFocusableHandler.removeListener(this.tabPane);
        super.uninstallListeners();
    }

    @Override
    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    @Override
    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new TabbedPanePropertyChangeHandler();
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new AquaTruncatingTabbedPaneLayout();
    }

    protected boolean shouldRepaintSelectedTabOnMouseDown() {
        return false;
    }

    @Override
    public void appearanceChanged(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
        this.configureAppearanceContext(aquaAppearance, (JTabbedPane)jComponent);
    }

    @Override
    public void activeStateChanged(@NotNull JComponent jComponent, boolean bl) {
        this.configureAppearanceContext(null, (JTabbedPane)jComponent);
    }

    protected void configureAppearanceContext(@Nullable AquaAppearance aquaAppearance, @NotNull JTabbedPane jTabbedPane) {
        if (aquaAppearance == null) {
            aquaAppearance = AppearanceManager.ensureAppearance(jTabbedPane);
        }
        AquaUIPainter.State state = this.getState();
        this.appearanceContext = new AppearanceContext(aquaAppearance, state, false, false);
        this.isDark = aquaAppearance.isDark();
        AquaColors.installColors(jTabbedPane, this.appearanceContext, this.colors);
        jTabbedPane.repaint();
    }

    @Override
    public void applySizeFor(JComponent jComponent, AquaUIPainter.Size size, boolean bl) {
        if (size != this.sizeVariant) {
            this.sizeVariant = size;
            AquaUtilControlSize.configureFontFromSize(jComponent, size);
            this.updateLayoutParameters();
            jComponent.revalidate();
            jComponent.repaint();
        }
    }

    protected void updateLayoutParameters() {
        SegmentedButtonLayoutConfiguration segmentedButtonLayoutConfiguration = new SegmentedButtonLayoutConfiguration(this.buttonWidget, this.sizeVariant, AquaUIPainter.Position.FIRST);
        LayoutInfo layoutInfo = this.painter.getLayoutInfo().getLayoutInfo(segmentedButtonLayoutConfiguration);
        this.fixedTabHeight = (int)layoutInfo.getFixedVisualHeight();
        this.onlyTabInsets = this.getTabInsets(AquaUIPainter.Position.ONLY);
        this.leftTabInsets = this.getTabInsets(AquaUIPainter.Position.FIRST);
        this.rightTabInsets = this.getTabInsets(AquaUIPainter.Position.LAST);
        this.middleTabInsets = this.getTabInsets(AquaUIPainter.Position.MIDDLE);
        int n = this.onlyTabInsets.top + this.onlyTabInsets.bottom + 1;
        if (n % 2 == 1) {
            ++n;
        }
        this.maxIconSize = this.fixedTabHeight - n;
    }

    protected Insets getTabInsets(AquaUIPainter.Position position) {
        SegmentedButtonLayoutConfiguration segmentedButtonLayoutConfiguration = new SegmentedButtonLayoutConfiguration(this.buttonWidget, this.sizeVariant, position);
        Insetter insetter = this.painter.getLayoutInfo().getSegmentedButtonLabelInsets(segmentedButtonLayoutConfiguration);
        Insets insets = insetter.asInsets();
        if (insets == null) {
            insets = new Insets(3, 0, 3, 0);
        }
        AquaButtonExtendedTypes.WidgetInfo widgetInfo = AquaButtonExtendedTypes.getTabWidgetInfo(this.sizeVariant, position);
        int n = widgetInfo.getMargin();
        return new Insets(insets.top, insets.left + n, insets.bottom, insets.right + n);
    }

    @Override
    protected void assureRectsCreated(int n) {
        this.visibleTabState.init(n);
        super.assureRectsCreated(n);
    }

    @Override
    public void update(@NotNull Graphics graphics, @NotNull JComponent jComponent) {
        AquaAppearance aquaAppearance = AppearanceManager.registerCurrentAppearance(jComponent);
        if (jComponent.isOpaque()) {
            AquaUtils.fillRect(graphics, jComponent, 2);
        }
        this.paint(graphics, jComponent);
        AppearanceManager.restoreCurrentAppearance(aquaAppearance);
    }

    @Override
    public void paint(@NotNull Graphics graphics, @NotNull JComponent jComponent) {
        this.ensureCurrentLayout();
        int n = this.tabPane.getTabPlacement();
        int n2 = this.tabPane.getSelectedIndex();
        this.paintContentBorder(graphics, n, n2);
        Rectangle rectangle = graphics.getClipBounds();
        boolean bl = this.isLeftToRight = (this.tabPane.getComponentOrientation().isLeftToRight() || n == 2) && n != 4;
        if (DEBUG_CUTOUT && !this.isDark) {
            graphics = graphics.create();
            ((Graphics2D)graphics).setComposite(AlphaComposite.SrcOver.derive(0.2f));
        }
        if (this.visibleTabState.needsScrollTabs()) {
            this.paintScrollingTabs(graphics, rectangle, n, n2);
        } else {
            this.paintAllTabs(graphics, rectangle, n, n2);
        }
        if (DEBUG_CUTOUT) {
            graphics.dispose();
        }
    }

    protected void paintAllTabs(Graphics graphics, Rectangle rectangle, int n, int n2) {
        boolean bl = false;
        for (int i = 0; i < this.rects.length; ++i) {
            if (i == n2) {
                bl = true;
                continue;
            }
            if (!this.rects[i].intersects(rectangle)) continue;
            this.paintTabNormal(graphics, n, i, false);
        }
        if (bl && this.rects[n2].intersects(rectangle)) {
            this.paintTabNormal(graphics, n, n2, true);
        }
    }

    protected void paintScrollingTabs(Graphics graphics, Rectangle rectangle, int n, int n2) {
        for (int i = 0; i < this.visibleTabState.getTotal(); ++i) {
            int n3 = this.visibleTabState.getIndex(i);
            if (n3 == n2 || !this.rects[n3].intersects(rectangle)) continue;
            this.paintTabNormal(graphics, n, n3, false);
        }
        Rectangle rectangle2 = this.visibleTabState.getLeftScrollTabRect();
        if (this.visibleTabState.needsLeftScrollTab() && rectangle2.intersects(rectangle)) {
            this.paintTabNormalFromRect(graphics, n, rectangle2, -2, false, this.fIconRect, this.fTextRect);
        }
        Rectangle rectangle3 = this.visibleTabState.getRightScrollTabRect();
        if (this.visibleTabState.needsRightScrollTab() && rectangle3.intersects(rectangle)) {
            this.paintTabNormalFromRect(graphics, n, rectangle3, -1, false, this.fIconRect, this.fTextRect);
        }
        if (n2 >= 0) {
            this.paintTabNormal(graphics, n, n2, true);
        }
    }

    @Override
    @Nullable
    public Shape getFocusRingOutline(JComponent jComponent) {
        int n = this.tabPane.getSelectedIndex();
        if (n >= 0 && n < this.rects.length) {
            Rectangle rectangle = this.rects[n];
            return this.createFocusRingOutline(n, rectangle);
        }
        return null;
    }

    @NotNull
    protected Shape createFocusRingOutline(int n, Rectangle rectangle) {
        int n2 = this.tabPane.getTabPlacement();
        boolean bl = n2 == 2 || n2 == 4;
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = bl ? rectangle.height : rectangle.width;
        int n6 = bl ? rectangle.width : rectangle.height;
        SegmentedButtonLayoutConfiguration segmentedButtonLayoutConfiguration = this.getTabLayoutConfiguration(n);
        AppearanceManager.ensureAppearance(this.tabPane);
        AquaUtils.configure(this.painter, this.tabPane, n5, n6);
        Shape shape = this.painter.getOutline(segmentedButtonLayoutConfiguration);
        AffineTransform affineTransform = new AffineTransform();
        if (bl) {
            affineTransform.translate(n3 + n6, n4);
            affineTransform.rotate(1.5707963267948966);
        } else {
            affineTransform.translate(n3, n4);
        }
        return affineTransform.createTransformedShape(shape);
    }

    private static boolean isScrollTabIndex(int n) {
        return n == -1 || n == -2;
    }

    protected static void transposeRect(@NotNull Rectangle rectangle) {
        int n = rectangle.width;
        rectangle.width = rectangle.height;
        rectangle.height = n;
    }

    @Override
    protected int getTabLabelShiftX(int n, int n2, boolean bl) {
        Rectangle rectangle = n2 >= 0 ? this.rects[n2] : this.visibleTabState.getRightScrollTabRect();
        int n3 = 0;
        return n3;
    }

    @Override
    protected int getTabLabelShiftY(int n, int n2, boolean bl) {
        return 0;
    }

    @Nullable
    protected Icon getIconForScrollTab(int n, int n2, boolean bl) {
        Image image;
        int n3;
        boolean bl2;
        boolean bl3 = bl2 = !AquaUtils.isLeftToRight(this.tabPane);
        if (n == 4) {
            bl2 = false;
        }
        if (n == 2) {
            bl2 = true;
        }
        int n4 = n3 = n2 == -1 ? 3 : 7;
        if (bl2) {
            if (n3 == 3) {
                n3 = 7;
            } else if (n3 == 7) {
                n3 = 3;
            }
        }
        if ((image = AquaImageFactory.getArrowImageForDirection(n3)) == null) {
            return null;
        }
        if (!bl) {
            image = AquaImageFactory.getProcessedImage(image, AquaImageFactory.LIGHTEN_FOR_DISABLED);
        } else if (this.isDark) {
            image = AquaImageFactory.getProcessedImage(image, AquaImageFactory.LIGHTEN_100);
        }
        if (this.sizeVariant == AquaUIPainter.Size.MINI) {
            int n5 = (int)((double)image.getWidth(null) * 0.8);
            int n6 = (int)((double)image.getHeight(null) * 0.8);
            image = image.getScaledInstance(n5, n6, 4);
        }
        return new ImageIcon(image);
    }

    protected void paintTabNormal(@NotNull Graphics graphics, int n, int n2, boolean bl) {
        this.paintTabNormalFromRect(graphics, n, this.rects[n2], n2, bl, this.fIconRect, this.fTextRect);
    }

    protected void paintTabNormalFromRect(@NotNull Graphics object, int n, Rectangle rectangle, int n2, boolean bl, @NotNull Rectangle rectangle2, @NotNull Rectangle rectangle3) {
        Object object2;
        boolean bl2;
        AquaUIPainter.Direction direction = this.getDirection();
        boolean bl3 = bl2 = direction == AquaUIPainter.Direction.LEFT || direction == AquaUIPainter.Direction.RIGHT;
        if (bl2) {
            object2 = AquaUtils.toGraphics2D((Graphics)object);
            if (object2 == null) {
                return;
            }
            object2 = (Graphics2D)((Graphics)object2).create();
            if (n == 2) {
                ((Graphics2D)object2).translate(0, rectangle.height);
            } else {
                ((Graphics2D)object2).translate(rectangle.width, 0);
            }
            double d = n == 2 ? -1.5707963267948966 : 1.5707963267948966;
            ((Graphics2D)object2).transform(AffineTransform.getRotateInstance(d, rectangle.x, rectangle.y));
            AquaTabbedPaneUI.transposeRect(this.fContentRect);
            AquaTabbedPaneUI.transposeRect(rectangle);
            object = object2;
        }
        this.paintTabBackground((Graphics)object, rectangle, bl, this.isLeftToRight, n2);
        object2 = this.getTabInsets(n, n2);
        this.fContentRect.setBounds(rectangle.x + ((Insets)object2).left, rectangle.y + ((Insets)object2).top, rectangle.width - ((Insets)object2).left - ((Insets)object2).right, rectangle.height - ((Insets)object2).top - ((Insets)object2).bottom);
        this.paintContents((Graphics)object, n, n2, rectangle, rectangle2, rectangle3, bl);
        if (bl2) {
            ((Graphics)object).dispose();
            AquaTabbedPaneUI.transposeRect(rectangle);
        }
    }

    protected void paintTabBackground(@NotNull Graphics graphics, @NotNull Rectangle rectangle, boolean bl, boolean bl2, int n) {
        AquaUtils.configure(this.painter, this.tabPane, rectangle.width, rectangle.height);
        SegmentedButtonConfiguration segmentedButtonConfiguration = this.getConfiguration(bl, bl2, n);
        Painter painter = this.painter.getPainter(segmentedButtonConfiguration);
        painter.paint(graphics, rectangle.x, rectangle.y);
    }

    @NotNull
    protected SegmentedButtonConfiguration getConfiguration(boolean bl, boolean bl2, int n) {
        AquaUIPainter.Direction direction;
        boolean bl3;
        int n2 = this.tabPane.getTabCount();
        boolean bl4 = this.visibleTabState.needsLeftScrollTab();
        boolean bl5 = this.visibleTabState.needsRightScrollTab();
        boolean bl6 = n == 0;
        boolean bl7 = bl3 = n == n2 - 1;
        if (bl4 || bl5) {
            if (n == -1) {
                bl6 = false;
                bl3 = true;
            } else if (n == -2) {
                bl6 = true;
                bl3 = false;
            } else {
                if (bl4) {
                    bl6 = false;
                }
                if (bl5) {
                    bl3 = false;
                }
            }
        }
        if ((direction = this.getDirection()) == AquaUIPainter.Direction.LEFT || direction == AquaUIPainter.Direction.RIGHT) {
            boolean bl8 = bl3;
            bl3 = bl6;
            bl6 = bl8;
        }
        AquaUIPainter.State state = this.getTabState(n, bl);
        boolean bl9 = bl;
        boolean bl10 = false;
        boolean bl11 = false;
        AquaUIPainter.Position position = AquaTabbedPaneUI.getSegmentPosition(bl6, bl3, bl2);
        int n3 = this.tabPane.getSelectedIndex();
        boolean bl12 = this.getSegmentTrailingSeparator(n, n3, bl2);
        boolean bl13 = this.getSegmentLeadingSeparator(n, n3, bl2);
        boolean bl14 = this.tabPane.hasFocus() && bl;
        SegmentedButtonConfiguration.DividerState dividerState = AquaSegmentedButtonBorder.getDividerState(bl13, bl10);
        SegmentedButtonConfiguration.DividerState dividerState2 = AquaSegmentedButtonBorder.getDividerState(bl12, bl11);
        return new SegmentedButtonConfiguration(this.buttonWidget, this.sizeVariant, state, bl9, bl14, AquaUIPainter.Direction.UP, position, dividerState, dividerState2);
    }

    protected void paintContents(@NotNull Graphics graphics, int n, int n2, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
        Object object;
        Icon icon;
        String string;
        if (AquaTabbedPaneUI.isScrollTabIndex(n2)) {
            string = null;
            icon = this.getIconForScrollTab(n, n2, this.tabPane.isEnabled());
        } else {
            object = this.getTabComponentAt(n2);
            if (object != null) {
                return;
            }
            string = this.tabPane.getTitleAt(n2);
            icon = this.getIconForTab(n2);
        }
        object = graphics.getClip();
        graphics.clipRect(this.fContentRect.x, this.fContentRect.y, this.fContentRect.width, this.fContentRect.height);
        Font font = this.tabPane.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        this.layoutLabel(n, fontMetrics, n2 < 0 ? 0 : n2, string, icon, this.fContentRect, rectangle2, rectangle3, false);
        if (!(graphics instanceof Graphics2D)) {
            graphics.setClip((Shape)object);
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (n2 >= 0) {
            this.paintTitle(graphics2D, font, fontMetrics, rectangle3, n2, bl, string);
        }
        if (icon != null) {
            this.paintIcon(graphics, n, n2, icon, rectangle2, bl);
        }
        graphics.setClip((Shape)object);
    }

    protected void paintTitle(@NotNull Graphics2D graphics2D, Font font, FontMetrics fontMetrics, Rectangle rectangle, int n, boolean bl, String string) {
        View view = this.getTextViewForTab(n);
        if (view != null) {
            view.paint(graphics2D, rectangle);
            return;
        }
        if (string == null) {
            return;
        }
        Color color = this.tabPane.getForegroundAt(n);
        if (color instanceof UIResource) {
            graphics2D.setColor(this.getTabTextColor(n, bl));
        } else {
            graphics2D.setColor(color);
        }
        graphics2D.setFont(font);
        JavaSupport.drawString(this.tabPane, graphics2D, string, rectangle.x, rectangle.y + fontMetrics.getAscent());
    }

    @NotNull
    protected Color getTabTextColor(int n, boolean bl) {
        assert (this.appearanceContext != null);
        AppearanceContext appearanceContext = this.appearanceContext;
        if (this.appearanceContext.getState() == AquaUIPainter.State.ACTIVE) {
            if (!this.tabPane.isEnabledAt(n)) {
                appearanceContext = appearanceContext.withState(AquaUIPainter.State.DISABLED);
            } else if (this.isPressedAt(n)) {
                appearanceContext = appearanceContext.withState(AquaUIPainter.State.PRESSED);
            }
        }
        appearanceContext = appearanceContext.withSelected(bl);
        return this.colors.getForeground(appearanceContext);
    }

    protected boolean isPressedAt(int n) {
        return false;
    }

    @NotNull
    protected AquaUIPainter.Direction getDirection() {
        switch (this.tabPane.getTabPlacement()) {
            case 3: {
                return AquaUIPainter.Direction.DOWN;
            }
            case 2: {
                return AquaUIPainter.Direction.LEFT;
            }
            case 4: {
                return AquaUIPainter.Direction.RIGHT;
            }
        }
        return AquaUIPainter.Direction.UP;
    }

    @NotNull
    protected static AquaUIPainter.Position getSegmentPosition(boolean bl, boolean bl2, boolean bl3) {
        if (bl && bl2) {
            return AquaUIPainter.Position.ONLY;
        }
        if (bl) {
            return bl3 ? AquaUIPainter.Position.FIRST : AquaUIPainter.Position.LAST;
        }
        if (bl2) {
            return bl3 ? AquaUIPainter.Position.LAST : AquaUIPainter.Position.FIRST;
        }
        return AquaUIPainter.Position.MIDDLE;
    }

    protected boolean getSegmentTrailingSeparator(int n, int n2, boolean bl) {
        return true;
    }

    protected boolean getSegmentLeadingSeparator(int n, int n2, boolean bl) {
        return false;
    }

    @NotNull
    protected AquaUIPainter.State getState() {
        if (AquaFocusHandler.isActive(this.tabPane)) {
            if (this.tabPane.isEnabled()) {
                return AquaUIPainter.State.ACTIVE;
            }
            return AquaUIPainter.State.DISABLED;
        }
        return AquaUIPainter.State.INACTIVE;
    }

    @NotNull
    protected AquaUIPainter.State getTabState(int n, boolean bl) {
        AquaUIPainter.State state;
        if (this.appearanceContext != null && ((state = this.appearanceContext.getState()) == AquaUIPainter.State.INACTIVE || state == AquaUIPainter.State.DISABLED || state == AquaUIPainter.State.DISABLED_INACTIVE)) {
            return state;
        }
        if (!this.tabPane.isEnabled()) {
            return AquaUIPainter.State.DISABLED;
        }
        if (this.pressedTab == n) {
            return AquaUIPainter.State.PRESSED;
        }
        return AquaUIPainter.State.ACTIVE;
    }

    @Override
    @NotNull
    protected Insets getContentBorderInsets(int n) {
        Insets insets = this.getContentDrawingInsets(n);
        AquaTabbedPaneUI.rotateInsets(this.contentBorderInsets, this.currentContentBorderInsets, n);
        this.currentContentBorderInsets.left += insets.left;
        this.currentContentBorderInsets.right += insets.right;
        this.currentContentBorderInsets.top += insets.top;
        this.currentContentBorderInsets.bottom += insets.bottom;
        return this.currentContentBorderInsets;
    }

    protected static void rotateInsets(Insets insets, Insets insets2, int n) {
        switch (n) {
            case 2: {
                insets2.top = insets.right;
                insets2.left = insets.top;
                insets2.bottom = insets.left;
                insets2.right = insets.bottom;
                break;
            }
            case 3: {
                insets2.top = insets.bottom;
                insets2.left = insets.left;
                insets2.bottom = insets.top;
                insets2.right = insets.right;
                break;
            }
            case 4: {
                insets2.top = insets.left;
                insets2.left = insets.bottom;
                insets2.bottom = insets.right;
                insets2.right = insets.top;
                break;
            }
            default: {
                insets2.top = insets.top;
                insets2.left = insets.left;
                insets2.bottom = insets.bottom;
                insets2.right = insets.right;
            }
        }
    }

    @NotNull
    protected Insets getContentDrawingInsets(int n) {
        AquaTabbedPaneUI.rotateInsets(this.contentDrawingInsets, this.currentContentDrawingInsets, n);
        return this.currentContentDrawingInsets;
    }

    @Override
    @Nullable
    protected Icon getIconForTab(int n) {
        final Icon icon = super.getIconForTab(n);
        if (icon == null) {
            return null;
        }
        int n2 = icon.getIconHeight();
        if (n2 <= this.maxIconSize) {
            return icon;
        }
        float f = (float)this.maxIconSize / (float)n2;
        int n3 = icon.getIconWidth();
        return new AquaIcon.CachingScalingIcon((int)((float)n3 * f), this.maxIconSize){

            @Override
            Image createImage() {
                return AquaIcon.getImageForIcon(icon);
            }
        };
    }

    @Override
    protected void paintContentBorder(@NotNull Graphics graphics, int n, int n2) {
        int n3 = this.tabPane.getWidth();
        int n4 = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int n5 = insets.left;
        int n6 = insets.top;
        int n7 = n3 - insets.right - insets.left;
        int n8 = n4 - insets.top - insets.bottom;
        int n9 = this.fixedTabHeight / 2;
        n9 -= 5;
        switch (n) {
            case 1: {
                n6 += n9;
                n8 -= n9;
                break;
            }
            case 3: {
                n8 -= n9;
                break;
            }
            case 2: {
                n5 += n9;
                n7 -= n9;
                break;
            }
            case 4: {
                n7 -= n9;
            }
        }
        Border border = AquaGroupBorder.getTabbedPaneGroupBorder();
        Shapes shapes = this.getContentBorderCutout();
        if (shapes != null) {
            if (DEBUG_CUTOUT) {
                graphics.setColor(new Color(255, 0, 0, 120));
                graphics.fillRect(0, 0, n3, n4);
            }
            Rectangle rectangle = graphics.getClipBounds();
            BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.translate(-rectangle.x, -rectangle.y);
            border.paintBorder(this.tabPane, graphics2D, n5, n6, n7, n8);
            graphics2D.setComposite(AlphaComposite.Src);
            graphics2D.setColor(AquaColors.CLEAR);
            shapes.fill(graphics2D);
            graphics2D.dispose();
            graphics.drawImage(bufferedImage, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
        } else {
            border.paintBorder(this.tabPane, graphics, n5, n6, n7, n8);
        }
    }

    @Nullable
    protected Shapes getContentBorderCutout() {
        int n = this.tabPane.getTabCount();
        if (n > 0 && (DEBUG_CUTOUT || this.isDark)) {
            Shapes shapes = new Shapes();
            if (this.visibleTabState.needsScrollTabs()) {
                Rectangle rectangle;
                if (this.visibleTabState.needsLeftScrollTab()) {
                    rectangle = this.visibleTabState.getLeftScrollTabRect();
                    this.addTabShape(shapes, -2, rectangle);
                }
                if (this.visibleTabState.needsRightScrollTab()) {
                    rectangle = this.visibleTabState.getRightScrollTabRect();
                    this.addTabShape(shapes, -1, rectangle);
                }
                for (int i = 0; i < this.visibleTabState.getTotal(); ++i) {
                    int n2 = this.visibleTabState.getIndex(i);
                    if (n2 < 0) continue;
                    Rectangle rectangle2 = this.rects[n2];
                    this.addTabShape(shapes, n2, rectangle2);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    Rectangle rectangle = this.rects[i];
                    this.addTabShape(shapes, i, rectangle);
                }
            }
            if (!shapes.isEmpty()) {
                return shapes;
            }
        }
        return null;
    }

    private void addTabShape(@NotNull Shapes shapes, int n, @NotNull Rectangle rectangle) {
        Shape shape = this.createFocusRingOutline(n, rectangle);
        shapes.add(shape);
    }

    public boolean isTabVisible(int n) {
        if (!this.visibleTabState.needsScrollTabs()) {
            return true;
        }
        if (n == -1 || n == -2) {
            return true;
        }
        for (int i = 0; i < this.visibleTabState.getTotal(); ++i) {
            if (this.visibleTabState.getIndex(i) != n) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected SegmentedButtonLayoutConfiguration getTabLayoutConfiguration(int n) {
        int n2;
        boolean bl = this.tabPane.getComponentOrientation().isLeftToRight();
        AquaUIPainter.Position position = n == -2 ? (bl ? AquaUIPainter.Position.FIRST : AquaUIPainter.Position.LAST) : (n == -1 ? (bl ? AquaUIPainter.Position.LAST : AquaUIPainter.Position.FIRST) : ((n2 = this.tabPane.getTabCount()) < 2 ? AquaUIPainter.Position.ONLY : (n == 0 ? (bl ? AquaUIPainter.Position.FIRST : AquaUIPainter.Position.LAST) : (n == n2 - 1 ? (bl ? AquaUIPainter.Position.LAST : AquaUIPainter.Position.FIRST) : AquaUIPainter.Position.MIDDLE))));
        return new SegmentedButtonLayoutConfiguration(this.buttonWidget, this.sizeVariant, position);
    }

    @Override
    @NotNull
    protected Insets getTabInsets(int n, int n2) {
        int n3 = this.tabPane.getTabCount();
        boolean bl = this.tabPane.getComponentOrientation().isLeftToRight();
        AquaUIPainter.Position position = n3 < 2 ? AquaUIPainter.Position.ONLY : (n2 == 0 ? (bl ? AquaUIPainter.Position.FIRST : AquaUIPainter.Position.LAST) : (n2 == n3 - 1 ? (bl ? AquaUIPainter.Position.LAST : AquaUIPainter.Position.FIRST) : AquaUIPainter.Position.MIDDLE));
        switch (position) {
            case ONLY: {
                return this.onlyTabInsets;
            }
            case FIRST: {
                return this.leftTabInsets;
            }
            case LAST: {
                return this.rightTabInsets;
            }
            case MIDDLE: {
                return this.middleTabInsets;
            }
        }
        return new Insets(3, 10, 3, 10);
    }

    @Override
    @Nullable
    public Rectangle getTabBounds(@NotNull JTabbedPane jTabbedPane, int n) {
        if (this.visibleTabState.needsScrollTabs() && (this.visibleTabState.isBefore(n) || this.visibleTabState.isAfter(n))) {
            return null;
        }
        return super.getTabBounds(jTabbedPane, n);
    }

    @Override
    public int tabForCoordinate(@NotNull JTabbedPane jTabbedPane, int n, int n2) {
        this.ensureCurrentLayout();
        Point point = new Point(n, n2);
        if (this.visibleTabState.needsScrollTabs()) {
            for (int i = 0; i < this.visibleTabState.getTotal(); ++i) {
                int n3 = this.visibleTabState.getIndex(i);
                if (!this.rects[n3].contains(point.x, point.y)) continue;
                return n3;
            }
            if (this.visibleTabState.getRightScrollTabRect().contains(point.x, point.y)) {
                return -1;
            }
        } else {
            int n4 = this.tabPane.getTabCount();
            for (int i = 0; i < n4; ++i) {
                if (!this.rects[i].contains(point.x, point.y)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    protected int calculateTabHeight(int n, int n2, int n3) {
        return this.fixedTabHeight;
    }

    @Override
    protected boolean shouldRotateTabRuns(int n) {
        return false;
    }

    @Override
    protected ChangeListener createChangeListener() {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!AquaTabbedPaneUI.this.isTabVisible(AquaTabbedPaneUI.this.tabPane.getSelectedIndex())) {
                    AquaTabbedPaneUI.this.popupSelectionChanged = true;
                }
                AquaTabbedPaneUI.this.tabPane.revalidate();
                AquaTabbedPaneUI.this.tabPane.repaint();
            }
        };
    }

    public class MouseHandler
    extends MouseInputAdapter
    implements ActionListener {
        protected int trackingTab = -3;
        protected Timer popupTimer = new Timer(500, this);

        public MouseHandler() {
            this.popupTimer.setRepeats(false);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)mouseEvent.getSource();
            if (!jTabbedPane.isEnabled()) {
                this.trackingTab = -3;
                return;
            }
            Point point = mouseEvent.getPoint();
            this.trackingTab = this.getCurrentTab(jTabbedPane, point);
            if (this.trackingTab == -3 || !AquaTabbedPaneUI.this.shouldRepaintSelectedTabOnMouseDown() && this.trackingTab == jTabbedPane.getSelectedIndex()) {
                this.trackingTab = -3;
                return;
            }
            if (this.trackingTab == -2 || this.trackingTab == -1) {
                this.popupTimer.start();
            }
            AquaTabbedPaneUI.this.pressedTab = this.trackingTab;
            this.repaint(jTabbedPane, AquaTabbedPaneUI.this.pressedTab);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.trackingTab == -3) {
                return;
            }
            JTabbedPane jTabbedPane = (JTabbedPane)mouseEvent.getSource();
            int n = this.getCurrentTab(jTabbedPane, mouseEvent.getPoint());
            AquaTabbedPaneUI.this.pressedTab = n != this.trackingTab ? -3 : this.trackingTab;
            if (this.trackingTab == -2 || this.trackingTab == -1) {
                this.popupTimer.start();
            }
            this.repaint(jTabbedPane, this.trackingTab);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.trackingTab == -3) {
                return;
            }
            this.popupTimer.stop();
            JTabbedPane jTabbedPane = (JTabbedPane)mouseEvent.getSource();
            Point point = mouseEvent.getPoint();
            int n = this.getCurrentTab(jTabbedPane, point);
            if (this.trackingTab == -1 && n == -1) {
                jTabbedPane.setSelectedIndex(jTabbedPane.getSelectedIndex() + 1);
            }
            if (this.trackingTab == -2 && n == -2) {
                jTabbedPane.setSelectedIndex(jTabbedPane.getSelectedIndex() - 1);
            }
            if (this.trackingTab >= 0 && n == this.trackingTab) {
                jTabbedPane.setSelectedIndex(this.trackingTab);
            }
            this.repaint(jTabbedPane, this.trackingTab);
            AquaTabbedPaneUI.this.pressedTab = -3;
            this.trackingTab = -3;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.trackingTab != AquaTabbedPaneUI.this.pressedTab) {
                return;
            }
            if (this.trackingTab == -1) {
                this.showFullPopup(false);
                this.trackingTab = -3;
            }
            if (this.trackingTab == -2) {
                this.showFullPopup(true);
                this.trackingTab = -3;
            }
        }

        int getCurrentTab(JTabbedPane jTabbedPane, Point point) {
            int n = AquaTabbedPaneUI.this.tabForCoordinate(jTabbedPane, point.x, point.y);
            if (n >= 0 && jTabbedPane.isEnabledAt(n)) {
                return n;
            }
            if (AquaTabbedPaneUI.this.visibleTabState.needsLeftScrollTab() && AquaTabbedPaneUI.this.visibleTabState.getLeftScrollTabRect().contains(point)) {
                return -2;
            }
            if (AquaTabbedPaneUI.this.visibleTabState.needsRightScrollTab() && AquaTabbedPaneUI.this.visibleTabState.getRightScrollTabRect().contains(point)) {
                return -1;
            }
            return -3;
        }

        void repaint(JTabbedPane jTabbedPane, int n) {
            switch (n) {
                case -1: {
                    jTabbedPane.repaint(AquaTabbedPaneUI.this.visibleTabState.getRightScrollTabRect());
                    return;
                }
                case -2: {
                    jTabbedPane.repaint(AquaTabbedPaneUI.this.visibleTabState.getLeftScrollTabRect());
                    return;
                }
            }
            if (this.trackingTab >= 0) {
                jTabbedPane.repaint(AquaTabbedPaneUI.this.rects[this.trackingTab]);
            }
        }

        void showFullPopup(boolean bl) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            for (int i = 0; i < AquaTabbedPaneUI.this.tabPane.getTabCount(); ++i) {
                if (!(bl ? AquaTabbedPaneUI.this.visibleTabState.isBefore(i) : AquaTabbedPaneUI.this.visibleTabState.isAfter(i))) continue;
                jPopupMenu.add(this.createMenuItem(i));
            }
            if (bl) {
                Rectangle rectangle = AquaTabbedPaneUI.this.visibleTabState.getLeftScrollTabRect();
                Dimension dimension = jPopupMenu.getPreferredSize();
                jPopupMenu.show(AquaTabbedPaneUI.this.tabPane, rectangle.x - dimension.width, rectangle.y + 7);
            } else {
                Rectangle rectangle = AquaTabbedPaneUI.this.visibleTabState.getRightScrollTabRect();
                jPopupMenu.show(AquaTabbedPaneUI.this.tabPane, rectangle.x + rectangle.width, rectangle.y + 7);
            }
            jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    AquaTabbedPaneUI.this.pressedTab = -3;
                    AquaTabbedPaneUI.this.tabPane.repaint(AquaTabbedPaneUI.this.visibleTabState.getLeftScrollTabRect());
                    AquaTabbedPaneUI.this.tabPane.repaint(AquaTabbedPaneUI.this.visibleTabState.getRightScrollTabRect());
                }
            });
        }

        @NotNull
        JMenuItem createMenuItem(int n) {
            Serializable serializable;
            final Component component = AquaTabbedPaneUI.this.getTabComponentAt(n);
            JMenuItem jMenuItem = component == null ? new JMenuItem(AquaTabbedPaneUI.this.tabPane.getTitleAt(n), AquaTabbedPaneUI.this.tabPane.getIconAt(n)) : (serializable = new JMenuItem(){

                @Override
                public void paintComponent(Graphics graphics) {
                    super.paintComponent(graphics);
                    Dimension dimension = component.getSize();
                    component.setSize(this.getSize());
                    component.validate();
                    component.paint(graphics);
                    component.setSize(dimension);
                }

                @Override
                public Dimension getPreferredSize() {
                    return component.getPreferredSize();
                }
            });
            serializable = AquaTabbedPaneUI.this.tabPane.getBackgroundAt(n);
            if (!(serializable instanceof UIResource)) {
                jMenuItem.setBackground((Color)serializable);
            }
            jMenuItem.setForeground(AquaTabbedPaneUI.this.tabPane.getForegroundAt(n));
            if (!AquaTabbedPaneUI.this.tabPane.isEnabledAt(n)) {
                jMenuItem.setEnabled(false);
            }
            final int n2 = n;
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = AquaTabbedPaneUI.this.isTabVisible(n2);
                    AquaTabbedPaneUI.this.tabPane.setSelectedIndex(n2);
                    if (!bl) {
                        AquaTabbedPaneUI.this.popupSelectionChanged = true;
                        AquaTabbedPaneUI.this.tabPane.invalidate();
                        AquaTabbedPaneUI.this.tabPane.repaint();
                    }
                }
            });
            return jMenuItem;
        }
    }

    protected class FocusHandler
    extends FocusAdapter {
        Rectangle sWorkingRect = new Rectangle();

        protected FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (this.isDefaultFocusReceiver(AquaTabbedPaneUI.this.tabPane) && !AquaTabbedPaneUI.this.hasAvoidedFirstFocus) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                AquaTabbedPaneUI.this.hasAvoidedFirstFocus = true;
            }
            this.adjustPaintingRectForFocusRing(focusEvent);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.adjustPaintingRectForFocusRing(focusEvent);
        }

        void adjustPaintingRectForFocusRing(FocusEvent focusEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)focusEvent.getSource();
            int n = jTabbedPane.getTabCount();
            int n2 = jTabbedPane.getSelectedIndex();
            if (n2 != -1 && n > 0 && n == AquaTabbedPaneUI.this.rects.length) {
                this.sWorkingRect.setBounds(AquaTabbedPaneUI.this.rects[n2]);
                this.sWorkingRect.grow(4, 4);
                jTabbedPane.repaint(this.sWorkingRect);
            }
        }

        boolean isDefaultFocusReceiver(@NotNull JComponent jComponent) {
            if (AquaTabbedPaneUI.this.isDefaultFocusReceiver == null) {
                Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalPolicy().getDefaultComponent(this.getTopLevelFocusCycleRootAncestor(jComponent));
                AquaTabbedPaneUI.this.isDefaultFocusReceiver = component != null && component.equals(jComponent);
            }
            return AquaTabbedPaneUI.this.isDefaultFocusReceiver;
        }

        Container getTopLevelFocusCycleRootAncestor(Container container) {
            Container container2;
            while ((container2 = container.getFocusCycleRootAncestor()) != null) {
                container = container2;
            }
            return container;
        }
    }

    protected class TabbedPanePropertyChangeHandler
    extends AquaTabbedPaneCopyFromBasicUI.PropertyChangeHandler {
        protected TabbedPanePropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            JTabbedPane jTabbedPane = (JTabbedPane)propertyChangeEvent.getSource();
            if ("componentOrientation".equals(string)) {
                jTabbedPane.revalidate();
                jTabbedPane.repaint();
                super.propertyChange(propertyChangeEvent);
                return;
            }
            if ("Frame.active".equals(string)) {
                jTabbedPane.repaint();
                return;
            }
            super.propertyChange(propertyChangeEvent);
        }
    }

    protected class AquaTruncatingTabbedPaneLayout
    extends AquaTabbedPaneCopyFromBasicUI.TabbedPaneLayout {
        protected AquaTruncatingTabbedPaneLayout() {
        }

        @Override
        protected int preferredTabAreaWidth(int n, int n2) {
            if (n == 2 || n == 4) {
                return super.preferredTabAreaHeight(n, n2);
            }
            return super.preferredTabAreaWidth(n, n2);
        }

        @Override
        protected int preferredTabAreaHeight(int n, int n2) {
            if (n == 2 || n == 4) {
                return super.preferredTabAreaWidth(n, n2);
            }
            return super.preferredTabAreaHeight(n, n2);
        }

        @Override
        protected void calculateTabRects(int n, int n2) {
            if (n2 <= 0) {
                return;
            }
            this.superCalculateTabRects(n, n2);
            if (AquaTabbedPaneUI.this.rects.length <= 0) {
                return;
            }
            AquaTabbedPaneUI.this.visibleTabState.alignRectsRunFor(AquaTabbedPaneUI.this.rects, AquaTabbedPaneUI.this.tabPane.getSize(), n, AquaUtils.isLeftToRight(AquaTabbedPaneUI.this.tabPane));
        }

        @Override
        protected void padTabRun(int n, int n2, int n3, int n4) {
            if (n == 1 || n == 3) {
                super.padTabRun(n, n2, n3, n4);
                return;
            }
            Rectangle rectangle = AquaTabbedPaneUI.this.rects[n3];
            int n5 = rectangle.y + rectangle.height - AquaTabbedPaneUI.this.rects[n2].y;
            int n6 = n4 - (rectangle.y + rectangle.height);
            float f = (float)n6 / (float)n5;
            for (int i = n2; i <= n3; ++i) {
                Rectangle rectangle2 = AquaTabbedPaneUI.this.rects[i];
                if (i > n2) {
                    rectangle2.y = AquaTabbedPaneUI.this.rects[i - 1].y + AquaTabbedPaneUI.this.rects[i - 1].height;
                }
                rectangle2.height += Math.round((float)rectangle2.height * f);
            }
            rectangle.height = n4 - rectangle.y;
        }

        protected synchronized void superCalculateTabRects(int n, int n2) {
            int n3;
            int n4;
            int n5;
            int n6;
            Dimension dimension = AquaTabbedPaneUI.this.tabPane.getSize();
            Insets insets = AquaTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = AquaTabbedPaneUI.this.getTabAreaInsets(n);
            switch (n) {
                case 2: {
                    AquaTabbedPaneUI.this.maxTabWidth = AquaTabbedPaneUI.this.calculateMaxTabHeight(n);
                    n6 = insets.left + insets2.left;
                    n5 = insets.top + insets2.top;
                    n4 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 4: {
                    AquaTabbedPaneUI.this.maxTabWidth = AquaTabbedPaneUI.this.calculateMaxTabHeight(n);
                    n6 = dimension.width - insets.right - insets2.right - AquaTabbedPaneUI.this.maxTabWidth - 1;
                    n5 = insets.top + insets2.top;
                    n4 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 3: {
                    AquaTabbedPaneUI.this.maxTabHeight = AquaTabbedPaneUI.this.calculateMaxTabHeight(n);
                    n6 = insets.left + insets2.left;
                    n5 = dimension.height - insets.bottom - insets2.bottom - AquaTabbedPaneUI.this.maxTabHeight;
                    n4 = dimension.width - (insets.right + insets2.right);
                    break;
                }
                default: {
                    AquaTabbedPaneUI.this.maxTabHeight = AquaTabbedPaneUI.this.calculateMaxTabHeight(n);
                    n6 = insets.left + insets2.left;
                    n5 = insets.top + insets2.top;
                    n4 = dimension.width - (insets.right + insets2.right);
                }
            }
            AquaTabbedPaneUI.this.tabRunOverlay = AquaTabbedPaneUI.this.getTabRunOverlay(n);
            AquaTabbedPaneUI.this.runCount = 0;
            AquaTabbedPaneUI.this.selectedRun = 0;
            if (n2 == 0) {
                return;
            }
            FontMetrics fontMetrics = AquaTabbedPaneUI.this.getFontMetrics();
            boolean bl = n == 2 || n == 4;
            int n7 = AquaTabbedPaneUI.this.tabPane.getSelectedIndex();
            AquaTabbedPaneUI.this.visibleTabState.setNeedsScrollers(false);
            for (n3 = 0; n3 < n2; ++n3) {
                Rectangle rectangle = AquaTabbedPaneUI.this.rects[n3];
                if (bl) {
                    this.calculateVerticalTabRunRect(rectangle, fontMetrics, n, n4, n3, n6, n5);
                    if (rectangle.y + rectangle.height <= n4) continue;
                    AquaTabbedPaneUI.this.visibleTabState.setNeedsScrollers(true);
                    continue;
                }
                this.calculateHorizontalTabRunRect(rectangle, fontMetrics, n, n4, n3, n6, n5);
                if (rectangle.x + rectangle.width <= n4) continue;
                AquaTabbedPaneUI.this.visibleTabState.setNeedsScrollers(true);
            }
            AquaTabbedPaneUI.this.visibleTabState.relayoutForScrolling(AquaTabbedPaneUI.this.rects, n6, n5, n4, n7, bl, n2, AquaUtils.isLeftToRight(AquaTabbedPaneUI.this.tabPane));
            if (!AquaUtils.isLeftToRight(AquaTabbedPaneUI.this.tabPane) && !bl) {
                n3 = dimension.width - (insets.right + insets2.right);
                for (int i = 0; i < n2; ++i) {
                    AquaTabbedPaneUI.this.rects[i].x = n3 - AquaTabbedPaneUI.this.rects[i].x - AquaTabbedPaneUI.this.rects[i].width;
                }
            }
        }

        private void calculateHorizontalTabRunRect(@NotNull Rectangle rectangle, FontMetrics fontMetrics, int n, int n2, int n3, int n4, int n5) {
            if (n3 > 0) {
                rectangle.x = AquaTabbedPaneUI.this.rects[n3 - 1].x + AquaTabbedPaneUI.this.rects[n3 - 1].width;
            } else {
                AquaTabbedPaneUI.this.tabRuns[0] = 0;
                AquaTabbedPaneUI.this.runCount = 1;
                AquaTabbedPaneUI.this.maxTabWidth = 0;
                rectangle.x = n4;
            }
            rectangle.width = AquaTabbedPaneUI.this.calculateTabWidth(n, n3, fontMetrics);
            AquaTabbedPaneUI.this.maxTabWidth = Math.max(AquaTabbedPaneUI.this.maxTabWidth, rectangle.width);
            rectangle.y = n5;
            rectangle.height = AquaTabbedPaneUI.this.maxTabHeight;
        }

        private void calculateVerticalTabRunRect(@NotNull Rectangle rectangle, @NotNull FontMetrics fontMetrics, int n, int n2, int n3, int n4, int n5) {
            if (n3 > 0) {
                rectangle.y = AquaTabbedPaneUI.this.rects[n3 - 1].y + AquaTabbedPaneUI.this.rects[n3 - 1].height;
            } else {
                AquaTabbedPaneUI.this.tabRuns[0] = 0;
                AquaTabbedPaneUI.this.runCount = 1;
                AquaTabbedPaneUI.this.maxTabHeight = 0;
                rectangle.y = n5;
            }
            rectangle.height = AquaTabbedPaneUI.this.calculateTabWidth(n, n3, fontMetrics);
            AquaTabbedPaneUI.this.maxTabHeight = Math.max(AquaTabbedPaneUI.this.maxTabHeight, rectangle.height);
            rectangle.x = n4;
            rectangle.width = AquaTabbedPaneUI.this.maxTabWidth;
        }

        @Override
        protected void layoutTabComponents() {
            Container container = this.getTabContainer();
            if (container == null) {
                return;
            }
            int n = AquaTabbedPaneUI.this.tabPane.getTabPlacement();
            Rectangle rectangle = new Rectangle();
            Point point = new Point(-container.getX(), -container.getY());
            for (int i = 0; i < AquaTabbedPaneUI.this.tabPane.getTabCount(); ++i) {
                boolean bl;
                Component component = AquaTabbedPaneUI.this.getTabComponentAt(i);
                if (component == null) continue;
                AquaTabbedPaneUI.this.getTabBounds(i, rectangle);
                Insets insets = AquaTabbedPaneUI.this.getTabInsets(AquaTabbedPaneUI.this.tabPane.getTabPlacement(), i);
                boolean bl2 = bl = i == AquaTabbedPaneUI.this.tabPane.getSelectedIndex();
                if (n == 1 || n == 3) {
                    rectangle.x += insets.left + point.x + AquaTabbedPaneUI.this.getTabLabelShiftX(n, i, bl);
                    rectangle.y += insets.top + point.y + AquaTabbedPaneUI.this.getTabLabelShiftY(n, i, bl);
                    rectangle.width -= insets.left + insets.right;
                    rectangle.height -= insets.top + insets.bottom - 1;
                } else {
                    rectangle.x += insets.top + point.x + AquaTabbedPaneUI.this.getTabLabelShiftY(n, i, bl);
                    rectangle.y += insets.left + point.y + AquaTabbedPaneUI.this.getTabLabelShiftX(n, i, bl);
                    rectangle.width -= insets.top + insets.bottom - 1;
                    rectangle.height -= insets.left + insets.right;
                }
                component.setBounds(rectangle);
            }
        }
    }

    private static class Shapes {
        @NotNull
        private List<Shape> shapes = new ArrayList<Shape>();

        private Shapes() {
        }

        public void add(@NotNull Shape shape) {
            Rectangle rectangle = shape.getBounds();
            if (rectangle.width > 0 && rectangle.height > 0) {
                this.shapes.add(shape);
            }
        }

        public boolean isEmpty() {
            return this.shapes.isEmpty();
        }

        public void fill(@NotNull Graphics2D graphics2D) {
            for (Shape shape : this.shapes) {
                graphics2D.fill(shape);
            }
        }
    }
}

