/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.ComponentVibrantEffects;
import org.violetlib.aqua.SelectionBoundsDescription;
import org.violetlib.aqua.SelectionBoundsTracker;
import org.violetlib.aqua.VisualEffectView;
import org.violetlib.aqua.VisualEffectViewPeer;

public class AquaVibrantSupport {
    public static final int NO_VIBRANT_STYLE = -1;
    public static final int LIGHT_STYLE = 0;
    public static final int DARK_STYLE = 1;
    public static final int SIDEBAR_STYLE = 2;
    public static final int TITLE_BAR_STYLE = 3;
    public static final int MENU_STYLE = 4;
    public static final int POPOVER_STYLE = 5;
    public static final int MEDIUM_LIGHT_STYLE = 6;
    public static final int ULTRA_DARK_STYLE = 7;
    public static final int SELECTION_STYLE = 9;
    public static final int SHEET_STYLE = 8;
    public static final int HEADER_STYLE = 10;
    public static final int WINDOW_BACKGROUND_STYLE = 11;
    public static final int HUD_WINDOW_STYLE = 12;
    public static final int FULL_SCREEN_MODAL_STYLE = 13;
    public static final int TOOL_TIP_STYLE = 14;
    public static final int CONTENT_BACKGROUND_STYLE = 15;
    public static final int UNDER_WINDOW_BACKGROUND_STYLE = 16;
    public static final int UNDER_PAGE_BACKGROUND_STYLE = 17;
    public static final String BACKGROUND_STYLE_KEY = "Aqua.backgroundStyle";
    public static final String POPUP_BACKGROUND_STYLE_KEY = "AquaPopup.backgroundStyle";
    public static final String POPUP_CORNER_RADIUS_KEY = "AquaPopup.cornerRadius";
    private static final String VIBRANT_EFFECTS_KEY = "AquaInternal.vibrantEffects";
    private static final String VIBRANT_WINDOW_KEY = "AquaInternal.vibrantWindow";
    private static final PropertyChangeListener vibrantStylePropertyChangeListener = new VibrantStylePropertyChangeListener();

    public static int parseVibrantStyle(Object object, boolean bl) {
        if (object instanceof String) {
            if (object.equals("vibrantLight")) {
                return 0;
            }
            if (object.equals("vibrantDark")) {
                return 1;
            }
            if (object.equals("vibrantSidebar")) {
                return bl ? 2 : 0;
            }
            if (object.equals("vibrantTitleBar")) {
                return 3;
            }
            if (object.equals("vibrantMenu")) {
                return 4;
            }
            if (object.equals("vibrantPopover")) {
                return 5;
            }
            if (object.equals("vibrantMediumLight")) {
                return 6;
            }
            if (object.equals("vibrantUltraDark")) {
                return 7;
            }
            if (object.equals("vibrantSheet")) {
                return 8;
            }
            if (object.equals("vibrantSelection")) {
                return 9;
            }
            if (object.equals("vibrantHeader")) {
                return 10;
            }
            if (object.equals("vibrantWindowBackground")) {
                return 11;
            }
            if (object.equals("vibrantHUDWindow")) {
                return 12;
            }
            if (object.equals("vibrantFullScreenUI")) {
                return 13;
            }
            if (object.equals("vibrantToolTip")) {
                return 14;
            }
            if (object.equals("vibrantContentBackground")) {
                return 15;
            }
            if (object.equals("vibrantUnderWindowBackground")) {
                return 16;
            }
            if (object.equals("vibrantUnderPageBackground")) {
                return 17;
            }
        }
        return -1;
    }

    public static boolean isVibrant(JComponent jComponent) {
        Object object = jComponent.getClientProperty(VIBRANT_EFFECTS_KEY);
        if (object != null) {
            return true;
        }
        return jComponent instanceof JRootPane && (object = jComponent.getClientProperty(VIBRANT_WINDOW_KEY)) != null;
    }

    public static void installVibrantStyle(@NotNull JComponent jComponent) {
        jComponent.addPropertyChangeListener(vibrantStylePropertyChangeListener);
        AquaVibrantSupport.updateVibrantStyle(jComponent);
    }

    public static void uninstallVibrantStyle(@NotNull JComponent jComponent) {
        jComponent.removePropertyChangeListener(vibrantStylePropertyChangeListener);
        AquaVibrantSupport.internalUninstallVibrantStyle(jComponent);
    }

    private static void processVibrantStyleChange(@NotNull PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        JComponent jComponent = (JComponent)propertyChangeEvent.getSource();
        if (BACKGROUND_STYLE_KEY.equals(string)) {
            AquaVibrantSupport.updateVibrantStyle(jComponent);
        }
    }

    private static void updateVibrantStyle(@NotNull JComponent jComponent) {
        int n;
        Object object = jComponent.getClientProperty(BACKGROUND_STYLE_KEY);
        if (object instanceof String && (n = AquaVibrantSupport.parseVibrantStyle(object, true)) >= 0) {
            AquaVibrantSupport.installVibrantStyle(jComponent, n, null);
            return;
        }
        AquaVibrantSupport.internalUninstallVibrantStyle(jComponent);
    }

    private static void installVibrantStyle(@NotNull JComponent jComponent, int n, @Nullable SelectionBoundsTracker selectionBoundsTracker) {
        VisualEffectView visualEffectView;
        Object object = jComponent.getClientProperty(VIBRANT_EFFECTS_KEY);
        if (object != null) {
            if (object instanceof VisualEffectView) {
                visualEffectView = (VisualEffectView)object;
                if (visualEffectView.getStyle() == n) {
                    return;
                }
                visualEffectView.dispose();
            }
            jComponent.putClientProperty(VIBRANT_EFFECTS_KEY, null);
        }
        visualEffectView = new ComponentVibrantEffects(jComponent, n, selectionBoundsTracker);
        jComponent.putClientProperty(VIBRANT_EFFECTS_KEY, visualEffectView);
    }

    private static void internalUninstallVibrantStyle(@NotNull JComponent jComponent) {
        Object object = jComponent.getClientProperty(VIBRANT_EFFECTS_KEY);
        if (object != null) {
            if (object instanceof VisualEffectView) {
                VisualEffectView visualEffectView = (VisualEffectView)object;
                visualEffectView.dispose();
            }
            jComponent.putClientProperty(VIBRANT_EFFECTS_KEY, null);
        }
    }

    public static void addFullWindowVibrantView(@NotNull Window window, int n) {
        boolean bl = window.getType() == Window.Type.POPUP || !AquaUtils.isDecorated(window);
        long l2 = AquaUtils.execute(window, l -> AquaVibrantSupport.setupVisualEffectWindow(l, n, bl));
        if (l2 != 0L) {
            System.err.println("Unable to install visual effect view");
        } else {
            JRootPane jRootPane = AquaUtils.getRootPane(window);
            if (jRootPane != null) {
                AquaUtils.enableTranslucency(window);
                jRootPane.putClientProperty(VIBRANT_WINDOW_KEY, Boolean.TRUE);
                AquaUtils.paintImmediately(window, jRootPane);
                AquaUtils.syncAWTView(window);
            }
        }
    }

    public static void removeFullWindowVibrantView(@NotNull Window window) {
        JRootPane jRootPane = AquaUtils.getRootPane(window);
        if (jRootPane != null && jRootPane.getClientProperty(VIBRANT_WINDOW_KEY) != null) {
            long l = AquaUtils.execute(window, AquaVibrantSupport::removeVisualEffectWindow);
            if (l != 0L) {
                System.err.println("Unable to remove visual effect view");
            } else {
                jRootPane.putClientProperty(VIBRANT_WINDOW_KEY, null);
                jRootPane.repaint();
            }
        }
    }

    public static VisualEffectViewPeer createVisualEffectView(@NotNull Window window, int n, boolean bl) {
        long l2 = AquaUtils.execute(window, l -> AquaVibrantSupport.nativeCreateVisualEffectView(l, n, bl));
        if (l2 != 0L) {
            AquaUtils.enableTranslucency(window);
            return new VisualEffectViewPeerImpl(window, l2);
        }
        return null;
    }

    private static native int setupVisualEffectWindow(long var0, int var2, boolean var3);

    private static native int removeVisualEffectWindow(long var0);

    private static native long nativeCreateVisualEffectView(long var0, int var2, boolean var3);

    private static native int setViewFrame(long var0, int var2, int var3, int var4, int var5, int var6);

    private static native int nativeUpdateSelectionBackgrounds(long var0, int[] var2);

    private static native int disposeVisualEffectView(long var0);

    private static class VisualEffectViewPeerImpl
    implements VisualEffectViewPeer {
        @NotNull
        private final Window w;
        private long nativeNSViewPointer;

        public VisualEffectViewPeerImpl(@NotNull Window window, long l) {
            this.w = window;
            this.nativeNSViewPointer = l;
        }

        @Override
        public void dispose() {
            if (this.nativeNSViewPointer != 0L) {
                int n;
                if (this.w.isDisplayable() && (n = AquaVibrantSupport.disposeVisualEffectView(this.nativeNSViewPointer)) != 0) {
                    System.err.println("disposeVisualEffectView failed");
                }
                this.nativeNSViewPointer = 0L;
            }
        }

        @Override
        public void setFrame(int n, int n2, int n3, int n4) {
            int n5 = this.w.getHeight() - (n2 + n4);
            int n6 = AquaVibrantSupport.setViewFrame(this.nativeNSViewPointer, n, n2, n3, n4, n5);
            if (n6 != 0) {
                System.err.println("setViewFrame failed");
            }
        }

        @Override
        public void updateSelectionBackgrounds(SelectionBoundsDescription selectionBoundsDescription) {
            int n = AquaVibrantSupport.nativeUpdateSelectionBackgrounds(this.nativeNSViewPointer, selectionBoundsDescription != null ? selectionBoundsDescription.getData() : null);
            if (n != 0) {
                System.err.println("updateSelectionBackgrounds failed");
            }
        }
    }

    private static class VibrantStylePropertyChangeListener
    implements PropertyChangeListener {
        private VibrantStylePropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AquaVibrantSupport.processVibrantStyleChange(propertyChangeEvent);
        }
    }
}

