/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextPaneUI;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceContext;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaCaret;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaComponentUI;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaKeyBindings;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.BasicContextualColors;
import org.violetlib.aqua.FocusRingOutlineProvider;
import org.violetlib.jnr.aqua.AquaUIPainter;

public class AquaTextPaneUI
extends BasicTextPaneUI
implements FocusRingOutlineProvider,
AquaComponentUI {
    private JTextComponent editor;
    private AquaFocusHandler handler;
    private boolean oldDragState = false;
    @NotNull
    protected BasicContextualColors colors = AquaColors.TEXT_COLORS;
    @Nullable
    protected AppearanceContext appearanceContext;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaTextPaneUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        if (jComponent instanceof JTextComponent) {
            this.editor = (JTextComponent)jComponent;
            super.installUI(jComponent);
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.editor = null;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        JTextComponent jTextComponent = this.getComponent();
        this.handler = new AquaFocusHandler();
        jTextComponent.addFocusListener(this.handler);
        jTextComponent.addPropertyChangeListener(this.handler);
        AquaUtilControlSize.addSizePropertyListener(jTextComponent);
        AppearanceManager.installListener(this.editor);
    }

    @Override
    protected void uninstallListeners() {
        AppearanceManager.uninstallListener(this.editor);
        JTextComponent jTextComponent = this.getComponent();
        AquaUtilControlSize.removeSizePropertyListener(jTextComponent);
        jTextComponent.removeFocusListener(this.handler);
        jTextComponent.removePropertyChangeListener(this.handler);
        this.handler = null;
        super.uninstallListeners();
    }

    @Override
    protected void installDefaults() {
        if (!GraphicsEnvironment.isHeadless()) {
            this.oldDragState = this.editor.getDragEnabled();
            this.editor.setDragEnabled(true);
        }
        super.installDefaults();
        this.configureAppearanceContext(null);
    }

    @Override
    protected void uninstallDefaults() {
        if (!GraphicsEnvironment.isHeadless()) {
            this.editor.setDragEnabled(this.oldDragState);
        }
        super.uninstallDefaults();
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        AquaKeyBindings aquaKeyBindings = AquaKeyBindings.instance();
        aquaKeyBindings.setDefaultAction(this.getKeymapName());
        JTextComponent jTextComponent = this.getComponent();
        aquaKeyBindings.installAquaUpDownActions(jTextComponent);
    }

    @Override
    public void appearanceChanged(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
        this.configureAppearanceContext(aquaAppearance);
    }

    @Override
    public void activeStateChanged(@NotNull JComponent jComponent, boolean bl) {
        this.configureAppearanceContext(null);
    }

    protected void configureAppearanceContext(@Nullable AquaAppearance aquaAppearance) {
        if (aquaAppearance == null) {
            aquaAppearance = AppearanceManager.ensureAppearance(this.editor);
        }
        AquaUIPainter.State state = this.getState();
        this.appearanceContext = new AppearanceContext(aquaAppearance, state, false, false);
        AquaColors.installColors(this.editor, this.appearanceContext, this.colors);
        this.editor.repaint();
    }

    protected AquaUIPainter.State getState() {
        boolean bl = AquaFocusHandler.isActive(this.editor);
        boolean bl2 = AquaFocusHandler.hasFocus(this.editor);
        return bl ? (bl2 ? AquaUIPainter.State.ACTIVE_DEFAULT : AquaUIPainter.State.ACTIVE) : AquaUIPainter.State.INACTIVE;
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        AquaAppearance aquaAppearance = AppearanceManager.registerCurrentAppearance(jComponent);
        super.update(graphics, jComponent);
        AppearanceManager.restoreCurrentAppearance(aquaAppearance);
    }

    @Override
    protected Caret createCaret() {
        return new AquaCaret();
    }

    @Override
    public Shape getFocusRingOutline(JComponent jComponent) {
        return null;
    }
}

