/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollPaneUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceContext;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaComponentUI;
import org.violetlib.aqua.AquaOverlayScrollPaneController;
import org.violetlib.aqua.AquaOverlayScrollPaneLayout;
import org.violetlib.aqua.AquaTreeUI;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.aqua.OverlayScrollPaneHack;
import org.violetlib.jnr.aqua.AquaUIPainter;

public class AquaScrollPaneUI
extends BasicScrollPaneUI
implements AquaUtilControlSize.Sizeable,
AquaComponentUI {
    public static final String SCROLL_PANE_STYLE_KEY = "JScrollPane.style";
    public static final String SCROLL_PANE_THUMB_STYLE_KEY = "JScrollPane.thumbStyle";
    public static final String SCROLL_PANE_AQUA_OVERLAY_SCROLL_BARS_KEY = "AquaOverlayScrollBars";
    public static final String THUMB_STYLE_DARK = "dark";
    public static final String THUMB_STYLE_LIGHT = "light";
    public static final int WHEEL_CHANGE_DIRECTION_MINIMUM = 3;
    public static final boolean isRTLSupported = OSXSystemProperties.doScrollPanesSupportRTL();
    private static final boolean useViewportHack = true;
    protected AquaUIPainter.Size size;
    protected boolean isOverlayScrollBars;
    protected AquaOverlayScrollPaneController overlayController;
    protected int contraryScrollCount;
    protected OverlayScrollPaneHack overlayScrollPaneHack;
    protected LayoutManager legacyLayoutManager;
    @Nullable
    protected AppearanceContext appearanceContext;
    protected PropertyChangeListener propertyChangeListener;
    protected ChangeListener preferenceChangeListener;
    protected ComponentListener componentListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaScrollPaneUI();
    }

    @Override
    protected MouseWheelListener createMouseWheelListener() {
        return new XYMouseWheelHandler();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.legacyLayoutManager = this.scrollpane.getLayout();
        if (this.legacyLayoutManager == null) {
            this.legacyLayoutManager = new ScrollPaneLayout.UIResource();
        }
        this.setScrollBarStyle(this.shouldUseOverlayScrollBars());
        this.scrollpane.putClientProperty(SCROLL_PANE_AQUA_OVERLAY_SCROLL_BARS_KEY, this.isOverlayScrollBars);
        this.configureAppearanceContext(null);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.setScrollBarStyle(false);
        JScrollPane jScrollPane = this.scrollpane;
        super.uninstallUI(jComponent);
        jScrollPane.putClientProperty(SCROLL_PANE_AQUA_OVERLAY_SCROLL_BARS_KEY, null);
    }

    @Override
    protected void installListeners(JScrollPane jScrollPane) {
        super.installListeners(jScrollPane);
        this.componentListener = new MyComponentListener();
        jScrollPane.addComponentListener(this.componentListener);
        this.propertyChangeListener = new MyPropertyChangeListener();
        jScrollPane.addPropertyChangeListener(this.propertyChangeListener);
        this.preferenceChangeListener = new PreferenceChangeListener();
        OSXSystemProperties.addChangeListener(this.preferenceChangeListener);
        AquaUtilControlSize.addSizePropertyListener(jScrollPane);
        AppearanceManager.installListener(jScrollPane);
    }

    @Override
    protected void uninstallListeners(JComponent jComponent) {
        if (this.overlayController != null) {
            this.overlayController.dispose();
            this.overlayController = null;
        }
        if (this.overlayScrollPaneHack != null) {
            this.overlayScrollPaneHack.dispose();
            this.overlayScrollPaneHack = null;
        }
        AppearanceManager.uninstallListener(jComponent);
        AquaUtilControlSize.removeSizePropertyListener(jComponent);
        OSXSystemProperties.removeChangeListener(this.preferenceChangeListener);
        this.preferenceChangeListener = null;
        jComponent.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        jComponent.removeComponentListener(this.componentListener);
        this.componentListener = null;
        super.uninstallListeners(jComponent);
    }

    @Override
    public void applySizeFor(JComponent jComponent, AquaUIPainter.Size size, boolean bl) {
        this.size = size;
        if (jComponent instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)jComponent;
            this.updateScrollBar(jScrollPane.getHorizontalScrollBar());
            this.updateScrollBar(jScrollPane.getVerticalScrollBar());
        }
    }

    @Override
    public void appearanceChanged(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
        this.configureAppearanceContext(null);
    }

    @Override
    public void activeStateChanged(@NotNull JComponent jComponent, boolean bl) {
    }

    protected void configureAppearanceContext(@Nullable AquaAppearance aquaAppearance) {
        if (aquaAppearance == null) {
            aquaAppearance = AppearanceManager.ensureAppearance(this.scrollpane);
        }
        AquaUIPainter.State state = this.getState();
        this.appearanceContext = new AppearanceContext(aquaAppearance, state, false, false);
        this.updateThumbStyle();
        this.scrollpane.repaint();
    }

    @NotNull
    protected AquaUIPainter.State getState() {
        return AquaUIPainter.State.ACTIVE;
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        AquaAppearance aquaAppearance = AppearanceManager.registerCurrentAppearance(jComponent);
        if (jComponent.isOpaque()) {
            Color color = AquaColors.getBackground(jComponent, "controlBackground");
            AquaUtils.fillRect(graphics, jComponent, color, 2);
        }
        this.paint(graphics, jComponent);
        AppearanceManager.restoreCurrentAppearance(aquaAppearance);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        boolean bl;
        if (this.syncLayoutManager()) {
            this.scrollpane.validate();
        }
        if ((bl = this.isSideBar()) && !this.isOverlayScrollBars) {
            this.setSidebarStyle(this.scrollpane.getHorizontalScrollBar(), true);
            this.setSidebarStyle(this.scrollpane.getVerticalScrollBar(), true);
        } else {
            this.setSidebarStyle(this.scrollpane.getHorizontalScrollBar(), false);
            this.setSidebarStyle(this.scrollpane.getVerticalScrollBar(), false);
        }
        super.paint(graphics, jComponent);
        if (!this.isOverlayScrollBars && !bl) {
            JScrollBar jScrollBar = this.scrollpane.getVerticalScrollBar();
            JScrollBar jScrollBar2 = this.scrollpane.getHorizontalScrollBar();
            if (jScrollBar != null && jScrollBar2 != null && jScrollBar.isVisible() && jScrollBar2.isVisible()) {
                int n = jScrollBar.getX();
                int n2 = jScrollBar.getX() + jScrollBar.getWidth();
                int n3 = jScrollBar2.getY();
                int n4 = jScrollBar2.getY() + jScrollBar2.getHeight();
                assert (this.appearanceContext != null);
                AquaAppearance aquaAppearance = this.appearanceContext.getAppearance();
                Color color = aquaAppearance.getColor("scrollPaneTrack");
                Color color2 = aquaAppearance.getColor("scrollPaneTrackBorder");
                int n5 = n2 - n;
                int n6 = n4 - n3;
                graphics.setColor(color);
                graphics.fillRect(n, n3, n5 - 1, n6 - 1);
                graphics.setColor(color2);
                graphics.fillRect(n, n4 - 1, n5, 1);
                if (AquaUtils.isLeftToRight(this.scrollpane) || !isRTLSupported) {
                    graphics.fillRect(n2 - 1, n3, 1, n6 - 1);
                    graphics.fillRect(n, n3, 1, 1);
                } else {
                    graphics.fillRect(n, n3, 1, n6 - 1);
                    graphics.fillRect(n2 - 1, n3, 1, 1);
                }
            }
        }
    }

    protected boolean isSideBar() {
        AquaTreeUI aquaTreeUI;
        Component component;
        JViewport jViewport = this.scrollpane.getViewport();
        return jViewport != null && (component = SwingUtilities.getUnwrappedView(jViewport)) instanceof JTree && (aquaTreeUI = AquaUtils.getUI((JTree)component, AquaTreeUI.class)) != null && aquaTreeUI.isSideBar();
    }

    protected void setSidebarStyle(JScrollBar jScrollBar, boolean bl) {
        if (jScrollBar != null) {
            Object object = jScrollBar.getClientProperty("JScrollBar.style");
            if (object == null) {
                if (bl) {
                    jScrollBar.putClientProperty("JScrollBar.style", "sidebar");
                }
            } else if (object.equals("sidebar") && !bl) {
                jScrollBar.putClientProperty("JScrollBar.style", null);
            }
        }
    }

    public boolean isOverlayScrollBars() {
        return this.isOverlayScrollBars;
    }

    protected void updateStyle() {
        boolean bl = this.shouldUseOverlayScrollBars();
        if (bl != this.isOverlayScrollBars) {
            this.setScrollBarStyle(bl);
            this.scrollpane.putClientProperty(SCROLL_PANE_AQUA_OVERLAY_SCROLL_BARS_KEY, bl);
        }
    }

    protected void updateThumbStyle() {
        if (this.isOverlayScrollBars) {
            this.updateScrollBar(this.scrollpane.getHorizontalScrollBar());
            this.updateScrollBar(this.scrollpane.getVerticalScrollBar());
        }
    }

    protected boolean shouldUseOverlayScrollBars() {
        LayoutManager layoutManager = this.scrollpane.getLayout();
        if (layoutManager != null && !(layoutManager instanceof UIResource)) {
            return false;
        }
        Object object = this.scrollpane.getClientProperty(SCROLL_PANE_STYLE_KEY);
        if ("overlay".equals(object)) {
            return true;
        }
        if ("legacy".equals(object)) {
            return false;
        }
        return OSXSystemProperties.useOverlayScrollBars();
    }

    protected void setScrollBarStyle(boolean bl) {
        this.isOverlayScrollBars = bl;
        this.syncLayoutManager();
        this.syncOverlayScrollPaneHack();
        if (this.isOverlayScrollBars) {
            if (this.overlayController == null) {
                this.overlayController = new AquaOverlayJScrollPaneController();
            }
        } else if (this.overlayController != null) {
            this.overlayController.dispose();
            this.overlayController = null;
        }
        this.updateScrollBar(this.scrollpane.getHorizontalScrollBar());
        this.updateScrollBar(this.scrollpane.getVerticalScrollBar());
        this.scrollpane.revalidate();
        this.scrollpane.repaint();
    }

    protected void syncOverlayScrollPaneHack() {
        if (this.isOverlayScrollBars && this.scrollpane.isOptimizedDrawingEnabled()) {
            if (this.overlayScrollPaneHack == null) {
                this.overlayScrollPaneHack = new OverlayScrollPaneHack(this.scrollpane);
            }
        } else if (this.overlayScrollPaneHack != null) {
            this.overlayScrollPaneHack.dispose();
            this.overlayScrollPaneHack = null;
        }
    }

    public void syncOverlayScrollPaneViewportHolderSize() {
        if (this.overlayScrollPaneHack != null) {
            this.overlayScrollPaneHack.syncScrollPaneSize();
        }
    }

    protected void updateScrollBar(JScrollBar jScrollBar) {
        if (jScrollBar != null) {
            jScrollBar.revalidate();
            jScrollBar.repaint();
            jScrollBar.putClientProperty("JComponent.sizeVariant", AquaUtilControlSize.getStringFromSize(this.size));
            if (this.isOverlayScrollBars) {
                Object object = this.scrollpane.getClientProperty(SCROLL_PANE_THUMB_STYLE_KEY);
                if (THUMB_STYLE_LIGHT.equals(object)) {
                    jScrollBar.putClientProperty("JScrollBar.thumbStyle", "overlayLight");
                } else if (THUMB_STYLE_DARK.equals(object)) {
                    jScrollBar.putClientProperty("JScrollBar.thumbStyle", "overlayDark");
                } else {
                    AquaAppearance aquaAppearance = AppearanceManager.ensureAppearance(this.scrollpane);
                    String string = aquaAppearance.isDark() ? "overlayLight" : "overlayDark";
                    jScrollBar.putClientProperty("JScrollBar.thumbStyle", string);
                }
            } else {
                jScrollBar.putClientProperty("JScrollBar.thumbStyle", null);
            }
        }
    }

    protected boolean syncLayoutManager() {
        LayoutManager layoutManager = this.scrollpane.getLayout();
        if (layoutManager instanceof AquaOverlayScrollPaneLayout) {
            if (!this.isOverlayScrollBars) {
                this.scrollpane.setLayout(this.legacyLayoutManager);
                return true;
            }
        } else {
            this.legacyLayoutManager = layoutManager;
            if (this.isOverlayScrollBars) {
                if (layoutManager instanceof UIResource) {
                    this.scrollpane.setLayout(new AquaOverlayScrollPaneLayout());
                    this.hideScrollBar(this.scrollpane.getHorizontalScrollBar());
                    this.hideScrollBar(this.scrollpane.getVerticalScrollBar());
                    return true;
                }
                this.updateStyle();
            }
        }
        return false;
    }

    protected void hideScrollBar(JScrollBar jScrollBar) {
        if (jScrollBar != null) {
            jScrollBar.setVisible(false);
        }
    }

    protected boolean isAxisScrollable(boolean bl) {
        JScrollBar jScrollBar;
        JScrollBar jScrollBar2 = jScrollBar = bl ? this.scrollpane.getHorizontalScrollBar() : this.scrollpane.getVerticalScrollBar();
        if (jScrollBar == null) {
            return false;
        }
        int n = Math.max(0, jScrollBar.getMaximum() - jScrollBar.getMinimum());
        int n2 = jScrollBar.getModel().getExtent();
        return n2 > 0 && n2 < n;
    }

    protected class XYMouseWheelHandler
    extends BasicScrollPaneUI.MouseWheelHandler {
        protected XYMouseWheelHandler() {
            super(AquaScrollPaneUI.this);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            JScrollBar jScrollBar;
            boolean bl = mouseWheelEvent.isShiftDown();
            if (!AquaScrollPaneUI.this.isAxisScrollable(bl)) {
                AquaScrollPaneUI.this.contraryScrollCount = 0;
                return;
            }
            if (AquaScrollPaneUI.this.overlayController != null) {
                int n = AquaScrollPaneUI.this.overlayController.getActiveAxis();
                if (n == 0 && !bl || n == 1 && bl) {
                    AquaScrollPaneUI.this.contraryScrollCount += mouseWheelEvent.getUnitsToScroll();
                    if (Math.abs(AquaScrollPaneUI.this.contraryScrollCount) < 3) {
                        return;
                    }
                } else {
                    AquaScrollPaneUI.this.contraryScrollCount = 0;
                }
            }
            boolean bl2 = (jScrollBar = AquaScrollPaneUI.this.scrollpane.getVerticalScrollBar()) != null && jScrollBar.isVisible();
            JScrollBar jScrollBar2 = AquaScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
            boolean bl3 = jScrollBar2 != null && jScrollBar2.isVisible();
            boolean bl4 = false;
            if (jScrollBar != null) {
                jScrollBar.setVisible(!bl);
                if (!bl && AquaScrollPaneUI.this.overlayController != null) {
                    AquaScrollPaneUI.this.overlayController.activateScrollBar(mouseWheelEvent, true);
                    bl4 = true;
                }
            }
            if (jScrollBar2 != null) {
                jScrollBar2.setVisible(bl);
                if (bl && AquaScrollPaneUI.this.overlayController != null) {
                    AquaScrollPaneUI.this.overlayController.activateScrollBar(mouseWheelEvent, false);
                    bl4 = true;
                }
            }
            super.mouseWheelMoved(mouseWheelEvent);
            if (!bl4) {
                if (jScrollBar != null) {
                    jScrollBar.setVisible(bl2);
                }
                if (jScrollBar2 != null) {
                    jScrollBar2.setVisible(bl3);
                }
            }
            mouseWheelEvent.consume();
        }
    }

    protected class MyComponentListener
    extends ComponentAdapter {
        protected MyComponentListener() {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            AquaScrollPaneUI.this.syncLayoutManager();
        }
    }

    protected class AquaOverlayJScrollPaneController
    extends AquaOverlayScrollPaneController {
        public AquaOverlayJScrollPaneController() {
            this.setVerticalScrollBar(AquaScrollPaneUI.this.scrollpane.getVerticalScrollBar());
            this.setHorizontalScrollBar(AquaScrollPaneUI.this.scrollpane.getHorizontalScrollBar());
        }

        @Override
        protected void reconfigure(JScrollBar jScrollBar, String string) {
            if (AquaScrollPaneUI.this.overlayScrollPaneHack != null) {
                AquaScrollPaneUI.this.overlayScrollPaneHack.reconfigure(jScrollBar, string);
            } else {
                AquaScrollPaneUI.this.scrollpane.remove(jScrollBar);
                AquaScrollPaneUI.this.scrollpane.add(jScrollBar, string, 0);
            }
        }
    }

    protected class MyPropertyChangeListener
    implements PropertyChangeListener {
        protected MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string != null) {
                if (string.equals(AquaScrollPaneUI.SCROLL_PANE_STYLE_KEY)) {
                    AquaScrollPaneUI.this.updateStyle();
                } else if (string.equals(AquaScrollPaneUI.SCROLL_PANE_THUMB_STYLE_KEY)) {
                    AquaScrollPaneUI.this.updateThumbStyle();
                } else if (string.equals("verticalScrollBar")) {
                    this.updateVerticalScrollBar();
                } else if (string.equals("horizontalScrollBar")) {
                    this.updateHorizontalScrollBar();
                }
            }
        }

        protected void updateVerticalScrollBar() {
            if (AquaScrollPaneUI.this.overlayController != null) {
                AquaScrollPaneUI.this.overlayController.setVerticalScrollBar(AquaScrollPaneUI.this.scrollpane.getVerticalScrollBar());
            }
            AquaScrollPaneUI.this.updateScrollBar(AquaScrollPaneUI.this.scrollpane.getVerticalScrollBar());
        }

        protected void updateHorizontalScrollBar() {
            if (AquaScrollPaneUI.this.overlayController != null) {
                AquaScrollPaneUI.this.overlayController.setHorizontalScrollBar(AquaScrollPaneUI.this.scrollpane.getHorizontalScrollBar());
            }
            AquaScrollPaneUI.this.updateScrollBar(AquaScrollPaneUI.this.scrollpane.getHorizontalScrollBar());
        }
    }

    protected class PreferenceChangeListener
    implements ChangeListener {
        protected PreferenceChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            AquaScrollPaneUI.this.updateStyle();
        }
    }
}

