/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicLookAndFeel;
import org.violetlib.aqua.AquaButtonBorder;
import org.violetlib.aqua.AquaButtonUI;
import org.violetlib.aqua.AquaFocusRingManager;
import org.violetlib.aqua.AquaFonts;
import org.violetlib.aqua.AquaGroupBorder;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaKeyBindings;
import org.violetlib.aqua.AquaLineBorder;
import org.violetlib.aqua.AquaMenuBarBorder;
import org.violetlib.aqua.AquaMenuItemBorder;
import org.violetlib.aqua.AquaMnemonicHandler;
import org.violetlib.aqua.AquaNativeSupport;
import org.violetlib.aqua.AquaPopupFactory;
import org.violetlib.aqua.AquaRootPaneUI;
import org.violetlib.aqua.AquaSheetSupport;
import org.violetlib.aqua.AquaTableHeaderBorder;
import org.violetlib.aqua.AquaTableScrollPaneCorner;
import org.violetlib.aqua.AquaTextFieldBorder;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.JavaSupport;
import org.violetlib.aqua.fc.OSXFile;
import org.violetlib.jnr.aqua.AquaNativeRendering;

public class AquaLookAndFeel
extends BasicLookAndFeel {
    private static final String PKG_PREFIX = "org.violetlib.aqua.";
    private AquaFocusRingManager focusRingManager;
    private PropertyChangeListener uiChangeListener;
    private AquaPopupFactory popupFactory;
    public static boolean suppressCreationOfDisabledButtonIcons;

    @Override
    public String getName() {
        return "VAqua";
    }

    @Override
    public String getID() {
        return "VAqua";
    }

    @Override
    public String getDescription() {
        return "VAqua Look and Feel for Mac OS X";
    }

    @Override
    public boolean getSupportsWindowDecorations() {
        return false;
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return true;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return AquaNativeSupport.load();
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.popupFactory == null) {
            this.popupFactory = JavaSupport.createPopupFactory();
        }
        if (PopupFactory.getSharedInstance() != this.popupFactory) {
            PopupFactory.setSharedInstance(this.popupFactory);
        }
        this.popupFactory.setActive(true);
        this.focusRingManager = AquaFocusRingManager.getInstance();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(AquaMnemonicHandler.getInstance());
        if (this.uiChangeListener == null) {
            this.uiChangeListener = new MyUIChangeListener();
        }
        UIManager.addPropertyChangeListener(this.uiChangeListener);
    }

    @Override
    public void uninitialize() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(AquaMnemonicHandler.getInstance());
        UIManager.removePropertyChangeListener(this.uiChangeListener);
        if (this.focusRingManager != null) {
            this.focusRingManager.uninstall();
            this.focusRingManager = null;
        }
        this.popupFactory.setActive(false);
        super.uninitialize();
    }

    @Override
    public Icon getDisabledIcon(JComponent jComponent, Icon icon) {
        if (!suppressCreationOfDisabledButtonIcons) {
            AquaButtonUI aquaButtonUI;
            if (icon instanceof ImageIcon && jComponent instanceof AbstractButton && (aquaButtonUI = AquaUtils.getUI(jComponent, AquaButtonUI.class)) != null) {
                return aquaButtonUI.createDisabledIcon((AbstractButton)jComponent, (ImageIcon)icon);
            }
            return super.getDisabledIcon(jComponent, icon);
        }
        return null;
    }

    @Override
    public Icon getDisabledSelectedIcon(JComponent jComponent, Icon icon) {
        if (!suppressCreationOfDisabledButtonIcons) {
            AquaButtonUI aquaButtonUI;
            if (icon instanceof ImageIcon && jComponent instanceof AbstractButton && (aquaButtonUI = AquaUtils.getUI(jComponent, AquaButtonUI.class)) != null) {
                return aquaButtonUI.createDisabledSelectedIcon((AbstractButton)jComponent, (ImageIcon)icon);
            }
            return super.getDisabledSelectedIcon(jComponent, icon);
        }
        return null;
    }

    public void displayAsSheet(Window window, Runnable runnable) throws UnsupportedOperationException {
        AquaSheetSupport.displayAsSheet(window, runnable);
    }

    public void showOptionPaneAsSheet(JDialog jDialog, JOptionPane jOptionPane, Consumer<Integer> consumer) {
        AquaSheetSupport.showOptionPaneAsSheet(jDialog, jOptionPane, consumer);
    }

    public void showFileChooserAsSheet(Window window, JFileChooser jFileChooser, Consumer<Integer> consumer) {
        AquaSheetSupport.showFileChooserAsSheet(window, jFileChooser, consumer);
    }

    public void setForceActiveWindowDisplay(boolean bl) {
        AquaRootPaneUI.setForceActiveWindowDisplay(bl);
    }

    @Override
    protected ActionMap getAudioActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("AuditoryCues.actionMap");
        if (actionMap != null) {
            return actionMap;
        }
        Object[] objectArray = (Object[])UIManager.get("AuditoryCues.cueList");
        if (objectArray != null) {
            actionMap = new ActionMapUIResource();
            for (int i = objectArray.length - 1; i >= 0; --i) {
                actionMap.put(objectArray[i], this.createAudioAction(objectArray[i]));
            }
        }
        UIManager.getLookAndFeelDefaults().put("AuditoryCues.actionMap", actionMap);
        return actionMap;
    }

    protected static Object makeIcon(String string) {
        return new UIDefaults.ProxyLazyValue("org.violetlib.aqua.AquaIcon", "loadResource", new Object[]{string});
    }

    @Override
    public UIDefaults getDefaults() {
        UIDefaults uIDefaults = new UIDefaults();
        uIDefaults.put("ClassLoader", this.getClass().getClassLoader());
        try {
            this.initClassDefaults(uIDefaults);
            super.initSystemColorDefaults(uIDefaults);
            super.initComponentDefaults(uIDefaults);
            this.initSystemColorDefaults(uIDefaults);
            this.initComponentDefaults(uIDefaults);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return uIDefaults;
    }

    private void initResourceBundle(UIDefaults uIDefaults) {
        uIDefaults.setDefaultLocale(Locale.getDefault());
        this.addResourceBundle(uIDefaults, "org.violetlib.aqua.resources.aqua");
        this.addResourceBundle(uIDefaults, "org.violetlib.aqua.Labels");
    }

    private void addResourceBundle(UIDefaults uIDefaults, String string) {
        uIDefaults.addResourceBundle(string);
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string);
            Enumeration<String> enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement();
                uIDefaults.put(string2, resourceBundle.getString(string2));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void initComponentDefaults(UIDefaults uIDefaults2) {
        ColorUIResource colorUIResource;
        InsetsUIResource insetsUIResource;
        this.initResourceBundle(uIDefaults2);
        InsetsUIResource insetsUIResource2 = insetsUIResource = new InsetsUIResource(0, 0, 0, 0);
        UIDefaults.ActiveValue activeValue = new UIDefaults.ActiveValue(){

            @Override
            public Object createValue(UIDefaults uIDefaults) {
                return new DefaultListCellRenderer.UIResource();
            }
        };
        BorderUIResource.EmptyBorderUIResource emptyBorderUIResource = new BorderUIResource.EmptyBorderUIResource(2, 0, 2, 0);
        ColorUIResource colorUIResource2 = new ColorUIResource(new Color(0, 0, 0, 152));
        ColorUIResource colorUIResource3 = new ColorUIResource(new Color(192, 192, 192, 192));
        ColorUIResource colorUIResource4 = new ColorUIResource(new Color(0, 0, 0, 100));
        UIDefaults.LazyValue lazyValue = uIDefaults -> new BasicBorders.MarginBorder();
        int n = 0;
        InsetsUIResource insetsUIResource3 = insetsUIResource;
        int n2 = 500;
        UIDefaults.LazyValue lazyValue2 = uIDefaults -> AquaTextFieldBorder.getTextFieldBorder();
        UIDefaults.LazyValue lazyValue3 = lazyValue;
        UIDefaults.LazyValue lazyValue4 = uIDefaults -> AquaGroupBorder.getBorderForTitledBorder();
        AquaTableHeaderBorder aquaTableHeaderBorder = AquaTableHeaderBorder.getListHeaderBorder();
        BorderUIResource.EmptyBorderUIResource emptyBorderUIResource2 = new BorderUIResource.EmptyBorderUIResource(0, 0, 0, 0);
        AquaLineBorder aquaLineBorder = new AquaLineBorder("scrollPaneBorder");
        ColorUIResource colorUIResource5 = new ColorUIResource(140, 140, 140);
        UIDefaults.LazyValue lazyValue5 = uIDefaults -> BasicBorders.getInternalFrameBorder();
        BorderUIResource.EmptyBorderUIResource emptyBorderUIResource3 = new BorderUIResource.EmptyBorderUIResource(1, 1, 1, 1);
        ColorUIResource colorUIResource6 = colorUIResource = new ColorUIResource(237, 237, 237);
        UIDefaults.LazyValue lazyValue6 = uIDefaults -> AquaFonts.getControlTextFont();
        UIDefaults.LazyValue lazyValue7 = uIDefaults -> AquaFonts.getControlTextSmallFont();
        UIDefaults.LazyValue lazyValue8 = uIDefaults -> AquaFonts.getControlTextMiniFont();
        UIDefaults.LazyValue lazyValue9 = uIDefaults -> AquaFonts.getIconButtonFont();
        UIDefaults.LazyValue lazyValue10 = uIDefaults -> AquaFonts.getIconButtonSmallFont();
        UIDefaults.LazyValue lazyValue11 = uIDefaults -> AquaFonts.getAlertHeaderFont();
        UIDefaults.LazyValue lazyValue12 = uIDefaults -> AquaFonts.getMenuFont();
        UIDefaults.LazyValue lazyValue13 = uIDefaults -> AquaFonts.getViewFont();
        UIDefaults.LazyValue lazyValue14 = uIDefaults -> AquaFonts.getSideBarFont();
        UIDefaults.LazyValue lazyValue15 = uIDefaults -> AquaFonts.getSideBarSelectionFont();
        UIDefaults.LazyValue lazyValue16 = uIDefaults -> AquaFonts.getSideBarCategoryFont();
        UIDefaults.LazyValue lazyValue17 = uIDefaults -> AquaFonts.getSideBarCategorySelectionFont();
        UIDefaults.LazyValue lazyValue18 = uIDefaults -> AquaFonts.getPreviewLabelFont();
        UIDefaults.LazyValue lazyValue19 = uIDefaults -> AquaFonts.getPreviewValueFont();
        UIDefaults.LazyValue lazyValue20 = uIDefaults -> AquaFonts.getPreviewNameFont();
        UIDefaults.LazyValue lazyValue21 = uIDefaults -> AquaFonts.getPreviewTypeSizeFont();
        UIDefaults.LazyValue lazyValue22 = uIDefaults -> AquaFonts.getRecessedButtonFont();
        UIDefaults.LazyValue lazyValue23 = uIDefaults -> AquaFonts.getInlineButtonFont();
        AquaMenuItemBorder aquaMenuItemBorder = new AquaMenuItemBorder();
        BorderUIResource.EmptyBorderUIResource emptyBorderUIResource4 = new BorderUIResource.EmptyBorderUIResource(0, 0, 0, 0);
        UIDefaults.LazyInputMap lazyInputMap = new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"});
        UIDefaults.LazyInputMap lazyInputMap2 = new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancelSelection", "meta PERIOD", "cancelSelection", "F5", "refresh"});
        UIDefaults.LazyValue lazyValue24 = uIDefaults -> AquaImageFactory.getConfirmImageIcon();
        UIDefaults.LazyValue lazyValue25 = uIDefaults -> AquaImageFactory.getCautionImageIcon();
        UIDefaults.LazyValue lazyValue26 = uIDefaults -> AquaImageFactory.getStopImageIcon();
        UIDefaults.LazyValue lazyValue27 = uIDefaults -> AquaImageFactory.getLockImageIcon();
        AquaKeyBindings aquaKeyBindings = AquaKeyBindings.instance();
        Object[] objectArray = new Object[]{"control", colorUIResource, "Browser.expandedIcon", AquaLookAndFeel.makeIcon("fc/Unselected.png"), "Browser.expandingIcon", AquaLookAndFeel.makeIcon("fc/Unselected.png"), "Browser.focusedSelectedExpandedIcon", AquaLookAndFeel.makeIcon("fc/SelectedFocused.png"), "Browser.focusedSelectedExpandingIcon", AquaLookAndFeel.makeIcon("fc/SelectedFocused.png"), "Browser.selectedExpandedIcon", AquaLookAndFeel.makeIcon("fc/SelectedUnfocused.png"), "Browser.selectedExpandingIcon", AquaLookAndFeel.makeIcon("fc/SelectedUnfocused.png"), "Button.border", uIDefaults -> AquaButtonBorder.getPushButtonBorder(), "Button.font", lazyValue6, "Button.textIconGap", 4, "Button.textShiftOffset", n, "Button.focusInputMap", lazyInputMap, "Button.margin", new InsetsUIResource(0, 0, 0, 0), "Button.recessed.font", lazyValue22, "Button.inline.font", lazyValue23, "CheckBox.font", lazyValue6, "CheckBox.margin", new InsetsUIResource(1, 1, 0, 1), "CheckBox.focusInputMap", lazyInputMap, "CheckBoxMenuItem.font", lazyValue12, "CheckBoxMenuItem.acceleratorFont", lazyValue12, "CheckBoxMenuItem.acceleratorDelimiter", "", "CheckBoxMenuItem.border", aquaMenuItemBorder, "CheckBoxMenuItem.margin", insetsUIResource2, "CheckBoxMenuItem.borderPainted", true, "CheckBoxMenuItem.checkIcon", uIDefaults -> AquaImageFactory.getMenuItemCheckIcon(), "CheckBoxMenuItem.dashIcon", uIDefaults -> AquaImageFactory.getMenuItemDashIcon(), "ColorChooser.background", colorUIResource6, "ComboBox.font", lazyValue6, "ComboBox.ancestorInputMap", aquaKeyBindings.getComboBoxInputMap(), "ComboBox.padding", new InsetsUIResource(1, 4, 1, 4), "ComboBox.maximumRowCount", 5, "DesktopIcon.border", lazyValue5, "DesktopIcon.borderColor", colorUIResource2, "DesktopIcon.borderRimColor", colorUIResource3, "DesktopIcon.labelBackground", colorUIResource4, "EditorPane.focusInputMap", aquaKeyBindings.getMultiLineTextInputMap(), "EditorPane.font", lazyValue6, "EditorPane.caretBlinkRate", n2, "EditorPane.border", lazyValue3, "EditorPane.margin", insetsUIResource3, "FileChooser.ancestorInputMap", lazyInputMap2, "FileChooser.cellTipOrigin", new Point(18, 1), "FileChooser.previewNameFont", lazyValue20, "FileChooser.previewTypeSizeFont", lazyValue21, "FileChooser.previewLabelFont", lazyValue18, "FileChooser.previewValueFont", lazyValue19, "FileChooser.previewLabelInsets", new InsetsUIResource(1, 0, 0, 4), "FileChooser.previewLabelDelimiter", "", "FileChooser.autovalidate", true, "FileChooser.quickLookEnabled", true, "FileChooser.orderByType", false, "FileChooser.speed", false, "FileChooser.browserCellTextIconGap", 6, "FileChooser.browserCellTextArrowIconGap", 5, "FileChooser.cancelButtonMnemonic", n, "FileChooser.saveButtonMnemonic", n, "FileChooser.openButtonMnemonic", n, "FileChooser.updateButtonMnemonic", n, "FileChooser.helpButtonMnemonic", n, "FileChooser.directoryOpenButtonMnemonic", n, "FileChooser.lookInLabelMnemonic", n, "FileChooser.fileNameLabelMnemonic", n, "FileChooser.filesOfTypeLabelMnemonic", n, "FileChooser.sideBarRowHeight", 24, "FileView.aliasBadgeIcon", OSXFile.getAliasBadgeIcon(), "FileView.computerIcon", AquaImageFactory.getComputerIcon(), "FileView.directoryIcon", OSXFile.getDirectoryIcon(), "FileView.fileIcon", OSXFile.getFileIcon(), "FileView.networkIcon", OSXFile.getNetworkIcon(), "FormattedTextField.focusInputMap", aquaKeyBindings.getFormattedTextFieldInputMap(), "FormattedTextField.font", lazyValue6, "FormattedTextField.caretBlinkRate", n2, "FormattedTextField.border", lazyValue2, "FormattedTextField.margin", insetsUIResource, "IconButton.font", lazyValue9, "IconButton.smallFont", lazyValue10, "InternalFrame.titleFont", lazyValue6, "InternalFrame.background", colorUIResource, "InternalFrame.borderColor", colorUIResource, "InternalFrame.borderShadow", Color.red, "InternalFrame.borderDarkShadow", Color.green, "InternalFrame.borderHighlight", Color.blue, "InternalFrame.borderLight", Color.yellow, "InternalFrame.border", null, "InternalFrame.icon", null, "InternalFrame.paletteBorder", null, "InternalFrame.paletteTitleFont", lazyValue7, "InternalFrame.paletteBackground", colorUIResource, "InternalFrame.optionDialogBorder", null, "InternalFrame.optionDialogTitleFont", lazyValue12, "InternalFrame.optionDialogBackground", colorUIResource, "InternalFrame.closeSound", null, "InternalFrame.maximizeSound", null, "InternalFrame.minimizeSound", null, "InternalFrame.restoreDownSound", null, "InternalFrame.restoreUpSound", null, "InternalFrame.windowBindings", new Object[]{"shift ESCAPE", "showSystemMenu", "ctrl SPACE", "showSystemMenu", "ESCAPE", "hideSystemMenu"}, "Label.font", lazyValue6, "Label.border", null, "List.font", lazyValue13, "List.focusCellHighlightBorder", emptyBorderUIResource3, "List.focusSelectedCellHighlightBorder", emptyBorderUIResource3, "List.cellNoFocusBorder", emptyBorderUIResource3, "List.border", null, "List.cellRenderer", activeValue, "List.focusInputMap", aquaKeyBindings.getListInputMap(), "Menu.font", lazyValue12, "Menu.acceleratorFont", lazyValue12, "Menu.border", aquaMenuItemBorder, "Menu.borderPainted", false, "Menu.margin", insetsUIResource2, "Menu.arrowIcon", uIDefaults -> AquaImageFactory.getMenuArrowIcon(), "Menu.consumesTabs", true, "Menu.menuPopupOffsetY", 1, "Menu.submenuPopupOffsetY", -4, "Menu.opaque", false, "MenuBar.font", lazyValue12, "MenuBar.border", new AquaMenuBarBorder(), "MenuBar.margin", new InsetsUIResource(0, 8, 0, 8), "MenuItem.font", lazyValue12, "MenuItem.acceleratorFont", lazyValue12, "MenuItem.acceleratorDelimiter", "", "MenuItem.border", aquaMenuItemBorder, "MenuItem.margin", insetsUIResource2, "MenuItem.borderPainted", true, "OptionPane.font", lazyValue11, "OptionPane.messageFont", lazyValue6, "OptionPane.buttonFont", lazyValue6, "OptionPane.border", new BorderUIResource.EmptyBorderUIResource(12, 21, 17, 21), "OptionPane.messageAreaBorder", emptyBorderUIResource2, "OptionPane.buttonAreaBorder", new BorderUIResource.EmptyBorderUIResource(13, 0, 0, 0), "OptionPane.minimumSize", new DimensionUIResource(262, 90), "OptionPane.errorIcon", lazyValue26, "OptionPane.informationIcon", lazyValue24, "OptionPane.warningIcon", lazyValue25, "OptionPane.questionIcon", lazyValue24, "_SecurityDecisionIcon", lazyValue27, "OptionPane.windowBindings", new Object[]{"ESCAPE", "close"}, "OptionPane.errorSound", null, "OptionPane.informationSound", null, "OptionPane.questionSound", null, "OptionPane.warningSound", null, "OptionPane.buttonClickThreshhold", 500, "OptionPane.yesButtonMnemonic", "", "OptionPane.noButtonMnemonic", "", "OptionPane.okButtonMnemonic", "", "OptionPane.cancelButtonMnemonic", "", "Panel.font", lazyValue6, "Panel.background", colorUIResource6, "PasswordField.focusInputMap", aquaKeyBindings.getPasswordFieldInputMap(), "PasswordField.font", lazyValue6, "PasswordField.caretBlinkRate", n2, "PasswordField.border", lazyValue2, "PasswordField.margin", insetsUIResource, "PasswordField.echoChar", Character.valueOf('\u25cf'), "PopupMenu.font", lazyValue12, "PopupMenu.border", emptyBorderUIResource4, "ProgressBar.font", lazyValue6, "ProgressBar.border", new BorderUIResource(BorderFactory.createEmptyBorder()), "ProgressBar.repaintInterval", 30, "ProgressBar.circularRepaintInterval", 70, "RadioButton.font", lazyValue6, "RadioButton.margin", new InsetsUIResource(1, 1, 0, 1), "RadioButton.focusInputMap", lazyInputMap, "RadioButtonMenuItem.font", lazyValue12, "RadioButtonMenuItem.acceleratorFont", lazyValue12, "RadioButtonMenuItem.acceleratorDelimiter", "", "RadioButtonMenuItem.border", aquaMenuItemBorder, "RadioButtonMenuItem.margin", insetsUIResource2, "RadioButtonMenuItem.borderPainted", true, "RadioButtonMenuItem.checkIcon", uIDefaults -> AquaImageFactory.getMenuItemCheckIcon(), "RadioButtonMenuItem.dashIcon", uIDefaults -> AquaImageFactory.getMenuItemDashIcon(), "Separator.width", 1, "ScrollBar.border", null, "ScrollBar.focusInputMap", aquaKeyBindings.getScrollBarInputMap(), "ScrollBar.focusInputMap.RightToLeft", aquaKeyBindings.getScrollBarRightToLeftInputMap(), "ScrollBar.width", 16, "ScrollPane.font", lazyValue6, "ScrollPane.border", aquaLineBorder, "ScrollPane.viewportBorder", null, "ScrollPane.ancestorInputMap", aquaKeyBindings.getScrollPaneInputMap(), "ScrollPane.ancestorInputMap.RightToLeft", new UIDefaults.LazyInputMap(new Object[0]), "Viewport.font", lazyValue6, "Slider.font", lazyValue7, "Slider.border", null, "Slider.focusInsets", new InsetsUIResource(0, 0, 0, 0), "Slider.focusInputMap", aquaKeyBindings.getSliderInputMap(), "Slider.focusInputMap.RightToLeft", aquaKeyBindings.getSliderRightToLeftInputMap(), "Spinner.font", lazyValue6, "Spinner.border", null, "Spinner.arrowButtonSize", new Dimension(16, 5), "Spinner.ancestorInputMap", aquaKeyBindings.getSpinnerInputMap(), "Spinner.editorBorderPainted", true, "Spinner.editorAlignment", 11, "SplitPane.border", null, "SplitPane.continuousLayout", true, "SplitPane.dividerSize", 9, "SplitPaneDivider.border", null, "TabbedPane.font", lazyValue6, "TabbedPane.smallFont", lazyValue7, "TabbedPane.useSmallLayout", false, "TabbedPane.textIconGap", 4, "TabbedPane.tabInsets", new InsetsUIResource(0, 10, 3, 10), "TabbedPane.tabAreaInsets", new InsetsUIResource(3, 9, -1, 9), "TabbedPane.contentBorderInsets", new InsetsUIResource(8, 0, 0, 0), "TabbedPane.selectedTabPadInsets", new InsetsUIResource(0, 0, 0, 0), "TabbedPane.tabsOverlapBorder", true, "TabbedPane.selectedLabelShift", -1, "TabbedPane.labelShift", 1, "TabbedPane.selectionFollowsFocus", true, "Table.font", lazyValue13, "Table.focusCellHighlightBorder", emptyBorderUIResource3, "Table.focusSelectedCellHighlightBorder", emptyBorderUIResource3, "Table.cellFocusNoBorder", emptyBorderUIResource3, "Table.scrollPaneBorder", aquaLineBorder, "Table.scrollPaneCornerComponent", uIDefaults -> new AquaTableScrollPaneCorner(), "Table.ancestorInputMap", aquaKeyBindings.getTableInputMap(), "Table.ancestorInputMap.RightToLeft", aquaKeyBindings.getTableRightToLeftInputMap(), "TableHeader.font", lazyValue7, "TableHeader.cellBorder", aquaTableHeaderBorder, "TableHeader.borderHeight", 1, "TextArea.focusInputMap", aquaKeyBindings.getMultiLineTextInputMap(), "TextArea.font", lazyValue6, "TextArea.caretBlinkRate", n2, "TextArea.border", lazyValue3, "TextArea.margin", insetsUIResource, "TextField.focusInputMap", aquaKeyBindings.getTextFieldInputMap(), "TextField.font", lazyValue6, "TextField.caretBlinkRate", n2, "TextField.border", lazyValue2, "TextField.margin", insetsUIResource, "TextPane.focusInputMap", aquaKeyBindings.getMultiLineTextInputMap(), "TextPane.font", lazyValue6, "TextPane.caretBlinkRate", n2, "TextPane.border", lazyValue3, "TextPane.margin", insetsUIResource3, "TitledBorder.font", lazyValue7, "TitledBorder.border", lazyValue4, "TitledBorder.position", 1, "ToggleButton.border", uIDefaults -> AquaButtonBorder.getToggleButtonBorder(), "ToggleButton.font", lazyValue6, "ToggleButton.textIconGap", 4, "ToggleButton.textShiftOffset", n, "ToggleButton.focusInputMap", lazyInputMap, "ToggleButton.margin", new InsetsUIResource(0, 0, 0, 0), "ToolBar.font", lazyValue6, "ToolBar.dockingBackground", colorUIResource6, "ToolBar.dockingForeground", new ColorUIResource(Color.darkGray), "ToolBar.floatingBackground", colorUIResource6, "ToolBar.floatingForeground", new ColorUIResource(Color.darkGray), "ToolBar.borderHandleColor", colorUIResource5, "ToolBar.separatorSize", null, "ToolTip.font", lazyValue7, "ToolTip.border", emptyBorderUIResource, "Tree.font", lazyValue13, "Tree.editorBorder", emptyBorderUIResource2, "Tree.leftChildIndent", 8, "Tree.rightChildIndent", 12, "Tree.rowHeight", 19, "Tree.scrollsOnExpand", false, "Tree.openIcon", uIDefaults -> AquaImageFactory.getTreeOpenFolderIcon(), "Tree.closedIcon", uIDefaults -> AquaImageFactory.getTreeFolderIcon(), "Tree.leafIcon", OSXFile.getGenericFileSidebarIcon(), "Tree.changeSelectionWithFocus", true, "Tree.drawsFocusBorderAroundIcon", false, "Tree.sideBar.font", lazyValue14, "Tree.sideBar.selectionFont", lazyValue15, "Tree.sideBarCategory.font", lazyValue16, "Tree.sideBarCategory.selectionFont", lazyValue17, "Tree.focusInputMap", aquaKeyBindings.getTreeInputMap(), "Tree.focusInputMap.RightToLeft", aquaKeyBindings.getTreeRightToLeftInputMap(), "Tree.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancel"})};
        uIDefaults2.putDefaults(objectArray);
        int n3 = AquaUtils.getJavaVersion();
        if (n3 < 900000) {
            ColorUIResource colorUIResource7 = new ColorUIResource(Color.white);
            ColorUIResource colorUIResource8 = new ColorUIResource(Color.black);
            ColorUIResource colorUIResource9 = new ColorUIResource(Color.white);
            ColorUIResource colorUIResource10 = new ColorUIResource(54, 148, 253);
            ColorUIResource colorUIResource11 = colorUIResource7;
            ColorUIResource colorUIResource12 = new ColorUIResource(0.5f, 0.5f, 0.5f);
            EmptyBorder emptyBorder = new EmptyBorder(0, 0, 0, 0);
            Object[] objectArray2 = new Object[]{"MenuBar.font", lazyValue12, "MenuBar.background", colorUIResource7, "MenuBar.foreground", colorUIResource8, "MenuBar.border", new com.apple.laf.AquaMenuBarBorder(), "MenuBar.margin", new InsetsUIResource(0, 8, 0, 8), "MenuBar.selectionBackground", colorUIResource10, "MenuBar.selectionForeground", colorUIResource9, "MenuBar.disabledBackground", colorUIResource11, "MenuBar.disabledForeground", colorUIResource12, "MenuBar.backgroundPainter", emptyBorder, "MenuBar.selectedBackgroundPainter", emptyBorder};
            uIDefaults2.putDefaults(objectArray2);
        }
        JavaSupport.installAATextInfo(uIDefaults2);
    }

    @Override
    protected void initSystemColorDefaults(UIDefaults uIDefaults) {
    }

    @Override
    protected void initClassDefaults(UIDefaults uIDefaults) {
        String string = "javax.swing.plaf.basic.";
        int n = AquaUtils.getJavaVersion();
        Object[] objectArray = new Object[]{"ButtonUI", "org.violetlib.aqua.AquaButtonUI", "CheckBoxUI", "org.violetlib.aqua.AquaButtonCheckBoxUI", "CheckBoxMenuItemUI", "org.violetlib.aqua.AquaMenuItemUI", "LabelUI", "org.violetlib.aqua.AquaLabelUI", "ListUI", "org.violetlib.aqua.AquaListUI", "MenuUI", "org.violetlib.aqua.AquaMenuUI", "MenuItemUI", "org.violetlib.aqua.AquaMenuItemUI", "OptionPaneUI", "org.violetlib.aqua.AquaOptionPaneUI", "PanelUI", "org.violetlib.aqua.AquaPanelUI", "RadioButtonMenuItemUI", "org.violetlib.aqua.AquaMenuItemUI", "RadioButtonUI", "org.violetlib.aqua.AquaButtonRadioUI", "ProgressBarUI", "org.violetlib.aqua.AquaProgressBarUI", "RootPaneUI", "org.violetlib.aqua.AquaRootPaneUI", "SliderUI", "org.violetlib.aqua.AquaSliderUI", "ScrollBarUI", "org.violetlib.aqua.AquaScrollBarUI", "TabbedPaneUI", "org.violetlib.aqua.AquaTabbedPaneUI", "TableUI", "org.violetlib.aqua.AquaTableUI", "ToggleButtonUI", "org.violetlib.aqua.AquaButtonToggleUI", "ToolBarUI", "org.violetlib.aqua.AquaToolBarUI", "ToolTipUI", "org.violetlib.aqua.AquaToolTipUI", "TreeUI", "org.violetlib.aqua.AquaTreeUI", "InternalFrameUI", "org.violetlib.aqua.AquaInternalFrameUI", "DesktopIconUI", "org.violetlib.aqua.AquaInternalFrameDockIconUI", "DesktopPaneUI", "org.violetlib.aqua.AquaInternalFramePaneUI", "EditorPaneUI", "org.violetlib.aqua.AquaEditorPaneUI", "TextFieldUI", "org.violetlib.aqua.AquaTextFieldUI", "TextPaneUI", "org.violetlib.aqua.AquaTextPaneUI", "ComboBoxUI", "org.violetlib.aqua.AquaComboBoxUI", "ComboBoxPopupMenuUI", "org.violetlib.aqua.AquaComboBoxPopupMenuUI", "PopupMenuUI", "org.violetlib.aqua.AquaPopupMenuUI", "TextAreaUI", "org.violetlib.aqua.AquaTextAreaUI", "MenuBarUI", n >= 900000 ? "org.violetlib.aqua.AquaMenuBarUI" : "com.apple.laf.AquaMenuBarUI", "FileChooserUI", "org.violetlib.aqua.fc.AquaFileChooserUI", "PasswordFieldUI", "org.violetlib.aqua.AquaTextPasswordFieldUI", "TableHeaderUI", "org.violetlib.aqua.AquaTableHeaderUI", "FormattedTextFieldUI", "org.violetlib.aqua.AquaTextFieldFormattedUI", "SpinnerUI", "org.violetlib.aqua.AquaSpinnerUI", "SplitPaneUI", "org.violetlib.aqua.AquaSplitPaneUI", "ScrollPaneUI", "org.violetlib.aqua.AquaScrollPaneUI", "PopupMenuSeparatorUI", "org.violetlib.aqua.AquaPopupMenuSeparatorUI", "SeparatorUI", "org.violetlib.aqua.AquaSeparatorUI", "ToolBarSeparatorUI", "org.violetlib.aqua.AquaToolBarSeparatorUI", "ColorChooserUI", string + "BasicColorChooserUI", "ViewportUI", "org.violetlib.aqua.AquaViewportUI"};
        uIDefaults.putDefaults(objectArray);
    }

    public String getLongDescription() {
        return "VAqua release " + AquaLookAndFeel.getReleaseName() + " (build " + AquaLookAndFeel.getBuildID() + ")";
    }

    @Override
    public String toString() {
        return this.getLongDescription();
    }

    public static String getReleaseName() {
        return AquaLookAndFeel.getStringResource("RELEASE.txt");
    }

    public static String getBuildID() {
        return AquaLookAndFeel.getStringResource("BUILD.txt");
    }

    public static String getVersion() {
        return "VAqua look and feel release " + AquaLookAndFeel.getReleaseName() + ", build " + AquaLookAndFeel.getBuildID() + " using VAquaRendering release " + AquaNativeRendering.getReleaseName() + ", build " + AquaNativeRendering.getBuildID();
    }

    public static void showVersion() {
        System.err.println("VAqua look and feel: release " + AquaLookAndFeel.getReleaseName() + ", build " + AquaLookAndFeel.getBuildID());
        System.err.println("  using VAquaRendering: release " + AquaNativeRendering.getReleaseName() + ", build " + AquaNativeRendering.getBuildID());
    }

    private static String getStringResource(String string) {
        InputStream inputStream = AquaLookAndFeel.class.getResourceAsStream(string);
        if (inputStream != null) {
            try {
                int n;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                StringBuilder stringBuilder = new StringBuilder();
                while ((n = bufferedReader.read()) >= 0) {
                    stringBuilder.append((char)n);
                }
                return stringBuilder.toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return "Unknown";
    }

    protected class MyUIChangeListener
    implements PropertyChangeListener {
        protected MyUIChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object;
            String string = propertyChangeEvent.getPropertyName();
            if ("lookAndFeel".equals(string) && (object = propertyChangeEvent.getNewValue()) == AquaLookAndFeel.this) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (AquaLookAndFeel.this.focusRingManager != null) {
                            AquaLookAndFeel.this.focusRingManager.install();
                        }
                    }
                });
            }
        }
    }
}

