/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JNRPlatformUtils {
    @Nullable
    private static String platformVersionString;
    private static int platformVersion;

    public static synchronized int getPlatformVersion() {
        if (platformVersionString == null) {
            boolean bl;
            String string = System.getProperty("os.name");
            String string2 = System.getProperty("os.version");
            boolean bl2 = bl = string.equals("Mac OS X") || string.equals("macOS");
            if (bl) {
                platformVersionString = string2;
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
                if (stringTokenizer.hasMoreTokens()) {
                    n = JNRPlatformUtils.parseComponent(stringTokenizer.nextToken());
                    if (stringTokenizer.hasMoreTokens()) {
                        n2 = JNRPlatformUtils.parseComponent(stringTokenizer.nextToken());
                        if (stringTokenizer.hasMoreTokens()) {
                            n3 = JNRPlatformUtils.parseComponent(stringTokenizer.nextToken());
                        }
                    }
                }
                platformVersion = n * 10000 + n2 * 100 + n3;
                return platformVersion;
            }
        }
        return platformVersion;
    }

    private static int parseComponent(@NotNull String string) {
        try {
            int n = Integer.parseInt(string);
            if (n > 0) {
                return n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 0;
    }

    @Nullable
    public static Graphics2D toGraphics2D(@NotNull Graphics graphics) {
        try {
            return (Graphics2D)graphics;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    static {
        platformVersion = 0;
    }
}

