/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.fc.FileSystemTreeModel;
import org.violetlib.aqua.fc.OSXFile;
import org.violetlib.aqua.fc.SequentialDispatcher;
import org.violetlib.aqua.fc.SidebarTreeFileNode;
import org.violetlib.aqua.fc.Worker;

public class SidebarTreeModel
extends DefaultTreeModel
implements TreeModelListener {
    private TreePath volumesPath;
    private FileSystemTreeModel model;
    private DefaultMutableTreeNode devicesNode;
    private DefaultMutableTreeNode favoritesNode;
    private FileSystemTreeModel.Node computerNode;
    private JFileChooser fileChooser;
    private SequentialDispatcher dispatcher = new SequentialDispatcher();
    private static final File[] defaultUserItems = new File[]{new File(AquaUtils.getProperty("user.home"), "Desktop"), new File(AquaUtils.getProperty("user.home"), "Documents"), new File(AquaUtils.getProperty("user.home"))};

    public SidebarTreeModel(JFileChooser jFileChooser, TreePath treePath, FileSystemTreeModel fileSystemTreeModel) {
        super(new DefaultMutableTreeNode(), true);
        this.fileChooser = jFileChooser;
        this.volumesPath = treePath;
        this.model = fileSystemTreeModel;
        this.computerNode = fileSystemTreeModel.getRoot();
        this.devicesNode = new DefaultMutableTreeNode(UIManager.getString("FileChooser.devices"));
        this.devicesNode.setAllowsChildren(true);
        this.favoritesNode = new DefaultMutableTreeNode(UIManager.getString("FileChooser.favorites"));
        this.favoritesNode.setAllowsChildren(true);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getRoot();
        defaultMutableTreeNode.add(this.favoritesNode);
        defaultMutableTreeNode.add(this.devicesNode);
        this.updateUserNode();
        this.updateDevicesNode();
        fileSystemTreeModel.addTreeModelListener(this);
    }

    public void lazyValidate() {
    }

    public void invokeWhenValid(Runnable runnable) {
        runnable.run();
    }

    private void updateUserNode() {
        List<Node> list = this.getUserFavorites();
        this.replaceNodes(this.favoritesNode, list, false);
    }

    private void updateDevicesNode() {
        Map<String, OSXFile.SystemItemInfo> map = this.readVolumes();
        boolean[] blArray = new boolean[1];
        ArrayList<SidebarViewToModelNode> arrayList = new ArrayList<SidebarViewToModelNode>();
        FileSystemTreeModel.Node node = this.computerNode;
        OSXFile.SystemItemInfo systemItemInfo = map.get("Computer");
        if (systemItemInfo != null && systemItemInfo.isVisible) {
            arrayList.add(this.createOrFindDeviceNode(node, -2, systemItemInfo.icon, blArray));
        }
        for (OSXFile.SystemItemInfo systemItemInfo2 : map.values()) {
            File file;
            SidebarViewToModelNode sidebarViewToModelNode;
            String string;
            if (systemItemInfo2 == systemItemInfo || (string = systemItemInfo2.path) == null || arrayList.contains(sidebarViewToModelNode = this.createOrFindDeviceNode(file = new File(string), systemItemInfo2.sequenceNumber, systemItemInfo2.icon, blArray))) continue;
            arrayList.add(sidebarViewToModelNode);
        }
        Collections.sort(arrayList, new SideBarViewToModelNodeComparator());
        this.replaceNodes(this.devicesNode, arrayList, blArray[0]);
    }

    private SidebarViewToModelNode createOrFindDeviceNode(File file, int n, Icon icon, boolean[] blArray) {
        TreePath treePath = this.model.toPath(file, null);
        FileSystemTreeModel.Node node = (FileSystemTreeModel.Node)treePath.getLastPathComponent();
        return this.createOrFindDeviceNode(node, n, icon, blArray);
    }

    private SidebarViewToModelNode createOrFindDeviceNode(FileSystemTreeModel.Node node, int n, Icon icon, boolean[] blArray) {
        int n2 = this.devicesNode.getChildCount();
        for (int i = 0; i < n2; ++i) {
            SidebarViewToModelNode sidebarViewToModelNode;
            TreeNode treeNode = this.devicesNode.getChildAt(i);
            if (!(treeNode instanceof SidebarViewToModelNode) || (sidebarViewToModelNode = (SidebarViewToModelNode)treeNode).getTarget() != node) continue;
            if (!Objects.equals(sidebarViewToModelNode.icon, icon)) {
                blArray[0] = true;
            }
            sidebarViewToModelNode.sequenceNumber = n;
            sidebarViewToModelNode.icon = icon;
            return sidebarViewToModelNode;
        }
        return new SidebarViewToModelNode(node, n, icon);
    }

    /*
     * WARNING - void declaration
     */
    private void replaceNodes(DefaultMutableTreeNode defaultMutableTreeNode, List<? extends DefaultMutableTreeNode> list, boolean bl) {
        int n;
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        ArrayList<DefaultMutableTreeNode> arrayList2 = new ArrayList<DefaultMutableTreeNode>();
        ArrayList<DefaultMutableTreeNode> arrayList3 = new ArrayList<DefaultMutableTreeNode>();
        ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList6 = new ArrayList<Integer>();
        int n2 = defaultMutableTreeNode.getChildCount();
        for (n = 0; n < n2; ++n) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
            if (!list.contains(defaultMutableTreeNode2)) {
                arrayList.add(defaultMutableTreeNode2);
                arrayList4.add(n);
                continue;
            }
            arrayList3.add(defaultMutableTreeNode2);
            arrayList6.add(list.indexOf(defaultMutableTreeNode2));
        }
        n = list.size();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode objectArray2 = list.get(i);
            if (objectArray2 == null || arrayList3.contains(objectArray2)) continue;
            arrayList2.add(objectArray2);
            arrayList5.add(i);
        }
        if (!arrayList.isEmpty() || !arrayList2.isEmpty()) {
            defaultMutableTreeNode.removeAllChildren();
            for (DefaultMutableTreeNode i : list) {
                defaultMutableTreeNode.add(i);
            }
        }
        if (!arrayList.isEmpty()) {
            void objectArray3;
            int[] nArray = new int[arrayList.size()];
            boolean i = false;
            while (objectArray3 < nArray.length) {
                nArray[objectArray3] = (Integer)arrayList4.get((int)objectArray3);
                ++objectArray3;
            }
            Object[] objectArray = arrayList.toArray();
            this.fireTreeNodesRemoved(this, defaultMutableTreeNode.getPath(), nArray, objectArray);
        }
        if (!arrayList2.isEmpty()) {
            void var13_26;
            int[] nArray = new int[arrayList2.size()];
            boolean bl2 = false;
            while (var13_26 < nArray.length) {
                nArray[var13_26] = (Integer)arrayList5.get((int)var13_26);
                ++var13_26;
            }
            Object[] objectArray = arrayList2.toArray();
            this.fireTreeNodesInserted(this, defaultMutableTreeNode.getPath(), nArray, objectArray);
        }
        if (bl && !arrayList3.isEmpty()) {
            void var13_30;
            int[] nArray = new int[arrayList3.size()];
            boolean bl3 = false;
            while (var13_30 < nArray.length) {
                nArray[var13_30] = (Integer)arrayList6.get((int)var13_30);
                ++var13_30;
            }
            Object[] objectArray = arrayList3.toArray();
            this.fireTreeNodesChanged(this, defaultMutableTreeNode.getPath(), nArray, objectArray);
        }
    }

    private List<Node> getUserFavorites() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        List<OSXFile.SystemItemInfo> list = OSXFile.getSidebarFiles(0);
        if (list != null) {
            for (OSXFile.SystemItemInfo systemItemInfo : list) {
                Serializable serializable;
                boolean bl;
                String string = systemItemInfo.name;
                String string2 = systemItemInfo.path;
                boolean bl2 = bl = string2 != null && !string2.isEmpty();
                if (!bl && (string.equals("AirDrop") || string.endsWith("-AirDrop")) || string.equals("iCloud") || string.equals("All My Files")) continue;
                if (systemItemInfo.path != null) {
                    serializable = new File(string2);
                    FileNode fileNode = new FileNode((File)serializable);
                    Icon icon = systemItemInfo.icon;
                    if (icon != null) {
                        fileNode.icon = icon;
                    }
                    arrayList.add(fileNode);
                    continue;
                }
                serializable = new AliasNode(string);
                arrayList.add((Node)serializable);
            }
        }
        return arrayList;
    }

    private Map<String, OSXFile.SystemItemInfo> readVolumes() {
        HashMap<String, OSXFile.SystemItemInfo> hashMap = new HashMap<String, OSXFile.SystemItemInfo>();
        List<OSXFile.SystemItemInfo> list = OSXFile.getSidebarFiles(1);
        if (list != null) {
            for (OSXFile.SystemItemInfo systemItemInfo : list) {
                String string = systemItemInfo.name;
                if (systemItemInfo.id == 1) {
                    string = "Computer";
                }
                hashMap.put(string, systemItemInfo);
            }
        }
        return hashMap;
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        if (treeModelEvent.getTreePath().equals(this.volumesPath)) {
            this.updateDevicesNode();
        }
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        if (treeModelEvent.getTreePath().equals(this.volumesPath)) {
            this.updateDevicesNode();
        }
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        if (treeModelEvent.getTreePath().equals(this.volumesPath)) {
            this.updateDevicesNode();
        }
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        if (treeModelEvent.getTreePath().equals(this.volumesPath)) {
            this.updateDevicesNode();
        }
    }

    private class SideBarViewToModelNodeComparator
    implements Comparator<SidebarViewToModelNode> {
        private SideBarViewToModelNodeComparator() {
        }

        @Override
        public int compare(SidebarViewToModelNode sidebarViewToModelNode, SidebarViewToModelNode sidebarViewToModelNode2) {
            return sidebarViewToModelNode.getSequenceNumber() - sidebarViewToModelNode2.getSequenceNumber();
        }
    }

    private class SidebarViewToModelNode
    extends Node {
        private FileSystemTreeModel.Node target;
        private int sequenceNumber;
        private Icon icon;

        public SidebarViewToModelNode(FileSystemTreeModel.Node node, int n, Icon icon) {
            this.target = node;
            this.sequenceNumber = n;
            this.icon = icon;
        }

        @Override
        public File getResolvedFile() {
            return this.target.getResolvedFile();
        }

        @Override
        public String getUserName() {
            return this.target.getUserName();
        }

        @Override
        public Icon getIcon() {
            if (this.icon != null) {
                return this.icon;
            }
            return this.target.getIcon();
        }

        public FileSystemTreeModel.Node getTarget() {
            return this.target;
        }

        public int getSequenceNumber() {
            return this.sequenceNumber;
        }

        @Override
        public String toString() {
            return this.target.toString();
        }
    }

    private class AliasNode
    extends Node {
        private File file;
        private Icon icon;
        private String userName;
        private String aliasName;
        private boolean isTraversable;
        protected int fileLabel;

        public AliasNode(String string) {
            this.fileLabel = -1;
            this.file = null;
            this.aliasName = string;
            this.isTraversable = true;
        }

        @Override
        public File getResolvedFile() {
            if (this.file == null) {
                this.icon = null;
                this.file = OSXFile.resolveAlias(new File(this.aliasName), false);
            }
            return this.file;
        }

        @Override
        public Icon getIcon() {
            if (this.icon == null) {
                Icon icon = this.icon = this.isTraversable() ? UIManager.getIcon("FileView.directoryIcon") : UIManager.getIcon("FileView.fileIcon");
                if (this.file != null && !UIManager.getBoolean("FileChooser.speed")) {
                    SidebarTreeModel.this.dispatcher.dispatch(new Worker<Icon>(){

                        @Override
                        public Icon construct() {
                            return SidebarTreeModel.this.fileChooser.getIcon(AliasNode.this.file);
                        }

                        @Override
                        public void done(Icon icon) {
                            AliasNode.this.icon = icon;
                            int[] nArray = new int[]{AliasNode.this.getParent().getIndex(AliasNode.this)};
                            Object[] objectArray = new Object[]{AliasNode.this};
                            SidebarTreeModel.this.fireTreeNodesChanged(SidebarTreeModel.this, ((DefaultMutableTreeNode)AliasNode.this.getParent()).getPath(), nArray, objectArray);
                        }
                    });
                }
            }
            return this.icon;
        }

        @Override
        public String getUserName() {
            if (this.userName == null && this.file != null) {
                this.userName = SidebarTreeModel.this.fileChooser.getName(this.file);
            }
            return this.userName == null ? this.aliasName : this.userName;
        }

        public boolean isTraversable() {
            return this.isTraversable;
        }

        @Override
        public String toString() {
            return this.getUserName();
        }
    }

    private abstract class Node
    extends DefaultMutableTreeNode
    implements SidebarTreeFileNode {
        private Node() {
        }

        @Override
        public boolean getAllowsChildren() {
            return false;
        }
    }

    private class FileNode
    extends Node {
        private File file;
        private Icon icon;
        private String userName;
        private boolean isTraversable;
        protected int fileLabel = -1;

        public FileNode(File file) {
            this.file = file;
            this.isTraversable = file.isDirectory();
        }

        @Override
        public File getResolvedFile() {
            return this.file;
        }

        public File getFile() {
            return this.file;
        }

        @Override
        public Icon getIcon() {
            if (this.icon == null) {
                Icon icon = this.icon = this.isTraversable() ? UIManager.getIcon("FileView.directoryIcon") : UIManager.getIcon("FileView.fileIcon");
                if (!UIManager.getBoolean("FileChooser.speed")) {
                    SidebarTreeModel.this.dispatcher.dispatch(new Worker<Icon>(){

                        @Override
                        public Icon construct() {
                            return SidebarTreeModel.this.fileChooser.getIcon(FileNode.this.file);
                        }

                        @Override
                        public void done(Icon icon) {
                            FileNode.this.icon = icon;
                            int[] nArray = new int[]{FileNode.this.getParent().getIndex(FileNode.this)};
                            Object[] objectArray = new Object[]{FileNode.this};
                            SidebarTreeModel.this.fireTreeNodesChanged(SidebarTreeModel.this, SidebarTreeModel.this.favoritesNode.getPath(), nArray, objectArray);
                        }
                    });
                }
            }
            return this.icon;
        }

        @Override
        public String getUserName() {
            if (this.userName == null) {
                this.userName = SidebarTreeModel.this.fileChooser.getName(this.file);
            }
            return this.userName;
        }

        public boolean isTraversable() {
            return this.isTraversable;
        }

        @Override
        public String toString() {
            return this.getUserName();
        }
    }
}

