/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicPanelUI;
import org.violetlib.aqua.AquaBoxPainter;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.AquaVibrantSupport;
import org.violetlib.aqua.BackgroundPainter;

public class AquaPanelUI
extends BasicPanelUI {
    public static final String PANEL_STYLE_KEY = "JPanel.style";
    public static final String GROUP_BOX_STYLE = "groupBox";
    public static final String GROUP_BOX_TITLE_KEY = "Aqua.groupBoxTitle";
    static AquaUtils.RecyclableSingleton<AquaPanelUI> instance = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaPanelUI>(AquaPanelUI.class);
    public PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AquaPanelUI.this.propertyChange(propertyChangeEvent);
        }
    };

    public static ComponentUI createUI(JComponent jComponent) {
        return instance.get();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        AquaVibrantSupport.updateVibrantStyle(jComponent);
        jComponent.addPropertyChangeListener(this.propertyChangeListener);
        this.updateStyle(jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.propertyChangeListener);
        AquaVibrantSupport.uninstallVibrantStyle(jComponent);
        Border border = jComponent.getBorder();
        if (border instanceof UIResource) {
            jComponent.setBorder(null);
        }
        super.uninstallUI(jComponent);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        BackgroundPainter backgroundPainter = this.getBackgroundPainter(jComponent);
        if (backgroundPainter != null) {
            backgroundPainter.paintBackground(jComponent, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
    }

    @Override
    public final void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque() || AquaVibrantSupport.isVibrant(jComponent)) {
            AquaUtils.fillRect(graphics, jComponent, 3);
        }
        this.paint(graphics, jComponent);
    }

    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (AquaVibrantSupport.processVibrantStyleChange(propertyChangeEvent)) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        if (PANEL_STYLE_KEY.equals(string) || GROUP_BOX_TITLE_KEY.equals(string)) {
            JComponent jComponent = (JComponent)propertyChangeEvent.getSource();
            this.updateStyle(jComponent);
        }
    }

    protected void updateStyle(JComponent jComponent) {
        jComponent.repaint();
        Border border = jComponent.getBorder();
        if (border == null || border instanceof UIResource) {
            jComponent.setBorder(this.getDefaultBorder(jComponent));
        }
    }

    protected Border getDefaultBorder(JComponent jComponent) {
        String string = this.getStyle(jComponent);
        if (GROUP_BOX_STYLE.equals(string)) {
            String string2 = this.getGroupBoxTitle(jComponent);
            if (string2 != null) {
                return AquaBoxPainter.getBorderForTitledBox();
            }
            return AquaBoxPainter.getTitlelessBorder();
        }
        return null;
    }

    protected String getStyle(JComponent jComponent) {
        Object object = jComponent.getClientProperty(PANEL_STYLE_KEY);
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    protected String getGroupBoxTitle(JComponent jComponent) {
        Object object = jComponent.getClientProperty(GROUP_BOX_TITLE_KEY);
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    protected BackgroundPainter getBackgroundPainter(JComponent jComponent) {
        Object object = jComponent.getClientProperty(PANEL_STYLE_KEY);
        if (GROUP_BOX_STYLE.equals(object)) {
            return AquaBoxPainter.getInstance();
        }
        return null;
    }
}

