/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.BoundedRangeModel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class AquaMarginView
extends View {
    protected final View base;
    protected int margin;
    protected Rectangle tempRect;

    public AquaMarginView(View view, int n) {
        super(view.getElement());
        this.base = view;
        this.margin = n;
        this.tempRect = new Rectangle();
        view.setParent(this);
    }

    public void setMargin(int n) {
        this.margin = n;
    }

    @Override
    public float getMinimumSpan(int n) {
        return this.base.getMinimumSpan(n) + (float)(n == 0 ? this.margin * 2 : 0);
    }

    @Override
    public float getPreferredSpan(int n) {
        return this.base.getPreferredSpan(n) + (float)(n == 0 ? this.margin * 2 : 0);
    }

    @Override
    public float getMaximumSpan(int n) {
        return this.base.getMaximumSpan(n) + (float)(n == 0 ? this.margin * 2 : 0);
    }

    @Override
    public float getAlignment(int n) {
        return this.base.getAlignment(n);
    }

    @Override
    public void setSize(float f, float f2) {
        this.base.setSize(f - (float)(2 * this.margin), f2);
    }

    @Override
    public int getResizeWeight(int n) {
        return this.base.getResizeWeight(n);
    }

    @Override
    public int getStartOffset() {
        return this.base.getStartOffset();
    }

    @Override
    public int getEndOffset() {
        return this.base.getEndOffset();
    }

    @Override
    public void paint(Graphics graphics, Shape shape) {
        graphics = graphics.create();
        Rectangle rectangle = this.getClipRegion(shape);
        graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Rectangle rectangle2 = this.getBaseAllocation(shape);
        this.base.paint(graphics, rectangle2);
        graphics.dispose();
    }

    @Override
    public int getViewCount() {
        return this.base.getViewCount();
    }

    @Override
    public View getView(int n) {
        return this.base.getView(n);
    }

    @Override
    public void replace(int n, int n2, View[] viewArray) {
        this.base.replace(n, n2, viewArray);
    }

    @Override
    public int getViewIndex(float f, float f2, Shape shape) {
        return this.base.getViewIndex(f, f2, shape);
    }

    @Override
    public Shape getChildAllocation(int n, Shape shape) {
        Rectangle rectangle = this.getBaseAllocation(shape);
        return this.base.getChildAllocation(n, rectangle);
    }

    @Override
    public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        Rectangle rectangle = this.getBaseAllocation(shape);
        return this.base.getNextVisualPositionFrom(n, bias, rectangle, n2, biasArray);
    }

    @Override
    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        Rectangle rectangle = this.getBaseAllocation(shape);
        return this.base.modelToView(n, rectangle, bias);
    }

    @Override
    public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
        Rectangle rectangle = this.getBaseAllocation(shape);
        return this.base.modelToView(n, bias, n2, bias2, rectangle);
    }

    @Override
    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        Rectangle rectangle = this.getBaseAllocation(shape);
        return this.base.viewToModel(f, f2, rectangle, biasArray);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Rectangle rectangle = this.getBaseAllocation(shape);
        this.base.insertUpdate(documentEvent, rectangle, viewFactory);
        this.updateVisibilityModel();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Rectangle rectangle = this.getBaseAllocation(shape);
        this.base.removeUpdate(documentEvent, rectangle, viewFactory);
        this.updateVisibilityModel();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Rectangle rectangle = this.getBaseAllocation(shape);
        this.base.changedUpdate(documentEvent, rectangle, viewFactory);
    }

    protected Rectangle getBaseAllocation(Shape shape) {
        if (shape != null) {
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            this.tempRect.setBounds(rectangle);
            this.tempRect.x += this.margin;
            this.tempRect.width -= 2 * this.margin;
            return this.adjustAllocation(this.tempRect);
        }
        return null;
    }

    protected Rectangle getClipRegion(Shape shape) {
        return shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
    }

    protected Rectangle adjustAllocation(Rectangle rectangle) {
        Container container = this.getContainer();
        if (container instanceof JTextField) {
            int n;
            int n2;
            int n3;
            JTextField jTextField = (JTextField)container;
            BoundedRangeModel boundedRangeModel = jTextField.getHorizontalVisibility();
            int n4 = (int)this.getPreferredSpan(0) - 2 * this.margin;
            int n5 = Math.max(n4, rectangle.width);
            int n6 = boundedRangeModel.getValue();
            if (n6 + (n3 = Math.min(n5, rectangle.width - 1)) > n5) {
                n6 = n5 - n3;
            }
            if (n6 <= this.margin) {
                n6 = 0;
            }
            if ((n2 = n3 - (n = boundedRangeModel.getExtent())) < -1 || n2 > 1) {
                boundedRangeModel.setRangeProperties(n6, n3, boundedRangeModel.getMinimum(), n5, false);
            }
            if (n4 >= rectangle.width) {
                rectangle.width = n4;
                rectangle.x -= boundedRangeModel.getValue();
            }
        }
        return rectangle;
    }

    void updateVisibilityModel() {
        Container container = this.getContainer();
        if (container instanceof JTextField) {
            JTextField jTextField = (JTextField)container;
            BoundedRangeModel boundedRangeModel = jTextField.getHorizontalVisibility();
            int n = (int)this.getPreferredSpan(0) - 2 * this.margin;
            int n2 = boundedRangeModel.getExtent();
            int n3 = Math.max(n, n2);
            n2 = n2 == 0 ? n3 : n2;
            int n4 = n3 - n2;
            int n5 = boundedRangeModel.getValue();
            if (n5 + n2 > n3) {
                n5 = n3 - n2;
            }
            if ((n4 = Math.max(0, Math.min(n4, n5))) <= this.margin) {
                n4 = 0;
            }
            boundedRangeModel.setRangeProperties(n4, n2, 0, n3, false);
        }
    }
}

