/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.violetlib.aqua.AquaFocusRingPainter;

public class AquaFocusRingManager {
    private static AquaFocusRingManager INSTANCE = new AquaFocusRingManager();
    private Component currentOwner;
    private final String FOCUS_OWNER_PROPERTY = "permanentFocusOwner";
    private final PropertyChangeListener myFocusChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (!"permanentFocusOwner".equals(string)) {
                return;
            }
            Object object = propertyChangeEvent.getNewValue();
            if (object instanceof Component) {
                Component component = (Component)object;
                AquaFocusRingManager.this.update(component);
            } else {
                AquaFocusRingManager.this.update(null);
            }
        }
    };
    private boolean isInstalled;
    private final AquaFocusRingPainter painter = new AquaFocusRingPainter();

    public static AquaFocusRingManager getInstance() {
        return INSTANCE;
    }

    protected AquaFocusRingManager() {
    }

    public void install() {
        if (!this.isInstalled) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            keyboardFocusManager.addPropertyChangeListener("permanentFocusOwner", this.myFocusChangeListener);
            Component component = keyboardFocusManager.getPermanentFocusOwner();
            this.update(component);
            this.isInstalled = true;
        }
    }

    public void uninstall() {
        if (this.isInstalled) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            keyboardFocusManager.removePropertyChangeListener("permanentFocusOwner", this.myFocusChangeListener);
            if (this.currentOwner != null) {
                this.painter.setFocusOwner(null);
                this.currentOwner = null;
            }
            this.isInstalled = false;
        }
    }

    private void update(Component component) {
        if (component == this.currentOwner) {
            return;
        }
        this.currentOwner = component;
        Component component2 = this.currentOwner instanceof JComponent && this.isValid(this.currentOwner) ? this.currentOwner : null;
        this.painter.setFocusOwner((JComponent)component2);
    }

    private boolean isValid(Component component) {
        return component.isVisible();
    }

    private void updateFocusRing(JComponent jComponent) {
        if (jComponent == this.currentOwner && this.isValid(jComponent)) {
            this.painter.update();
        }
    }

    public static void focusRingOutlineChanged(JComponent jComponent) {
        AquaFocusRingManager aquaFocusRingManager = AquaFocusRingManager.getInstance();
        aquaFocusRingManager.updateFocusRing(jComponent);
    }
}

