/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.coreui;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.aqua.SplitPaneDividerConfiguration;
import org.violetlib.jnr.aqua.TableColumnHeaderConfiguration;
import org.violetlib.jnr.aqua.coreui.ColorWellRenderer;
import org.violetlib.jnr.aqua.coreui.CoreUIPainter;
import org.violetlib.jnr.aqua.impl.CircularSliderPainterExtension;
import org.violetlib.jnr.aqua.impl.LinearSliderPainterExtension;
import org.violetlib.jnr.aqua.impl.PopUpArrowPainter;
import org.violetlib.jnr.aqua.impl.PullDownArrowPainter;
import org.violetlib.jnr.aqua.impl.TableColumnHeaderCellPainterExtension;
import org.violetlib.jnr.aqua.impl.ThinSplitPaneDividerPainterExtension;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.ReusableCompositor;

public class AugmentedCoreUIPainter
extends CoreUIPainter {
    public AugmentedCoreUIPainter() {
    }

    public AugmentedCoreUIPainter(boolean bl) {
        super(bl);
    }

    @Override
    @NotNull
    public AugmentedCoreUIPainter copy() {
        return new AugmentedCoreUIPainter(this.useJRS);
    }

    @Override
    @NotNull
    protected Renderer getButtonRenderer(@NotNull ButtonConfiguration buttonConfiguration) {
        Renderer renderer = super.getButtonRenderer(buttonConfiguration);
        if (buttonConfiguration.getButtonWidget() == AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL) {
            return new ColorWellRenderer(buttonConfiguration, renderer);
        }
        return renderer;
    }

    @Override
    @NotNull
    protected Renderer getSegmentedButtonRenderer(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration) {
        Renderer renderer = super.getSegmentedButtonRenderer(segmentedButtonConfiguration);
        if (this.isCustomSegmentedButtonRendererNeeded(segmentedButtonConfiguration)) {
            return this.createCustomSegmentedButtonRenderer(segmentedButtonConfiguration, renderer);
        }
        return renderer;
    }

    protected boolean isCustomSegmentedButtonRendererNeeded(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration) {
        AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget = segmentedButtonConfiguration.getWidget();
        return segmentedButtonWidget != AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SMALL_SQUARE && (segmentedButtonConfiguration.getLeftDividerState() != SegmentedButtonConfiguration.DividerState.NONE || segmentedButtonConfiguration.getRightDividerState() != SegmentedButtonConfiguration.DividerState.NONE);
    }

    @NotNull
    protected Renderer createCustomSegmentedButtonRenderer(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration, @NotNull Renderer renderer) {
        return new MySegmentedButtonRenderer(segmentedButtonConfiguration, renderer);
    }

    @Override
    @NotNull
    protected Renderer getSplitPaneDividerRenderer(@NotNull SplitPaneDividerConfiguration splitPaneDividerConfiguration) {
        if (splitPaneDividerConfiguration.getWidget() == AquaUIPainter.DividerWidget.THIN_DIVIDER) {
            ThinSplitPaneDividerPainterExtension thinSplitPaneDividerPainterExtension = new ThinSplitPaneDividerPainterExtension(splitPaneDividerConfiguration);
            return Renderer.create(thinSplitPaneDividerPainterExtension);
        }
        return super.getSplitPaneDividerRenderer(splitPaneDividerConfiguration);
    }

    @Override
    @NotNull
    public Renderer getTableColumnHeaderRenderer(@NotNull TableColumnHeaderConfiguration tableColumnHeaderConfiguration) {
        TableColumnHeaderCellPainterExtension tableColumnHeaderCellPainterExtension = new TableColumnHeaderCellPainterExtension(tableColumnHeaderConfiguration);
        return Renderer.create(tableColumnHeaderCellPainterExtension);
    }

    @Override
    @NotNull
    protected Renderer getSliderRenderer(@NotNull SliderConfiguration sliderConfiguration) {
        Renderer renderer = super.getSliderRenderer(sliderConfiguration);
        if (sliderConfiguration.getWidget() == AquaUIPainter.SliderWidget.SLIDER_CIRCULAR) {
            Renderer renderer2 = Renderer.create(new CircularSliderPainterExtension(sliderConfiguration));
            return Renderer.createCompositeRenderer(renderer, renderer2);
        }
        return renderer;
    }

    @Override
    @Nullable
    protected Renderer getSliderTickMarkRenderer(@NotNull SliderConfiguration sliderConfiguration) {
        if (sliderConfiguration.getWidget() != AquaUIPainter.SliderWidget.SLIDER_CIRCULAR && sliderConfiguration.hasTickMarks()) {
            return Renderer.create(new LinearSliderPainterExtension(uiLayout, sliderConfiguration));
        }
        return null;
    }

    @Override
    @Nullable
    public Renderer getPopupArrowRenderer(@NotNull PopupButtonConfiguration popupButtonConfiguration) {
        Renderer renderer = super.getPopupArrowRenderer(popupButtonConfiguration);
        if (this.isArrowNeeded(popupButtonConfiguration)) {
            if (popupButtonConfiguration.isPopUp()) {
                return Renderer.create(new PopUpArrowPainter(popupButtonConfiguration));
            }
            return Renderer.create(new PullDownArrowPainter(popupButtonConfiguration));
        }
        return renderer;
    }

    private boolean isArrowNeeded(@NotNull PopupButtonConfiguration popupButtonConfiguration) {
        AquaUIPainter.PopupButtonWidget popupButtonWidget = popupButtonConfiguration.getPopupButtonWidget();
        return popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_RECESSED || popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_RECESSED;
    }

    protected class MySegmentedButtonRenderer
    extends Renderer {
        @NotNull
        private final SegmentedButtonConfiguration g;
        @NotNull
        private final Renderer r;

        public MySegmentedButtonRenderer(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration, Renderer renderer) {
            this.g = segmentedButtonConfiguration;
            this.r = renderer;
        }

        @Override
        public void composeTo(@NotNull ReusableCompositor reusableCompositor) {
            boolean bl;
            boolean bl2 = this.g.getLeftDividerState() != SegmentedButtonConfiguration.DividerState.NONE;
            boolean bl3 = bl = this.g.getRightDividerState() != SegmentedButtonConfiguration.DividerState.NONE && reusableCompositor.getScaleFactor() > 1;
            if (!bl2 && !bl) {
                this.r.composeTo(reusableCompositor);
            } else {
                int n = bl2 ? 1 : 0;
                int n2 = bl ? 1 : 0;
                int n3 = reusableCompositor.getRasterWidth();
                int n4 = reusableCompositor.getRasterHeight();
                Renderer renderer = Renderer.createRasterOffsetRenderer(this.r, n, 0, n3 - n - n2, n4);
                renderer.composeTo(reusableCompositor);
                SegmentedButtonConfiguration segmentedButtonConfiguration = new SegmentedButtonConfiguration(this.g.getWidget(), this.g.getSize(), this.g.getState(), this.g.isSelected(), this.g.isFocused(), this.g.getDirection(), AquaUIPainter.Position.MIDDLE, this.g.getRightDividerState(), this.g.getLeftDividerState());
                int n5 = 100;
                Renderer renderer2 = AugmentedCoreUIPainter.super.getSegmentedButtonRenderer(segmentedButtonConfiguration);
                ReusableCompositor reusableCompositor2 = new ReusableCompositor();
                reusableCompositor2.reset(n5, n4, reusableCompositor.getScaleFactor());
                renderer2.composeTo(reusableCompositor2);
                if (n > 0) {
                    reusableCompositor.composeFrom(reusableCompositor2, n5 - 1, 0, 0, 0, n, n4);
                }
                if (n2 > 0) {
                    reusableCompositor.composeFrom(reusableCompositor2, n3 - n2, 0, n2, n4);
                }
            }
        }
    }
}

