/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.violetlib.aqua.fc.AquaFileSystemView;
import org.violetlib.aqua.fc.OSXFile;

public abstract class BasicOSXFileSystemView
extends AquaFileSystemView {
    protected final File volumesFolder = new File("/Volumes");
    protected final File networkFolder = new File("/Network");
    protected final File unixRoot = new File("/");
    private final File computer = this.volumesFolder;
    protected File systemVolume;
    protected static final Set<String> hiddenTopLevelNames = new HashSet<String>();
    protected static final Set<String> hiddenDirectoryNames = new HashSet<String>();
    protected static final Set<File> hiddenFiles = new HashSet<File>();

    protected BasicOSXFileSystemView() {
    }

    @Override
    public final File getSystemVolume() {
        if (this.systemVolume == null) {
            this.systemVolume = this.determineSystemVolume();
        }
        return this.systemVolume;
    }

    protected File determineSystemVolume() {
        File[] fileArray = this.volumesFolder.listFiles();
        File file = null;
        if (fileArray != null) {
            for (File file2 : fileArray) {
                try {
                    if (!file2.getCanonicalFile().equals(this.unixRoot)) continue;
                    file = file2;
                    break;
                }
                catch (IOException iOException) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        return file == null ? this.unixRoot : file;
    }

    @Override
    public File getComputer() {
        return this.computer;
    }

    @Override
    public File canonicalize(File file) {
        if (file.equals(this.unixRoot)) {
            return this.getSystemVolume();
        }
        return file;
    }

    @Override
    public File getParentDirectory(File file) {
        File file2;
        File file3 = file2 = this.isRoot(file) ? null : super.getParentDirectory(file);
        if (file2 != null && file2.equals(this.unixRoot)) {
            file2 = this.getSystemVolume();
        }
        return file2;
    }

    protected List<File> getRootList() {
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = this.volumesFolder.listFiles();
        if (fileArray != null) {
            arrayList.addAll(Arrays.asList(fileArray));
        }
        arrayList.add(this.networkFolder);
        return arrayList;
    }

    @Override
    public final File[] getRoots() {
        List<File> list = this.getRootList();
        return list.toArray(new File[list.size()]);
    }

    @Override
    public boolean isHiddenFile(File file) {
        if (OSXFile.isInvisible(file)) {
            return true;
        }
        String string = file.getName();
        if (string.length() == 0) {
            return false;
        }
        if (string.charAt(string.length() - 1) == '\r') {
            return true;
        }
        if (string.charAt(0) == '.') {
            return true;
        }
        if (hiddenTopLevelNames.contains(string) && (file.getParent() == null || this.isRoot(file.getParentFile()))) {
            return true;
        }
        if (hiddenDirectoryNames.contains(string)) {
            return true;
        }
        return hiddenFiles.contains(file);
    }

    @Override
    public boolean isRoot(File file) {
        return file.equals(this.unixRoot) || file.equals(this.networkFolder) || file.getParentFile() != null && file.getParentFile().equals(this.volumesFolder);
    }

    @Override
    public boolean isParent(File file, File file2) {
        if (file == null || file2 == null) {
            return false;
        }
        return file.equals(file2.getParentFile());
    }

    @Override
    public File getChild(File file, String string) {
        return new File(file, string);
    }

    @Override
    public boolean isFileSystemRoot(File file) {
        File file2 = file.getParentFile();
        return file2 == null || file2.equals(this.volumesFolder);
    }

    @Override
    public File getHomeDirectory() {
        return this.createFileObject(System.getProperty("user.home"));
    }

    @Override
    public File getDefaultDirectory() {
        return this.getHomeDirectory();
    }

    @Override
    public Icon getSystemIcon(File file) {
        Icon icon;
        if (file.equals(this.networkFolder) && (icon = UIManager.getIcon("FileView.networkIcon")) != null) {
            return icon;
        }
        return super.getSystemIcon(file);
    }
}

