/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import org.violetlib.aqua.AquaCustomStyledWindow;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaRootPaneUI;
import org.violetlib.aqua.AquaVibrantSupport;
import org.violetlib.aqua.SwingUtilitiesModified;
import org.violetlib.jnr.Insets2D;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.aqua.AquaUIPainter;
import sun.java2d.opengl.OGLRenderQueue;
import sun.swing.SwingUtilities2;

public final class AquaUtils
extends SwingUtilitiesModified {
    private static final String ANIMATIONS_PROPERTY = "swing.enableAnimations";
    private static final int javaVersion = AquaUtils.obtainJavaVersion();
    private static final RecyclableSingleton<Boolean> enableAnimations = new RecyclableSingleton<Boolean>(){

        @Override
        protected Boolean getInstance() {
            String string = AccessController.doPrivileged(() -> System.getProperty(AquaUtils.ANIMATIONS_PROPERTY));
            return !"false".equals(string);
        }
    };
    private static final int MENU_BLINK_DELAY = 50;
    private static final RecyclableSingleton<Method> getJComponentGetFlagMethod = new RecyclableSingleton<Method>(){

        @Override
        protected Method getInstance() {
            return AccessController.doPrivileged(new PrivilegedAction<Method>(){

                @Override
                public Method run() {
                    try {
                        Method method = JComponent.class.getDeclaredMethod("getFlag", Integer.TYPE);
                        method.setAccessible(true);
                        return method;
                    }
                    catch (Throwable throwable) {
                        return null;
                    }
                }
            });
        }
    };
    private static final Integer OPAQUE_SET_FLAG = 24;
    public static final int ERASE_IF_TEXTURED = 1;
    public static final int ERASE_IF_VIBRANT = 2;
    public static final int ERASE_ALWLAYS = 4;
    static final Map<Object, Object> appContextMap = new HashMap<Object, Object>();
    private static final WeakHashMap<Graphics, Integer> scaleMap = new WeakHashMap();
    public static final int TITLE_BAR_NONE = 0;
    public static final int TITLE_BAR_ORDINARY = 1;
    public static final int TITLE_BAR_TRANSPARENT = 2;
    public static final int TITLE_BAR_HIDDEN = 3;
    public static final int TITLE_BAR_OVERLAY = 4;

    private AquaUtils() {
    }

    public static int getJavaVersion() {
        return javaVersion;
    }

    private static int obtainJavaVersion() {
        String string = System.getProperty("java.version");
        int n = 0;
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "._");
        try {
            while (stringTokenizer.hasMoreTokens()) {
                int n3;
                String string2 = stringTokenizer.nextToken();
                int n4 = Integer.parseInt(string2);
                int n5 = n3 = ++n2 < 4 ? 100 : 1000;
                if (n4 < 0 || n4 >= n3) {
                    return 0;
                }
                n = n * n3 + n4;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
        if (n2 != 4) {
            return 0;
        }
        return n;
    }

    public static <T> T getUI(JComponent jComponent, Class<T> clazz) {
        try {
            Class<?> clazz2 = jComponent.getClass();
            Method method = clazz2.getMethod("getUI", new Class[0]);
            Object object = method.invoke((Object)jComponent, new Object[0]);
            return clazz.cast(object);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Insets combineAsInsets(Insetter insetter, Insets insets) {
        if (insetter != null) {
            Insets insets2 = insetter.asInsets();
            return AquaUtils.combineInsets(insets2, insets);
        }
        return insets != null ? insets : new Insets(0, 0, 0, 0);
    }

    public static Insets2D combineAsInsets2D(Insetter insetter, Insets insets) {
        if (insetter != null) {
            Insets2D insets2D = insetter.asInsets2D();
            return AquaUtils.combineInsets(insets2D, insets);
        }
        return insets != null ? AquaUtils.asInsets2D(insets) : new Insets2D(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public static Insets combineInsets(Insets insets, Insets insets2) {
        if (insets != null) {
            if (insets2 != null) {
                return new Insets(insets.top + insets2.top, insets.left + insets2.left, insets.bottom + insets2.bottom, insets.right + insets2.right);
            }
            return insets;
        }
        if (insets2 != null) {
            return insets2;
        }
        return new Insets(0, 0, 0, 0);
    }

    public static Insets2D combineInsets(Insets2D insets2D, Insets insets) {
        if (insets2D != null) {
            if (insets != null) {
                return new Insets2D(insets2D.getTop() + (float)insets.top, insets2D.getLeft() + (float)insets.left, insets2D.getBottom() + (float)insets.bottom, insets2D.getRight() + (float)insets.right);
            }
            return insets2D;
        }
        if (insets != null) {
            return AquaUtils.asInsets2D(insets);
        }
        return new Insets2D(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public static Insets2D asInsets2D(Insets insets) {
        return new Insets2D(insets.top, insets.left, insets.bottom, insets.right);
    }

    public static Rectangle toRectangle(Rectangle2D rectangle2D) {
        if (rectangle2D instanceof Rectangle) {
            return (Rectangle)rectangle2D;
        }
        int n = (int)Math.floor(rectangle2D.getX());
        int n2 = (int)Math.floor(rectangle2D.getY());
        int n3 = (int)Math.ceil(rectangle2D.getWidth());
        int n4 = (int)Math.ceil(rectangle2D.getHeight());
        return new Rectangle(n, n2, n3, n4);
    }

    public static Rectangle toMinimumRectangle(Rectangle2D rectangle2D) {
        if (rectangle2D instanceof Rectangle) {
            return (Rectangle)rectangle2D;
        }
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getWidth();
        int n = (int)Math.ceil(d);
        int n2 = (int)Math.floor(d2 -= (double)n - d);
        double d3 = rectangle2D.getY();
        double d4 = rectangle2D.getHeight();
        int n3 = (int)Math.ceil(d3);
        int n4 = (int)Math.floor(d4 -= (double)n3 - d3);
        return new Rectangle(n, n3, n2, n4);
    }

    public static Point getScreenLocation(Component component) {
        Point point = new Point(0, 0);
        SwingUtilities.convertPointToScreen(point, component);
        return point;
    }

    public static Rectangle getScreenBounds(Point point, Component component) {
        GraphicsConfiguration graphicsConfiguration = AquaUtils.getCurrentGraphicsConfiguration(point, component);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Rectangle rectangle = graphicsConfiguration != null ? graphicsConfiguration.getBounds() : new Rectangle(toolkit.getScreenSize());
        Insets insets = toolkit.getScreenInsets(graphicsConfiguration);
        int n = insets.top / 2;
        int n2 = insets.bottom;
        int n3 = insets.left;
        int n4 = insets.right;
        return new Rectangle(rectangle.x + n3, rectangle.y + n, rectangle.width - n3 - n4, rectangle.height - n - n2);
    }

    private static GraphicsConfiguration getCurrentGraphicsConfiguration(Point point, Component component) {
        GraphicsDevice[] graphicsDeviceArray;
        GraphicsConfiguration graphicsConfiguration = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice graphicsDevice : graphicsDeviceArray = graphicsEnvironment.getScreenDevices()) {
            GraphicsConfiguration graphicsConfiguration2;
            if (graphicsDevice.getType() != 0 || !(graphicsConfiguration2 = graphicsDevice.getDefaultConfiguration()).getBounds().contains(point)) continue;
            graphicsConfiguration = graphicsConfiguration2;
            break;
        }
        if (graphicsConfiguration == null && component != null) {
            graphicsConfiguration = component.getGraphicsConfiguration();
        }
        return graphicsConfiguration;
    }

    public static JRootPane getRootPane(Window window) {
        if (window instanceof RootPaneContainer) {
            RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)window);
            return rootPaneContainer.getRootPane();
        }
        return null;
    }

    public static boolean isLeftToRight(Component component) {
        return component == null || component.getComponentOrientation().isLeftToRight();
    }

    public static AquaUIPainter.UILayoutDirection getLayoutDirection(Component component) {
        return component == null || component.getComponentOrientation().isLeftToRight() ? AquaUIPainter.UILayoutDirection.LEFT_TO_RIGHT : AquaUIPainter.UILayoutDirection.RIGHT_TO_LEFT;
    }

    static void enforceComponentOrientation(Component component, ComponentOrientation componentOrientation) {
        component.setComponentOrientation(componentOrientation);
        if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                AquaUtils.enforceComponentOrientation(component2, componentOrientation);
            }
        }
    }

    public static boolean isOnToolbar(JComponent jComponent) {
        for (Container container = jComponent.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JToolBar)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFullScreenWindow(Window window) {
        GraphicsConfiguration graphicsConfiguration = window.getGraphicsConfiguration();
        GraphicsDevice graphicsDevice = graphicsConfiguration.getDevice();
        Window window2 = graphicsDevice.getFullScreenWindow();
        if (window2 != null) {
            return window2 == window;
        }
        return AquaUtils.nativeIsFullScreenWindow(window);
    }

    public static void paintImmediately(JComponent jComponent) {
        try {
            Method method = JComponent.class.getDeclaredMethod("_paintImmediately", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            method.setAccessible(true);
            method.invoke((Object)jComponent, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        catch (Exception exception) {
            System.err.println("Unable to paint immediately: " + exception);
        }
    }

    private static boolean animationsEnabled() {
        return enableAnimations.get();
    }

    static void blinkMenu(Selectable selectable) {
        if (!AquaUtils.animationsEnabled()) {
            return;
        }
        try {
            selectable.paintSelected(false);
            Thread.sleep(50L);
            selectable.paintSelected(true);
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static boolean hasOpaqueBeenExplicitlySet(JComponent jComponent) {
        Method method = getJComponentGetFlagMethod.get();
        if (method == null) {
            return false;
        }
        try {
            return Boolean.TRUE.equals(method.invoke((Object)jComponent, OPAQUE_SET_FLAG));
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static void fillRect(Graphics graphics, Component component, int n) {
        AquaUtils.fillRect(graphics, component, n, 0, 0, component.getWidth(), component.getHeight());
    }

    public static void fillRect(Graphics graphics, Component component, int n, int n2, int n3, int n4, int n5) {
        Color color = AquaUtils.getFillColor(component, n);
        AquaUtils.fillRect(graphics, color, n2, n3, n4, n5);
    }

    private static Color getFillColor(Component component, int n) {
        if ((n & 4) != 0) {
            return null;
        }
        Color color = component.getBackground();
        if (color != null && !(color instanceof UIResource)) {
            return color;
        }
        return !AquaUtils.isMagicEraser(component, n) ? color : null;
    }

    private static boolean isMagicEraser(Component component, int n) {
        boolean bl;
        boolean bl2 = (n & 1) != 0;
        boolean bl3 = bl = (n & 2) != 0;
        while (component != null) {
            JComponent jComponent;
            if (component instanceof JRootPane) {
                jComponent = (JRootPane)component;
                Object object = jComponent.getClientProperty("apple.awt.brushMetalLook");
                if (object != null && bl2 && Boolean.parseBoolean(object.toString())) {
                    return true;
                }
                object = jComponent.getClientProperty("Window.style");
                if (object != null && object.equals("textured") && bl2) {
                    return true;
                }
            }
            if (component instanceof JComponent) {
                jComponent = (JComponent)component;
                if (bl && AquaVibrantSupport.isVibrant(jComponent)) {
                    return true;
                }
            }
            component = component.getParent();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillRect(Graphics graphics, Color color, int n, int n2, int n3, int n4) {
        Graphics graphics2 = graphics.create();
        try {
            if (color != null) {
                graphics2.setColor(color);
                graphics2.fillRect(n, n2, n3, n4);
            } else if (graphics2 instanceof Graphics2D) {
                ((Graphics2D)graphics2).setComposite(AlphaComposite.Src);
                graphics2.setColor(new Color(0, 0, 0, 0));
                graphics2.fillRect(n, n2, n3, n4);
            }
        }
        finally {
            graphics2.dispose();
        }
    }

    public static Graphics2D toGraphics2D(Graphics graphics) {
        try {
            return (Graphics2D)graphics;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public static boolean isProperty(String string, String ... stringArray) {
        if (string != null) {
            for (String string2 : stringArray) {
                if (!string2.equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getProperty(JComponent jComponent, String ... stringArray) {
        for (String string : stringArray) {
            Object object = jComponent.getClientProperty(string);
            if (object == null) continue;
            return AquaUtils.toString(object);
        }
        return null;
    }

    public static String toString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public static Boolean getBooleanProperty(JComponent jComponent, String ... stringArray) {
        for (String string : stringArray) {
            Object object = jComponent.getClientProperty(string);
            if (object == null) continue;
            return AquaUtils.toBoolean(object);
        }
        return null;
    }

    public static Boolean toBoolean(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return null;
    }

    public static Integer getIntegerProperty(JComponent jComponent, String ... stringArray) {
        for (String string : stringArray) {
            Object object = jComponent.getClientProperty(string);
            if (object instanceof String) {
                String string2 = (String)object;
                try {
                    return Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
            }
            if (!(object instanceof Integer)) continue;
            return (Integer)object;
        }
        return null;
    }

    public static String getProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public static String getProperty(String string, String string2) {
        try {
            return System.getProperty(string, string2);
        }
        catch (SecurityException securityException) {
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object get(Object object) {
        Map<Object, Object> map = appContextMap;
        synchronized (map) {
            return appContextMap.get(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object put(Object object, Object object2) {
        Map<Object, Object> map = appContextMap;
        synchronized (map) {
            return appContextMap.put(object, object2);
        }
    }

    public static <T> T getSoftReferenceValue(Object object, Supplier<T> supplier) {
        Object t;
        SoftReference softReference = (SoftReference)AquaUtils.get(object);
        if (softReference != null && (t = softReference.get()) != null) {
            return t;
        }
        t = supplier.get();
        softReference = new SoftReference(t);
        AquaUtils.put(object, softReference);
        return t;
    }

    public static void drawString(JComponent jComponent, Graphics graphics, String string, int n, int n2) {
        SwingUtilities2.drawString(jComponent, graphics, string, n, n2);
    }

    public static void drawStringUnderlineCharAt(JComponent jComponent, Graphics graphics, String string, int n, int n2, int n3) {
        SwingUtilities2.drawStringUnderlineCharAt(jComponent, graphics, string, n, n2, n3);
    }

    public static String clipStringIfNecessary(JComponent jComponent, FontMetrics fontMetrics, String string, int n) {
        return SwingUtilities2.clipStringIfNecessary(jComponent, fontMetrics, string, n);
    }

    public static int stringWidth(JComponent jComponent, FontMetrics fontMetrics, String string) {
        return SwingUtilities2.stringWidth(jComponent, fontMetrics, string);
    }

    public static void installAATextInfo(UIDefaults uIDefaults) {
        SwingUtilities2.AATextInfo aATextInfo = SwingUtilities2.AATextInfo.getAATextInfo((boolean)true);
        uIDefaults.put(SwingUtilities2.AA_TEXT_PROPERTY_KEY, aATextInfo);
    }

    public static Object beginGraphics(Graphics2D graphics2D) {
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return object;
    }

    public static void endGraphics(Graphics2D graphics2D, Object object) {
        if (object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        }
    }

    public static int getScaleFactor(Graphics graphics) {
        int n;
        Integer n2 = scaleMap.get(graphics);
        if (n2 != null) {
            return n2;
        }
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
            n = AquaUtils.getScaleFactor(graphicsConfiguration);
        } else {
            n = 1;
        }
        scaleMap.put(graphics, n);
        return n;
    }

    public static int getScaleFactor(GraphicsConfiguration graphicsConfiguration) {
        GraphicsDevice graphicsDevice = graphicsConfiguration.getDevice();
        Object object = null;
        try {
            Method method = graphicsDevice.getClass().getMethod("getScaleFactor", new Class[0]);
            if (method != null) {
                method.setAccessible(true);
                object = method.invoke((Object)graphicsDevice, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 1;
    }

    public static void drawHLine(Graphics graphics, int n, int n2, int n3) {
        if (n2 < n) {
            int n4 = n2;
            n2 = n;
            n = n4;
        }
        graphics.fillRect(n, n3, n2 - n + 1, 1);
    }

    public static FontMetrics getFontMetrics(JComponent jComponent, Graphics graphics, Font font) {
        if (jComponent != null) {
            return jComponent.getFontMetrics(font);
        }
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public static JScrollPane getScrollPaneAncestor(Component component) {
        Container container = component.getParent();
        if (container instanceof JViewport) {
            JViewport jViewport = (JViewport)container;
            if ((container = jViewport.getParent()) instanceof JScrollPane) {
                return AquaUtils.verifyScrollPaneAncestor(component, (JScrollPane)container);
            }
            if (container instanceof JComponent && !((JComponent)container).isOptimizedDrawingEnabled() && (container = container.getParent()) instanceof JScrollPane) {
                return AquaUtils.verifyScrollPaneAncestor(component, (JScrollPane)container);
            }
        }
        return null;
    }

    private static JScrollPane verifyScrollPaneAncestor(Component component, JScrollPane jScrollPane) {
        JViewport jViewport = jScrollPane.getViewport();
        return jViewport != null && jViewport.getView() == component ? jScrollPane : null;
    }

    public static void setTitleBarStyle(Window window, int n) {
        AquaUtils.ensureWindowPeer(window);
        int n2 = AquaUtils.nativeSetTitleBarStyle(window, n);
        if (n2 != 0) {
            throw new UnsupportedOperationException("Unable to set window title bar style");
        }
        if (n == 3) {
            AquaUtils.setWindowTitle(window, "");
        }
    }

    public static void setWindowTitle(Window window, String string) {
        if (window instanceof Frame) {
            ((Frame)window).setTitle(string);
        } else if (window instanceof Dialog) {
            ((Dialog)window).setTitle(string);
        }
    }

    public static void addNativeToolbarToWindow(Window window) throws UnsupportedOperationException {
        AquaUtils.ensureWindowPeer(window);
        int n = AquaUtils.nativeAddToolbarToWindow(window);
        if (n != 0) {
            throw new UnsupportedOperationException("Unable to add native toolbar to window");
        }
    }

    public static void ensureWindowPeer(Window window) {
        if (!window.isDisplayable()) {
            window.setSize(window.getPreferredSize());
            window.addNotify();
        }
    }

    public static void unsetTitledWindowStyle(Window window) throws UnsupportedOperationException {
        String string;
        Rectangle rectangle = window.getBounds();
        Insets insets = window.getInsets();
        int n = insets.top;
        if (n == 0) {
            throw new UnsupportedOperationException("Unable to unset titled window style: no top inset");
        }
        int n2 = rectangle.height - n;
        try {
            Method method = window.getClass().getMethod("getPeer", new Class[0]);
            method.setAccessible(true);
            Object object = method.invoke((Object)window, new Object[0]);
            if (object != null) {
                method = object.getClass().getDeclaredMethod("getPlatformWindow", new Class[0]);
                method.setAccessible(true);
                Object object2 = method.invoke(object, new Object[0]);
                if (object2 != null) {
                    method = object2.getClass().getDeclaredMethod("setStyleBits", Integer.TYPE, Boolean.TYPE);
                    method.setAccessible(true);
                    int n3 = 2;
                    method.invoke(object2, n3, false);
                    Field field = Component.class.getDeclaredField("height");
                    field.setAccessible(true);
                    field.setInt(window, n2);
                    method = object.getClass().getDeclaredMethod("updateInsets", Insets.class);
                    method.setAccessible(true);
                    method.invoke(object, new Insets(0, 0, 0, 0));
                    window.invalidate();
                    window.validate();
                    return;
                }
                string = "no platform window";
            } else {
                string = "no peer";
            }
        }
        catch (Exception exception) {
            string = exception.toString();
        }
        throw new UnsupportedOperationException(string);
    }

    public static void restoreTitledWindowStyle(Window window, int n) {
        Rectangle rectangle = window.getBounds();
        int n2 = rectangle.height + n;
        try {
            Method method = window.getClass().getMethod("getPeer", new Class[0]);
            method.setAccessible(true);
            Object object = method.invoke((Object)window, new Object[0]);
            if (object != null) {
                method = object.getClass().getDeclaredMethod("getPlatformWindow", new Class[0]);
                method.setAccessible(true);
                Object object2 = method.invoke(object, new Object[0]);
                if (object2 != null) {
                    method = object2.getClass().getDeclaredMethod("setStyleBits", Integer.TYPE, Boolean.TYPE);
                    method.setAccessible(true);
                    int n3 = 2;
                    method.invoke(object2, n3, true);
                    Field field = Component.class.getDeclaredField("height");
                    field.setAccessible(true);
                    field.setInt(window, n2);
                    method = object.getClass().getDeclaredMethod("updateInsets", Insets.class);
                    method.setAccessible(true);
                    method.invoke(object, new Insets(n, 0, 0, 0));
                    window.invalidate();
                    window.validate();
                } else {
                    System.err.println("Unable to restore titled window style: no platform window");
                }
            } else {
                System.err.println("Unable to restore titled window style: no peer");
            }
        }
        catch (Exception exception) {
            System.err.println("Unable to restore titled window style: " + exception);
        }
    }

    public static AquaCustomStyledWindow getCustomStyledWindow(Window window) {
        AquaRootPaneUI aquaRootPaneUI;
        JRootPane jRootPane = AquaUtils.getRootPane(window);
        if (jRootPane != null && (aquaRootPaneUI = AquaUtils.getUI(jRootPane, AquaRootPaneUI.class)) != null) {
            return aquaRootPaneUI.getCustomStyledWindow();
        }
        return null;
    }

    public static void setWindowBackgroundClear(Window window, boolean bl) {
        Color color = bl ? new Color(0, 0, 0, 0) : AquaImageFactory.getWindowBackgroundColorUIResource();
        AquaUtils.setWindowTextured(window, bl);
        AquaUtils.setWindowBackground(window, color);
        new ShadowMaker(window);
    }

    private static void setWindowTextured(Window window, boolean bl) {
        try {
            Method method = window.getClass().getMethod("getPeer", new Class[0]);
            method.setAccessible(true);
            Object object = method.invoke((Object)window, new Object[0]);
            if (object == null) {
                System.err.println("Unable to set window textured: no peer for " + window);
                return;
            }
            Method method2 = object.getClass().getDeclaredMethod("setTextured", Boolean.TYPE);
            method2.setAccessible(true);
            method2.invoke(object, bl);
        }
        catch (Exception exception) {
            System.err.println("Unable to set textured: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setWindowBackground(Window window, Color color) {
        if (color.equals(window.getBackground())) {
            return;
        }
        OGLRenderQueue oGLRenderQueue = OGLRenderQueue.getInstance();
        oGLRenderQueue.lock();
        try {
            window.setBackground(color);
        }
        catch (Throwable throwable) {
            Object object;
            block12: {
                Method method = window.getClass().getMethod("getPeer", new Class[0]);
                method.setAccessible(true);
                object = method.invoke((Object)window, new Object[0]);
                if (object != null) break block12;
                System.err.println("Unable to set window background: no peer for " + window);
                return;
            }
            try {
                Method method = object.getClass().getDeclaredMethod("setBackground", Color.class);
                method.setAccessible(true);
                method.invoke(object, color);
                Method method2 = object.getClass().getDeclaredMethod("setOpaque", Boolean.TYPE);
                method2.setAccessible(true);
                method2.invoke(object, color.getAlpha() == 255);
            }
            catch (Throwable throwable2) {
                Throwable throwable3;
                if (throwable2 instanceof InvocationTargetException) {
                    throwable3 = ((InvocationTargetException)throwable2).getTargetException();
                }
                System.err.println("Unable to set window background: " + throwable3);
            }
        }
        finally {
            oGLRenderQueue.unlock();
        }
    }

    public static void setCornerRadius(Window window, float f) {
        AquaUtils.nativeSetWindowCornerRadius(window, f);
    }

    public static void setAWTViewVisibility(Window window, boolean bl) {
        AquaUtils.nativeSetAWTViewVisibility(window, bl);
    }

    public static void syncAWTView(Window window) {
        Toolkit.getDefaultToolkit().sync();
        AquaUtils.nativeSyncAWTView(window);
    }

    private static native boolean nativeIsFullScreenWindow(Window var0);

    private static native int nativeSetTitleBarStyle(Window var0, int var1);

    private static native int nativeAddToolbarToWindow(Window var0);

    private static native int nativeSetWindowCornerRadius(Window var0, float var1);

    private static native void nativeSetAWTViewVisibility(Window var0, boolean var1);

    private static native void nativeSyncAWTView(Window var0);

    public static native void debugWindow(Window var0);

    public static native void syslog(String var0);

    public static class GrayUIResource
    extends ColorUIResource {
        public GrayUIResource(int n) {
            super(new Color(n, n, n));
        }
    }

    private static class ShadowMaker
    implements ActionListener,
    Runnable {
        private final Window w;

        public ShadowMaker(Window window) {
            this.w = window;
            SwingUtilities.invokeLater(this);
            Timer timer = new Timer(100, this);
            timer.setRepeats(false);
            timer.start();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.run();
        }

        @Override
        public void run() {
            if (this.w instanceof RootPaneContainer) {
                AquaUtils.syncAWTView(this.w);
                JRootPane jRootPane = ((RootPaneContainer)((Object)this.w)).getRootPane();
                jRootPane.putClientProperty("apple.awt.windowShadow.revalidateNow", Math.random());
            }
        }
    }

    static class SlicedShadowBorder
    extends ShadowBorder {
        private final AquaImageFactory.SlicedImageControl slices;

        SlicedShadowBorder(Painter painter, Painter painter2, int n, int n2, float f, float f2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
            super(painter, painter2, n, n2, f, f2, n3);
            BufferedImage bufferedImage = new BufferedImage(n4, n5, 3);
            super.paintBorder(null, bufferedImage.getGraphics(), 0, 0, n4, n5);
            this.slices = new AquaImageFactory.SlicedImageControl(bufferedImage, n6, n7, n8, n9, false);
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            this.slices.paint(graphics, n, n2, n3, n4);
        }
    }

    static class ShadowBorder
    implements Border {
        private final Painter prePainter;
        private final Painter postPainter;
        private final int offsetX;
        private final int offsetY;
        private final float distance;
        private final int blur;
        private final Insets insets;
        private final ConvolveOp blurOp;

        ShadowBorder(Painter painter, Painter painter2, int n, int n2, float f, float f2, int n3) {
            this.prePainter = painter;
            this.postPainter = painter2;
            this.offsetX = n;
            this.offsetY = n2;
            this.distance = f;
            this.blur = n3;
            int n4 = n3 / 2;
            this.insets = new Insets(n4 - n2, n4 - n, n4 + n2, n4 + n);
            float f3 = f2 / (float)(n3 * n3);
            float[] fArray = new float[n3 * n3];
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = f3;
            }
            this.blurOp = new ConvolveOp(new Kernel(n3, n3, fArray));
        }

        @Override
        public final boolean isBorderOpaque() {
            return false;
        }

        @Override
        public final Insets getBorderInsets(Component component) {
            return this.insets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            BufferedImage bufferedImage = new BufferedImage(n3 + this.blur * 2, n4 + this.blur * 2, 3);
            this.paintToImage(bufferedImage, n, n2, n3, n4);
            graphics.drawImage(bufferedImage, -this.blur, -this.blur, null);
        }

        private void paintToImage(BufferedImage bufferedImage, int n, int n2, int n3, int n4) {
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.setColor(Color.black);
            graphics2D.fillRect(0, 0, n3 + this.blur * 2, n4 + this.blur * 2);
            int n5 = (int)((float)(n + this.blur + this.offsetX) + (float)this.insets.left * this.distance);
            int n6 = (int)((float)(n2 + this.blur + this.offsetY) + (float)this.insets.top * this.distance);
            int n7 = (int)((float)n3 - (float)(this.insets.left + this.insets.right) * this.distance);
            int n8 = (int)((float)n4 - (float)(this.insets.top + this.insets.bottom) * this.distance);
            graphics2D.setComposite(AlphaComposite.DstAtop);
            if (this.prePainter != null) {
                this.prePainter.paint(graphics2D, n5, n6, n7, n8);
            }
            graphics2D.dispose();
            graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setComposite(AlphaComposite.DstAtop);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            graphics2D.drawImage(bufferedImage, this.blurOp, 0, 0);
            if (this.postPainter != null) {
                this.postPainter.paint(graphics2D, n5, n6, n7, n8);
            }
            graphics2D.dispose();
        }
    }

    static interface Painter {
        public void paint(Graphics var1, int var2, int var3, int var4, int var5);
    }

    static interface JComponentPainter {
        public void paint(JComponent var1, Graphics var2, int var3, int var4, int var5, int var6);
    }

    static interface Selectable {
        public void paintSelected(boolean var1);
    }

    static abstract class LazyKeyedSingleton<K, V> {
        private Map<K, V> refs;

        LazyKeyedSingleton() {
        }

        V get(K k) {
            V v;
            if (this.refs == null) {
                this.refs = new HashMap();
            }
            if ((v = this.refs.get(k)) != null) {
                return v;
            }
            V v2 = this.getInstance(k);
            this.refs.put(k, v2);
            return v2;
        }

        protected abstract V getInstance(K var1);
    }

    static class RecyclableSingletonFromDefaultConstructor<T>
    extends RecyclableSingleton<T> {
        private final Class<T> clazz;

        RecyclableSingletonFromDefaultConstructor(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        protected T getInstance() {
            try {
                return this.clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                return null;
            }
        }
    }

    public static abstract class RecyclableSingleton<T> {
        final T get() {
            return (T)AquaUtils.getSoftReferenceValue(this, () -> this.getInstance());
        }

        void reset() {
            AquaUtils.put(this, null);
        }

        protected abstract T getInstance();
    }

    static abstract class RecyclableObject<T> {
        private SoftReference<T> objectRef;

        RecyclableObject() {
        }

        T get() {
            T t;
            if (this.objectRef != null && (t = this.objectRef.get()) != null) {
                return t;
            }
            t = this.create();
            this.objectRef = new SoftReference<T>(t);
            return t;
        }

        protected abstract T create();
    }
}

