/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.GraphicsEnvironment;
import java.awt.Shape;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextPaneUI;
import javax.swing.text.Caret;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import org.violetlib.aqua.AquaCaret;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaHighlighter;
import org.violetlib.aqua.AquaKeyBindings;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.FocusRingOutlineProvider;

public class AquaTextPaneUI
extends BasicTextPaneUI
implements FocusRingOutlineProvider {
    AquaFocusHandler handler;
    boolean oldDragState = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaTextPaneUI();
    }

    @Override
    public Shape getFocusRingOutline(JComponent jComponent) {
        return null;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        JTextComponent jTextComponent = this.getComponent();
        this.handler = new AquaFocusHandler();
        jTextComponent.addFocusListener(this.handler);
        jTextComponent.addPropertyChangeListener(this.handler);
        AquaUtilControlSize.addSizePropertyListener(jTextComponent);
    }

    @Override
    protected void uninstallListeners() {
        JTextComponent jTextComponent = this.getComponent();
        AquaUtilControlSize.removeSizePropertyListener(jTextComponent);
        jTextComponent.removeFocusListener(this.handler);
        jTextComponent.removePropertyChangeListener(this.handler);
        this.handler = null;
        super.uninstallListeners();
    }

    @Override
    protected void installDefaults() {
        JTextComponent jTextComponent = this.getComponent();
        if (!GraphicsEnvironment.isHeadless()) {
            this.oldDragState = jTextComponent.getDragEnabled();
            jTextComponent.setDragEnabled(true);
        }
        super.installDefaults();
    }

    @Override
    protected void uninstallDefaults() {
        if (!GraphicsEnvironment.isHeadless()) {
            this.getComponent().setDragEnabled(this.oldDragState);
        }
        super.uninstallDefaults();
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        AquaKeyBindings aquaKeyBindings = AquaKeyBindings.instance();
        aquaKeyBindings.setDefaultAction(this.getKeymapName());
        JTextComponent jTextComponent = this.getComponent();
        aquaKeyBindings.installAquaUpDownActions(jTextComponent);
    }

    @Override
    protected Caret createCaret() {
        JTextComponent jTextComponent = this.getComponent();
        Window window = SwingUtilities.getWindowAncestor(jTextComponent);
        return new AquaCaret(window, jTextComponent);
    }

    @Override
    protected Highlighter createHighlighter() {
        return new AquaHighlighter();
    }
}

