/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.FieldView;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import org.violetlib.aqua.AquaCaret;
import org.violetlib.aqua.AquaCellEditorPolicy;
import org.violetlib.aqua.AquaFieldView;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaHighlighter;
import org.violetlib.aqua.AquaKeyBindings;
import org.violetlib.aqua.AquaMarginView;
import org.violetlib.aqua.AquaTextFieldBorder;
import org.violetlib.aqua.AquaTextFieldSearch;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.Border2D;
import org.violetlib.aqua.FocusRingOutlineProvider;
import org.violetlib.jnr.Insets2D;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.LayoutInfo;

public class AquaTextFieldUI
extends BasicTextFieldUI
implements FocusRingOutlineProvider {
    public static final String TEXT_FIELD_STYLE_KEY = "JTextField.style";
    public static final String TEXT_FIELD_VARIANT_KEY = "JTextField.variant";
    public static final String QUAQUA_TEXT_FIELD_STYLE_KEY = "Quaqua.TextField.style";
    protected AquaUtils.JComponentPainter delegate;
    protected AquaFocusHandler handler;
    protected PropertyChangeListener propertyChangeListener;
    protected HierarchyListener hierarchyListener;
    protected JTextComponent editor;
    protected View topView;
    boolean oldDragState = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaTextFieldUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        if (jComponent instanceof JTextComponent) {
            this.editor = (JTextComponent)jComponent;
            super.installUI(jComponent);
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.editor = null;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.handler = new AquaTextFieldFocusHandler();
        this.editor.addFocusListener(this.handler);
        this.editor.addPropertyChangeListener(this.handler);
        this.propertyChangeListener = new AquaPropertyChangeHandler();
        this.editor.addPropertyChangeListener(this.propertyChangeListener);
        this.hierarchyListener = new AquaHierarchyListener();
        this.editor.addHierarchyListener(this.hierarchyListener);
        LookAndFeel.installProperty(this.editor, "opaque", UIManager.getBoolean(this.getPropertyPrefix() + "opaque"));
        AquaUtilControlSize.addSizePropertyListener(this.editor);
    }

    @Override
    protected void uninstallListeners() {
        AquaUtilControlSize.removeSizePropertyListener(this.editor);
        this.editor.removeFocusListener(this.handler);
        this.editor.removePropertyChangeListener(this.handler);
        this.editor.removePropertyChangeListener(this.propertyChangeListener);
        this.editor.removeHierarchyListener(this.hierarchyListener);
        this.handler = null;
        super.uninstallListeners();
    }

    protected void updateFocusStyle(JTextComponent jTextComponent, boolean bl) {
    }

    protected void updateActiveStyle() {
        this.editor.repaint();
    }

    public void updateStyle() {
        if (this.wantsToBeASearchField()) {
            AquaTextFieldSearch.installSearchField(this.editor);
        } else {
            AquaTextFieldSearch.uninstallSearchField(this.editor);
        }
        if (this.topView instanceof AquaMarginView) {
            AquaMarginView aquaMarginView = (AquaMarginView)this.topView;
            int n = this.getTextMargin();
            aquaMarginView.setMargin(n);
        }
        this.editor.revalidate();
        this.editor.repaint();
    }

    protected boolean wantsToBeASearchField() {
        String string = this.getStyleProperty();
        return "search".equals(string);
    }

    protected boolean isStyleProperty(String string) {
        return AquaUtils.isProperty(string, TEXT_FIELD_STYLE_KEY, TEXT_FIELD_VARIANT_KEY, QUAQUA_TEXT_FIELD_STYLE_KEY);
    }

    protected String getStyleProperty() {
        return AquaUtils.getProperty(this.editor, TEXT_FIELD_STYLE_KEY, TEXT_FIELD_VARIANT_KEY, QUAQUA_TEXT_FIELD_STYLE_KEY);
    }

    @Override
    protected void installDefaults() {
        if (!GraphicsEnvironment.isHeadless()) {
            this.oldDragState = this.editor.getDragEnabled();
            this.editor.setDragEnabled(true);
        }
        super.installDefaults();
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        if (!GraphicsEnvironment.isHeadless()) {
            this.getComponent().setDragEnabled(this.oldDragState);
        }
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        AquaKeyBindings.instance().setDefaultAction(this.getKeymapName());
    }

    @Override
    public final View create(Element element) {
        this.topView = this.createView(element);
        return this.topView;
    }

    private View createView(Element element) {
        View view = this.createBasicView(element);
        int n = this.getTextMargin();
        if (n > 0 && view instanceof FieldView) {
            return new AquaMarginView(view, n);
        }
        return view;
    }

    protected View createBasicView(Element element) {
        View view = super.create(element);
        Class<?> clazz = view.getClass();
        if (clazz == FieldView.class) {
            return new AquaFieldView(element);
        }
        return view;
    }

    public int getTextMargin() {
        Border border = this.editor.getBorder();
        if (border instanceof AquaTextFieldBorder) {
            AquaTextFieldBorder aquaTextFieldBorder = (AquaTextFieldBorder)border;
            return aquaTextFieldBorder.getTextMargin(this.editor);
        }
        return 0;
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getLayoutSize(LayoutOption.MAXIMUM);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getLayoutSize(LayoutOption.PREFERRED);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getLayoutSize(LayoutOption.MINIMUM);
    }

    protected Dimension getLayoutSize(LayoutOption layoutOption) {
        Dimension dimension = this.getLayoutSizeFromText(layoutOption);
        Border border = this.editor.getBorder();
        if (border instanceof AquaTextFieldBorder) {
            AquaTextFieldBorder aquaTextFieldBorder = (AquaTextFieldBorder)border;
            LayoutInfo layoutInfo = aquaTextFieldBorder.getLayoutInfo(this.editor);
            int n = (int)Math.max((float)dimension.width, layoutInfo.getMinimumVisualWidth());
            int n2 = (int)Math.max((float)dimension.height, layoutInfo.getMinimumVisualHeight());
            return new Dimension(n, n2);
        }
        return dimension;
    }

    protected Dimension getLayoutSizeFromText(LayoutOption layoutOption) {
        Object object;
        Insetter insetter;
        Dimension dimension = this.getTextSize(layoutOption);
        int n = dimension.width;
        int n2 = dimension.height;
        Border border = this.editor.getBorder();
        if (border instanceof AquaTextFieldBorder && (insetter = ((AquaTextFieldBorder)(object = (AquaTextFieldBorder)border)).getTextInsets(this.editor)) != null) {
            int n3 = layoutOption != LayoutOption.MINIMUM ? ((AquaTextFieldBorder)object).getExtraHeight(this.editor) : 0;
            Dimension dimension2 = insetter.expand(new Dimension(n, n2 + n3));
            return dimension2;
        }
        object = this.editor.getInsets();
        return new Dimension(n + ((Insets)object).left + ((Insets)object).right, n2 + ((Insets)object).top + ((Insets)object).bottom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dimension getTextSize(LayoutOption layoutOption) {
        Dimension dimension = new Dimension();
        if (this.topView != null) {
            Document document = this.editor.getDocument();
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readLock();
            }
            if (layoutOption == LayoutOption.PREFERRED) {
                Dimension dimension2 = this.editor.getSize();
                if (dimension2.width == 0 && dimension2.height == 0) {
                    this.topView.setSize(2.1474836E9f, 2.1474836E9f);
                } else {
                    Insets insets = this.editor.getInsets();
                    if (dimension2.width > insets.left + insets.right && dimension2.height > insets.top + insets.bottom) {
                        this.topView.setSize(dimension2.width - insets.left - insets.right, dimension2.height - insets.top - insets.bottom);
                    }
                }
            }
            try {
                float f = 0.0f;
                float f2 = 0.0f;
                switch (layoutOption) {
                    case MINIMUM: {
                        f = this.topView.getMinimumSpan(0);
                        f2 = this.topView.getMinimumSpan(1);
                        break;
                    }
                    case PREFERRED: {
                        f = this.topView.getPreferredSpan(0);
                        f2 = this.topView.getPreferredSpan(1);
                        break;
                    }
                    case MAXIMUM: {
                        f = this.topView.getMaximumSpan(0);
                        f2 = this.topView.getMaximumSpan(1);
                    }
                }
                dimension.width = (int)Math.min(100000.0f, f + 1.0f);
                dimension.height = (int)Math.min(100000.0f, f2);
            }
            finally {
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).readUnlock();
                }
            }
        }
        return dimension;
    }

    @Override
    public Shape getFocusRingOutline(JComponent jComponent) {
        Border border = jComponent.getBorder();
        if (border instanceof FocusRingOutlineProvider) {
            FocusRingOutlineProvider focusRingOutlineProvider = (FocusRingOutlineProvider)((Object)border);
            return focusRingOutlineProvider.getFocusRingOutline(jComponent);
        }
        return new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight());
    }

    @Override
    protected void paintSafely(Graphics graphics) {
        float f;
        float f2;
        Border2D border2D;
        Insets2D insets2D;
        Border border;
        this.paintBackgroundSafely(graphics);
        if (graphics instanceof Graphics2D && (border = this.editor.getBorder()) instanceof Border2D && (insets2D = (border2D = (Border2D)((Object)border)).getBorderInsets2D(this.editor)) != null && (f2 = insets2D.getTop()) - (f = (float)Math.floor(f2)) > 0.001f) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.translate(0.0, f2 - f);
            super.paintSafely(graphics2D);
            graphics2D.dispose();
            return;
        }
        super.paintSafely(graphics);
    }

    protected void paintBackgroundSafely(Graphics graphics) {
        int n = this.editor.getWidth();
        int n2 = this.editor.getHeight();
        if (this.delegate != null) {
            this.delegate.paint(this.editor, graphics, 0, 0, n, n2);
            return;
        }
        boolean bl = this.editor.isOpaque();
        Border border = this.editor.getBorder();
        if (!(border instanceof AquaTextFieldBorder)) {
            if (!bl && AquaUtils.hasOpaqueBeenExplicitlySet(this.editor)) {
                return;
            }
            graphics.setColor(this.editor.getBackground());
            graphics.fillRect(0, 0, n, n2);
            return;
        }
        AquaTextFieldBorder aquaTextFieldBorder = (AquaTextFieldBorder)border;
        aquaTextFieldBorder.paintBackground(this.editor, graphics);
    }

    @Override
    protected void paintBackground(Graphics graphics) {
    }

    @Override
    protected Caret createCaret() {
        Window window = SwingUtilities.getWindowAncestor(this.editor);
        return new AquaCaret(window, this.editor);
    }

    @Override
    protected Highlighter createHighlighter() {
        return new AquaHighlighter();
    }

    protected void setPaintingDelegate(AquaUtils.JComponentPainter jComponentPainter) {
        this.delegate = jComponentPainter;
    }

    protected static enum LayoutOption {
        MINIMUM,
        PREFERRED,
        MAXIMUM;

    }

    protected class AquaHierarchyListener
    implements HierarchyListener {
        protected AquaHierarchyListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if ((hierarchyEvent.getChangeFlags() & 1L) != 0L) {
                AquaTextFieldUI.this.updateStyle();
            }
        }
    }

    protected class AquaPropertyChangeHandler
    implements PropertyChangeListener {
        protected AquaPropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (AquaTextFieldUI.this.isStyleProperty(string) || AquaCellEditorPolicy.isCellEditorProperty(string)) {
                AquaTextFieldUI.this.updateStyle();
            } else if ("Frame.active".equals(string)) {
                AquaTextFieldUI.this.updateActiveStyle();
            }
        }
    }

    protected class AquaTextFieldFocusHandler
    extends AquaFocusHandler {
        protected AquaTextFieldFocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            super.focusGained(focusEvent);
            AquaTextFieldUI.this.updateFocusStyle(AquaTextFieldUI.this.editor, true);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            Caret caret;
            super.focusLost(focusEvent);
            AquaTextFieldUI.this.updateFocusStyle(AquaTextFieldUI.this.editor, false);
            if (!focusEvent.isTemporary() && (caret = AquaTextFieldUI.this.editor.getCaret()) != null) {
                caret.setDot(0);
            }
        }
    }
}

