/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaToolBarUI;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.AquaVibrantSupport;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.aqua.WindowDraggingMouseListener;

public class AquaCustomStyledWindow {
    public static final int STYLE_NORMAL = 0;
    public static final int STYLE_TRANSPARENT = 1;
    public static final int STYLE_HIDDEN = 2;
    public static final int STYLE_UNIFIED = 3;
    public static final int STYLE_TEXTURED_HIDDEN = 4;
    public static final int STYLE_COMBINED = 5;
    protected final int TITLE_BAR_HEIGHT = 22;
    protected final int TITLE_BAR_BUTTONS_WIDTH = 78;
    protected Window w;
    protected JRootPane rp;
    protected final int style;
    protected final int titleBarStyle;
    protected final boolean isTopMarginPainted;
    protected final boolean isBottomMarginPainted;
    protected final boolean isTextured;
    protected JComponent contentPane;
    protected JToolBar windowToolBar;
    protected WindowPropertyChangeListener propertyChangeListener;
    protected WindowDraggingMouseListener windowDraggingMouseListener;
    protected WindowMarginDraggingMouseListener windowMarginDraggingMouseListener;
    protected HierarchyListener toolbarHierarchyListener;

    public AquaCustomStyledWindow(Window window, int n) throws IllegalArgumentException {
        if (window instanceof JFrame) {
            JFrame jFrame = (JFrame)window;
            if (jFrame.isUndecorated()) {
                throw new IllegalArgumentException("Window is not decorated");
            }
            this.w = window;
            this.rp = jFrame.getRootPane();
        } else if (window instanceof JDialog) {
            JDialog jDialog = (JDialog)window;
            if (jDialog.isUndecorated()) {
                throw new IllegalArgumentException("Window is not decorated");
            }
            this.w = window;
            this.rp = jDialog.getRootPane();
        } else {
            throw new IllegalArgumentException("Window is not decorated");
        }
        this.style = n;
        switch (n) {
            case 0: {
                this.titleBarStyle = 4;
                this.isTopMarginPainted = false;
                this.isBottomMarginPainted = false;
                this.isTextured = false;
                break;
            }
            case 1: {
                this.titleBarStyle = 2;
                this.isTopMarginPainted = this.getTopMarginHeight() > 0;
                this.isBottomMarginPainted = this.getBottomMarginHeight() > 0;
                this.isTextured = false;
                break;
            }
            case 2: {
                this.titleBarStyle = 3;
                this.isTopMarginPainted = this.getTopMarginHeight() > 0;
                this.isBottomMarginPainted = this.getBottomMarginHeight() > 0;
                this.isTextured = false;
                break;
            }
            case 3: {
                this.titleBarStyle = 2;
                this.isTopMarginPainted = true;
                this.isBottomMarginPainted = this.getBottomMarginHeight() > 0;
                this.isTextured = true;
                break;
            }
            case 4: {
                this.titleBarStyle = 3;
                this.isTopMarginPainted = true;
                this.isBottomMarginPainted = this.getBottomMarginHeight() > 0;
                this.isTextured = true;
                break;
            }
            case 5: {
                this.titleBarStyle = 2;
                this.isTopMarginPainted = true;
                this.isBottomMarginPainted = this.getBottomMarginHeight() > 0;
                this.isTextured = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid style");
            }
        }
        this.contentPane = this.getContentPane();
        if (this.contentPane == null) {
            throw new IllegalArgumentException("Window content pane is not a Swing component");
        }
        if (this.isTextured) {
            this.windowToolBar = this.getWindowToolbar();
            if (this.windowToolBar == null) {
                throw new RequiredToolBarNotFoundException();
            }
            this.setupToolbar(this.windowToolBar);
        }
        this.setupContentPane(this.contentPane);
        if (this.isTopMarginPainted || this.isBottomMarginPainted) {
            this.propertyChangeListener = new WindowPropertyChangeListener();
            this.rp.addPropertyChangeListener("Frame.active", this.propertyChangeListener);
        }
        if (n == 5) {
            AquaUtils.setWindowTitle(window, "");
        }
        AquaUtils.setTitleBarStyle(window, this.titleBarStyle);
    }

    public int getStyle() {
        return this.style;
    }

    public void refreshWindowStyleMask() {
        AquaUtils.setTitleBarStyle(this.w, this.titleBarStyle);
    }

    public void dispose() {
        if (this.w != null) {
            this.rp.removePropertyChangeListener("Frame.active", this.propertyChangeListener);
            this.propertyChangeListener = null;
            this.rp = null;
            AquaUtils.setTitleBarStyle(this.w, 1);
            if (this.windowToolBar != null) {
                this.resetBorder(this.windowToolBar);
                if (this.toolbarHierarchyListener != null) {
                    this.windowToolBar.removeHierarchyListener(this.toolbarHierarchyListener);
                    this.toolbarHierarchyListener = null;
                }
                this.windowToolBar = null;
            }
            if (this.windowDraggingMouseListener != null) {
                this.windowDraggingMouseListener.detach();
                this.windowDraggingMouseListener = null;
            }
            if (this.windowMarginDraggingMouseListener != null) {
                this.windowMarginDraggingMouseListener.detach();
                this.windowMarginDraggingMouseListener = null;
            }
            this.resetBorder(this.contentPane);
            this.w = null;
            this.contentPane = null;
        }
    }

    protected void setupContentPane(JComponent jComponent) {
        if (!(this.style != 0 && this.style != 1 || this.isTopMarginPainted)) {
            this.installBorder(jComponent, 22, 0, 0, 0);
        } else {
            this.installBorder(jComponent, 0, 0, 0, 0);
        }
        if (this.isTopMarginPainted || this.isBottomMarginPainted) {
            jComponent.setOpaque(false);
            this.attachWindowMarginDraggingMouseListener(jComponent);
        }
    }

    protected void setupToolbar(JToolBar jToolBar) {
        jToolBar.setOpaque(false);
        Container container = jToolBar;
        while ((container = container.getParent()) != this.contentPane && container != null) {
            if (!(container instanceof JComponent)) continue;
            ((JComponent)container).setOpaque(false);
        }
        this.installToolbarBorder(jToolBar);
        this.attachWindowDraggingMouseListener(jToolBar);
        this.attachHierarchyListener(jToolBar);
    }

    protected void installToolbarBorder(JToolBar jToolBar) {
        Border border = jToolBar.getBorder();
        if (border == null || border instanceof UIResource) {
            int n;
            boolean bl = AquaToolBarUI.isTallFormat(jToolBar);
            int n2 = 4;
            int n3 = 4;
            int n4 = n = bl ? 0 : 4;
            if (this.style == 3) {
                jToolBar.setBorder(new CustomToolbarBorder(n2, 22, n, true));
            } else if (this.style == 5) {
                jToolBar.setBorder(new CustomToolbarBorder(78, n3, n, true));
            } else if (this.style == 4) {
                jToolBar.setBorder(new CustomToolbarBorder(n2, n3, n, true));
            }
        }
    }

    protected void installBorder(JComponent jComponent, int n, int n2, int n3, int n4) {
        Border border = jComponent.getBorder();
        if (border == null || border instanceof UIResource) {
            jComponent.setBorder(new BorderUIResource.EmptyBorderUIResource(n, n2, n3, n4));
        }
    }

    protected void resetBorder(JComponent jComponent) {
        Border border = jComponent.getBorder();
        if (border == null || border instanceof UIResource) {
            if (jComponent instanceof JToolBar) {
                jComponent.setBorder(AquaToolBarUI.getToolBarBorder());
            } else {
                jComponent.setBorder(null);
            }
        }
    }

    protected void attachWindowDraggingMouseListener(JComponent jComponent) {
        if (jComponent != null && this.windowDraggingMouseListener == null) {
            int n = this.titleBarStyle == 2 ? 22 : 0;
            this.windowDraggingMouseListener = new WindowDraggingMouseListener(n);
            this.windowDraggingMouseListener.attach(jComponent);
        }
    }

    protected void attachWindowMarginDraggingMouseListener(JComponent jComponent) {
        if (jComponent != null && this.windowMarginDraggingMouseListener == null) {
            this.windowMarginDraggingMouseListener = new WindowMarginDraggingMouseListener();
            this.windowMarginDraggingMouseListener.attach(jComponent);
        }
    }

    protected void attachHierarchyListener(JToolBar jToolBar) {
        if (this.toolbarHierarchyListener == null) {
            this.toolbarHierarchyListener = new ToolbarHierarchyListener();
        }
        jToolBar.addHierarchyListener(this.toolbarHierarchyListener);
    }

    public void paintBackground(Graphics graphics) {
        if ((this.isTopMarginPainted || this.isBottomMarginPainted) && !AquaVibrantSupport.isVibrant(this.rp)) {
            if (this.isTopMarginPainted) {
                this.paintTopMarginBackground(graphics);
            }
            if (this.isBottomMarginPainted) {
                this.paintBottomMarginBackground(graphics);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintTopMarginBackground(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            int n = this.rp.getWidth();
            int n2 = this.getTopMarginHeight();
            int n3 = this.isTextured ? this.rp.getHeight() : n2;
            boolean bl = AquaFocusHandler.isActive(this.rp);
            if (bl) {
                Color color = new Color(230, 230, 230);
                Color color2 = new Color(208, 208, 208);
                GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, 0.0f, n2, color2);
                graphics2D.setPaint(gradientPaint);
            } else {
                graphics2D.setColor(new Color(246, 246, 246));
            }
            graphics2D.fillRect(0, 0, n, n3);
            if (n2 > 0) {
                int n4 = AquaUtils.getScaleFactor(graphics2D);
                this.paintUnifiedDivider(graphics2D, 0, n, bl, true, n4);
                this.paintUnifiedDivider(graphics2D, n2 - 1, n, bl, false, n4);
            }
        }
        finally {
            graphics2D.dispose();
        }
    }

    protected void paintUnifiedDivider(Graphics2D graphics2D, int n, int n2, boolean bl, boolean bl2, int n3) {
        Color color;
        String string = "Window.unified" + (bl2 ? "Top" : "Bottom") + "Divider" + (bl ? "" : "Inactive") + "Color";
        if (n3 > 1) {
            color = UIManager.getColor(string + "1");
            Color color2 = UIManager.getColor(string + "2");
            if (color != null && color2 != null) {
                graphics2D.setColor(color);
                graphics2D.fill(new Rectangle2D.Float(0.0f, n, n2, 0.5f));
                graphics2D.setColor(color2);
                graphics2D.fill(new Rectangle2D.Float(0.0f, (float)n + 0.5f, n2, 0.5f));
                return;
            }
        }
        if ((color = UIManager.getColor(string)) != null) {
            graphics2D.setColor(color);
            graphics2D.fillRect(0, n, n2, 1);
        }
    }

    protected int getTopMarginHeight() {
        switch (this.style) {
            case 3: 
            case 4: {
                return this.windowToolBar.getHeight();
            }
            case 5: {
                return Math.max(this.windowToolBar.getHeight(), 22);
            }
            case 1: 
            case 2: {
                if (this.rp == null) break;
                Integer n = AquaUtils.getIntegerProperty(this.rp, "Aqua.windowTopMargin");
                return n != null ? n : -1;
            }
        }
        return -1;
    }

    protected int getBottomMarginHeight() {
        switch (this.style) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (this.rp == null) break;
                Integer n = AquaUtils.getIntegerProperty(this.rp, "Aqua.windowBottomMargin");
                return n != null ? n : -1;
            }
        }
        return -1;
    }

    protected void paintBottomMarginBackground(Graphics graphics) {
        int n = this.getBottomMarginHeight();
        if (n > 0) {
            int n2 = this.rp.getHeight() - n;
            this.paintBottomMarginBackground(graphics, n2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintBottomMarginBackground(Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            boolean bl = AquaFocusHandler.isActive(this.rp);
            if (bl) {
                if (OSXSystemProperties.OSVersion < 1012) {
                    graphics2D.setColor(new Color(234, 234, 234));
                } else {
                    Color color = new Color(228, 228, 228);
                    Color color2 = new Color(217, 217, 217);
                    GradientPaint gradientPaint = new GradientPaint(0.0f, n, color, 0.0f, n + n2, color2);
                    graphics2D.setPaint(gradientPaint);
                }
            } else {
                graphics2D.setColor(new Color(246, 246, 246));
            }
            graphics2D.fillRect(0, n, this.rp.getWidth(), n2);
        }
        finally {
            graphics2D.dispose();
        }
    }

    protected JComponent getContentPane() {
        Container container = this.rp.getContentPane();
        return container instanceof JComponent ? (JComponent)container : null;
    }

    public JToolBar getWindowToolbar() {
        Container container = this.rp.getContentPane();
        return this.getWindowToolbar(container);
    }

    protected JToolBar getWindowToolbar(Container container) {
        JToolBar jToolBar;
        Component component;
        int n;
        int n2 = container.getComponentCount();
        for (n = 0; n < n2; ++n) {
            component = container.getComponent(n);
            if (!(component instanceof JToolBar) || (jToolBar = (JToolBar)component).isFloatable()) continue;
            return jToolBar;
        }
        for (n = 0; n < n2; ++n) {
            component = container.getComponent(n);
            if (!(component instanceof Container) || (jToolBar = this.getWindowToolbar((Container)component)) == null) continue;
            return jToolBar;
        }
        return null;
    }

    public static class CustomToolbarBorder
    extends AbstractBorder
    implements UIResource {
        protected int extraTop;
        protected int extraLeft;
        protected int extraBottom;
        protected boolean includeBottomLine;
        protected boolean isExtraTopSuppressed;

        public CustomToolbarBorder(int n, int n2, int n3, boolean bl) {
            this.extraLeft = n;
            this.extraTop = n2;
            this.extraBottom = n3;
            this.includeBottomLine = bl;
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            JToolBar jToolBar = (JToolBar)component;
            Insets insets2 = jToolBar.getMargin();
            insets.left = insets2.left + this.extraLeft;
            insets.top = insets2.top + (this.isExtraTopSuppressed ? 0 : this.extraTop);
            insets.right = insets2.right;
            insets.bottom = insets2.bottom + this.extraBottom + (this.includeBottomLine ? 1 : 0);
            return insets;
        }

        public void setExtraTopSuppressed(boolean bl) {
            this.isExtraTopSuppressed = bl;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        }
    }

    protected class ToolbarHierarchyListener
    implements HierarchyListener {
        protected ToolbarHierarchyListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            JToolBar jToolBar;
            if (hierarchyEvent.getChangeFlags() == 1L && SwingUtilities.getWindowAncestor(jToolBar = (JToolBar)hierarchyEvent.getComponent()) != AquaCustomStyledWindow.this.w) {
                AquaCustomStyledWindow.this.resetBorder(jToolBar);
                if (jToolBar == AquaCustomStyledWindow.this.windowToolBar) {
                    AquaCustomStyledWindow.this.windowToolBar = null;
                }
                jToolBar.removeHierarchyListener(AquaCustomStyledWindow.this.toolbarHierarchyListener);
                if (AquaCustomStyledWindow.this.windowDraggingMouseListener != null) {
                    AquaCustomStyledWindow.this.windowDraggingMouseListener.detach();
                    AquaCustomStyledWindow.this.windowDraggingMouseListener = null;
                }
            }
        }
    }

    protected class WindowMarginDraggingMouseListener
    extends WindowDraggingMouseListener {
        public WindowMarginDraggingMouseListener() {
            super(0);
        }

        @Override
        protected boolean isDragArea(Component component, Point point) {
            int n = point.y;
            int n2 = AquaCustomStyledWindow.this.getTopMarginHeight();
            if (n2 > 0 && n < n2) {
                return true;
            }
            int n3 = AquaCustomStyledWindow.this.getBottomMarginHeight();
            return n3 > 0 && n >= component.getHeight() - n3;
        }
    }

    protected class WindowPropertyChangeListener
    implements PropertyChangeListener {
        protected WindowPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AquaCustomStyledWindow.this.rp.repaint();
        }
    }

    public static class RequiredToolBarNotFoundException
    extends IllegalArgumentException {
        public RequiredToolBarNotFoundException() {
            super("Window content pane must contain a non-floatable JToolBar");
        }
    }
}

