/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JEditorPane;
import javax.swing.JTextArea;
import javax.swing.plaf.UIResource;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import org.violetlib.aqua.AquaHighlighter;

public class AquaCaret
extends DefaultCaret
implements UIResource,
PropertyChangeListener {
    final boolean isMultiLineEditor;
    final JTextComponent c;
    boolean mFocused = false;
    private boolean shouldSelectAllOnFocus = true;

    public AquaCaret(Window window, JTextComponent jTextComponent) {
        this.c = jTextComponent;
        this.isMultiLineEditor = this.c instanceof JTextArea || this.c instanceof JEditorPane;
        jTextComponent.addPropertyChangeListener(this);
    }

    @Override
    protected Highlighter.HighlightPainter getSelectionPainter() {
        return AquaHighlighter.getInstance();
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            bl = this.getDot() == this.getMark();
        }
        super.setVisible(bl);
    }

    @Override
    protected void fireStateChanged() {
        if (this.mFocused) {
            this.setVisible(this.getComponent().isEditable());
        }
        super.fireStateChanged();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("Frame.active".equals(string)) {
            JTextComponent jTextComponent = (JTextComponent)propertyChangeEvent.getSource();
            if (propertyChangeEvent.getNewValue() == Boolean.TRUE) {
                this.setVisible(jTextComponent.hasFocus());
            } else {
                this.setVisible(false);
            }
            if (this.getDot() != this.getMark()) {
                jTextComponent.getUI().damageRange(jTextComponent, this.getDot(), this.getMark());
            }
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        int n;
        JTextComponent jTextComponent = this.getComponent();
        if (!jTextComponent.isEnabled() || !jTextComponent.isEditable()) {
            super.focusGained(focusEvent);
            return;
        }
        this.mFocused = true;
        if (!this.shouldSelectAllOnFocus) {
            this.shouldSelectAllOnFocus = true;
            super.focusGained(focusEvent);
            return;
        }
        if (this.isMultiLineEditor) {
            super.focusGained(focusEvent);
            return;
        }
        int n2 = jTextComponent.getDocument().getLength();
        int n3 = this.getDot();
        if (n3 == (n = this.getMark())) {
            if (n3 == 0) {
                jTextComponent.setCaretPosition(n2);
                jTextComponent.moveCaretPosition(0);
            } else if (n3 == n2) {
                jTextComponent.setCaretPosition(0);
                jTextComponent.moveCaretPosition(n2);
            }
        }
        super.focusGained(focusEvent);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.mFocused = false;
        this.shouldSelectAllOnFocus = true;
        if (this.isMultiLineEditor) {
            this.setVisible(false);
            this.c.repaint();
        } else {
            super.focusLost(focusEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger()) {
            super.mousePressed(mouseEvent);
            this.shouldSelectAllOnFocus = false;
        }
    }
}

