/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.coreui;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.aqua.ComboBoxConfiguration;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.aqua.ScrollBarConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.SplitPaneDividerConfiguration;
import org.violetlib.jnr.aqua.impl.NativeSupport;
import org.violetlib.jnr.aqua.impl.ViewRendererDescriptions;
import org.violetlib.jnr.impl.BasicRendererDescription;
import org.violetlib.jnr.impl.JNRPlatformUtils;
import org.violetlib.jnr.impl.JNRUtils;
import org.violetlib.jnr.impl.MultiResolutionRendererDescription;
import org.violetlib.jnr.impl.RendererDescription;

public class CoreUIRendererDescriptions
extends ViewRendererDescriptions {
    @Override
    @NotNull
    public RendererDescription getSplitPaneDividerRendererDescription(@NotNull SplitPaneDividerConfiguration splitPaneDividerConfiguration) {
        AquaUIPainter.DividerWidget dividerWidget = splitPaneDividerConfiguration.getWidget();
        AquaUIPainter.Orientation orientation = splitPaneDividerConfiguration.getOrientation();
        switch (splitPaneDividerConfiguration.getWidget()) {
            case THIN_DIVIDER: 
            case THICK_DIVIDER: {
                return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
            }
            case PANE_SPLITTER: {
                return orientation == AquaUIPainter.Orientation.HORIZONTAL ? new BasicRendererDescription(0.0f, -1.0f, 0.0f, 2.0f) : new BasicRendererDescription(-1.0f, 0.0f, 2.0f, 0.0f);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public RendererDescription getButtonRendererDescription(@NotNull ButtonConfiguration buttonConfiguration) {
        AquaUIPainter.ButtonWidget buttonWidget = this.toCanonicalButtonStyle(buttonConfiguration.getButtonWidget());
        AquaUIPainter.Size size = buttonConfiguration.getSize();
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_ROUND) {
            switch (size) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 2.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 4.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 2.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED || buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR) {
            int n = JNRPlatformUtils.getPlatformVersion();
            if (n >= 101100) {
                BasicRendererDescription basicRendererDescription = new BasicRendererDescription(0.0f, -1.0f, 0.0f, 2.0f);
                BasicRendererDescription basicRendererDescription2 = new BasicRendererDescription(-0.5f, -1.0f, 1.0f, 2.0f);
                return new MultiResolutionRendererDescription(basicRendererDescription, basicRendererDescription2);
            }
            return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
        }
        return super.getButtonRendererDescription(buttonConfiguration);
    }

    @Override
    @NotNull
    public RendererDescription getSegmentedButtonRendererDescription(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration) {
        int n = JNRPlatformUtils.getPlatformVersion();
        AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget = segmentedButtonConfiguration.getWidget();
        AquaUIPainter.Size size = segmentedButtonConfiguration.getSize();
        RendererDescription rendererDescription = super.getSegmentedButtonRendererDescription(segmentedButtonConfiguration);
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        switch (segmentedButtonWidget) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: 
            case BUTTON_SEGMENTED_SEPARATED: {
                f3 = JNRUtils.size2D(size, -0.51f, -1.0f, -2.0f);
                f4 = JNRUtils.size(size, -2, -2, -1);
                if (segmentedButtonWidget == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SEPARATED && segmentedButtonConfiguration.getPosition() != AquaUIPainter.Position.ONLY) {
                    return this.getSegmentedSeparatedRendererDescription(segmentedButtonConfiguration, rendererDescription, f3, f4);
                }
                f5 = f6 = (float)JNRUtils.size(size, 2, 2, 1);
                break;
            }
            case BUTTON_SEGMENTED_INSET: {
                f3 = JNRUtils.size2D(size, -1.0f, -1.51f, -2.0f);
                f4 = -1.0f;
                f5 = 1.0f;
                f6 = 1.0f;
                break;
            }
            case BUTTON_SEGMENTED_SCURVE: 
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: {
                if (size == AquaUIPainter.Size.MINI) {
                    rendererDescription = this.createVertical(0.0f, 4.0f);
                }
                f3 = JNRUtils.size2D(size, 0.0f, n >= 101100 ? -1.5f : -1.0f, -2.0f);
                if (!segmentedButtonWidget.isSeparated()) break;
                return this.getTexturedSeparatedRendererDescription(segmentedButtonConfiguration, rendererDescription, f3);
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                f3 = -1.0f;
                f7 = JNRUtils.size(size, 0, -1, -2);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return this.adjustSegmentedRendererDescription(segmentedButtonConfiguration, rendererDescription, f, f2, f3, f4, f5, f6, f7);
    }

    @NotNull
    protected RendererDescription getTexturedSeparatedRendererDescription(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration, @NotNull RendererDescription rendererDescription, float f) {
        float f2 = 0.0f;
        float f3 = -0.5f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        boolean bl = segmentedButtonConfiguration.getLeftDividerState() != SegmentedButtonConfiguration.DividerState.NONE;
        boolean bl2 = segmentedButtonConfiguration.getRightDividerState() != SegmentedButtonConfiguration.DividerState.NONE;
        AquaUIPainter.Position position = segmentedButtonConfiguration.getPosition();
        if (position == AquaUIPainter.Position.FIRST) {
            if (!bl2) {
                f2 = 1.0f;
                f3 = 0.5f;
            } else {
                f3 = 0.0f;
            }
        } else if (position == AquaUIPainter.Position.MIDDLE) {
            if (bl2 && !bl) {
                f3 = 0.5f;
                f5 = -0.5f;
            } else if (bl && !bl2) {
                f2 = 1.0f;
                f3 = 0.5f;
            } else if (!bl && !bl2) {
                f2 = 1.0f;
                f3 = 1.0f;
                f5 = -0.5f;
            } else {
                f3 = 0.0f;
            }
        } else if (position == AquaUIPainter.Position.LAST) {
            if (!bl) {
                f3 = 0.5f;
                f5 = -0.5f;
            } else {
                f3 = 0.0f;
            }
        }
        RendererDescription rendererDescription2 = this.adjustSegmentedRendererDescription(segmentedButtonConfiguration, rendererDescription, f2, f4, f, 0.0f, 0.0f, 0.0f, 0.0f);
        RendererDescription rendererDescription3 = this.adjustSegmentedRendererDescription(segmentedButtonConfiguration, rendererDescription, f3, f5, f, 0.0f, 0.0f, 0.0f, 0.0f);
        return new MultiResolutionRendererDescription(rendererDescription2, rendererDescription3);
    }

    @NotNull
    protected RendererDescription getSegmentedSeparatedRendererDescription(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration, @NotNull RendererDescription rendererDescription, float f, float f2) {
        boolean bl = segmentedButtonConfiguration.getLeftDividerState() != SegmentedButtonConfiguration.DividerState.NONE;
        boolean bl2 = segmentedButtonConfiguration.getRightDividerState() != SegmentedButtonConfiguration.DividerState.NONE;
        float f3 = bl2 ? 2.0f : 2.5f;
        AquaUIPainter.Position position = segmentedButtonConfiguration.getPosition();
        if (position != AquaUIPainter.Position.FIRST) {
            if (position == AquaUIPainter.Position.MIDDLE) {
                f2 = 0.0f;
                f3 = 0.49f;
                if (bl2 && !bl) {
                    f2 = -0.49f;
                } else if (bl && bl2) {
                    f3 = 0.0f;
                } else if (!bl && !bl2) {
                    f3 = 1.0f;
                    f2 = -0.49f;
                }
            } else if (position == AquaUIPainter.Position.LAST) {
                f3 = 2.0f;
                f2 = bl ? 0.0f : -0.49f;
            }
        }
        try {
            return JNRUtils.adjustRendererDescription(rendererDescription, f2, f, f3, 0.0f);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            NativeSupport.log("Unable to adjust segmented button renderer description for " + segmentedButtonConfiguration);
            return rendererDescription;
        }
    }

    @NotNull
    protected RendererDescription adjustSegmentedRendererDescription(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration, @NotNull RendererDescription rendererDescription, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        boolean bl;
        AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget = segmentedButtonConfiguration.getWidget();
        boolean bl2 = segmentedButtonWidget.isSeparated();
        AquaUIPainter.Position position = segmentedButtonConfiguration.getPosition();
        boolean bl3 = position == AquaUIPainter.Position.FIRST || position == AquaUIPainter.Position.ONLY;
        boolean bl4 = position == AquaUIPainter.Position.LAST || position == AquaUIPainter.Position.ONLY;
        boolean bl5 = !bl2 && (position == AquaUIPainter.Position.MIDDLE || position == AquaUIPainter.Position.LAST);
        boolean bl6 = bl = !bl2 && (position == AquaUIPainter.Position.FIRST || position == AquaUIPainter.Position.MIDDLE);
        if (bl3) {
            f2 += f4;
            f += f5;
        }
        if (bl4) {
            f += f6;
        }
        if (bl5 && segmentedButtonConfiguration.getLeftDividerState() == SegmentedButtonConfiguration.DividerState.NONE) {
            f2 -= 1.0f;
            f += 1.0f;
        }
        if (bl && segmentedButtonConfiguration.getRightDividerState() == SegmentedButtonConfiguration.DividerState.NONE) {
            f += 1.0f;
        }
        try {
            return JNRUtils.adjustRendererDescription(rendererDescription, f2, f3, f, f7);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            NativeSupport.log("Unable to adjust segmented button renderer description for " + segmentedButtonConfiguration);
            return rendererDescription;
        }
    }

    @Override
    @NotNull
    public RendererDescription getComboBoxRendererDescription(@NotNull ComboBoxConfiguration comboBoxConfiguration) {
        AquaUIPainter.ComboBoxWidget comboBoxWidget = comboBoxConfiguration.getWidget();
        AquaUIPainter.Size size = comboBoxConfiguration.getSize();
        if (comboBoxWidget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL) {
            switch (size) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, -3.0f, 2.0f, 3.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, -3.0f, 2.0f, 3.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(0.0f, -1.5f, 2.0f, 2.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        if (comboBoxWidget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED || comboBoxWidget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED_TOOLBAR) {
            switch (size) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        switch (size) {
            case LARGE: 
            case REGULAR: {
                return new BasicRendererDescription(-0.5f, 0.0f, 2.0f, 1.0f);
            }
            case SMALL: {
                return new BasicRendererDescription(-0.5f, 0.0f, 1.0f, 0.0f);
            }
            case MINI: {
                return new BasicRendererDescription(-0.5f, -0.51f, 2.0f, 1.0f);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RendererDescription getPopupButtonRendererDescription(@NotNull PopupButtonConfiguration popupButtonConfiguration) {
        AquaUIPainter.PopupButtonWidget popupButtonWidget = popupButtonConfiguration.getPopupButtonWidget();
        AquaUIPainter.Size size = popupButtonConfiguration.getSize();
        if (popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_CELL) {
            switch (size) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        return super.getPopupButtonRendererDescription(popupButtonConfiguration);
    }

    @Nullable
    public RendererDescription getPopUpArrowRendererDescription(@NotNull PopupButtonConfiguration popupButtonConfiguration, @NotNull AquaUIPainter.Size size) {
        float f = JNRUtils.size2D(size, 1.0f, 0.0f, 2.0f);
        float f2 = JNRUtils.size2D(size, 3.0f, 1.0f, 1.0f);
        int n = JNRUtils.size(size, 1, 0, 1);
        int n2 = JNRUtils.size(size, 3, 1, 0);
        return new BasicRendererDescription(-f, -f2, n, n2);
    }

    @NotNull
    public RendererDescription getPullDownArrowRendererDescription(@NotNull PopupButtonConfiguration popupButtonConfiguration) {
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @NotNull
    public RendererDescription getScrollBarThumbRendererDescription(@NotNull ScrollBarConfiguration scrollBarConfiguration) {
        int n;
        int n2 = n = scrollBarConfiguration.getWidget() == AquaUIPainter.ScrollBarWidget.LEGACY ? 2 : 1;
        if (scrollBarConfiguration.getOrientation() == AquaUIPainter.Orientation.VERTICAL) {
            return new BasicRendererDescription(0.0f, n, 0.0f, -2 * n);
        }
        return new BasicRendererDescription(n, 0.0f, -2 * n, 0.0f);
    }
}

