/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import org.violetlib.aqua.fc.ViewModeControl;

public class ViewModeControlImpl
extends ViewModeControl {
    private static Image listViewImage;
    private static Image columnViewImage;
    private ButtonGroup group;
    private JToggleButton listViewButton;
    private JToggleButton columnViewButton;
    private int selectedViewMode = -1;

    public ViewModeControlImpl() {
        this.initComponents();
        this.setFocusable(false);
        this.setOpaque(false);
        this.setSelectedViewMode(2);
    }

    @Override
    public synchronized void addKeyListener(KeyListener keyListener) {
        this.listViewButton.addKeyListener(keyListener);
        this.columnViewButton.addKeyListener(keyListener);
    }

    @Override
    public void setSelectedViewMode(int n) {
        if (n != this.selectedViewMode && (n == 1 || n == 2)) {
            this.selectedViewMode = n;
            int n2 = this.getComponentCount();
            String string = "" + n;
            for (int i = 0; i < n2; ++i) {
                JToggleButton jToggleButton;
                Component component = this.getComponent(i);
                if (!(component instanceof JToggleButton) || !string.equals((jToggleButton = (JToggleButton)component).getActionCommand())) continue;
                jToggleButton.setSelected(true);
            }
            this.selectedViewModeChanged();
        }
    }

    @Override
    public int getSelectedViewMode() {
        return this.selectedViewMode;
    }

    private void initComponents() {
        if (listViewImage == null) {
            listViewImage = Toolkit.getDefaultToolkit().getImage("NSImage://NSListViewTemplate");
        }
        if (columnViewImage == null) {
            columnViewImage = Toolkit.getDefaultToolkit().getImage("NSImage://NSColumnViewTemplate");
        }
        this.group = new ButtonGroup();
        ImageIcon imageIcon = new ImageIcon(listViewImage);
        ImageIcon imageIcon2 = new ImageIcon(columnViewImage);
        this.listViewButton = this.createButton(imageIcon, "first", 1);
        this.columnViewButton = this.createButton(imageIcon2, "last", 2);
        this.add(this.listViewButton);
        this.add(this.columnViewButton);
        this.setLayout(new FlowLayout(1, 0, 0));
    }

    protected JToggleButton createButton(ImageIcon imageIcon, String string, final int n) {
        JToggleButton jToggleButton = new JToggleButton(imageIcon);
        jToggleButton.putClientProperty("JButton.buttonType", "segmentedTextured");
        jToggleButton.putClientProperty("JButton.segmentPosition", string);
        jToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ViewModeControlImpl.this.setSelectedViewMode(n);
            }
        });
        jToggleButton.setActionCommand("" + n);
        this.group.add(jToggleButton);
        return jToggleButton;
    }
}

