/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SeparatorUI;

public class AquaSeparatorUI
extends SeparatorUI {
    private static int thickness;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaSeparatorUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        if (thickness == 0) {
            thickness = UIManager.getInt("Separator.width");
        }
        this.installDefaults((JSeparator)jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults((JSeparator)jComponent);
    }

    protected void installDefaults(JSeparator jSeparator) {
        LookAndFeel.installColors(jSeparator, "Separator.background", "Separator.foreground");
        LookAndFeel.installProperty(jSeparator, "opaque", Boolean.FALSE);
    }

    protected void uninstallDefaults(JSeparator jSeparator) {
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Dimension dimension = jComponent.getSize();
        Insets insets = jComponent.getInsets();
        graphics.setColor(jComponent.getForeground());
        int n = insets.left;
        int n2 = insets.top;
        int n3 = Math.max(0, dimension.width - insets.left - insets.right);
        int n4 = Math.max(0, dimension.height - insets.top - insets.bottom);
        if (((JSeparator)jComponent).getOrientation() == 1) {
            int n5 = Math.min(n3, thickness);
            n3 = n5 + (n3 - n5) / 2;
        } else {
            int n6 = Math.min(n4, thickness);
            n4 = n6 + (n4 - n6) / 2;
        }
        graphics.fillRect(n, n2, n3, n4);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Insets insets = jComponent.getInsets();
        if (((JSeparator)jComponent).getOrientation() == 1) {
            return new Dimension(thickness + insets.left + insets.right, insets.top + insets.bottom);
        }
        return new Dimension(insets.left + insets.right, thickness + insets.top + insets.bottom);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        if (((JSeparator)jComponent).getOrientation() == 1) {
            dimension.height = Integer.MAX_VALUE;
        } else {
            dimension.width = Integer.MAX_VALUE;
        }
        return dimension;
    }
}

