/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicLookAndFeel;
import org.violetlib.aqua.AquaButtonBorder;
import org.violetlib.aqua.AquaButtonUI;
import org.violetlib.aqua.AquaFocusRingManager;
import org.violetlib.aqua.AquaFonts;
import org.violetlib.aqua.AquaGroupBorder;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaKeyBindings;
import org.violetlib.aqua.AquaListUI;
import org.violetlib.aqua.AquaMenuBarBorder;
import org.violetlib.aqua.AquaMenuItemBorder;
import org.violetlib.aqua.AquaMenuPainter;
import org.violetlib.aqua.AquaMnemonicHandler;
import org.violetlib.aqua.AquaNativeSupport;
import org.violetlib.aqua.AquaPopupFactory;
import org.violetlib.aqua.AquaRootPaneUI;
import org.violetlib.aqua.AquaSheetSupport;
import org.violetlib.aqua.AquaTableHeaderBorder;
import org.violetlib.aqua.AquaTableScrollPaneCorner;
import org.violetlib.aqua.AquaTextFieldBorder;
import org.violetlib.aqua.AquaToolBarUI;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.aqua.fc.AquaBrowserSizeHandleIcon;
import org.violetlib.aqua.fc.OSXFile;
import org.violetlib.jnr.aqua.AquaNativeRendering;

public class AquaLookAndFeel
extends BasicLookAndFeel {
    private static final String PKG_PREFIX = "org.violetlib.aqua.";
    private AquaFocusRingManager focusRingManager;
    private PropertyChangeListener uiChangeListener;
    private AquaPopupFactory popupFactory;
    public static boolean suppressCreationOfDisabledButtonIcons;

    @Override
    public String getName() {
        return "VAqua";
    }

    @Override
    public String getID() {
        return "VAqua";
    }

    @Override
    public String getDescription() {
        return "VAqua Look and Feel for Mac OS X";
    }

    @Override
    public boolean getSupportsWindowDecorations() {
        return false;
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return true;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return AquaNativeSupport.load();
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.popupFactory == null) {
            this.popupFactory = new AquaPopupFactory();
            PopupFactory.setSharedInstance(this.popupFactory);
        }
        this.popupFactory.setActive(true);
        this.focusRingManager = AquaFocusRingManager.getInstance();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(AquaMnemonicHandler.getInstance());
        if (this.uiChangeListener == null) {
            this.uiChangeListener = new MyUIChangeListener();
        }
        UIManager.addPropertyChangeListener(this.uiChangeListener);
    }

    @Override
    public void uninitialize() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(AquaMnemonicHandler.getInstance());
        UIManager.removePropertyChangeListener(this.uiChangeListener);
        if (this.focusRingManager != null) {
            this.focusRingManager.uninstall();
            this.focusRingManager = null;
        }
        this.popupFactory.setActive(false);
        super.uninitialize();
    }

    @Override
    public Icon getDisabledIcon(JComponent jComponent, Icon icon) {
        if (!suppressCreationOfDisabledButtonIcons) {
            AquaButtonUI aquaButtonUI;
            if (icon instanceof ImageIcon && jComponent instanceof AbstractButton && (aquaButtonUI = AquaUtils.getUI(jComponent, AquaButtonUI.class)) != null) {
                return aquaButtonUI.createDisabledIcon((AbstractButton)jComponent, (ImageIcon)icon);
            }
            return super.getDisabledIcon(jComponent, icon);
        }
        return null;
    }

    @Override
    public Icon getDisabledSelectedIcon(JComponent jComponent, Icon icon) {
        if (!suppressCreationOfDisabledButtonIcons) {
            AquaButtonUI aquaButtonUI;
            if (icon instanceof ImageIcon && jComponent instanceof AbstractButton && (aquaButtonUI = AquaUtils.getUI(jComponent, AquaButtonUI.class)) != null) {
                return aquaButtonUI.createDisabledSelectedIcon((AbstractButton)jComponent, (ImageIcon)icon);
            }
            return super.getDisabledSelectedIcon(jComponent, icon);
        }
        return null;
    }

    public void displayAsSheet(Window window, Runnable runnable) throws UnsupportedOperationException {
        AquaSheetSupport.displayAsSheet(window, runnable);
    }

    public void showOptionPaneAsSheet(JDialog jDialog, JOptionPane jOptionPane, Consumer<Integer> consumer) {
        AquaSheetSupport.showOptionPaneAsSheet(jDialog, jOptionPane, consumer);
    }

    public void showFileChooserAsSheet(Window window, JFileChooser jFileChooser, Consumer<Integer> consumer) {
        AquaSheetSupport.showFileChooserAsSheet(window, jFileChooser, consumer);
    }

    public void setForceActiveWindowDisplay(boolean bl) {
        AquaRootPaneUI.setForceActiveWindowDisplay(bl);
    }

    @Override
    protected ActionMap getAudioActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("AuditoryCues.actionMap");
        if (actionMap != null) {
            return actionMap;
        }
        Object[] objectArray = (Object[])UIManager.get("AuditoryCues.cueList");
        if (objectArray != null) {
            actionMap = new ActionMapUIResource();
            for (int i = objectArray.length - 1; i >= 0; --i) {
                actionMap.put(objectArray[i], this.createAudioAction(objectArray[i]));
            }
        }
        UIManager.getLookAndFeelDefaults().put("AuditoryCues.actionMap", actionMap);
        return actionMap;
    }

    protected static Object makeIcon(String string) {
        return new UIDefaults.ProxyLazyValue("org.violetlib.aqua.AquaIcon", "loadResource", new Object[]{string});
    }

    @Override
    public UIDefaults getDefaults() {
        UIDefaults uIDefaults = new UIDefaults();
        uIDefaults.put("ClassLoader", this.getClass().getClassLoader());
        try {
            this.initClassDefaults(uIDefaults);
            super.initSystemColorDefaults(uIDefaults);
            super.initComponentDefaults(uIDefaults);
            this.initSystemColorDefaults(uIDefaults);
            this.initComponentDefaults(uIDefaults);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return uIDefaults;
    }

    private void initResourceBundle(UIDefaults uIDefaults) {
        uIDefaults.setDefaultLocale(Locale.getDefault());
        this.addResourceBundle(uIDefaults, "org.violetlib.aqua.resources.aqua");
        this.addResourceBundle(uIDefaults, "org.violetlib.aqua.Labels");
    }

    private void addResourceBundle(UIDefaults uIDefaults, String string) {
        uIDefaults.addResourceBundle(string);
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string);
            Enumeration<String> enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement();
                uIDefaults.put(string2, resourceBundle.getString(string2));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void initComponentDefaults(UIDefaults uIDefaults2) {
        Color color;
        InsetsUIResource insetsUIResource;
        this.initResourceBundle(uIDefaults2);
        InsetsUIResource insetsUIResource2 = insetsUIResource = new InsetsUIResource(0, 0, 0, 0);
        UIDefaults.ActiveValue activeValue = new UIDefaults.ActiveValue(){

            @Override
            public Object createValue(UIDefaults uIDefaults) {
                return new DefaultListCellRenderer.UIResource();
            }
        };
        BorderUIResource.EmptyBorderUIResource emptyBorderUIResource = new BorderUIResource.EmptyBorderUIResource(2, 0, 2, 0);
        ColorUIResource colorUIResource = new ColorUIResource(255, 255, 204);
        ColorUIResource colorUIResource2 = new ColorUIResource(Color.black);
        ColorUIResource colorUIResource3 = new ColorUIResource(Color.white);
        ColorUIResource colorUIResource4 = new ColorUIResource(new Color(0, 0, 0, 152));
        ColorUIResource colorUIResource5 = new ColorUIResource(new Color(192, 192, 192, 192));
        ColorUIResource colorUIResource6 = new ColorUIResource(new Color(0, 0, 0, 100));
        ColorUIResource colorUIResource7 = new ColorUIResource(192, 192, 192);
        ColorUIResource colorUIResource8 = new ColorUIResource(0.25f, 0.25f, 0.25f);
        ColorUIResource colorUIResource9 = new ColorUIResource(1.0f, 0.4f, 0.4f);
        ColorUIResource colorUIResource10 = new ColorUIResource(245, 245, 245);
        ColorUIResource colorUIResource11 = new ColorUIResource(new Color(0, 0, 0, 25));
        ColorUIResource colorUIResource12 = colorUIResource3;
        ColorUIResource colorUIResource13 = colorUIResource7;
        ColorUIResource colorUIResource14 = colorUIResource3;
        ColorUIResource colorUIResource15 = colorUIResource2;
        ColorUIResource colorUIResource16 = colorUIResource2;
        ColorUIResource colorUIResource17 = colorUIResource7;
        ColorUIResource colorUIResource18 = colorUIResource2;
        ColorUIResource colorUIResource19 = colorUIResource2;
        ColorUIResource colorUIResource20 = new ColorUIResource(140, 140, 140);
        UIDefaults.LazyValue lazyValue = uIDefaults -> new BasicBorders.MarginBorder();
        InsetsUIResource insetsUIResource3 = insetsUIResource;
        UIDefaults.LazyValue lazyValue2 = uIDefaults -> AquaTextFieldBorder.getTextFieldBorder();
        UIDefaults.LazyValue lazyValue3 = lazyValue;
        UIDefaults.LazyValue lazyValue4 = uIDefaults -> AquaGroupBorder.getBorderForTitledBorder();
        UIDefaults.LazyValue lazyValue5 = uIDefaults -> AquaGroupBorder.getTitlelessBorder();
        AquaTableHeaderBorder aquaTableHeaderBorder = AquaTableHeaderBorder.getListHeaderBorder();
        BorderUIResource.EmptyBorderUIResource emptyBorderUIResource2 = new BorderUIResource.EmptyBorderUIResource(0, 0, 0, 0);
        BorderUIResource.LineBorderUIResource lineBorderUIResource = new BorderUIResource.LineBorderUIResource(new Color(200, 200, 200), 1);
        BorderUIResource.CompoundBorderUIResource compoundBorderUIResource = new BorderUIResource.CompoundBorderUIResource(new BorderUIResource.MatteBorderUIResource(0, 0, 1, 0, new ColorUIResource(0xFFFFFF)), new BorderUIResource.EmptyBorderUIResource(0, 4, 1, 0));
        Color color2 = AquaImageFactory.getSelectionBackgroundColorUIResource();
        Color color3 = AquaImageFactory.getSelectionForegroundColorUIResource();
        Color color4 = AquaImageFactory.getSelectionInactiveBackgroundColorUIResource();
        Color color5 = AquaImageFactory.getSelectionInactiveForegroundColorUIResource();
        Color color6 = AquaImageFactory.getComboBoxSelectionBackgroundColorUIResource();
        Color color7 = AquaImageFactory.getComboBoxSelectionForegroundColorUIResource();
        ColorUIResource colorUIResource21 = new ColorUIResource(211, 211, 211);
        Color color8 = AquaImageFactory.getTextSelectionForegroundColorUIResource();
        Color color9 = AquaImageFactory.getTextSelectionBackgroundColorUIResource();
        ColorUIResource colorUIResource22 = new ColorUIResource(212, 212, 212);
        ColorUIResource colorUIResource23 = new ColorUIResource(200, 200, 200);
        ColorUIResource colorUIResource24 = colorUIResource7;
        ColorUIResource colorUIResource25 = colorUIResource2;
        ColorUIResource colorUIResource26 = colorUIResource3;
        ColorUIResource colorUIResource27 = colorUIResource3;
        ColorUIResource colorUIResource28 = colorUIResource6;
        UIDefaults.LazyValue lazyValue6 = uIDefaults -> BasicBorders.getInternalFrameBorder();
        BorderUIResource.EmptyBorderUIResource emptyBorderUIResource3 = new BorderUIResource.EmptyBorderUIResource(1, 1, 1, 1);
        Color color10 = AquaImageFactory.getDesktopBackgroundColorUIResource();
        Color color11 = AquaImageFactory.getFocusRingColorUIResource();
        Color color12 = color = AquaImageFactory.getWindowBackgroundColorUIResource();
        Color color13 = color;
        Color color14 = color;
        ColorUIResource colorUIResource29 = new ColorUIResource(new Color(0, 0, 0, 170));
        ColorUIResource colorUIResource30 = new ColorUIResource(new Color(0, 0, 0, 75));
        ColorUIResource colorUIResource31 = new ColorUIResource(Color.WHITE);
        ColorUIResource colorUIResource32 = new ColorUIResource(new Color(255, 255, 255, 155));
        ColorUIResource colorUIResource33 = OSXSystemProperties.OSVersion >= 1011 ? new ColorUIResource(37, 125, 252) : new ColorUIResource(0, 122, 255);
        ColorUIResource colorUIResource34 = OSXSystemProperties.OSVersion >= 1011 ? new ColorUIResource(new Color(37, 125, 252, 120)) : new ColorUIResource(new Color(0, 122, 255, 120));
        UIDefaults.LazyValue lazyValue7 = uIDefaults -> AquaFonts.getControlTextFont();
        UIDefaults.LazyValue lazyValue8 = uIDefaults -> AquaFonts.getControlTextSmallFont();
        UIDefaults.LazyValue lazyValue9 = uIDefaults -> AquaFonts.getControlTextMiniFont();
        UIDefaults.LazyValue lazyValue10 = uIDefaults -> AquaFonts.getIconButtonFont();
        UIDefaults.LazyValue lazyValue11 = uIDefaults -> AquaFonts.getIconButtonSmallFont();
        UIDefaults.LazyValue lazyValue12 = uIDefaults -> AquaFonts.getAlertHeaderFont();
        UIDefaults.LazyValue lazyValue13 = uIDefaults -> AquaFonts.getMenuFont();
        UIDefaults.LazyValue lazyValue14 = uIDefaults -> AquaFonts.getViewFont();
        UIDefaults.LazyValue lazyValue15 = uIDefaults -> AquaFonts.getSideBarFont();
        UIDefaults.LazyValue lazyValue16 = uIDefaults -> AquaFonts.getSideBarSelectionFont();
        UIDefaults.LazyValue lazyValue17 = uIDefaults -> AquaFonts.getSideBarCategoryFont();
        UIDefaults.LazyValue lazyValue18 = uIDefaults -> AquaFonts.getSideBarCategorySelectionFont();
        UIDefaults.LazyValue lazyValue19 = uIDefaults -> AquaFonts.getPreviewLabelFont();
        UIDefaults.LazyValue lazyValue20 = uIDefaults -> AquaFonts.getPreviewValueFont();
        UIDefaults.LazyValue lazyValue21 = uIDefaults -> AquaFonts.getPreviewNameFont();
        UIDefaults.LazyValue lazyValue22 = uIDefaults -> AquaFonts.getPreviewTypeSizeFont();
        UIDefaults.LazyValue lazyValue23 = uIDefaults -> AquaFonts.getRecessedButtonFont();
        UIDefaults.LazyValue lazyValue24 = uIDefaults -> AquaFonts.getInlineButtonFont();
        ColorUIResource colorUIResource35 = new ColorUIResource(new Color(0, 0, 0, 0));
        ColorUIResource colorUIResource36 = new ColorUIResource(new Color(0, 0, 0, 67));
        ColorUIResource colorUIResource37 = new ColorUIResource(205, 205, 205);
        ColorUIResource colorUIResource38 = new ColorUIResource(new Color(31, 31, 31, 217));
        ColorUIResource colorUIResource39 = new ColorUIResource(68, 68, 68);
        ColorUIResource colorUIResource40 = new ColorUIResource(30, 30, 30);
        ColorUIResource colorUIResource41 = new ColorUIResource(0, 0, 0);
        ColorUIResource colorUIResource42 = new ColorUIResource(new Color(85, 85, 85, 217));
        ColorUIResource colorUIResource43 = new ColorUIResource(0, 0, 0);
        ColorUIResource colorUIResource44 = new ColorUIResource(209, 209, 209);
        ColorUIResource colorUIResource45 = new ColorUIResource(new Color(246, 246, 246));
        ColorUIResource colorUIResource46 = colorUIResource35;
        ColorUIResource colorUIResource47 = colorUIResource2;
        ColorUIResource colorUIResource48 = colorUIResource3;
        ColorUIResource colorUIResource49 = new ColorUIResource(new Color(59, 152, 253));
        ColorUIResource colorUIResource50 = colorUIResource46;
        ColorUIResource colorUIResource51 = colorUIResource7;
        ColorUIResource colorUIResource52 = colorUIResource45;
        ColorUIResource colorUIResource53 = colorUIResource2;
        ColorUIResource colorUIResource54 = colorUIResource2;
        AquaMenuItemBorder aquaMenuItemBorder = new AquaMenuItemBorder();
        BorderUIResource.EmptyBorderUIResource emptyBorderUIResource4 = new BorderUIResource.EmptyBorderUIResource(0, 0, 0, 0);
        UIDefaults.LazyInputMap lazyInputMap = new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"});
        UIDefaults.LazyInputMap lazyInputMap2 = new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancelSelection", "meta PERIOD", "cancelSelection", "F5", "refresh"});
        UIDefaults.LazyValue lazyValue25 = uIDefaults -> AquaImageFactory.getConfirmImageIcon();
        UIDefaults.LazyValue lazyValue26 = uIDefaults -> AquaImageFactory.getCautionImageIcon();
        UIDefaults.LazyValue lazyValue27 = uIDefaults -> AquaImageFactory.getStopImageIcon();
        UIDefaults.LazyValue lazyValue28 = uIDefaults -> AquaImageFactory.getLockImageIcon();
        AquaKeyBindings aquaKeyBindings = AquaKeyBindings.instance();
        Object[] objectArray = new Object[]{"control", color, "Browser.selectionBackground", color2, "Browser.selectionForeground", color3, "Browser.inactiveSelectionBackground", color4, "Browser.inactiveSelectionForeground", color5, "Browser.expandedIcon", AquaLookAndFeel.makeIcon("fc/Unselected.png"), "Browser.expandingIcon", AquaLookAndFeel.makeIcon("fc/Unselected.png"), "Browser.focusedSelectedExpandedIcon", AquaLookAndFeel.makeIcon("fc/SelectedFocused.png"), "Browser.focusedSelectedExpandingIcon", AquaLookAndFeel.makeIcon("fc/SelectedFocused.png"), "Browser.selectedExpandedIcon", AquaLookAndFeel.makeIcon("fc/SelectedUnfocused.png"), "Browser.selectedExpandingIcon", AquaLookAndFeel.makeIcon("fc/SelectedUnfocused.png"), "Browser.sizeHandleIcon", uIDefaults -> new AquaBrowserSizeHandleIcon(), "Button.background", color14, "Button.foreground", colorUIResource2, "Button.disabledText", colorUIResource7, "Button.select", colorUIResource9, "Button.border", uIDefaults -> AquaButtonBorder.getPushButtonBorder(), "Button.font", lazyValue7, "Button.textIconGap", new Integer(4), "Button.textShiftOffset", 0, "Button.focusInputMap", lazyInputMap, "Button.margin", new InsetsUIResource(0, 0, 0, 0), "Button.opaque", false, "Button.recessed.font", lazyValue23, "Button.recessed.rolloverText", colorUIResource3, "Button.inline.font", lazyValue24, "Button.texturedSelectedColor", colorUIResource31, "Button.texturedDisabledSelectedColor", colorUIResource32, "Button.texturedUnselectedColor", colorUIResource29, "Button.texturedDisabledUnselectedColor", colorUIResource30, "Button.texturedNonexclusiveSelectedColor", colorUIResource33, "Button.texturedDisabledNonexclusiveSelectedColor", colorUIResource34, "CheckBox.background", color14, "CheckBox.foreground", colorUIResource2, "CheckBox.disabledText", colorUIResource7, "CheckBox.select", colorUIResource9, "CheckBox.font", lazyValue7, "CheckBox.margin", new InsetsUIResource(1, 1, 0, 1), "CheckBox.focusInputMap", lazyInputMap, "CheckBoxMenuItem.font", lazyValue13, "CheckBoxMenuItem.acceleratorFont", lazyValue13, "CheckBoxMenuItem.background", colorUIResource46, "CheckBoxMenuItem.foreground", colorUIResource47, "CheckBoxMenuItem.selectionBackground", colorUIResource49, "CheckBoxMenuItem.selectionForeground", colorUIResource48, "CheckBoxMenuItem.disabledBackground", colorUIResource50, "CheckBoxMenuItem.disabledForeground", colorUIResource51, "CheckBoxMenuItem.acceleratorForeground", colorUIResource53, "CheckBoxMenuItem.acceleratorSelectionForeground", colorUIResource54, "CheckBoxMenuItem.acceleratorDelimiter", "", "CheckBoxMenuItem.border", aquaMenuItemBorder, "CheckBoxMenuItem.margin", insetsUIResource2, "CheckBoxMenuItem.borderPainted", Boolean.TRUE, "CheckBoxMenuItem.checkIcon", uIDefaults -> AquaImageFactory.getMenuItemCheckIcon(), "CheckBoxMenuItem.dashIcon", uIDefaults -> AquaImageFactory.getMenuItemDashIcon(), "ColorChooser.background", color12, "ComboBox.font", lazyValue7, "ComboBox.background", colorUIResource3, "ComboBox.foreground", colorUIResource2, "ComboBox.selectionBackground", color6, "ComboBox.selectionForeground", color7, "ComboBox.disabledBackground", colorUIResource50, "ComboBox.disabledForeground", colorUIResource51, "ComboBox.ancestorInputMap", aquaKeyBindings.getComboBoxInputMap(), "ComboBox.padding", new InsetsUIResource(1, 4, 1, 4), "ComboBox.maximumRowCount", 5, "DesktopIcon.border", lazyValue6, "DesktopIcon.borderColor", colorUIResource4, "DesktopIcon.borderRimColor", colorUIResource5, "DesktopIcon.labelBackground", colorUIResource6, "Desktop.background", color10, "EditorPane.focusInputMap", aquaKeyBindings.getMultiLineTextInputMap(), "EditorPane.font", lazyValue7, "EditorPane.background", colorUIResource26, "EditorPane.foreground", colorUIResource25, "EditorPane.selectionBackground", color9, "EditorPane.selectionForeground", color8, "EditorPane.caretForeground", colorUIResource25, "EditorPane.caretBlinkRate", 500, "EditorPane.inactiveForeground", colorUIResource24, "EditorPane.inactiveBackground", colorUIResource27, "EditorPane.border", lazyValue3, "EditorPane.margin", insetsUIResource3, "FileChooser.ancestorInputMap", lazyInputMap2, "FileChooser.cellTipOrigin", new Point(18, 1), "FileChooser.previewNameFont", lazyValue21, "FileChooser.previewTypeSizeFont", lazyValue22, "FileChooser.previewLabelFont", lazyValue19, "FileChooser.previewValueFont", lazyValue20, "FileChooser.previewLabelForeground", new ColorUIResource(159, 159, 159), "FileChooser.previewValueForeground", new ColorUIResource(0, 0, 0), "FileChooser.previewLabelInsets", new InsetsUIResource(1, 0, 0, 4), "FileChooser.previewLabelDelimiter", "", "FileChooser.listView.extraColumnTextColor", new ColorUIResource(128, 128, 128), "FileChooser.listView.headerColor", new ColorUIResource(37, 37, 37), "FileChooser.listView.headerBackground", new ColorUIResource(240, 240, 240), "FileChooser.autovalidate", true, "FileChooser.quickLookEnabled", true, "FileChooser.orderByType", false, "FileChooser.speed", false, "FileChooser.browserCellBorder", compoundBorderUIResource, "FileChooser.browserCellFocusBorder", compoundBorderUIResource, "FileChooser.browserCellFocusBorderGrayed", compoundBorderUIResource, "FileChooser.browserCellTextIconGap", 6, "FileChooser.browserCellTextArrowIconGap", 5, "FileChooser.cancelButtonMnemonic", 0, "FileChooser.saveButtonMnemonic", 0, "FileChooser.openButtonMnemonic", 0, "FileChooser.updateButtonMnemonic", 0, "FileChooser.helpButtonMnemonic", 0, "FileChooser.directoryOpenButtonMnemonic", 0, "FileChooser.lookInLabelMnemonic", 0, "FileChooser.fileNameLabelMnemonic", 0, "FileChooser.filesOfTypeLabelMnemonic", 0, "FileChooser.sideBarRowHeight", 24, "FileChooser.sideBarIcon.Applications", OSXFile.getApplicationsSidebarIcon(), "FileChooser.sideBarIcon.Desktop", OSXFile.getDesktopSidebarIcon(), "FileChooser.sideBarIcon.Documents", OSXFile.getDocumentsSidebarIcon(), "FileChooser.sideBarIcon.Downloads", OSXFile.getDownloadsSidebarIcon(), "FileChooser.sideBarIcon.GenericFile", OSXFile.getGenericFileSidebarIcon(), "FileChooser.sideBarIcon.GenericFolder", OSXFile.getGenericFolderSidebarIcon(), "FileChooser.sideBarIcon.GenericVolume", OSXFile.getGenericVolumeSidebarIcon(), "FileChooser.sideBarIcon.Home", OSXFile.getHomeSidebarIcon(), "FileChooser.sideBarIcon.Movies", OSXFile.getMoviesSidebarIcon(), "FileChooser.sideBarIcon.Music", OSXFile.getMusicSidebarIcon(), "FileChooser.sideBarIcon.Network", OSXFile.getNetworkSidebarIcon(), "FileChooser.sideBarIcon.Pictures", OSXFile.getPicturesSidebarIcon(), "FileChooser.sideBarIcon.Utilities", OSXFile.getUtilitiesSidebarIcon(), "FileChooser.sideBarIcon.SmartFolder", OSXFile.getSmartFolderSidebarIcon(), "FileChooser.sideBarIcon.TimeMachineVolume", OSXFile.getTimeMachineSidebarIcon(), "FileView.aliasBadgeIcon", OSXFile.getAliasBadgeIcon(), "FileView.computerIcon", AquaImageFactory.getComputerIcon(), "FileView.directoryIcon", OSXFile.getDirectoryIcon(), "FileView.fileIcon", OSXFile.getFileIcon(), "FileView.networkIcon", OSXFile.getNetworkIcon(), "Focus.color", color11, "FormattedTextField.focusInputMap", aquaKeyBindings.getFormattedTextFieldInputMap(), "FormattedTextField.font", lazyValue7, "FormattedTextField.background", colorUIResource26, "FormattedTextField.foreground", colorUIResource25, "FormattedTextField.inactiveForeground", colorUIResource24, "FormattedTextField.inactiveBackground", colorUIResource27, "FormattedTextField.selectionBackground", color9, "FormattedTextField.selectionForeground", color8, "FormattedTextField.caretForeground", colorUIResource25, "FormattedTextField.caretBlinkRate", 500, "FormattedTextField.border", lazyValue2, "FormattedTextField.margin", insetsUIResource, "IconButton.font", lazyValue10, "IconButton.smallFont", lazyValue11, "InternalFrame.titleFont", lazyValue7, "InternalFrame.background", color, "InternalFrame.borderColor", color, "InternalFrame.borderShadow", Color.red, "InternalFrame.borderDarkShadow", Color.green, "InternalFrame.borderHighlight", Color.blue, "InternalFrame.borderLight", Color.yellow, "InternalFrame.opaque", Boolean.FALSE, "InternalFrame.border", null, "InternalFrame.icon", null, "InternalFrame.paletteBorder", null, "InternalFrame.paletteTitleFont", lazyValue8, "InternalFrame.paletteBackground", color, "InternalFrame.optionDialogBorder", null, "InternalFrame.optionDialogTitleFont", lazyValue13, "InternalFrame.optionDialogBackground", color, "InternalFrame.closeSound", null, "InternalFrame.maximizeSound", null, "InternalFrame.minimizeSound", null, "InternalFrame.restoreDownSound", null, "InternalFrame.restoreUpSound", null, "InternalFrame.activeTitleBackground", color, "InternalFrame.activeTitleForeground", colorUIResource25, "InternalFrame.inactiveTitleBackground", color, "InternalFrame.inactiveTitleForeground", colorUIResource24, "InternalFrame.windowBindings", new Object[]{"shift ESCAPE", "showSystemMenu", "ctrl SPACE", "showSystemMenu", "ESCAPE", "hideSystemMenu"}, "TitledBorder.font", lazyValue8, "TitledBorder.titleColor", colorUIResource2, "TitledBorder.aquaVariant", lazyValue4, "InsetBorder.aquaVariant", lazyValue5, "Label.font", lazyValue7, "Label.background", color14, "Label.foreground", colorUIResource2, "Label.disabledForeground", colorUIResource7, "Label.disabledShadow", colorUIResource8, "Label.border", null, "List.font", lazyValue14, "List.background", colorUIResource3, "List.foreground", colorUIResource2, "List.selectionBackground", color2, "List.selectionForeground", color3, "List.selectionInactiveBackground", color4, "List.selectionInactiveForeground", color5, "List.focusCellHighlightBorder", emptyBorderUIResource3, "List.focusSelectedCellHighlightBorder", emptyBorderUIResource3, "List.cellNoFocusBorder", emptyBorderUIResource3, "List.border", null, "List.cellRenderer", activeValue, "List.sourceListBackgroundPainter", uIDefaults -> AquaListUI.getSourceListBackgroundPainter(), "List.sourceListSelectionBackgroundPainter", uIDefaults -> AquaListUI.getSourceListSelectionBackgroundPainter(), "List.sourceListFocusedSelectionBackgroundPainter", uIDefaults -> AquaListUI.getSourceListFocusedSelectionBackgroundPainter(), "List.evenRowBackgroundPainter", uIDefaults -> AquaListUI.getListEvenBackgroundPainter(), "List.oddRowBackgroundPainter", uIDefaults -> AquaListUI.getListOddBackgroundPainter(), "List.evenRowBackground", colorUIResource3, "List.oddRowBackground", colorUIResource10, "List.focusInputMap", aquaKeyBindings.getListInputMap(), "Menu.font", lazyValue13, "Menu.acceleratorFont", lazyValue13, "Menu.background", colorUIResource46, "Menu.foreground", colorUIResource47, "Menu.selectionBackground", colorUIResource49, "Menu.selectionForeground", colorUIResource48, "Menu.disabledBackground", colorUIResource50, "Menu.disabledForeground", colorUIResource51, "Menu.acceleratorForeground", colorUIResource53, "Menu.acceleratorSelectionForeground", colorUIResource54, "Menu.border", aquaMenuItemBorder, "Menu.borderPainted", Boolean.FALSE, "Menu.borderColor", colorUIResource44, "Menu.margin", insetsUIResource2, "Menu.arrowIcon", uIDefaults -> AquaImageFactory.getMenuArrowIcon(), "Menu.consumesTabs", Boolean.TRUE, "Menu.menuPopupOffsetY", new Integer(1), "Menu.submenuPopupOffsetY", new Integer(-4), "MenuBar.font", lazyValue13, "MenuBar.background", colorUIResource45, "MenuBar.foreground", colorUIResource47, "MenuBar.border", new AquaMenuBarBorder(), "MenuBar.margin", new InsetsUIResource(0, 8, 0, 8), "MenuBar.selectionBackground", colorUIResource49, "MenuBar.selectionForeground", colorUIResource48, "MenuBar.disabledBackground", colorUIResource52, "MenuBar.disabledForeground", colorUIResource51, "MenuBar.backgroundPainter", uIDefaults -> AquaMenuPainter.getMenuBarPainter(), "MenuBar.selectedBackgroundPainter", uIDefaults -> AquaMenuPainter.getSelectedMenuBarItemPainter(), "MenuItem.font", lazyValue13, "MenuItem.acceleratorFont", lazyValue13, "MenuItem.background", colorUIResource46, "MenuItem.foreground", colorUIResource47, "MenuItem.selectionBackground", colorUIResource49, "MenuItem.selectionForeground", colorUIResource48, "MenuItem.disabledBackground", colorUIResource50, "MenuItem.disabledForeground", colorUIResource51, "MenuItem.acceleratorForeground", colorUIResource53, "MenuItem.acceleratorSelectionForeground", colorUIResource54, "MenuItem.acceleratorDelimiter", "", "MenuItem.border", aquaMenuItemBorder, "MenuItem.margin", insetsUIResource2, "MenuItem.borderPainted", Boolean.TRUE, "MenuItem.selectedBackgroundPainter", uIDefaults -> AquaMenuPainter.getSelectedMenuItemPainter(), "OptionPane.font", lazyValue12, "OptionPane.messageFont", lazyValue7, "OptionPane.buttonFont", lazyValue7, "OptionPane.background", color, "OptionPane.foreground", colorUIResource2, "OptionPane.messageForeground", colorUIResource2, "OptionPane.border", new BorderUIResource.EmptyBorderUIResource(12, 21, 17, 21), "OptionPane.messageAreaBorder", emptyBorderUIResource2, "OptionPane.buttonAreaBorder", new BorderUIResource.EmptyBorderUIResource(13, 0, 0, 0), "OptionPane.minimumSize", new DimensionUIResource(262, 90), "OptionPane.errorIcon", lazyValue27, "OptionPane.informationIcon", lazyValue25, "OptionPane.warningIcon", lazyValue26, "OptionPane.questionIcon", lazyValue25, "_SecurityDecisionIcon", lazyValue28, "OptionPane.windowBindings", new Object[]{"ESCAPE", "close"}, "OptionPane.errorSound", null, "OptionPane.informationSound", null, "OptionPane.questionSound", null, "OptionPane.warningSound", null, "OptionPane.buttonClickThreshhold", new Integer(500), "OptionPane.yesButtonMnemonic", "", "OptionPane.noButtonMnemonic", "", "OptionPane.okButtonMnemonic", "", "OptionPane.cancelButtonMnemonic", "", "Panel.font", lazyValue7, "Panel.background", color12, "Panel.foreground", colorUIResource2, "PasswordField.focusInputMap", aquaKeyBindings.getPasswordFieldInputMap(), "PasswordField.font", lazyValue7, "PasswordField.background", colorUIResource26, "PasswordField.foreground", colorUIResource25, "PasswordField.inactiveForeground", colorUIResource24, "PasswordField.inactiveBackground", colorUIResource27, "PasswordField.selectionBackground", color9, "PasswordField.selectionForeground", color8, "PasswordField.caretForeground", colorUIResource25, "PasswordField.caretBlinkRate", 500, "PasswordField.border", lazyValue2, "PasswordField.margin", insetsUIResource, "PasswordField.echoChar", new Character('\u25cf'), "PasswordField.capsLockIconColor", colorUIResource28, "PopupMenu.font", lazyValue13, "PopupMenu.background", colorUIResource35, "PopupMenu.translucentBackground", colorUIResource3, "PopupMenu.foreground", colorUIResource47, "PopupMenu.selectionBackground", colorUIResource49, "PopupMenu.selectionForeground", colorUIResource48, "PopupMenu.border", emptyBorderUIResource4, "ProgressBar.font", lazyValue7, "ProgressBar.foreground", colorUIResource2, "ProgressBar.background", color14, "ProgressBar.selectionForeground", colorUIResource2, "ProgressBar.selectionBackground", colorUIResource3, "ProgressBar.border", new BorderUIResource(BorderFactory.createEmptyBorder()), "ProgressBar.repaintInterval", 30, "ProgressBar.circularRepaintInterval", 70, "RadioButton.background", color14, "RadioButton.foreground", colorUIResource2, "RadioButton.disabledText", colorUIResource7, "RadioButton.select", colorUIResource9, "RadioButton.font", lazyValue7, "RadioButton.margin", new InsetsUIResource(1, 1, 0, 1), "RadioButton.focusInputMap", lazyInputMap, "RadioButtonMenuItem.font", lazyValue13, "RadioButtonMenuItem.acceleratorFont", lazyValue13, "RadioButtonMenuItem.background", colorUIResource46, "RadioButtonMenuItem.foreground", colorUIResource47, "RadioButtonMenuItem.selectionBackground", colorUIResource49, "RadioButtonMenuItem.selectionForeground", colorUIResource48, "RadioButtonMenuItem.disabledBackground", colorUIResource50, "RadioButtonMenuItem.disabledForeground", colorUIResource51, "RadioButtonMenuItem.acceleratorForeground", colorUIResource53, "RadioButtonMenuItem.acceleratorSelectionForeground", colorUIResource54, "RadioButtonMenuItem.acceleratorDelimiter", "", "RadioButtonMenuItem.border", aquaMenuItemBorder, "RadioButtonMenuItem.margin", insetsUIResource2, "RadioButtonMenuItem.borderPainted", Boolean.TRUE, "RadioButtonMenuItem.checkIcon", uIDefaults -> AquaImageFactory.getMenuItemCheckIcon(), "RadioButtonMenuItem.dashIcon", uIDefaults -> AquaImageFactory.getMenuItemDashIcon(), "Separator.background", null, "Separator.foreground", colorUIResource11, "Separator.width", 1, "ScrollBar.border", null, "ScrollBar.focusInputMap", aquaKeyBindings.getScrollBarInputMap(), "ScrollBar.focusInputMap.RightToLeft", aquaKeyBindings.getScrollBarRightToLeftInputMap(), "ScrollBar.width", new Integer(16), "ScrollBar.background", colorUIResource3, "ScrollBar.foreground", colorUIResource2, "ScrollPane.font", lazyValue7, "ScrollPane.background", colorUIResource3, "ScrollPane.foreground", colorUIResource2, "ScrollPane.border", lineBorderUIResource, "ScrollPane.viewportBorder", null, "ScrollPane.ancestorInputMap", aquaKeyBindings.getScrollPaneInputMap(), "ScrollPane.ancestorInputMap.RightToLeft", new UIDefaults.LazyInputMap(new Object[0]), "Viewport.font", lazyValue7, "Viewport.background", colorUIResource3, "Viewport.foreground", colorUIResource2, "Slider.foreground", colorUIResource2, "Slider.background", color14, "Slider.font", lazyValue8, "Slider.tickColor", new ColorUIResource(Color.GRAY), "Slider.border", null, "Slider.focusInsets", new InsetsUIResource(0, 0, 0, 0), "Slider.focusInputMap", aquaKeyBindings.getSliderInputMap(), "Slider.focusInputMap.RightToLeft", aquaKeyBindings.getSliderRightToLeftInputMap(), "Spinner.font", lazyValue7, "Spinner.background", color14, "Spinner.foreground", colorUIResource2, "Spinner.border", null, "Spinner.arrowButtonSize", new Dimension(16, 5), "Spinner.ancestorInputMap", aquaKeyBindings.getSpinnerInputMap(), "Spinner.editorBorderPainted", Boolean.TRUE, "Spinner.editorAlignment", 11, "SplitPane.background", color12, "SplitPane.border", null, "SplitPane.continuousLayout", Boolean.TRUE, "SplitPane.dividerSize", 9, "SplitPane.dividerColor", new ColorUIResource(Color.GRAY), "SplitPaneDivider.border", null, "TabbedPane.font", lazyValue7, "TabbedPane.smallFont", lazyValue8, "TabbedPane.useSmallLayout", Boolean.FALSE, "TabbedPane.background", color13, "TabbedPane.foreground", colorUIResource2, "TabbedPane.textIconGap", new Integer(4), "TabbedPane.tabInsets", new InsetsUIResource(0, 10, 3, 10), "TabbedPane.tabAreaInsets", new InsetsUIResource(3, 9, -1, 9), "TabbedPane.contentBorderInsets", new InsetsUIResource(8, 0, 0, 0), "TabbedPane.selectedTabPadInsets", new InsetsUIResource(0, 0, 0, 0), "TabbedPane.tabsOverlapBorder", Boolean.TRUE, "TabbedPane.selectedTabTitlePressedColor", colorUIResource12, "TabbedPane.selectedTabTitleDisabledColor", colorUIResource13, "TabbedPane.selectedTabTitleNormalColor", colorUIResource14, "TabbedPane.selectedTabTitleInactiveColor", colorUIResource15, "TabbedPane.nonSelectedTabTitlePressedColor", colorUIResource16, "TabbedPane.nonSelectedTabTitleDisabledColor", colorUIResource17, "TabbedPane.nonSelectedTabTitleNormalColor", colorUIResource18, "TabbedPane.nonSelectedTabTitleInactiveColor", colorUIResource19, "TabbedPane.selectedLabelShift", -1, "TabbedPane.labelShift", 1, "TabbedPane.selectionFollowsFocus", true, "Table.font", lazyValue14, "Table.foreground", colorUIResource2, "Table.background", colorUIResource3, "Table.selectionForeground", color3, "Table.selectionBackground", color2, "Table.selectionInactiveBackground", color4, "Table.selectionInactiveForeground", color5, "Table.gridColor", colorUIResource23, "Table.focusCellHighlightBorder", emptyBorderUIResource3, "Table.focusSelectedCellHighlightBorder", emptyBorderUIResource3, "Table.cellFocusNoBorder", emptyBorderUIResource3, "Table.scrollPaneBorder", lineBorderUIResource, "Table.evenRowBackground", colorUIResource3, "Table.oddRowBackground", colorUIResource10, "Table.scrollPaneCornerComponent", new UIDefaults.ActiveValue(){

            @Override
            public Object createValue(UIDefaults uIDefaults) {
                return new AquaTableScrollPaneCorner();
            }
        }, "Table.ancestorInputMap", aquaKeyBindings.getTableInputMap(), "Table.ancestorInputMap.RightToLeft", aquaKeyBindings.getTableRightToLeftInputMap(), "TableHeader.font", lazyValue8, "TableHeader.foreground", colorUIResource2, "TableHeader.background", colorUIResource3, "TableHeader.cellBorder", aquaTableHeaderBorder, "TableHeader.borderHeight", 1, "TableHeader.borderColor", colorUIResource23, "TextArea.focusInputMap", aquaKeyBindings.getMultiLineTextInputMap(), "TextArea.font", lazyValue7, "TextArea.background", colorUIResource26, "TextArea.foreground", colorUIResource25, "TextArea.inactiveForeground", colorUIResource24, "TextArea.inactiveBackground", colorUIResource27, "TextArea.selectionBackground", color9, "TextArea.selectionForeground", color8, "TextArea.caretForeground", colorUIResource25, "TextArea.caretBlinkRate", 500, "TextArea.border", lazyValue3, "TextArea.margin", insetsUIResource, "TextComponent.selectionBackgroundInactive", colorUIResource22, "TextField.focusInputMap", aquaKeyBindings.getTextFieldInputMap(), "TextField.font", lazyValue7, "TextField.background", colorUIResource26, "TextField.foreground", colorUIResource25, "TextField.inactiveForeground", colorUIResource24, "TextField.inactiveBackground", colorUIResource27, "TextField.selectionBackground", color9, "TextField.selectionForeground", color8, "TextField.caretForeground", colorUIResource25, "TextField.caretBlinkRate", 500, "TextField.border", lazyValue2, "TextField.margin", insetsUIResource, "TextPane.focusInputMap", aquaKeyBindings.getMultiLineTextInputMap(), "TextPane.font", lazyValue7, "TextPane.background", colorUIResource26, "TextPane.foreground", colorUIResource25, "TextPane.selectionBackground", color9, "TextPane.selectionForeground", color8, "TextPane.caretForeground", colorUIResource25, "TextPane.caretBlinkRate", 500, "TextPane.inactiveForeground", colorUIResource24, "TextPane.inactiveBackground", colorUIResource27, "TextPane.border", lazyValue3, "TextPane.margin", insetsUIResource3, "ToggleButton.background", color14, "ToggleButton.foreground", colorUIResource2, "ToggleButton.disabledText", colorUIResource7, "ToggleButton.selectedText", Color.WHITE, "ToggleButton.border", uIDefaults -> AquaButtonBorder.getToggleButtonBorder(), "ToggleButton.font", lazyValue7, "ToggleButton.textIconGap", new Integer(4), "ToggleButton.textShiftOffset", 0, "ToggleButton.focusInputMap", lazyInputMap, "ToggleButton.margin", new InsetsUIResource(0, 0, 0, 0), "ToggleButton.opaque", false, "ToolBar.font", lazyValue7, "ToolBar.background", color12, "ToolBar.foreground", new ColorUIResource(Color.gray), "ToolBar.dockingBackground", color12, "ToolBar.dockingForeground", color2, "ToolBar.floatingBackground", color12, "ToolBar.floatingForeground", new ColorUIResource(Color.darkGray), "ToolBar.border", uIDefaults -> AquaToolBarUI.getToolBarBorder(), "ToolBar.borderHandleColor", colorUIResource20, "ToolBar.separatorSize", null, "ToolBar.title.background", colorUIResource21, "ToolTip.font", lazyValue8, "ToolTip.background", colorUIResource, "ToolTip.foreground", colorUIResource2, "ToolTip.border", emptyBorderUIResource, "Tree.font", lazyValue14, "Tree.background", colorUIResource3, "Tree.foreground", colorUIResource2, "Tree.hash", colorUIResource3, "Tree.line", colorUIResource3, "Tree.textForeground", colorUIResource2, "Tree.textBackground", colorUIResource3, "Tree.selectionForeground", color3, "Tree.selectionBackground", color2, "Tree.selectionInactiveBackground", color4, "Tree.selectionInactiveForeground", color5, "Tree.selectionBorderColor", color2, "Tree.editorBorderSelectionColor", null, "Tree.editorBorder", emptyBorderUIResource2, "Tree.leftChildIndent", 8, "Tree.rightChildIndent", 12, "Tree.rowHeight", 19, "Tree.scrollsOnExpand", Boolean.FALSE, "Tree.openIcon", uIDefaults -> AquaImageFactory.getTreeOpenFolderIcon(), "Tree.closedIcon", uIDefaults -> AquaImageFactory.getTreeFolderIcon(), "Tree.leafIcon", uIDefaults -> AquaImageFactory.getTreeDocumentIcon(), "Tree.changeSelectionWithFocus", Boolean.TRUE, "Tree.drawsFocusBorderAroundIcon", Boolean.FALSE, "Tree.evenRowBackground", colorUIResource3, "Tree.oddRowBackground", colorUIResource10, "Tree.sideBar.font", lazyValue15, "Tree.sideBar.selectionFont", lazyValue16, "Tree.sideBarCategory.font", lazyValue17, "Tree.sideBarCategory.selectionFont", lazyValue18, "Tree.sideBar.selectionBackground", colorUIResource36, "Tree.sideBar.selectionInactiveBackground", colorUIResource37, "Tree.sideBar.foreground", colorUIResource38, "Tree.sideBar.inactiveForeground", colorUIResource39, "Tree.sideBar.selectionForeground", colorUIResource40, "Tree.sideBar.selectionInactiveForeground", colorUIResource41, "Tree.sideBarCategory.foreground", colorUIResource42, "Tree.sideBarCategory.selectionForeground", colorUIResource43, "Tree.focusInputMap", aquaKeyBindings.getTreeInputMap(), "Tree.focusInputMap.RightToLeft", aquaKeyBindings.getTreeRightToLeftInputMap(), "Tree.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancel"})};
        uIDefaults2.putDefaults(objectArray);
        AquaUtils.installAATextInfo(uIDefaults2);
    }

    @Override
    protected void initSystemColorDefaults(UIDefaults uIDefaults) {
    }

    @Override
    protected void initClassDefaults(UIDefaults uIDefaults) {
        Object[] objectArray = new Object[]{"ButtonUI", "org.violetlib.aqua.AquaButtonUI", "CheckBoxUI", "org.violetlib.aqua.AquaButtonCheckBoxUI", "CheckBoxMenuItemUI", "com.apple.laf.AquaMenuItemUI", "LabelUI", "org.violetlib.aqua.AquaLabelUI", "ListUI", "org.violetlib.aqua.AquaListUI", "MenuUI", "org.violetlib.aqua.AquaMenuUI", "MenuItemUI", "com.apple.laf.AquaMenuItemUI", "OptionPaneUI", "org.violetlib.aqua.AquaOptionPaneUI", "PanelUI", "org.violetlib.aqua.AquaPanelUI", "RadioButtonMenuItemUI", "com.apple.laf.AquaMenuItemUI", "RadioButtonUI", "org.violetlib.aqua.AquaButtonRadioUI", "ProgressBarUI", "org.violetlib.aqua.AquaProgressBarUI", "RootPaneUI", "org.violetlib.aqua.AquaRootPaneUI", "SliderUI", "org.violetlib.aqua.AquaSliderUI", "ScrollBarUI", "org.violetlib.aqua.AquaScrollBarUI", "TabbedPaneUI", "org.violetlib.aqua.AquaTabbedPaneUI", "TableUI", "org.violetlib.aqua.AquaTableUI", "ToggleButtonUI", "org.violetlib.aqua.AquaButtonToggleUI", "ToolBarUI", "org.violetlib.aqua.AquaToolBarUI", "ToolTipUI", "org.violetlib.aqua.AquaToolTipUI", "TreeUI", "org.violetlib.aqua.AquaTreeUI", "InternalFrameUI", "org.violetlib.aqua.AquaInternalFrameUI", "DesktopIconUI", "org.violetlib.aqua.AquaInternalFrameDockIconUI", "DesktopPaneUI", "org.violetlib.aqua.AquaInternalFramePaneUI", "EditorPaneUI", "org.violetlib.aqua.AquaEditorPaneUI", "TextFieldUI", "org.violetlib.aqua.AquaTextFieldUI", "TextPaneUI", "org.violetlib.aqua.AquaTextPaneUI", "ComboBoxUI", "org.violetlib.aqua.AquaComboBoxUI", "ComboBoxPopupMenuUI", "org.violetlib.aqua.AquaComboBoxPopupMenuUI", "PopupMenuUI", "org.violetlib.aqua.AquaPopupMenuUI", "TextAreaUI", "org.violetlib.aqua.AquaTextAreaUI", "MenuBarUI", "com.apple.laf.AquaMenuBarUI", "FileChooserUI", "org.violetlib.aqua.fc.AquaFileChooserUI", "PasswordFieldUI", "org.violetlib.aqua.AquaTextPasswordFieldUI", "TableHeaderUI", "org.violetlib.aqua.AquaTableHeaderUI", "FormattedTextFieldUI", "org.violetlib.aqua.AquaTextFieldFormattedUI", "SpinnerUI", "org.violetlib.aqua.AquaSpinnerUI", "SplitPaneUI", "org.violetlib.aqua.AquaSplitPaneUI", "ScrollPaneUI", "org.violetlib.aqua.AquaScrollPaneUI", "PopupMenuSeparatorUI", "org.violetlib.aqua.AquaPopupMenuSeparatorUI", "SeparatorUI", "org.violetlib.aqua.AquaSeparatorUI", "ToolBarSeparatorUI", "org.violetlib.aqua.AquaToolBarSeparatorUI", "ColorChooserUI", "javax.swing.plaf.basic.BasicColorChooserUI", "ViewportUI", "org.violetlib.aqua.AquaViewportUI"};
        uIDefaults.putDefaults(objectArray);
    }

    public String getLongDescription() {
        return "VAqua release " + AquaLookAndFeel.getReleaseName() + " (build " + AquaLookAndFeel.getBuildID() + ")";
    }

    @Override
    public String toString() {
        return this.getLongDescription();
    }

    public static String getReleaseName() {
        return AquaLookAndFeel.getStringResource("RELEASE.txt");
    }

    public static String getBuildID() {
        return AquaLookAndFeel.getStringResource("BUILD.txt");
    }

    public static String getVersion() {
        return "VAqua look and feel release " + AquaLookAndFeel.getReleaseName() + ", build " + AquaLookAndFeel.getBuildID() + " using VAquaRendering release " + AquaNativeRendering.getReleaseName() + ", build " + AquaNativeRendering.getBuildID();
    }

    public static void showVersion() {
        System.err.println("VAqua look and feel: release " + AquaLookAndFeel.getReleaseName() + ", build " + AquaLookAndFeel.getBuildID());
        System.err.println("  using VAquaRendering: release " + AquaNativeRendering.getReleaseName() + ", build " + AquaNativeRendering.getBuildID());
    }

    private static String getStringResource(String string) {
        InputStream inputStream = AquaLookAndFeel.class.getResourceAsStream(string);
        if (inputStream != null) {
            try {
                int n;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                StringBuilder stringBuilder = new StringBuilder();
                while ((n = bufferedReader.read()) >= 0) {
                    stringBuilder.append((char)n);
                }
                return stringBuilder.toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return "Unknown";
    }

    protected class MyUIChangeListener
    implements PropertyChangeListener {
        protected MyUIChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object;
            String string = propertyChangeEvent.getPropertyName();
            if ("lookAndFeel".equals(string) && (object = propertyChangeEvent.getNewValue()) == AquaLookAndFeel.this) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AquaLookAndFeel.this.focusRingManager.install();
                    }
                });
            }
        }
    }
}

