/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.RoundRectangle2D;
import java.io.Serializable;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ListUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;
import org.violetlib.aqua.AquaCellEditorPolicy;
import org.violetlib.aqua.AquaComboBoxButton;
import org.violetlib.aqua.AquaComboBoxPopup;
import org.violetlib.aqua.AquaComboBoxRenderer;
import org.violetlib.aqua.AquaComboBoxType;
import org.violetlib.aqua.AquaFullKeyboardFocusableHandler;
import org.violetlib.aqua.AquaListUI;
import org.violetlib.aqua.AquaPainting;
import org.violetlib.aqua.AquaTextFieldUI;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.ClientPropertyApplicator;
import org.violetlib.aqua.FocusRingOutlineProvider;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.aqua.OptionallyFocusableComponentHandler;
import org.violetlib.geom.ExpandableOutline;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.aqua.AbstractComboBoxLayoutConfiguration;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ComboBoxConfiguration;
import org.violetlib.jnr.aqua.ComboBoxLayoutConfiguration;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.LayoutConfiguration;
import org.violetlib.jnr.aqua.PopupButtonLayoutConfiguration;

public class AquaComboBoxUI
extends BasicComboBoxUI
implements AquaUtilControlSize.Sizeable,
FocusRingOutlineProvider {
    public static final String POPDOWN_CLIENT_PROPERTY_KEY = "JComboBox.isPopDown";
    public static final String ISSQUARE_CLIENT_PROPERTY_KEY = "JComboBox.isSquare";
    public static final String STYLE_CLIENT_PROPERTY_KEY = "JComboBox.style";
    public static final String TITLE_CLIENT_PROPERTY_KEY = "JComboBox.title";
    private static AquaUIPainter painter = AquaPainting.create();
    private static AquaCellEditorPolicy cellEditorPolicy = AquaCellEditorPolicy.getInstance();
    private static OptionallyFocusableComponentHandler focusHandler = new MyOptionalFocusHandler();
    private int oldMaximumRowCount;
    protected AquaUIPainter.Size sizeVariant;
    protected Dimension cachedPreferredSize = new Dimension(0, 0);
    protected AquaComboBoxButton arrowButton;
    protected HierarchyListener hierarchyListener;
    private Action highlightNextAction = new ComboBoxAction(){

        @Override
        public void performComboBoxAction(AquaComboBoxUI aquaComboBoxUI) {
            int n = AquaComboBoxUI.this.listBox.getSelectedIndex();
            if (n < AquaComboBoxUI.this.comboBox.getModel().getSize() - 1) {
                AquaComboBoxUI.this.listBox.setSelectedIndex(n + 1);
                AquaComboBoxUI.this.listBox.ensureIndexIsVisible(n + 1);
            }
            AquaComboBoxUI.this.comboBox.repaint();
        }
    };
    private Action highlightPreviousAction = new ComboBoxAction(){

        @Override
        void performComboBoxAction(AquaComboBoxUI aquaComboBoxUI) {
            int n = AquaComboBoxUI.this.listBox.getSelectedIndex();
            if (n > 0) {
                AquaComboBoxUI.this.listBox.setSelectedIndex(n - 1);
                AquaComboBoxUI.this.listBox.ensureIndexIsVisible(n - 1);
            }
            AquaComboBoxUI.this.comboBox.repaint();
        }
    };
    private Action highlightFirstAction = new ComboBoxAction(){

        @Override
        void performComboBoxAction(AquaComboBoxUI aquaComboBoxUI) {
            AquaComboBoxUI.this.listBox.setSelectedIndex(0);
            AquaComboBoxUI.this.listBox.ensureIndexIsVisible(0);
        }
    };
    private Action highlightLastAction = new ComboBoxAction(){

        @Override
        void performComboBoxAction(AquaComboBoxUI aquaComboBoxUI) {
            int n = AquaComboBoxUI.this.listBox.getModel().getSize();
            AquaComboBoxUI.this.listBox.setSelectedIndex(n - 1);
            AquaComboBoxUI.this.listBox.ensureIndexIsVisible(n - 1);
        }
    };
    private Action highlightPageUpAction = new ComboBoxAction(){

        @Override
        void performComboBoxAction(AquaComboBoxUI aquaComboBoxUI) {
            int n;
            int n2 = AquaComboBoxUI.this.listBox.getSelectedIndex();
            if (n2 != (n = AquaComboBoxUI.this.listBox.getFirstVisibleIndex())) {
                AquaComboBoxUI.this.listBox.setSelectedIndex(n);
                return;
            }
            int n3 = ((AquaComboBoxUI)AquaComboBoxUI.this).listBox.getVisibleRect().height / ((AquaComboBoxUI)AquaComboBoxUI.this).listBox.getCellBounds((int)0, (int)0).height;
            int n4 = n - n3;
            if (n4 < 0) {
                n4 = 0;
            }
            AquaComboBoxUI.this.listBox.ensureIndexIsVisible(n4);
            AquaComboBoxUI.this.listBox.setSelectedIndex(n4);
        }
    };
    private Action highlightPageDownAction = new ComboBoxAction(){

        @Override
        void performComboBoxAction(AquaComboBoxUI aquaComboBoxUI) {
            int n;
            int n2 = AquaComboBoxUI.this.listBox.getSelectedIndex();
            if (n2 != (n = AquaComboBoxUI.this.listBox.getLastVisibleIndex())) {
                AquaComboBoxUI.this.listBox.setSelectedIndex(n);
                return;
            }
            int n3 = ((AquaComboBoxUI)AquaComboBoxUI.this).listBox.getVisibleRect().height / ((AquaComboBoxUI)AquaComboBoxUI.this).listBox.getCellBounds((int)0, (int)0).height;
            int n4 = n + n3;
            int n5 = AquaComboBoxUI.this.listBox.getModel().getSize() - 1;
            if (n4 > n5) {
                n4 = n5;
            }
            AquaComboBoxUI.this.listBox.ensureIndexIsVisible(n4);
            AquaComboBoxUI.this.listBox.setSelectedIndex(n4);
        }
    };
    private final Action triggerSelectionAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AquaComboBoxUI.triggerSelectionEvent((JComboBox)actionEvent.getSource(), actionEvent);
        }

        @Override
        public boolean isEnabled() {
            return AquaComboBoxUI.this.comboBox.isPopupVisible() && super.isEnabled();
        }
    };
    private static final Action toggleSelectionAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            if (!jComboBox.isEnabled()) {
                return;
            }
            if (jComboBox.isEditable()) {
                return;
            }
            AquaComboBoxUI aquaComboBoxUI = (AquaComboBoxUI)jComboBox.getUI();
            if (jComboBox.isPopupVisible()) {
                jComboBox.setSelectedIndex(aquaComboBoxUI.getPopup().getList().getSelectedIndex());
                jComboBox.setPopupVisible(false);
                return;
            }
            jComboBox.setPopupVisible(true);
        }
    };
    private final Action hideAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            jComboBox.firePopupMenuCanceled();
            jComboBox.setPopupVisible(false);
        }

        @Override
        public boolean isEnabled() {
            return AquaComboBoxUI.this.comboBox.isPopupVisible() && super.isEnabled();
        }
    };
    static final AquaUtils.RecyclableSingleton<ClientPropertyApplicator<JComboBox<?>, AquaComboBoxUI>> APPLICATOR = new AquaUtils.RecyclableSingleton<ClientPropertyApplicator<JComboBox<?>, AquaComboBoxUI>>(){

        @Override
        protected ClientPropertyApplicator<JComboBox<?>, AquaComboBoxUI> getInstance() {
            return new ClientPropertyApplicator<JComboBox<?>, AquaComboBoxUI>(new ClientPropertyApplicator.Property[]{new ClientPropertyApplicator.Property<AquaComboBoxUI>("Frame.active"){

                @Override
                public void applyProperty(AquaComboBoxUI aquaComboBoxUI, Object object) {
                    if (Boolean.FALSE.equals(object) && aquaComboBoxUI.comboBox != null) {
                        aquaComboBoxUI.comboBox.hidePopup();
                    }
                    if (aquaComboBoxUI.listBox != null) {
                        aquaComboBoxUI.listBox.repaint();
                    }
                    if (aquaComboBoxUI.comboBox != null) {
                        aquaComboBoxUI.comboBox.repaint();
                    }
                }
            }, new ClientPropertyApplicator.Property<AquaComboBoxUI>("editable"){

                @Override
                public void applyProperty(AquaComboBoxUI aquaComboBoxUI, Object object) {
                    aquaComboBoxUI.configure(null);
                }
            }, new ClientPropertyApplicator.Property<AquaComboBoxUI>("background"){

                @Override
                public void applyProperty(AquaComboBoxUI aquaComboBoxUI, Object object) {
                    Color color = (Color)object;
                    if (aquaComboBoxUI.arrowButton != null) {
                        aquaComboBoxUI.arrowButton.setBackground(color);
                    }
                    if (aquaComboBoxUI.listBox != null) {
                        aquaComboBoxUI.listBox.setBackground(color);
                    }
                }
            }, new ClientPropertyApplicator.Property<AquaComboBoxUI>("foreground"){

                @Override
                public void applyProperty(AquaComboBoxUI aquaComboBoxUI, Object object) {
                    Color color = (Color)object;
                    if (aquaComboBoxUI.arrowButton != null) {
                        aquaComboBoxUI.arrowButton.setForeground(color);
                    }
                    if (aquaComboBoxUI.listBox != null) {
                        aquaComboBoxUI.listBox.setForeground(color);
                    }
                }
            }, new ClientPropertyApplicator.Property<AquaComboBoxUI>(AquaComboBoxUI.POPDOWN_CLIENT_PROPERTY_KEY){

                @Override
                public void applyProperty(AquaComboBoxUI aquaComboBoxUI, Object object) {
                    aquaComboBoxUI.configure(null);
                }
            }, new ClientPropertyApplicator.Property<AquaComboBoxUI>(AquaComboBoxUI.ISSQUARE_CLIENT_PROPERTY_KEY){

                @Override
                public void applyProperty(AquaComboBoxUI aquaComboBoxUI, Object object) {
                    aquaComboBoxUI.configure(null);
                }
            }, new ClientPropertyApplicator.Property<AquaComboBoxUI>(AquaComboBoxUI.STYLE_CLIENT_PROPERTY_KEY){

                @Override
                public void applyProperty(AquaComboBoxUI aquaComboBoxUI, Object object) {
                    aquaComboBoxUI.configure(null);
                }
            }, new ClientPropertyApplicator.Property<AquaComboBoxUI>(AquaComboBoxUI.TITLE_CLIENT_PROPERTY_KEY){

                @Override
                public void applyProperty(AquaComboBoxUI aquaComboBoxUI, Object object) {
                    AquaComboBoxType aquaComboBoxType;
                    if (aquaComboBoxUI.comboBox != null && (aquaComboBoxType = AquaComboBoxUI.getComboBoxType(aquaComboBoxUI.comboBox)) == AquaComboBoxType.PULL_DOWN_MENU_BUTTON) {
                        aquaComboBoxUI.comboBox.setPrototypeDisplayValue(object);
                        aquaComboBoxUI.comboBox.repaint();
                    }
                }
            }}){

                @Override
                public AquaComboBoxUI convertJComponentToTarget(JComboBox<?> jComboBox) {
                    ComboBoxUI comboBoxUI = jComboBox.getUI();
                    if (comboBoxUI instanceof AquaComboBoxUI) {
                        return (AquaComboBoxUI)comboBoxUI;
                    }
                    return null;
                }
            };
        }
    };

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaComboBoxUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        LookAndFeel.installProperty(jComponent, "opaque", false);
        this.oldMaximumRowCount = this.comboBox.getMaximumRowCount();
        int n = UIManager.getInt("ComboBox.maximumRowCount");
        if (n > 0) {
            this.comboBox.setMaximumRowCount(n);
        }
        this.comboBox.setRequestFocusEnabled(false);
        this.configure(null);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.comboBox.setMaximumRowCount(this.oldMaximumRowCount);
        super.uninstallUI(jComponent);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        AquaUtilControlSize.addSizePropertyListener(this.comboBox);
        this.comboBox.putClientProperty("Aqua.optionalFocusabilityHandler", focusHandler);
        AquaFullKeyboardFocusableHandler.addListener(this.comboBox);
        this.hierarchyListener = new MyHierarchyListener();
        this.comboBox.addHierarchyListener(this.hierarchyListener);
    }

    @Override
    protected void uninstallListeners() {
        this.comboBox.removeHierarchyListener(this.hierarchyListener);
        this.hierarchyListener = null;
        AquaUtilControlSize.removeSizePropertyListener(this.comboBox);
        AquaFullKeyboardFocusableHandler.removeListener(this.comboBox);
        super.uninstallListeners();
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        AquaComboBoxUI.getApplicator().attachAndApplyClientProperties(this.comboBox);
    }

    @Override
    protected void uninstallComponents() {
        AquaComboBoxUI.getApplicator().removeFrom(this.comboBox);
        super.uninstallComponents();
    }

    @Override
    protected ItemListener createItemListener() {
        return new ItemListener(){
            long lastBlink = 0L;

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() != 1) {
                    return;
                }
                if (!AquaComboBoxUI.this.popup.isVisible()) {
                    return;
                }
                long l = System.currentTimeMillis();
                if (l - 1000L < this.lastBlink) {
                    return;
                }
                this.lastBlink = l;
                JList<Object> jList = AquaComboBoxUI.this.popup.getList();
                ListUI listUI = jList.getUI();
                if (!(listUI instanceof AquaListUI)) {
                    return;
                }
                final AquaListUI aquaListUI = (AquaListUI)listUI;
                final int n = AquaComboBoxUI.this.comboBox.getSelectedIndex();
                ListModel<Object> listModel = jList.getModel();
                if (listModel == null) {
                    return;
                }
                final Object object = listModel.getElementAt(n);
                AquaUtils.blinkMenu(new AquaUtils.Selectable(){

                    @Override
                    public void paintSelected(boolean bl) {
                        aquaListUI.repaintCell(object, n, bl);
                    }
                });
            }
        };
    }

    @Override
    public void addEditor() {
        super.addEditor();
        this.isMinimumSizeDirty = true;
    }

    @Override
    public void removeEditor() {
        super.removeEditor();
        this.isMinimumSizeDirty = true;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        boolean bl = this.comboBox.isEditable();
        boolean bl2 = cellEditorPolicy.isCellEditor(this.comboBox);
        if (bl2) {
            Component component = this.comboBox.getEditor().getEditorComponent();
            component.setForeground(jComponent.getForeground());
        } else if (bl && this.arrowButton != null) {
            Configuration configuration = this.arrowButton.getConfiguration();
            painter.configure(jComponent.getWidth(), jComponent.getHeight());
            painter.getPainter(configuration).paint(graphics, 0.0f, 0.0f);
        }
    }

    protected AbstractComboBoxLayoutConfiguration getLayoutConfiguration() {
        return this.arrowButton != null ? this.arrowButton.getLayoutConfiguration() : null;
    }

    @Override
    public Shape getFocusRingOutline(JComponent jComponent) {
        AbstractComboBoxLayoutConfiguration abstractComboBoxLayoutConfiguration = this.getLayoutConfiguration();
        if (abstractComboBoxLayoutConfiguration != null) {
            painter.configure(jComponent.getWidth(), jComponent.getHeight());
            return painter.getOutline(abstractComboBoxLayoutConfiguration);
        }
        return null;
    }

    public void paintValue(Graphics graphics) {
        Serializable serializable;
        ListCellRenderer<Object> listCellRenderer = this.comboBox.getRenderer();
        Object object = null;
        AquaComboBoxType aquaComboBoxType = AquaComboBoxUI.getComboBoxType(this.comboBox);
        if (aquaComboBoxType == AquaComboBoxType.PULL_DOWN_MENU_BUTTON) {
            Object object2 = this.comboBox.getClientProperty(TITLE_CLIENT_PROPERTY_KEY);
            if (object2 != null) {
                if (object2 instanceof Icon) {
                    object2 = this.arrowButton.getIcon((Icon)object2);
                }
                object = object2;
            }
        } else {
            object = this.comboBox.getSelectedItem();
        }
        int n = 0;
        int n2 = 0;
        int n3 = this.comboBox.getWidth();
        int n4 = this.comboBox.getHeight();
        AbstractComboBoxLayoutConfiguration abstractComboBoxLayoutConfiguration = this.getLayoutConfiguration();
        if (abstractComboBoxLayoutConfiguration != null && (serializable = this.getContentBounds(abstractComboBoxLayoutConfiguration)) != null) {
            n2 = ((Rectangle)serializable).x;
            n = ((Rectangle)serializable).y;
            n3 = ((Rectangle)serializable).width;
            n4 = ((Rectangle)serializable).height;
        }
        if (this.padding != null) {
            n2 += this.padding.left;
            n += this.padding.top;
            n3 -= this.padding.left;
            n4 -= this.padding.top;
        }
        serializable = listCellRenderer.getListCellRendererComponent(this.listBox, object, -1, false, false);
        ((Component)serializable).setFont(this.currentValuePane.getFont());
        Color color = this.arrowButton.getForeground();
        ((Component)serializable).setForeground(color);
        boolean bl = false;
        if (serializable instanceof JPanel) {
            bl = true;
        }
        Color color2 = ((Component)serializable).getBackground();
        ((Component)serializable).setBackground(new Color(0, 0, 0, 0));
        this.currentValuePane.paintComponent(graphics, (Component)serializable, this.comboBox, n2, n, n3, n4, bl);
        ((Component)serializable).setBackground(color2);
    }

    protected Rectangle getContentBounds(LayoutConfiguration layoutConfiguration) {
        painter.configure(this.comboBox.getWidth(), this.comboBox.getHeight());
        if (layoutConfiguration instanceof ComboBoxLayoutConfiguration) {
            return AquaUtils.toMinimumRectangle(painter.getComboBoxEditorBounds((ComboBoxLayoutConfiguration)layoutConfiguration));
        }
        if (layoutConfiguration instanceof PopupButtonLayoutConfiguration) {
            return AquaUtils.toMinimumRectangle(painter.getPopupButtonContentBounds((PopupButtonLayoutConfiguration)layoutConfiguration));
        }
        return null;
    }

    protected Insetter getContentInsets(LayoutConfiguration layoutConfiguration) {
        if (layoutConfiguration instanceof ComboBoxLayoutConfiguration) {
            return painter.getLayoutInfo().getComboBoxEditorInsets((ComboBoxLayoutConfiguration)layoutConfiguration);
        }
        if (layoutConfiguration instanceof PopupButtonLayoutConfiguration) {
            return painter.getLayoutInfo().getPopupButtonContentInsets((PopupButtonLayoutConfiguration)layoutConfiguration);
        }
        return null;
    }

    @Override
    protected ListCellRenderer<Object> createRenderer() {
        return new AquaComboBoxRenderer(this.comboBox);
    }

    @Override
    protected ComboPopup createPopup() {
        return new AquaComboBoxPopup(this.comboBox);
    }

    @Override
    protected JButton createArrowButton() {
        this.arrowButton = new AquaComboBoxButton(this, this.comboBox, this.currentValuePane, this.listBox);
        return this.arrowButton;
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new AquaComboBoxEditor();
    }

    @Override
    protected void configureEditor() {
        super.configureEditor();
        this.comboBox.setFocusable(true);
        if (this.editor instanceof JTextField && !(this.editor instanceof AquaCustomComboTextField)) {
            JTextField jTextField = (JTextField)this.editor;
            jTextField.setUI(new AquaComboBoxEditorUI());
            jTextField.setBorder(null);
        }
    }

    @Override
    protected void unconfigureEditor() {
        super.unconfigureEditor();
        if (!this.comboBox.isEditable()) {
            this.comboBox.setFocusable(OSXSystemProperties.isFullKeyboardAccessEnabled());
        }
    }

    public boolean updateListSelectionFromEditor() {
        if (this.editor instanceof JTextField) {
            JTextField jTextField = (JTextField)this.editor;
            this.updateListSelectionFromEditor(jTextField);
            return true;
        }
        return false;
    }

    protected void updateListSelectionFromEditor(JTextField jTextField) {
        String string = jTextField.getText();
        ListModel listModel = this.listBox.getModel();
        int n = listModel.getSize();
        for (int i = 0; i < n; ++i) {
            String string2;
            Object e = listModel.getElementAt(i);
            if (e == null || (string2 = e.toString()) == null || !string2.equals(string)) continue;
            this.popup.getList().setSelectedIndex(i);
            return;
        }
        this.popup.getList().clearSelection();
    }

    @Override
    protected FocusListener createFocusListener() {
        return new BasicComboBoxUI.FocusHandler(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                AquaComboBoxUI.this.hasFocus = false;
                if (!focusEvent.isTemporary()) {
                    AquaComboBoxUI.this.setPopupVisible(AquaComboBoxUI.this.comboBox, false);
                }
                AquaComboBoxUI.this.comboBox.repaint();
                AccessibleContext accessibleContext = AquaComboBoxUI.this.comboBox.getAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
                }
            }
        };
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("aquaSelectNext", this.highlightNextAction);
        actionMapUIResource.put("aquaSelectPrevious", this.highlightPreviousAction);
        actionMapUIResource.put("enterPressed", this.triggerSelectionAction);
        actionMapUIResource.put("aquaSpacePressed", toggleSelectionAction);
        actionMapUIResource.put("aquaSelectHome", this.highlightFirstAction);
        actionMapUIResource.put("aquaSelectEnd", this.highlightLastAction);
        actionMapUIResource.put("aquaSelectPageUp", this.highlightPageUpAction);
        actionMapUIResource.put("aquaSelectPageDown", this.highlightPageDownAction);
        actionMapUIResource.put("aquaHidePopup", this.hideAction);
        SwingUtilities.replaceUIActionMap(this.comboBox, actionMapUIResource);
    }

    public ComboPopup getPopup() {
        return this.popup;
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new AquaComboBoxLayoutManager();
    }

    public static AquaComboBoxType getComboBoxType(JComboBox<?> jComboBox) {
        if (jComboBox.isEditable()) {
            return AquaComboBoxType.EDITABLE_COMBO_BOX;
        }
        if (Boolean.TRUE.equals(jComboBox.getClientProperty(POPDOWN_CLIENT_PROPERTY_KEY))) {
            return AquaComboBoxType.PULL_DOWN_MENU_BUTTON;
        }
        return AquaComboBoxType.POP_UP_MENU_BUTTON;
    }

    protected static void triggerSelectionEvent(JComboBox<?> jComboBox, ActionEvent actionEvent) {
        if (!jComboBox.isEnabled()) {
            return;
        }
        AquaComboBoxUI aquaComboBoxUI = (AquaComboBoxUI)jComboBox.getUI();
        if (aquaComboBoxUI.getPopup().getList().getSelectedIndex() < 0) {
            jComboBox.setPopupVisible(false);
        }
        if (cellEditorPolicy.isCellEditor(jComboBox)) {
            jComboBox.setSelectedItem(jComboBox.getSelectedItem());
            return;
        }
        if (jComboBox.isPopupVisible()) {
            jComboBox.setSelectedIndex(aquaComboBoxUI.getPopup().getList().getSelectedIndex());
            jComboBox.setPopupVisible(false);
            return;
        }
        JRootPane jRootPane = SwingUtilities.getRootPane(jComboBox);
        if (jRootPane == null) {
            return;
        }
        InputMap inputMap = jRootPane.getInputMap(2);
        ActionMap actionMap = jRootPane.getActionMap();
        if (inputMap == null || actionMap == null) {
            return;
        }
        Object object = inputMap.get(KeyStroke.getKeyStroke(10, 0));
        if (object == null) {
            return;
        }
        Action action = actionMap.get(object);
        if (action == null) {
            return;
        }
        action.actionPerformed(new ActionEvent(jRootPane, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getWhen(), actionEvent.getModifiers()));
    }

    @Override
    public void applySizeFor(JComponent jComponent, AquaUIPainter.Size size, boolean bl) {
        this.sizeVariant = size;
        if (bl) {
            size = this.determineDefaultSize(size);
        }
        this.configure(size);
    }

    public AquaUIPainter.Size getSizeVariant() {
        AbstractComboBoxLayoutConfiguration abstractComboBoxLayoutConfiguration;
        if (this.sizeVariant == null) {
            return AquaUIPainter.Size.REGULAR;
        }
        if (this.sizeVariant != AquaUIPainter.Size.REGULAR && (abstractComboBoxLayoutConfiguration = this.getLayoutConfiguration()) != null) {
            AquaUIPainter.PopupButtonWidget popupButtonWidget;
            AquaUIPainter.Size size = abstractComboBoxLayoutConfiguration.getSize();
            if (size == AquaUIPainter.Size.MINI && ((popupButtonWidget = this.getPopupButtonWidget()) == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_SQUARE || popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_SQUARE || popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_CELL || popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_CELL)) {
                size = AquaUIPainter.Size.SMALL;
            }
            return size;
        }
        return this.sizeVariant;
    }

    protected AquaUIPainter.Size determineDefaultSize(AquaUIPainter.Size size) {
        if (size == AquaUIPainter.Size.REGULAR && cellEditorPolicy.isCellEditor(this.comboBox) && this.comboBox.getHeight() < 16) {
            return AquaUIPainter.Size.SMALL;
        }
        return size;
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        if (this.isMinimumSizeDirty) {
            this.calculateLayoutSizes();
        }
        return new Dimension(this.cachedMinimumSize);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        if (this.isMinimumSizeDirty) {
            this.calculateLayoutSizes();
        }
        return new Dimension(this.cachedPreferredSize);
    }

    protected void calculateLayoutSizes() {
        Cloneable cloneable;
        int n;
        AbstractComboBoxLayoutConfiguration abstractComboBoxLayoutConfiguration = this.getLayoutConfiguration();
        LayoutInfo layoutInfo = painter.getLayoutInfo().getLayoutInfo(abstractComboBoxLayoutConfiguration);
        int n2 = n = (int)layoutInfo.getFixedVisualHeight();
        int n3 = n;
        Dimension dimension = null;
        if (this.arrowButton != null) {
            Insetter insetter;
            if (abstractComboBoxLayoutConfiguration.isCell()) {
                n3 += 6;
            }
            if ((insetter = this.getContentInsets(abstractComboBoxLayoutConfiguration)) != null) {
                cloneable = this.getDisplaySize();
                dimension = insetter.expand((Dimension)cloneable);
            }
        }
        if (dimension == null) {
            boolean bl = this.comboBox.isEditable();
            if (bl && this.arrowButton != null && this.editor != null) {
                dimension = super.getMinimumSize(this.comboBox);
                cloneable = this.arrowButton.getMargin();
                dimension.height += ((Insets)cloneable).top + ((Insets)cloneable).bottom;
            } else {
                dimension = super.getMinimumSize(this.comboBox);
            }
        }
        if (dimension.height > n2) {
            n2 = dimension.height;
        }
        if (dimension.height > n3) {
            n3 = dimension.height;
        }
        this.cachedMinimumSize.setSize(dimension.width, n2);
        this.cachedPreferredSize.setSize(dimension.width, n3);
        this.isMinimumSizeDirty = false;
    }

    @Override
    protected Dimension getDefaultSize() {
        DefaultListCellRenderer defaultListCellRenderer = this.comboBox.getRenderer();
        if (defaultListCellRenderer == null) {
            defaultListCellRenderer = new DefaultListCellRenderer();
        }
        Dimension dimension = this.getSizeForComponent(defaultListCellRenderer.getListCellRendererComponent(this.listBox, " ", -1, false, false));
        return new Dimension(dimension.width, dimension.height);
    }

    protected void configure(AquaUIPainter.Size size) {
        if (this.arrowButton != null) {
            this.arrowButton.configure(size);
        } else if (this.comboBox != null) {
            this.comboBox.repaint();
        }
    }

    public Point getPopupButtonLabelOffset() {
        int n = 0;
        int n2 = 0;
        AquaComboBoxType aquaComboBoxType = AquaComboBoxUI.getComboBoxType(this.comboBox);
        if (aquaComboBoxType == AquaComboBoxType.POP_UP_MENU_BUTTON) {
            n -= 8;
            n2 = 1;
            AquaUIPainter.PopupButtonWidget popupButtonWidget = this.getPopupButtonWidget();
            if (popupButtonWidget != AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP) {
                n -= 2;
                n2 = 2;
            }
        }
        return n != 0 || n2 != 0 ? new Point(n, n2) : null;
    }

    public AquaUIPainter.PopupButtonWidget getPopupButtonWidget() {
        AbstractComboBoxLayoutConfiguration abstractComboBoxLayoutConfiguration = this.getLayoutConfiguration();
        if (abstractComboBoxLayoutConfiguration instanceof PopupButtonLayoutConfiguration) {
            PopupButtonLayoutConfiguration popupButtonLayoutConfiguration = (PopupButtonLayoutConfiguration)abstractComboBoxLayoutConfiguration;
            return popupButtonLayoutConfiguration.getPopupButtonWidget();
        }
        return null;
    }

    static ClientPropertyApplicator<JComboBox<?>, AquaComboBoxUI> getApplicator() {
        return APPLICATOR.get();
    }

    class AquaComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        AquaComboBoxLayoutManager() {
            super(AquaComboBoxUI.this);
        }

        @Override
        public void layoutContainer(Container container) {
            int n = AquaComboBoxUI.this.comboBox.getWidth();
            int n2 = AquaComboBoxUI.this.comboBox.getHeight();
            if (AquaComboBoxUI.this.comboBox.isEditable()) {
                Rectangle rectangle;
                ComboBoxConfiguration comboBoxConfiguration = (ComboBoxConfiguration)AquaComboBoxUI.this.arrowButton.getConfiguration();
                painter.configure(n, n2);
                if (AquaComboBoxUI.this.editor != null) {
                    rectangle = AquaUtils.toMinimumRectangle(painter.getComboBoxEditorBounds(comboBoxConfiguration));
                    AquaComboBoxUI.this.editor.setBounds(rectangle);
                }
                if (AquaComboBoxUI.this.arrowButton != null) {
                    rectangle = AquaUtils.toMinimumRectangle(painter.getComboBoxIndicatorBounds(comboBoxConfiguration));
                    AquaComboBoxUI.this.arrowButton.setBounds(rectangle);
                }
            } else {
                AquaComboBoxUI.this.arrowButton.setBounds(0, 0, n, n2);
            }
        }
    }

    private abstract class ComboBoxAction
    extends AbstractAction {
        private ComboBoxAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!AquaComboBoxUI.this.comboBox.isEnabled() || !AquaComboBoxUI.this.comboBox.isShowing()) {
                return;
            }
            if (AquaComboBoxUI.this.comboBox.isPopupVisible()) {
                AquaComboBoxUI aquaComboBoxUI = (AquaComboBoxUI)AquaComboBoxUI.this.comboBox.getUI();
                this.performComboBoxAction(aquaComboBoxUI);
            } else {
                AquaComboBoxUI.this.comboBox.setPopupVisible(true);
            }
        }

        abstract void performComboBoxAction(AquaComboBoxUI var1);
    }

    class AquaCustomComboTextField
    extends JTextField {
        public AquaCustomComboTextField() {
            this.setUI(new AquaComboBoxEditorUI());
            this.setBorder(null);
            InputMap inputMap = this.getInputMap();
            inputMap.put(KeyStroke.getKeyStroke("DOWN"), AquaComboBoxUI.this.highlightNextAction);
            inputMap.put(KeyStroke.getKeyStroke("KP_DOWN"), AquaComboBoxUI.this.highlightNextAction);
            inputMap.put(KeyStroke.getKeyStroke("UP"), AquaComboBoxUI.this.highlightPreviousAction);
            inputMap.put(KeyStroke.getKeyStroke("KP_UP"), AquaComboBoxUI.this.highlightPreviousAction);
            inputMap.put(KeyStroke.getKeyStroke("HOME"), AquaComboBoxUI.this.highlightFirstAction);
            inputMap.put(KeyStroke.getKeyStroke("END"), AquaComboBoxUI.this.highlightLastAction);
            inputMap.put(KeyStroke.getKeyStroke("PAGE_UP"), AquaComboBoxUI.this.highlightPageUpAction);
            inputMap.put(KeyStroke.getKeyStroke("PAGE_DOWN"), AquaComboBoxUI.this.highlightPageDownAction);
            final Action action = this.getActionMap().get("notify-field-accept");
            inputMap.put(KeyStroke.getKeyStroke("ENTER"), new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AquaComboBoxUI.this.popup.isVisible()) {
                        AquaComboBoxUI.triggerSelectionEvent(AquaComboBoxUI.this.comboBox, actionEvent);
                        if (AquaComboBoxUI.this.editor instanceof AquaCustomComboTextField) {
                            ((AquaCustomComboTextField)AquaComboBoxUI.this.editor).selectAll();
                        }
                    } else {
                        action.actionPerformed(actionEvent);
                    }
                }
            });
        }

        public void configure(AquaUIPainter.ComboBoxWidget comboBoxWidget) {
            if (comboBoxWidget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL) {
                this.setBackground(Color.WHITE);
                this.setOpaque(true);
            } else {
                this.setBackground(new Color(0, 0, 0, 0));
                this.setOpaque(false);
            }
        }

        @Override
        public void setText(String string) {
            if (this.getText().equals(string)) {
                return;
            }
            super.setText(string);
        }
    }

    final class AquaComboBoxEditor
    extends BasicComboBoxEditor
    implements UIResource,
    DocumentListener {
        AquaComboBoxEditor() {
            this.editor.addFocusListener(this);
            this.editor.getDocument().addDocumentListener(this);
        }

        public void configure(AquaUIPainter.ComboBoxWidget comboBoxWidget) {
            if (this.editor instanceof AquaCustomComboTextField) {
                AquaCustomComboTextField aquaCustomComboTextField = (AquaCustomComboTextField)this.editor;
                aquaCustomComboTextField.configure(comboBoxWidget);
            }
        }

        @Override
        protected JTextField createEditorComponent() {
            return new AquaCustomComboTextField();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (AquaComboBoxUI.this.arrowButton != null) {
                AquaComboBoxUI.this.arrowButton.repaint();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (AquaComboBoxUI.this.arrowButton != null) {
                AquaComboBoxUI.this.arrowButton.repaint();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.editorTextChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.editorTextChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.editorTextChanged();
        }

        private void editorTextChanged() {
            if (AquaComboBoxUI.this.popup.isVisible()) {
                AquaComboBoxUI.this.updateListSelectionFromEditor(this.editor);
            }
        }
    }

    final class AquaComboBoxEditorUI
    extends AquaTextFieldUI
    implements FocusRingOutlineProvider {
        AquaComboBoxEditorUI() {
        }

        @Override
        protected void installDefaults() {
            super.installDefaults();
            JTextComponent jTextComponent = this.getComponent();
            LookAndFeel.installProperty(jTextComponent, "opaque", true);
            Border border = jTextComponent.getBorder();
            if (border == null || border instanceof UIDefaults) {
                jTextComponent.setBorder(null);
            }
        }

        @Override
        protected void paintBackgroundSafely(Graphics graphics) {
            AquaUIPainter.ComboBoxWidget comboBoxWidget;
            ComboBoxConfiguration comboBoxConfiguration;
            if (AquaComboBoxUI.this.comboBox.getParent() instanceof CellRendererPane) {
                return;
            }
            if (AquaComboBoxUI.this.arrowButton != null && (comboBoxConfiguration = (ComboBoxConfiguration)AquaComboBoxUI.this.arrowButton.getConfiguration()).getState() == AquaUIPainter.State.INACTIVE && ((comboBoxWidget = comboBoxConfiguration.getWidget()) == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED || comboBoxWidget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED_TOOLBAR)) {
                int n = this.editor.getWidth();
                int n2 = this.editor.getHeight();
                Color color = new Color(245, 245, 245);
                graphics.setColor(color);
                graphics.fillRect(0, 0, n, n2);
                return;
            }
            super.paintBackgroundSafely(graphics);
        }

        @Override
        public Shape getFocusRingOutline(JComponent jComponent) {
            Container container = jComponent.getParent();
            if (container instanceof JComboBox) {
                JComboBox jComboBox = (JComboBox)container;
                AquaComboBoxUI aquaComboBoxUI = AquaUtils.getUI(jComboBox, AquaComboBoxUI.class);
                if (aquaComboBoxUI != null) {
                    Shape shape = aquaComboBoxUI.getFocusRingOutline(jComboBox);
                    Rectangle rectangle = jComponent.getBounds();
                    return ExpandableOutline.createTranslatedShape(shape, -rectangle.x, -rectangle.y);
                }
                int n = jComboBox.getWidth();
                int n2 = jComboBox.getHeight();
                Rectangle rectangle = jComponent.getBounds();
                int n3 = -rectangle.x;
                int n4 = -rectangle.y;
                return new RoundRectangle2D.Double((float)n3 + 0.0f, (float)n4 + 0.0f, (float)n - 0.0f, (float)n2 - 0.0f, 9.0, 9.0);
            }
            return null;
        }
    }

    private static class MyOptionalFocusHandler
    implements OptionallyFocusableComponentHandler {
        private MyOptionalFocusHandler() {
        }

        @Override
        public void updateFocusability(JComponent jComponent, boolean bl) {
            JComboBox jComboBox = (JComboBox)jComponent;
            if (!jComboBox.isEditable()) {
                jComboBox.setFocusable(bl);
            }
        }
    }

    private class MyHierarchyListener
    implements HierarchyListener {
        private MyHierarchyListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            AquaComboBoxUI aquaComboBoxUI = AquaUtils.getUI(AquaComboBoxUI.this.comboBox, AquaComboBoxUI.class);
            if (aquaComboBoxUI != null) {
                aquaComboBoxUI.configure(null);
            }
        }
    }
}

