/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Shape;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.plaf.UIResource;
import org.violetlib.aqua.AquaBorder;
import org.violetlib.aqua.AquaButtonExtendedTypes;
import org.violetlib.aqua.AquaButtonIcon;
import org.violetlib.aqua.AquaButtonUI;
import org.violetlib.aqua.AquaDisclosureButtonBorder;
import org.violetlib.aqua.AquaDisclosureTriangleButtonBorder;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaIcon;
import org.violetlib.aqua.AquaIconToggleButtonBorder;
import org.violetlib.aqua.AquaPushButtonBorder;
import org.violetlib.aqua.AquaToggleButtonBorder;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.BackgroundPainter;
import org.violetlib.aqua.FocusRingOutlineProvider;
import org.violetlib.aqua.fc.EmptyIcon;
import org.violetlib.jnr.Insets2D;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.aqua.ButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.LayoutConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonLayoutConfiguration;

public abstract class AquaButtonBorder
extends AquaBorder
implements BackgroundPainter,
FocusRingOutlineProvider {
    public static final AquaUtils.RecyclableSingleton<AquaPushButtonBorder> fPush = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaPushButtonBorder>(AquaPushButtonBorder.class);
    private static final AquaUtils.RecyclableSingleton<AquaToggleButtonBorder> fToggle = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaToggleButtonBorder>(AquaToggleButtonBorder.class);
    private static final AquaUtils.RecyclableSingleton<AquaIconToggleButtonBorder> fIconToggle = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaIconToggleButtonBorder>(AquaIconToggleButtonBorder.class);
    public static final AquaUtils.RecyclableSingleton<AquaDisclosureTriangleButtonBorder> fDisclosureTriangle = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaDisclosureTriangleButtonBorder>(AquaDisclosureTriangleButtonBorder.class);
    public static final AquaUtils.RecyclableSingleton<AquaDisclosureButtonBorder> fDisclosure = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaDisclosureButtonBorder>(AquaDisclosureButtonBorder.class);
    protected static final Icon regularToolbarSizingIcon = new EmptyIcon(32, 32);
    protected static final Icon smallToolbarSizingIcon = new EmptyIcon(24, 24);

    public static AquaButtonBorder getPushButtonBorder() {
        return fPush.get();
    }

    public static AquaButtonBorder getToggleButtonBorder() {
        return fToggle.get();
    }

    public static AquaButtonBorder getIconToggleButtonBorder() {
        return fIconToggle.get();
    }

    public static AquaButtonBorder getToolBarPushButtonBorder() {
        return fPush.get();
    }

    public static AquaButtonBorder getToolBarToggleButtonBorder() {
        return fToggle.get();
    }

    public static AquaButtonBorder getDisclosureTriangleButtonBorder() {
        return fDisclosureTriangle.get();
    }

    public static AquaButtonBorder getDisclosureButtonBorder() {
        return fDisclosure.get();
    }

    protected AquaButtonBorder() {
    }

    @Override
    public final void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    @Override
    public final void paintBackground(JComponent jComponent, Graphics graphics, int n, int n2, int n3, int n4) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        this.doButtonPaint(abstractButton, graphics, n, n2, n3, n4);
    }

    protected void doButtonPaint(AbstractButton abstractButton, Graphics graphics, int n, int n2, int n3, int n4) {
        Configuration configuration = this.getConfiguration(abstractButton, n3, n4);
        if (configuration != null) {
            Object object;
            if (configuration instanceof ButtonConfiguration && ((ButtonLayoutConfiguration)(object = (ButtonConfiguration)configuration)).getButtonWidget() == AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL) {
                Color color = abstractButton.getBackground();
                graphics.setColor(color);
                graphics.fillRect(n + 4, n2 + 4, n3 - 8, n4 - 8);
            }
            this.painter.configure(n3, n4);
            object = this.painter.getPainter(configuration);
            object.paint(graphics, n, n2);
        }
    }

    protected AquaUIPainter.State getState(AbstractButton abstractButton) {
        boolean bl = AquaFocusHandler.isActive(abstractButton);
        if (!abstractButton.isEnabled()) {
            return bl ? AquaUIPainter.State.DISABLED : AquaUIPainter.State.DISABLED_INACTIVE;
        }
        if (!bl) {
            return AquaUIPainter.State.INACTIVE;
        }
        ButtonModel buttonModel = abstractButton.getModel();
        if (buttonModel.isArmed() && buttonModel.isPressed()) {
            return AquaUIPainter.State.PRESSED;
        }
        if (buttonModel.isRollover()) {
            return AquaUIPainter.State.ROLLOVER;
        }
        if (abstractButton instanceof JButton && ((JButton)abstractButton).isDefaultButton()) {
            return AquaUIPainter.State.ACTIVE_DEFAULT;
        }
        return AquaUIPainter.State.ACTIVE;
    }

    public boolean allowsContent() {
        return true;
    }

    public boolean isRolloverEnabled(AbstractButton abstractButton) {
        AquaButtonExtendedTypes.WidgetInfo widgetInfo = this.getWidgetInfo(abstractButton);
        return widgetInfo != null && widgetInfo.isRolloverEnabled();
    }

    public Font getCustomDefaultFont(AbstractButton abstractButton, AquaUIPainter.Size size, Font font) {
        LayoutConfiguration layoutConfiguration = this.getLayoutConfiguration(abstractButton);
        if (layoutConfiguration instanceof ButtonLayoutConfiguration) {
            ButtonLayoutConfiguration buttonLayoutConfiguration = (ButtonLayoutConfiguration)layoutConfiguration;
            AquaUIPainter.ButtonWidget buttonWidget = buttonLayoutConfiguration.getButtonWidget();
            return AquaButtonExtendedTypes.getFont(font, (Object)buttonWidget, size);
        }
        if (layoutConfiguration instanceof SegmentedButtonLayoutConfiguration) {
            SegmentedButtonLayoutConfiguration segmentedButtonLayoutConfiguration = (SegmentedButtonLayoutConfiguration)layoutConfiguration;
            AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget = segmentedButtonLayoutConfiguration.getWidget();
            return AquaButtonExtendedTypes.getFont(font, (Object)segmentedButtonWidget, size);
        }
        return font;
    }

    public Color getForegroundColor(AbstractButton abstractButton, AquaButtonExtendedTypes.ColorDefaults colorDefaults, boolean bl) {
        AquaButtonExtendedTypes.WidgetInfo widgetInfo = this.getWidgetInfo(abstractButton);
        boolean bl2 = abstractButton.getModel().isEnabled();
        boolean bl3 = this.shouldUseNonexclusiveStyle(abstractButton, widgetInfo);
        Color color = abstractButton.getForeground();
        if (color == null || color instanceof UIResource || !bl2 || bl3) {
            AquaUIPainter.State state = this.getState(abstractButton);
            AquaUIPainter.ButtonState buttonState = this.getButtonState(abstractButton);
            return widgetInfo.getForeground(state, buttonState, colorDefaults, bl3, bl);
        }
        return color;
    }

    protected boolean shouldUseNonexclusiveStyle(AbstractButton abstractButton, AquaButtonExtendedTypes.WidgetInfo widgetInfo) {
        DefaultButtonModel defaultButtonModel;
        ButtonModel buttonModel;
        return widgetInfo.isSegmented() && widgetInfo.isTextured() && abstractButton.getModel().isSelected() && (buttonModel = abstractButton.getModel()) instanceof DefaultButtonModel && (defaultButtonModel = (DefaultButtonModel)buttonModel).getGroup() == null;
    }

    public int getIconTextGap(AbstractButton abstractButton) {
        AquaButtonExtendedTypes.WidgetInfo widgetInfo = this.getWidgetInfo(abstractButton);
        int n = widgetInfo.getIconTextGap();
        return n > 0 ? n : 4;
    }

    @Override
    public final Insets getBorderInsets(Component component) {
        if (component == null || !(component instanceof AbstractButton)) {
            return new Insets(0, 0, 0, 0);
        }
        AbstractButton abstractButton = (AbstractButton)component;
        Insetter insetter = this.getContentInsets(abstractButton);
        Insets insets = this.getMarginAdjustments(abstractButton);
        return AquaUtils.combineAsInsets(insetter, insets);
    }

    public final Insets2D getBorderInsets2D(Component component) {
        if (component == null || !(component instanceof AbstractButton)) {
            return new Insets2D(0.0f, 0.0f, 0.0f, 0.0f);
        }
        AbstractButton abstractButton = (AbstractButton)component;
        Insetter insetter = this.getContentInsets(abstractButton);
        Insets insets = this.getMarginAdjustments(abstractButton);
        return AquaUtils.combineAsInsets2D(insetter, insets);
    }

    protected Insets getMarginAdjustments(AbstractButton abstractButton) {
        Insets insets = abstractButton.getMargin();
        if (insets != null && !(insets instanceof UIResource)) {
            return insets;
        }
        Insets insets2 = this.getSpecialMarginAdjustments(abstractButton);
        return insets2 != null ? insets2 : insets;
    }

    protected Insets getSpecialMarginAdjustments(AbstractButton abstractButton) {
        SegmentedButtonLayoutConfiguration segmentedButtonLayoutConfiguration;
        AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget;
        int n = this.getMargin(abstractButton);
        int n2 = 0;
        int n3 = n;
        int n4 = 0;
        int n5 = n;
        LayoutConfiguration layoutConfiguration = this.getLayoutConfiguration(abstractButton);
        if (layoutConfiguration instanceof SegmentedButtonLayoutConfiguration && ((segmentedButtonWidget = (segmentedButtonLayoutConfiguration = (SegmentedButtonLayoutConfiguration)layoutConfiguration).getWidget()) == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SMALL_SQUARE || segmentedButtonWidget == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED || segmentedButtonWidget == AquaUIPainter.SegmentedButtonWidget.BUTTON_TAB) && segmentedButtonLayoutConfiguration.getSize() == AquaUIPainter.Size.MINI) {
            n2 = 1;
        }
        return new Insets(n2, n3, n4, n5);
    }

    protected int getMargin(AbstractButton abstractButton) {
        AquaButtonExtendedTypes.WidgetInfo widgetInfo = this.getWidgetInfo(abstractButton);
        return widgetInfo.getMargin();
    }

    protected Insetter getContentInsets(AbstractButton abstractButton) {
        LayoutConfiguration layoutConfiguration = this.getLayoutConfiguration(abstractButton);
        return layoutConfiguration != null ? this.painter.getLayoutInfo().getContentInsets(layoutConfiguration) : null;
    }

    public Insets getContentInsets(AbstractButton abstractButton, int n, int n2) {
        Insetter insetter;
        LayoutConfiguration layoutConfiguration = this.getLayoutConfiguration(abstractButton);
        if (layoutConfiguration != null && (insetter = this.painter.getLayoutInfo().getContentInsets(layoutConfiguration)) != null) {
            return insetter.asInsets();
        }
        return null;
    }

    public AquaButtonIcon createIcon(AbstractButton abstractButton, boolean bl, AquaButtonExtendedTypes.ColorDefaults colorDefaults) {
        return new MyButtonIcon(abstractButton, bl, colorDefaults);
    }

    public Dimension getMinimumButtonSize(AbstractButton abstractButton) {
        Object object;
        Dimension dimension = new Dimension(10, 10);
        LayoutConfiguration layoutConfiguration = this.getLayoutConfiguration(abstractButton);
        if (layoutConfiguration != null) {
            object = this.painter.getLayoutInfo().getLayoutInfo(layoutConfiguration);
            int n = (int)Math.ceil(object.getMinimumVisualWidth());
            int n2 = (int)Math.ceil(object.getMinimumVisualHeight());
            if (n > 0) {
                dimension.width = n;
            }
            if (n2 > 0) {
                dimension.height = n2;
            }
        }
        object = this.getSizingIcon(abstractButton);
        Dimension dimension2 = AquaButtonUI.getPreferredButtonSize(abstractButton, abstractButton.getIconTextGap(), (Icon)object);
        if (dimension2 != null) {
            dimension.width = Math.max(dimension.width, dimension2.width);
            dimension.height = Math.max(dimension.height, dimension2.height);
        }
        return dimension;
    }

    public Dimension getPreferredButtonSize(AbstractButton abstractButton) {
        Dimension dimension = this.getMinimumButtonSize(abstractButton);
        Icon icon = this.getSizingIcon(abstractButton);
        Dimension dimension2 = AquaButtonUI.getPreferredButtonSize(abstractButton, abstractButton.getIconTextGap(), icon);
        if (dimension2 == null) {
            return null;
        }
        if (dimension != null) {
            if (dimension.width > dimension2.width) {
                dimension2.width = dimension.width;
            }
            if (dimension.height > dimension2.height) {
                dimension2.height = dimension.height;
            }
        }
        return dimension2;
    }

    public Icon getSizingIcon(AbstractButton abstractButton) {
        ButtonLayoutConfiguration buttonLayoutConfiguration;
        AquaUIPainter.ButtonWidget buttonWidget;
        LayoutConfiguration layoutConfiguration = this.getLayoutConfiguration(abstractButton);
        if (layoutConfiguration instanceof ButtonLayoutConfiguration && (buttonWidget = (buttonLayoutConfiguration = (ButtonLayoutConfiguration)layoutConfiguration).getButtonWidget()) == AquaUIPainter.ButtonWidget.BUTTON_TOOLBAR_ITEM) {
            AquaUIPainter.Size size = buttonLayoutConfiguration.getSize();
            switch (size) {
                case SMALL: 
                case MINI: {
                    return smallToolbarSizingIcon;
                }
            }
            return regularToolbarSizingIcon;
        }
        return null;
    }

    protected AquaButtonExtendedTypes.WidgetInfo getWidgetInfo(AbstractButton abstractButton) {
        Enum enum_ = null;
        LayoutConfiguration layoutConfiguration = this.getLayoutConfiguration(abstractButton);
        if (layoutConfiguration instanceof ButtonLayoutConfiguration) {
            enum_ = ((ButtonLayoutConfiguration)layoutConfiguration).getButtonWidget();
        }
        if (layoutConfiguration instanceof SegmentedButtonLayoutConfiguration) {
            enum_ = ((SegmentedButtonLayoutConfiguration)layoutConfiguration).getWidget();
        }
        return AquaButtonExtendedTypes.getWidgetInfo(enum_);
    }

    public Configuration getConfiguration(AbstractButton abstractButton, int n, int n2) {
        LayoutConfiguration layoutConfiguration = this.getLayoutConfiguration(abstractButton);
        if (layoutConfiguration instanceof ButtonLayoutConfiguration) {
            AquaUIPainter.State state = this.getState(abstractButton);
            boolean bl = state != AquaUIPainter.State.DISABLED && state != AquaUIPainter.State.INACTIVE && abstractButton.isFocusPainted() && abstractButton.hasFocus();
            AquaUIPainter.ButtonState buttonState = this.getButtonState(abstractButton);
            return new ButtonConfiguration((ButtonLayoutConfiguration)layoutConfiguration, state, bl, buttonState);
        }
        if (layoutConfiguration instanceof SegmentedButtonLayoutConfiguration) {
            AquaUIPainter.State state = this.getState(abstractButton);
            boolean bl = state != AquaUIPainter.State.DISABLED && state != AquaUIPainter.State.INACTIVE && abstractButton.isFocusPainted() && abstractButton.hasFocus();
            boolean bl2 = abstractButton.getModel().isSelected();
            AquaUIPainter.Direction direction = AquaUIPainter.Direction.NONE;
            return new SegmentedButtonConfiguration((SegmentedButtonLayoutConfiguration)layoutConfiguration, state, bl2, bl, direction, SegmentedButtonConfiguration.DividerState.NONE, SegmentedButtonConfiguration.DividerState.NONE);
        }
        return null;
    }

    public LayoutConfiguration getLayoutConfiguration(AbstractButton abstractButton) {
        return (LayoutConfiguration)abstractButton.getClientProperty("Aqua.Button.LayoutConfiguration");
    }

    public LayoutConfiguration determineLayoutConfiguration(AbstractButton abstractButton) {
        Object object = this.getButtonWidget(abstractButton);
        AquaUIPainter.Size size = AquaUtilControlSize.getUserSizeFrom(abstractButton);
        if (object instanceof AquaUIPainter.ButtonWidget) {
            AquaUIPainter.ButtonWidget buttonWidget = (AquaUIPainter.ButtonWidget)((Object)object);
            AquaUIPainter.UILayoutDirection uILayoutDirection = AquaUtils.getLayoutDirection(abstractButton);
            return new ButtonLayoutConfiguration(buttonWidget, size, uILayoutDirection);
        }
        if (object instanceof AquaUIPainter.SegmentedButtonWidget) {
            AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget = (AquaUIPainter.SegmentedButtonWidget)((Object)object);
            return new SegmentedButtonLayoutConfiguration(segmentedButtonWidget, size, AquaUIPainter.Position.ONLY);
        }
        return null;
    }

    public Object getButtonWidget(AbstractButton abstractButton) {
        return null;
    }

    @Override
    public Shape getFocusRingOutline(JComponent jComponent) {
        LayoutConfiguration layoutConfiguration = this.getLayoutConfiguration((AbstractButton)jComponent);
        if (layoutConfiguration != null) {
            int n = jComponent.getWidth();
            int n2 = jComponent.getHeight();
            this.painter.configure(n, n2);
            return this.painter.getOutline(layoutConfiguration);
        }
        return null;
    }

    protected boolean isProposedButtonWidgetUsable(AbstractButton abstractButton, Object object) {
        LayoutConfiguration layoutConfiguration;
        Object object2;
        AquaUIPainter.Size size = AquaUtilControlSize.getUserSizeFrom(abstractButton);
        if (object instanceof AquaUIPainter.ButtonWidget) {
            object2 = (AquaUIPainter.ButtonWidget)((Object)object);
            AquaUIPainter.UILayoutDirection uILayoutDirection = AquaUtils.getLayoutDirection(abstractButton);
            layoutConfiguration = new ButtonLayoutConfiguration((AquaUIPainter.ButtonWidget)((Object)object2), size, uILayoutDirection);
        } else if (object instanceof AquaUIPainter.SegmentedButtonWidget) {
            object2 = (AquaUIPainter.SegmentedButtonWidget)((Object)object);
            layoutConfiguration = new SegmentedButtonLayoutConfiguration((AquaUIPainter.SegmentedButtonWidget)((Object)object2), size, AquaUIPainter.Position.MIDDLE);
        } else {
            return false;
        }
        object2 = this.painter.getLayoutInfo().getLayoutInfo(layoutConfiguration);
        int n = (int)Math.ceil(object2.getFixedVisualHeight());
        if (n == 0) {
            return true;
        }
        Insetter insetter = this.painter.getLayoutInfo().getContentInsets(layoutConfiguration);
        if (insetter == null || !insetter.isInvertible()) {
            return true;
        }
        Font font = AquaUtilControlSize.isOKToInstallDefaultFont(abstractButton) ? AquaButtonExtendedTypes.getFont(AquaButtonUI.getGenericDefaultFont(abstractButton), object, size) : abstractButton.getFont();
        Dimension dimension = AquaButtonUI.getPreferredContentSize(abstractButton, font, abstractButton.getIconTextGap());
        Dimension dimension2 = insetter.expand(dimension);
        return dimension2.height <= n;
    }

    protected AquaUIPainter.ButtonState getButtonState(AbstractButton abstractButton) {
        ButtonLayoutConfiguration buttonLayoutConfiguration;
        if (abstractButton instanceof JToggleButton) {
            return abstractButton.getModel().isSelected() ? AquaUIPainter.ButtonState.ON : AquaUIPainter.ButtonState.OFF;
        }
        LayoutConfiguration layoutConfiguration = this.getLayoutConfiguration(abstractButton);
        if (layoutConfiguration instanceof ButtonLayoutConfiguration && (buttonLayoutConfiguration = (ButtonLayoutConfiguration)layoutConfiguration).getButtonWidget() == AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL) {
            return abstractButton.getModel().isSelected() ? AquaUIPainter.ButtonState.ON : AquaUIPainter.ButtonState.OFF;
        }
        return AquaUIPainter.ButtonState.STATELESS;
    }

    protected class MyButtonIcon
    extends AquaButtonIcon {
        protected final AbstractButton b;

        public MyButtonIcon(AbstractButton abstractButton, boolean bl, AquaButtonExtendedTypes.ColorDefaults colorDefaults) {
            super(AquaIcon.getImageForIcon(abstractButton.getIcon()), bl, colorDefaults);
            this.b = abstractButton;
        }

        @Override
        protected Color getExistingColor() {
            return this.b.getForeground();
        }

        @Override
        protected AquaButtonIcon.Key getRenderingKey() {
            AquaButtonExtendedTypes.WidgetInfo widgetInfo = AquaButtonBorder.this.getWidgetInfo(this.b);
            AquaUIPainter.State state = AquaButtonBorder.this.getState(this.b);
            AquaUIPainter.ButtonState buttonState = AquaButtonBorder.this.getButtonState(this.b);
            return new AquaButtonIcon.Key(widgetInfo, state, buttonState);
        }

        @Override
        protected boolean isNonexclusiveStyle(AquaButtonIcon.Key key) {
            return AquaButtonBorder.this.shouldUseNonexclusiveStyle(this.b, key.getWidgetInfo());
        }
    }
}

