/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.impl.AquaUIPainterBase;
import org.violetlib.jnr.aqua.impl.HybridAquaUIPainter;
import org.violetlib.jnr.aqua.impl.NativeSupport;
import org.violetlib.jnr.impl.ImageCache;
import org.violetlib.jnr.impl.JNRPlatformUtils;

public class AquaNativeRendering {
    private static boolean isInitialized;
    @Nullable
    private static AquaUIPainter preferredPainter;

    @NotNull
    public static AquaUIPainter createPainter() throws UnsupportedOperationException {
        if (!isInitialized) {
            AquaNativeRendering.findPainterClasses();
        }
        if (preferredPainter != null) {
            return preferredPainter.copy();
        }
        throw new UnsupportedOperationException("Unable to create a native painter");
    }

    public static void invalidateAppearances() {
        AquaUIPainterBase.nativeInvalidateAppearances();
    }

    public static void clearCache() {
        ImageCache.getInstance().flush();
    }

    private AquaNativeRendering() {
    }

    @NotNull
    public static String getReleaseName() {
        return AquaNativeRendering.getStringResource("RELEASE.txt");
    }

    @NotNull
    public static String getBuildID() {
        return AquaNativeRendering.getStringResource("BUILD.txt");
    }

    @NotNull
    public static String getVersionString() {
        return "VAquaRendering: release " + AquaNativeRendering.getReleaseName() + " (build " + AquaNativeRendering.getBuildID() + ")";
    }

    public static void showVersion() {
        System.err.println("VAquaRendering: release " + AquaNativeRendering.getReleaseName() + ", build " + AquaNativeRendering.getBuildID());
    }

    @NotNull
    private static String getStringResource(@NotNull String string) {
        InputStream inputStream = AquaNativeRendering.class.getResourceAsStream(string);
        if (inputStream != null) {
            try {
                int n;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                StringBuilder stringBuilder = new StringBuilder();
                while ((n = bufferedReader.read()) >= 0) {
                    stringBuilder.append((char)n);
                }
                return stringBuilder.toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return "Unknown";
    }

    private static synchronized void findPainterClasses() {
        boolean bl;
        if (isInitialized) {
            return;
        }
        isInitialized = true;
        AquaUIPainter aquaUIPainter = null;
        String string = "org.violetlib.jnr.aqua.impl.AugmentedAquaNativePainter";
        AquaUIPainter aquaUIPainter2 = AquaNativeRendering.getPainter(string, null);
        int n = NativeSupport.getJavaRuntimeSupportMajorVersion();
        boolean bl2 = bl = n >= 15;
        int n2 = JNRPlatformUtils.getPlatformVersion();
        if (n2 >= 101400) {
            bl2 = false;
        }
        String string2 = "org.violetlib.jnr.aqua.coreui.AugmentedCoreUIPainter";
        AquaUIPainter aquaUIPainter3 = AquaNativeRendering.getPainter(string2, bl2);
        if (bl) {
            String string3 = "org.violetlib.jnr.aqua.jrs.AugmentedJRSPainter";
            aquaUIPainter = AquaNativeRendering.getPainter(string3, null);
        }
        if (aquaUIPainter2 != null && aquaUIPainter3 != null) {
            preferredPainter = new HybridAquaUIPainter(aquaUIPainter2, aquaUIPainter3, aquaUIPainter);
        } else if (aquaUIPainter3 != null) {
            AquaNativeRendering.debug("Using Core UI painter as preferred painter");
            preferredPainter = aquaUIPainter3;
        } else if (aquaUIPainter2 != null) {
            AquaNativeRendering.debug("Using NSView painter as preferred painter");
            preferredPainter = aquaUIPainter2;
        } else {
            AquaNativeRendering.debug("Using JRS painter as preferred painter");
            preferredPainter = aquaUIPainter;
        }
    }

    protected static void debug(@NotNull String string) {
    }

    @Nullable
    protected static AquaUIPainter getPainter(@NotNull String string, @Nullable Boolean bl) {
        Class clazz = AquaNativeRendering.getClass(string);
        if (clazz != null) {
            if (AquaUIPainter.class.isAssignableFrom(clazz)) {
                try {
                    if (bl != null) {
                        Constructor constructor = clazz.getConstructor(Boolean.TYPE);
                        return (AquaUIPainter)constructor.newInstance(bl);
                    }
                    Constructor constructor = clazz.getConstructor(new Class[0]);
                    return (AquaUIPainter)constructor.newInstance(new Object[0]);
                }
                catch (Exception exception) {
                    System.err.println("Unable to instantiate painter class: " + string);
                    exception.printStackTrace();
                }
            } else {
                System.err.println("Painter class is not valid: " + string);
            }
        } else {
            AquaNativeRendering.debug("Painter class not found: " + string);
        }
        return null;
    }

    @Nullable
    protected static Class getClass(@NotNull String string) {
        ClassLoader classLoader = AquaNativeRendering.class.getClassLoader();
        try {
            return Class.forName(string, true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

