/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyListener;
import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jetbrains.annotations.NotNull;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaTableHeaderCellRenderer;
import org.violetlib.aqua.ContainerContextualColors;
import org.violetlib.aqua.fc.AquaFileChooserTreeTableUI;
import org.violetlib.aqua.fc.FileInfo;
import org.violetlib.aqua.fc.FileSystemTreeModel;
import org.violetlib.aqua.fc.GenericCellRenderer;
import org.violetlib.aqua.fc.ListView;
import org.violetlib.treetable.AbstractTreeColumnModel;
import org.violetlib.treetable.DefaultTreeTableCellRenderer;
import org.violetlib.treetable.DefaultTreeTableSorter;
import org.violetlib.treetable.TreeColumnModel;
import org.violetlib.treetable.TreeTable;

public class ListViewImpl
extends ListView {
    protected final TreeTable tree;
    protected final JScrollPane listViewScrollPane;
    protected final MyTableColumnModel tableColumnModel;
    private Font labelFont;
    private int COLUMN_MARGIN = 10;
    private GenericCellRenderer fileRenderer;
    protected final JFileChooser fc;
    private final TreeSelectionListener treeSelectionListener;
    protected Border tableHeaderBorder;

    public ListViewImpl(JFileChooser jFileChooser) {
        this.fc = jFileChooser;
        this.labelFont = UIManager.getFont("FileChooser.listView.font");
        this.treeSelectionListener = new MyTreeSelectionListener();
        this.setFocusable(false);
        FileSystemTreeModel fileSystemTreeModel = new FileSystemTreeModel(jFileChooser);
        this.tableColumnModel = this.createColumnModel();
        this.tree = new MyTreeTable(fileSystemTreeModel, new MyTreeColumnModel(), this.tableColumnModel);
        this.tree.setUI(new MyTreeTableUI(jFileChooser, this.tree));
        this.tree.setRootVisible(false);
        this.tree.setAlternateRowColor(this.tree.getBackground());
        this.tree.setBackground(UIManager.getColor("List.alternateBackground.0"));
        this.tree.setNodeSortingEnabled(true);
        this.tree.setRowMargin(0);
        this.tree.setRowHeight(18);
        this.tree.setBackground(new Color(0, 0, 0, 0));
        this.tree.setOpaque(false);
        this.listViewScrollPane = new JScrollPane();
        this.listViewScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.listViewScrollPane.setViewportView(this.tree);
        this.listViewScrollPane.setColumnHeaderView(this.tree.getTableHeader());
        this.setLayout(new BorderLayout());
        this.add(this.listViewScrollPane);
        this.tableHeaderBorder = new EmptyBorder(3, 3, 3, 0);
        JTableHeader jTableHeader = this.tree.getTableHeader();
        TableCellRenderer tableCellRenderer = jTableHeader.getDefaultRenderer();
        TableCellRenderer tableCellRenderer2 = this.createHeaderCellRenderer(tableCellRenderer, 2);
        TableCellRenderer tableCellRenderer3 = this.createHeaderCellRenderer(tableCellRenderer, 4);
        this.tableColumnModel.nameColumn.setHeaderRenderer(tableCellRenderer2);
        this.tableColumnModel.dateModifiedColumn.setHeaderRenderer(tableCellRenderer2);
        this.tableColumnModel.sizeColumn.setHeaderRenderer(tableCellRenderer3);
        this.tableColumnModel.kindColumn.setHeaderRenderer(tableCellRenderer2);
    }

    @Override
    public void setActive(boolean bl) {
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        if (bl) {
            treeSelectionModel.addTreeSelectionListener(this.treeSelectionListener);
        } else {
            treeSelectionModel.removeTreeSelectionListener(this.treeSelectionListener);
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.tree.requestFocusInWindow();
    }

    @Override
    public synchronized void addKeyListener(KeyListener keyListener) {
        this.tree.addKeyListener(keyListener);
    }

    @Override
    protected void updateForNewModel() {
        this.tree.setTreeModel(this.model);
        this.tree.setRowSorter(new MyTreeRowSorter(this.tree));
        this.tree.revalidate();
        this.tree.repaint();
    }

    @Override
    public void reconfigure() {
        this.setMultipleSelection(this.fc.isMultiSelectionEnabled());
        this.tree.repaint();
    }

    @Override
    public void setFileRenderer(GenericCellRenderer genericCellRenderer) {
        this.fileRenderer = genericCellRenderer;
        this.tree.repaint();
    }

    @Override
    public void setMultipleSelection(boolean bl) {
        this.tree.getSelectionModel().setSelectionMode(bl ? 4 : 1);
    }

    @Override
    public void setSelection(TreePath treePath) {
        this.tree.setSelectionPath(treePath);
    }

    @Override
    public void setSelection(List<TreePath> list) {
        TreePath[] treePathArray = list.toArray(new TreePath[list.size()]);
        this.tree.setSelectionPaths(treePathArray);
    }

    @Override
    public List<TreePath> getSelection() {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        return treePathArray != null ? new ArrayList<TreePath>(Arrays.asList(treePathArray)) : new ArrayList();
    }

    @Override
    public void ensurePathIsVisible(TreePath treePath) {
        this.tree.scrollPathToVisible(treePath);
    }

    protected MyTableColumnModel createColumnModel() {
        return new MyTableColumnModel();
    }

    protected TableCellRenderer createHeaderCellRenderer(TableCellRenderer tableCellRenderer, int n) {
        return new MyHeaderRenderer(n);
    }

    protected String getLengthString(long l) {
        float f;
        String string;
        if (l < 0L) {
            return "--";
        }
        if (l >= 1000000000L) {
            string = "FileChooser.sizeGBytesOnly";
            f = (float)l / 1.0E9f;
        } else if (l >= 1000000L) {
            string = "FileChooser.sizeMBytesOnly";
            f = (float)l / 1000000.0f;
        } else if (l >= 1024L) {
            string = "FileChooser.sizeKBytesOnly";
            f = (float)l / 1000.0f;
        } else {
            string = "FileChooser.sizeBytesOnly";
            f = l;
        }
        String string2 = UIManager.getString(string);
        if (string2 != null) {
            return MessageFormat.format(string2, Float.valueOf(f), l);
        }
        return "" + l;
    }

    protected String getModifiedString(File file, int n) {
        if (file != null) {
            Date date = new Date(file.lastModified());
            if (n < 150) {
                DateFormat dateFormat = DateFormat.getDateInstance(3);
                return dateFormat.format(date);
            }
            DateFormat dateFormat = DateFormat.getDateInstance();
            return dateFormat.format(date);
        }
        return "";
    }

    protected class MyTreeSelectionListener
    implements TreeSelectionListener {
        protected MyTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            ListViewImpl.this.selectionChanged();
        }
    }

    protected class MyTableColumnModel
    extends DefaultTableColumnModel {
        public TableColumn nameColumn;
        public TableColumn dateModifiedColumn;
        public TableColumn sizeColumn;
        public TableColumn kindColumn;

        public MyTableColumnModel() {
            this.nameColumn = new MyTableColumn(0, 200, true, "Name");
            this.dateModifiedColumn = new MyTableColumn(1, 90, false, "Date Modified");
            this.sizeColumn = new MyTableColumn(2, 80, false, "Size");
            this.kindColumn = new MyTableColumn(3, 150, false, "Kind");
            this.nameColumn.setCellRenderer(new MyNameCellRenderer());
            this.dateModifiedColumn.setCellRenderer(new MyDateCellRenderer());
            this.sizeColumn.setCellRenderer(new MySizeCellRenderer());
            this.kindColumn.setCellRenderer(new MyKindCellRenderer());
            this.addColumn(this.nameColumn);
            this.addColumn(this.dateModifiedColumn);
            this.addColumn(this.sizeColumn);
            this.addColumn(this.kindColumn);
            this.setColumnMargin(ListViewImpl.this.COLUMN_MARGIN);
        }
    }

    protected class MyTreeTable
    extends TreeTable {
        public MyTreeTable(TreeModel treeModel, TreeColumnModel treeColumnModel, TableColumnModel tableColumnModel) {
            super(treeModel, treeColumnModel, tableColumnModel);
        }

        @Override
        public Icon getIcon(Object object, boolean bl, boolean bl2) {
            if (object instanceof FileInfo) {
                FileInfo fileInfo = (FileInfo)object;
                return fileInfo.getIcon();
            }
            return super.getIcon(object, bl, bl2);
        }
    }

    protected class MyTreeColumnModel
    extends AbstractTreeColumnModel {
        private List<String> columnNames = new ArrayList<String>();

        public MyTreeColumnModel() {
            this.columnNames.add("Name");
            this.columnNames.add("Date Modified");
            this.columnNames.add("Size");
            this.columnNames.add("Kind");
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames.get(n);
        }

        @Override
        public Object getValueAt(Object object, int n) {
            return (FileSystemTreeModel.Node)object;
        }
    }

    protected class MyTreeTableUI
    extends AquaFileChooserTreeTableUI {
        public MyTreeTableUI(JFileChooser jFileChooser, TreeTable treeTable) {
            super(jFileChooser, treeTable);
        }

        @Override
        protected void select(TreePath treePath) {
            ListViewImpl.this.select(treePath);
        }
    }

    protected class MyTreeRowSorter
    extends DefaultTreeTableSorter<TreeModel, TreeColumnModel, Object> {
        public MyTreeRowSorter(TreeTable treeTable) {
            super(treeTable.getTreeModel(), treeTable.getTreeColumnModel());
            this.setComparator(0, new FileSystemTreeModel.ByNameComparator());
            this.setComparator(1, new FileSystemTreeModel.ByDateComparator());
            this.setComparator(2, new FileSystemTreeModel.BySizeComparator());
            this.setComparator(3, new FileSystemTreeModel.ByKindComparator());
        }
    }

    protected class MyHeaderRenderer
    extends AquaTableHeaderCellRenderer {
        public MyHeaderRenderer(int n) {
            this.setHorizontalAlignment(n);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JComponent jComponent = (JComponent)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Border border = jComponent.getBorder();
            Border border2 = border != null ? new CompoundBorder(border, ListViewImpl.this.tableHeaderBorder) : ListViewImpl.this.tableHeaderBorder;
            jComponent.setBorder(border2);
            if (AquaTableHeaderCellRenderer.getColumnSortOrder(jTable, n2) != null) {
                Font font = jComponent.getFont();
                jComponent.setFont(font.deriveFont(1));
            }
            return jComponent;
        }
    }

    private class MyKindCellRenderer
    extends MyCellRenderer {
        private MyKindCellRenderer() {
            super(2, "secondaryLabel");
        }

        @Override
        protected Object getCellValue(Object object) {
            FileSystemTreeModel.Node node = (FileSystemTreeModel.Node)object;
            return node.getFileKind();
        }
    }

    private class MySizeCellRenderer
    extends MyCellRenderer {
        private MySizeCellRenderer() {
            super(4, "secondaryLabel");
        }

        @Override
        protected Object getCellValue(Object object) {
            FileSystemTreeModel.Node node = (FileSystemTreeModel.Node)object;
            return ListViewImpl.this.getLengthString(node.getFileLength());
        }
    }

    private class MyDateCellRenderer
    extends MyCellRenderer {
        private MyDateCellRenderer() {
            super(2, "secondaryLabel");
        }

        @Override
        protected Object getCellValue(Object object) {
            FileSystemTreeModel.Node node = (FileSystemTreeModel.Node)object;
            File file = node.lazyGetResolvedFile();
            return ListViewImpl.this.getModifiedString(file, ListViewImpl.this.tableColumnModel.dateModifiedColumn.getWidth());
        }
    }

    private class MyNameCellRenderer
    extends MyCellRenderer {
        private MyNameCellRenderer() {
            super(2, "label");
        }

        @Override
        public Component getTreeTableCellRendererComponent(TreeTable treeTable, Object object, boolean bl, boolean bl2, int n, int n2, boolean bl3, boolean bl4) {
            AquaAppearance aquaAppearance = AppearanceManager.ensureAppearance(treeTable);
            ContainerContextualColors containerContextualColors = AquaColors.STRIPED_CONTAINER_COLORS;
            Component component = ListViewImpl.this.fileRenderer.getCellRendererComponent(treeTable, aquaAppearance, containerContextualColors, object, bl, bl2);
            if (component == null) {
                component = super.getTreeTableCellRendererComponent(treeTable, object, bl, bl2, n, n2, bl3, bl4);
            }
            return component;
        }

        @Override
        protected void setValue(Object object) {
        }
    }

    protected class MyCellRenderer
    extends DefaultTreeTableCellRenderer {
        @NotNull
        protected String textColorName;

        public MyCellRenderer(@NotNull int n, String string) {
            this.textColorName = string;
            this.setHorizontalAlignment(n);
            this.setFont(ListViewImpl.this.labelFont);
        }

        @Override
        public Component getTreeTableCellRendererComponent(TreeTable treeTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            bl2 = false;
            object = this.getCellValue(object);
            Component component = super.getTreeTableCellRendererComponent(treeTable, object, bl, bl2, n, n2);
            return this.fix(component, bl);
        }

        @Override
        public Component getTreeTableCellRendererComponent(TreeTable treeTable, Object object, boolean bl, boolean bl2, int n, int n2, boolean bl3, boolean bl4) {
            object = this.getCellValue(object);
            Component component = super.getTreeTableCellRendererComponent(treeTable, object, bl, bl2, n, n2, bl3, bl4);
            return this.fix(component, bl);
        }

        protected Object getCellValue(Object object) {
            return object;
        }

        protected Component fix(Component component, boolean bl) {
            AquaAppearance aquaAppearance = AppearanceManager.ensureAppearance(component);
            Color color = aquaAppearance.getColor(bl ? "alternateSelectedControlText" : this.textColorName);
            if (color == null) {
                color = Color.BLACK;
            }
            component.setForeground(AquaColors.getOrdinaryColor(color));
            return component;
        }
    }

    protected class MyTableColumn
    extends TableColumn {
        public MyTableColumn(int n, int n2, boolean bl, String string) {
            super(n, n2 + ListViewImpl.this.COLUMN_MARGIN);
            if (!bl) {
                this.setMaxWidth(this.getWidth());
            }
            this.setHeaderValue(string);
        }
    }
}

