/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.violetlib.aqua.SelectionRegion;

public class SelectionBoundsDescription {
    private int regionCount;
    private int lastY;
    private int lastH;
    private final int[] data;

    @NotNull
    public static SelectionBoundsDescription create(@NotNull SelectionRegion selectionRegion) {
        SelectionBoundsDescription selectionBoundsDescription = new SelectionBoundsDescription(1);
        selectionBoundsDescription.addRegion(selectionRegion);
        return selectionBoundsDescription;
    }

    public SelectionBoundsDescription(int n) {
        this.data = new int[n * 2 + 1];
    }

    public void addRegion(@NotNull SelectionRegion selectionRegion) {
        this.addRegion(selectionRegion.y, selectionRegion.height);
    }

    public void addDropTargetRegion(@NotNull SelectionRegion selectionRegion) {
        this.addRegion(selectionRegion.y, -selectionRegion.height);
    }

    public void addRegion(int n, int n2) {
        this.internalAddRegion(n, n2);
    }

    public void addDropTargetRegion(int n, int n2) {
        this.internalAddRegion(n, -n2);
    }

    private void internalAddRegion(int n, int n2) {
        if (this.regionCount > 0 && this.lastY == n && n2 > 0 && this.lastH > 0) {
            int n3 = this.regionCount * 2;
            this.data[n3] = this.data[n3] + n2;
        } else {
            this.data[0] = ++this.regionCount;
            this.data[this.regionCount * 2 - 1] = n;
            this.data[this.regionCount * 2] = n2;
        }
        this.lastY = n + n2;
        this.lastH = n2;
    }

    public int[] getData() {
        return this.data;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SelectionBoundsDescription selectionBoundsDescription = (SelectionBoundsDescription)object;
        return this.regionCount == selectionBoundsDescription.regionCount && Arrays.equals(this.data, selectionBoundsDescription.data);
    }

    public int hashCode() {
        return Objects.hash(this.regionCount, Arrays.hashCode(this.data));
    }
}

