/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaDragRecognitionSupport;
import org.violetlib.aqua.AquaTreeUI;
import org.violetlib.aqua.JavaSupport;
import org.violetlib.aqua.Utils;

public class AquaTreeMouseBehavior
extends MouseInputAdapter
implements AquaDragRecognitionSupport.BeforeDrag {
    protected JTree tree;
    protected AquaTreeUI ui;
    public static boolean isDebug = false;
    private boolean mouseReleaseDeselects;
    private boolean mouseDragSelects;
    private boolean isMouseReleaseStartsEditing;
    private boolean isMouseReleaseToggleExpansion;
    private boolean isDragRecognitionOngoing;
    private boolean isDragging;
    @Nullable
    private TreePath pathToToggle;

    public AquaTreeMouseBehavior(@NotNull JTree jTree) {
        this.tree = jTree;
        this.ui = (AquaTreeUI)jTree.getUI();
    }

    @Override
    public void dragStarting(@NotNull MouseEvent mouseEvent) {
        if (isDebug) {
            Utils.logDebug("Drag gesture recognized");
        }
        if (this.tree.getCellEditor() != null) {
            this.tree.getCellEditor().isCellEditable(new EventObject(this));
        }
        this.mouseReleaseDeselects = false;
        this.isMouseReleaseStartsEditing = false;
        this.isDragging = true;
    }

    @Override
    public void mousePressed(@NotNull MouseEvent mouseEvent) {
        if (isDebug) {
            Utils.logDebug("JTree mouse pressed " + mouseEvent.getClickCount());
        }
        if (this.tree.isEnabled() && SwingUtilities.isLeftMouseButton(mouseEvent) && !mouseEvent.isConsumed()) {
            boolean bl;
            TreePath treePath;
            if (this.ui.isEditing(this.tree) && this.tree.getInvokesStopCellEditing() && !this.ui.stopEditing(this.tree)) {
                return;
            }
            this.ui.completeEditing();
            if (this.tree.isRequestFocusEnabled()) {
                JavaSupport.requestFocusInWindowFromMouseEvent(this.tree);
            }
            boolean bl2 = (treePath = this.getMouseClickedClosestPathForLocation(this.tree, mouseEvent.getX(), mouseEvent.getY())) != null && this.ui.isExpandOperation(treePath, mouseEvent.getX(), mouseEvent.getY());
            int n = this.tree.getRowForPath(treePath);
            if (isDebug) {
                Utils.logDebug("  Path: " + treePath);
                if (treePath != null) {
                    Utils.logDebug("  Is expand operation: " + bl2);
                    Utils.logDebug("  Row: " + n);
                }
            }
            this.mouseDragSelects = false;
            this.mouseReleaseDeselects = false;
            this.isMouseReleaseToggleExpansion = bl2;
            this.isMouseReleaseStartsEditing = !bl2 && mouseEvent.getClickCount() == 1;
            this.isDragRecognitionOngoing = false;
            TreePath treePath2 = this.pathToToggle = this.isMouseReleaseToggleExpansion ? treePath : null;
            if (!(n < 0 || this.isMouseReleaseToggleExpansion || (bl = this.tree.isRowSelected(n)) && mouseEvent.isPopupTrigger())) {
                int n2 = this.tree.getRowForPath(this.tree.getAnchorSelectionPath());
                if ((mouseEvent.getModifiersEx() & 0x1900) == 256) {
                    if (bl) {
                        this.tree.removeSelectionInterval(n, n);
                    } else {
                        this.tree.addSelectionInterval(n, n);
                        this.mouseDragSelects = true;
                        this.isMouseReleaseStartsEditing = false;
                    }
                } else if ((mouseEvent.getModifiersEx() & 0x1840) == 64 && n2 != -1) {
                    this.tree.setSelectionInterval(n2, n);
                    this.ui.setLeadSelectionPath(treePath);
                    this.mouseDragSelects = true;
                    this.isMouseReleaseStartsEditing = false;
                } else if ((mouseEvent.getModifiersEx() & 0x140) == 0) {
                    if (bl) {
                        if (this.tree.getDragEnabled()) {
                            this.isDragRecognitionOngoing = AquaDragRecognitionSupport.mousePressed(mouseEvent);
                            this.mouseReleaseDeselects = false;
                            this.mouseDragSelects = false;
                        } else {
                            this.mouseReleaseDeselects = this.tree.isFocusOwner();
                        }
                    } else {
                        this.tree.setSelectionInterval(n, n);
                        if (this.tree.getDragEnabled() && this.ui.getPathBounds(this.tree, treePath).contains(mouseEvent.getPoint())) {
                            this.isDragRecognitionOngoing = AquaDragRecognitionSupport.mousePressed(mouseEvent);
                            this.mouseReleaseDeselects = false;
                            this.mouseDragSelects = false;
                            this.isMouseReleaseStartsEditing = false;
                        } else {
                            this.mouseDragSelects = true;
                            this.isMouseReleaseStartsEditing = false;
                        }
                    }
                    this.ui.setAnchorSelectionPath(treePath);
                    this.ui.setLeadSelectionPath(treePath);
                }
            }
            if (isDebug) {
                Utils.logDebug("  mouseDragSelects: " + this.mouseDragSelects);
                Utils.logDebug("  mouseReleaseStartsEditing: " + this.isMouseReleaseStartsEditing);
                Utils.logDebug("  mouseReleaseTogglesExpansion: " + this.isMouseReleaseToggleExpansion);
                Utils.logDebug("  mouseReleaseDeselects: " + this.mouseReleaseDeselects);
                Utils.logDebug("  dragRecognitionOngoing: " + this.isDragRecognitionOngoing);
            }
        }
    }

    @Override
    public void mouseDragged(@NotNull MouseEvent mouseEvent) {
        TreePath treePath;
        int n;
        if (isDebug) {
            Utils.logDebug("JTree mouse dragged");
        }
        if (this.tree.isEnabled() && SwingUtilities.isLeftMouseButton(mouseEvent) && !mouseEvent.isConsumed() && !this.isMouseReleaseToggleExpansion && this.tree.getDragEnabled() && this.isDragRecognitionOngoing) {
            this.isDragRecognitionOngoing = AquaDragRecognitionSupport.mouseDragged(mouseEvent, this);
            if (!this.isDragRecognitionOngoing && this.isDragRecognitionOngoing) {
                Utils.logDebug("  Drag recognition stopped");
            }
        }
        if (this.mouseDragSelects && this.isDragging && (n = this.tree.getRowForPath(treePath = this.ui.getClosestPathForLocation(this.tree, mouseEvent.getX(), mouseEvent.getY()))) != -1) {
            Rectangle rectangle = this.tree.getRowBounds(n);
            this.tree.scrollRectToVisible(rectangle);
            TreePath treePath2 = this.tree.getAnchorSelectionPath();
            int n2 = this.tree.getRowForPath(treePath2);
            if (this.tree.getSelectionModel().getSelectionMode() == 1) {
                this.tree.setSelectionInterval(n, n);
            } else {
                if (n2 < n) {
                    this.tree.setSelectionInterval(n2, n);
                } else {
                    this.tree.setSelectionInterval(n, n2);
                }
                this.ui.setAnchorSelectionPath(treePath2);
                this.ui.setLeadSelectionPath(treePath);
            }
        }
    }

    @Override
    public void mouseMoved(@NotNull MouseEvent mouseEvent) {
        this.ui.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseReleased(@NotNull MouseEvent mouseEvent) {
        if (isDebug) {
            Utils.logDebug("JTree mouse released " + mouseEvent.getClickCount());
        }
        this.isDragging = false;
        if (this.tree.isEnabled() && SwingUtilities.isLeftMouseButton(mouseEvent) && !mouseEvent.isConsumed()) {
            if (this.ui.isEditing(this.tree) && this.tree.getInvokesStopCellEditing() && !this.ui.stopEditing(this.tree)) {
                return;
            }
            if (this.isMouseReleaseToggleExpansion && this.pathToToggle != null) {
                this.ui.toggleExpandState(this.pathToToggle);
                this.isMouseReleaseToggleExpansion = false;
                this.pathToToggle = null;
            } else {
                TreePath treePath = this.getMouseClickedClosestPathForLocation(this.tree, mouseEvent.getX(), mouseEvent.getY());
                if (treePath != null) {
                    if (isDebug) {
                        Utils.logDebug("  path: " + treePath);
                        Utils.logDebug("  shouldStartEditing: " + this.isMouseReleaseStartsEditing);
                    }
                    boolean bl = this.isMouseReleaseStartsEditing;
                    this.isMouseReleaseStartsEditing = false;
                    if (bl && this.ui.startEditing(treePath, mouseEvent)) {
                        if (isDebug) {
                            Utils.logDebug("  Editing started");
                        }
                        return;
                    }
                    if (bl && isDebug) {
                        Utils.logDebug("  UI declined to start editing");
                    }
                    this.mouseDragSelects = false;
                    if (this.mouseReleaseDeselects) {
                        int n = this.tree.getRowForPath(treePath);
                        this.tree.setSelectionInterval(n, n);
                    }
                }
            }
        }
        if (this.tree.isRequestFocusEnabled()) {
            JavaSupport.requestFocusInWindowFromMouseEvent(this.tree);
        }
    }

    @Override
    public void mouseEntered(@NotNull MouseEvent mouseEvent) {
        this.ui.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseExited(@NotNull MouseEvent mouseEvent) {
        if (isDebug) {
            Utils.logDebug("  Mouse exited");
            if (this.isMouseReleaseStartsEditing) {
                Utils.logDebug("  Clearing mouseReleaseStartsEditing");
            }
        }
        this.isMouseReleaseStartsEditing = false;
        this.ui.mouseMoved(null);
    }

    @Nullable
    private TreePath getMouseClickedClosestPathForLocation(@NotNull JTree jTree, int n, int n2) {
        TreePath treePath = this.ui.getClosestPathForLocation(jTree, n, n2);
        if (treePath == null) {
            return null;
        }
        Rectangle rectangle = this.ui.getPathBounds(jTree, treePath);
        if (n2 > rectangle.y + rectangle.height) {
            return null;
        }
        return treePath;
    }
}

