/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuBarUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicRootPaneUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaAppearances;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaComponentUI;
import org.violetlib.aqua.AquaCustomStyledWindow;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.AquaVibrantSupport;
import org.violetlib.aqua.KeyWindowPatch;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.aqua.SystemPropertyChangeManager;
import org.violetlib.aqua.Utils;

public class AquaRootPaneUI
extends BasicRootPaneUI
implements AquaComponentUI,
SystemPropertyChangeManager.SystemPropertyChangeListener {
    public static final String AQUA_WINDOW_STYLE_KEY = "Aqua.windowStyle";
    public static final String AQUA_WINDOW_TOP_MARGIN_KEY = "Aqua.windowTopMargin";
    public static final String AQUA_WINDOW_BOTTOM_MARGIN_KEY = "Aqua.windowBottomMargin";
    public static final String AQUA_WINDOW_REPRESENTED_FILENAME_KEY = "Aqua.windowRepresentedFilename";
    static final boolean sUseScreenMenuBar = AquaUtils.getScreenMenuBarProperty();
    private static boolean forceActiveWindowDisplay;
    protected JRootPane rootPane;
    protected WindowHierarchyListener hierarchyListener;
    protected AncestorListener ancestorListener;
    protected PropertyChangeListener windowStylePropertyChangeListener;
    protected WindowListener windowListener;
    protected ContainerListener containerListener;
    protected boolean isInitialized;
    protected AquaCustomStyledWindow customStyledWindow;
    protected int vibrantStyle = -1;
    protected boolean vibrantStyleIsExplicitlySet;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaRootPaneUI();
    }

    public static void setForceActiveWindowDisplay(boolean bl) {
        if (bl != forceActiveWindowDisplay) {
            Window[] windowArray;
            forceActiveWindowDisplay = bl;
            for (Window window : windowArray = Window.getWindows()) {
                boolean bl2;
                boolean bl3;
                AquaRootPaneUI aquaRootPaneUI;
                JRootPane jRootPane = AquaUtils.getRootPane(window);
                if (jRootPane == null || (aquaRootPaneUI = AquaUtils.getUI(jRootPane, AquaRootPaneUI.class)) == null || (bl3 = bl || window.isActive()) == (bl2 = Boolean.TRUE.equals(jRootPane.getClientProperty("Frame.active")))) continue;
                jRootPane.repaint();
                AquaFocusHandler.updateComponentTreeUIActivation(jRootPane, bl3);
            }
        }
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.rootPane = (JRootPane)jComponent;
        super.installUI(jComponent);
        if (sUseScreenMenuBar) {
            this.containerListener = new MyContainerListener();
            JRootPane jRootPane = (JRootPane)jComponent;
            jRootPane.addContainerListener(this.containerListener);
        }
        this.configureWindowIfPossible();
        this.configureLayeredPane();
        this.configure();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        jComponent.removeAncestorListener(this.ancestorListener);
        this.disposeCustomWindowStyle();
        this.removeVisualEffectView();
        this.unconfigureLayeredPane();
        if (sUseScreenMenuBar) {
            JRootPane jRootPane = (JRootPane)jComponent;
            jRootPane.removeContainerListener(this.containerListener);
            this.containerListener = null;
        }
        this.isInitialized = false;
        this.vibrantStyle = -1;
        this.vibrantStyleIsExplicitlySet = false;
        super.uninstallUI(jComponent);
    }

    @Override
    protected void installListeners(JRootPane jRootPane) {
        super.installListeners(jRootPane);
        this.hierarchyListener = new WindowHierarchyListener();
        jRootPane.addHierarchyListener(this.hierarchyListener);
        AquaAppearances.register(jRootPane);
        this.ancestorListener = new MyAncestorListener();
        jRootPane.addAncestorListener(this.ancestorListener);
        this.windowListener = new MyWindowListener();
        AppearanceManager.installListeners(jRootPane);
    }

    @Override
    protected void uninstallListeners(JRootPane jRootPane) {
        AppearanceManager.uninstallListeners(jRootPane);
        AquaAppearances.unregister(jRootPane);
        jRootPane.removeHierarchyListener(this.hierarchyListener);
        this.hierarchyListener = null;
        jRootPane.removeAncestorListener(this.ancestorListener);
        this.ancestorListener = null;
        Window window = this.getWindow();
        if (window != null) {
            window.removeWindowListener(this.windowListener);
        }
        this.windowListener = null;
        super.uninstallListeners(jRootPane);
        if (this.windowStylePropertyChangeListener != null) {
            jRootPane.removePropertyChangeListener(this.windowStylePropertyChangeListener);
            this.windowStylePropertyChangeListener = null;
        }
    }

    @Override
    public void systemPropertyChanged(JComponent jComponent, Object object) {
        if (object.equals(AquaAppearances.APPEARANCE_CHANGE_TYPE)) {
            this.updateAppearances(null, false);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if ("Aqua.backgroundStyle".equals(string)) {
            Object object = propertyChangeEvent.getNewValue();
            this.updateVibrantStyleFromProperty(object);
        } else if (AQUA_WINDOW_STYLE_KEY.equals(string) || AQUA_WINDOW_TOP_MARGIN_KEY.equals(string) || AQUA_WINDOW_BOTTOM_MARGIN_KEY.equals(string)) {
            this.reconfigureCustomWindowStyle();
        } else if (AQUA_WINDOW_REPRESENTED_FILENAME_KEY.equals(string)) {
            this.configureRepresentedFilename();
        } else if ("ancestor".equals(string)) {
            Container container = this.rootPane.getParent();
            if (container instanceof Window) {
                Window window = (Window)container;
                KeyWindowPatch.applyPatchIfNeeded(window);
            }
        } else if ("Aqua.appearanceName".equals(string)) {
            this.configureSpecifiedWindowAppearance(true);
        }
    }

    private static void updateWindowActivation(WindowEvent windowEvent, boolean bl) {
        if (forceActiveWindowDisplay) {
            bl = true;
        }
        Component component = (Component)windowEvent.getSource();
        component.repaint();
        AquaFocusHandler.updateComponentTreeUIActivation(component, bl);
    }

    @Override
    public final void update(Graphics graphics, JComponent jComponent) {
        if (!this.isInitialized) {
            this.configure();
        }
        AquaAppearance aquaAppearance = AppearanceManager.registerCurrentAppearance(jComponent);
        if (jComponent.isOpaque() || this.vibrantStyle >= 0) {
            int n = 3;
            if (aquaAppearance.isDark() && this.customStyledWindow != null && this.customStyledWindow.isTextured()) {
                n = 0;
            }
            AquaUtils.fillRect(graphics, jComponent, n);
        }
        if (this.customStyledWindow != null) {
            this.customStyledWindow.paintMarginBackgrounds(graphics);
        }
        this.paint(graphics, jComponent);
    }

    public void configure() {
        if (this.rootPane.getParent() != null && this.rootPane.getParent().isDisplayable()) {
            this.isInitialized = true;
            this.configureSpecifiedWindowAppearance(false);
            this.updateAppearances(null, false);
            this.updatePopupStyle(this.rootPane);
            this.reconfigureCustomWindowStyle();
            this.updateVisualEffectView();
            this.configureRepresentedFilename();
        } else {
            this.reconfigureCustomWindowStyle();
        }
    }

    private void configureSpecifiedWindowAppearance(boolean bl) {
        String string;
        Window window = this.getWindow();
        if (window != null && window.isDisplayable() && ((string = this.getSpecifiedWindowAppearance()) != null || bl)) {
            AquaUtils.setWindowAppearance(window, string);
        }
    }

    @Nullable
    private String getSpecifiedWindowAppearance() {
        Object object = this.rootPane.getClientProperty("Aqua.appearanceName");
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    private void unconfigure() {
        this.removeVisualEffectView();
        Window window = this.getWindow();
        if (window != null) {
            this.configureEmbeddedDialogPatchIfNeeded(window);
        }
    }

    public void windowAppearanceChanged(@NotNull String string) {
        this.updateAppearances(string, false);
    }

    protected void updateAppearances(@Nullable String string, boolean bl) {
        Window window = this.getWindow();
        if (window != null) {
            this.updateWindowAppearances(window, string, bl);
        }
    }

    protected void updateWindowAppearances(@NotNull Window window, @Nullable String string, boolean bl) {
        if (string == null) {
            string = AquaUtils.getWindowEffectiveAppearanceName(window);
        }
        if (string != null) {
            AquaAppearance aquaAppearance;
            AquaAppearance aquaAppearance2 = AquaAppearances.get(string);
            if (aquaAppearance2 != (aquaAppearance = (AquaAppearance)this.rootPane.getClientProperty("Aqua.appearance"))) {
                this.rootPane.repaint();
                AppearanceManager.setRootPaneRegisteredAppearance(this.rootPane, aquaAppearance2);
            } else if (bl) {
                this.configureWindow(window);
                this.appearanceHasChanged();
            }
        }
    }

    private void configureWindowIfPossible() {
        Container container = this.rootPane.getParent();
        if (container instanceof Window) {
            Window window = (Window)container;
            this.configureWindow(window);
        }
    }

    protected void configureWindow(@NotNull Window window) {
        this.configureEmbeddedDialogPatchIfNeeded(window);
        if (window.isDisplayable()) {
            if (OSXSystemProperties.OSVersion >= 1014 && !this.vibrantStyleIsExplicitlySet) {
                int n = this.getDefaultWindowVibrantStyle();
                this.updateVibrantStyle(n, false);
            }
            if (!AquaColors.isPriority(this.rootPane.getBackground())) {
                this.rootPane.setBackground(null);
            }
            Color color = AquaUtils.getWindowBackground(this.rootPane);
            AquaUtils.setBackgroundCarefully(window, color);
            Color color2 = window.getForeground();
            if (!(color2 instanceof UIResource)) {
                window.setForeground(new ColorUIResource(color2));
            }
        }
    }

    protected void configureEmbeddedDialogPatchIfNeeded(@NotNull Window window) {
        if (window instanceof Dialog) {
            Dialog dialog = (Dialog)window;
            if (AquaUtils.windowHasEmbeddedOwner(window)) {
                String string = dialog.isModal() ? " modal" : "";
                Utils.logDebug("Configuring" + string + " dialog with embedded owner");
                if (dialog.isVisible() && dialog.isDisplayable()) {
                    AquaUtils.fixWindowWithEmbeddedOwner(window, 8);
                }
            }
        }
    }

    protected int getDefaultWindowVibrantStyle() {
        AquaAppearance aquaAppearance = AppearanceManager.getAppearance(this.rootPane);
        if (aquaAppearance.isDark()) {
            return 11;
        }
        return -1;
    }

    protected void appearanceHasChanged() {
        this.rootPane.repaint();
    }

    @Override
    public void appearanceChanged(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
        Container container = this.rootPane.getParent();
        if (container instanceof Window) {
            Window window = (Window)container;
            this.configureWindow(window);
        }
        this.appearanceHasChanged();
    }

    @Override
    public void activeStateChanged(@NotNull JComponent jComponent, boolean bl) {
        Container container = this.rootPane.getParent();
        if (container instanceof Window) {
            Window window = (Window)container;
            this.configureWindow(window);
        }
    }

    protected void updatePopupStyle(JRootPane jRootPane) {
        Component component;
        int n;
        Container container;
        Window window = SwingUtilities.getWindowAncestor(jRootPane);
        if (window != null && window.getType() == Window.Type.POPUP && (container = jRootPane.getContentPane()) != null && (n = container.getComponentCount()) == 1 && (component = container.getComponent(0)) instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            Object object = jComponent.getClientProperty("AquaPopup.backgroundStyle");
            this.updateVibrantStyleFromProperty(object);
            object = jComponent.getClientProperty("AquaPopup.cornerRadius");
            this.configurePopup(object);
        }
    }

    protected void configureRepresentedFilename() {
        Window window = this.getWindow();
        if (window != null && window.isDisplayable()) {
            Object object = this.rootPane.getClientProperty(AQUA_WINDOW_REPRESENTED_FILENAME_KEY);
            String string = "";
            if (object instanceof String) {
                string = (String)object;
            }
            AquaUtils.setWindowRepresentedFilename(window, string);
        }
    }

    protected void configureLayeredPane() {
        JLayeredPane jLayeredPane = this.rootPane.getLayeredPane();
        AppearanceManager.installListeners(jLayeredPane);
        if (sUseScreenMenuBar) {
            jLayeredPane.addContainerListener(this.containerListener);
        }
    }

    protected void unconfigureLayeredPane() {
        JLayeredPane jLayeredPane = this.rootPane.getLayeredPane();
        AppearanceManager.uninstallListeners(jLayeredPane);
        if (sUseScreenMenuBar) {
            jLayeredPane.removeContainerListener(this.containerListener);
        }
    }

    protected void updateVibrantStyleFromProperty(Object object) {
        int n;
        this.updateVibrantStyle(n, (n = AquaVibrantSupport.parseVibrantStyle(object, false)) != -1);
    }

    protected void updateVibrantStyle(int n, boolean bl) {
        int n2 = this.vibrantStyle;
        this.vibrantStyle = n;
        this.vibrantStyleIsExplicitlySet = bl;
        if (this.vibrantStyle != n2 && this.isInitialized) {
            this.updateVisualEffectView();
        }
    }

    protected void configurePopup(Object object) {
        Object object2;
        float f = 0.0f;
        if (object != null) {
            if (object instanceof String) {
                object2 = (String)object;
                if (((String)object2).equals("default")) {
                    f = 6.0f;
                }
            } else if (object instanceof Number) {
                f = ((Number)object).floatValue();
            }
            if (f < 0.0f) {
                f = 0.0f;
            }
        }
        object2 = SwingUtilities.getWindowAncestor(this.rootPane);
        AquaUtils.configurePopup((Window)object2, f);
    }

    @Nullable
    protected Window getWindow() {
        return SwingUtilities.getWindowAncestor(this.rootPane);
    }

    protected void updateVisualEffectView() {
        Window window = this.getWindow();
        if (window != null && !this.isEmbeddedView(window)) {
            if (this.vibrantStyle >= 0) {
                try {
                    AquaVibrantSupport.addFullWindowVibrantView(window, this.vibrantStyle);
                }
                catch (IllegalArgumentException | UnsupportedOperationException runtimeException) {
                    Utils.logError("Unable to install visual effect view", runtimeException);
                }
            } else {
                AquaVibrantSupport.removeFullWindowVibrantView(window);
            }
        }
    }

    protected boolean isEmbeddedView(@NotNull Window window) {
        String string = window.getClass().getSimpleName();
        return string.contains("CViewEmbeddedFrame");
    }

    protected void removeVisualEffectView() {
        Window window = this.getWindow();
        if (window != null) {
            AquaVibrantSupport.removeFullWindowVibrantView(window);
        }
    }

    protected void reconfigureCustomWindowStyle() {
        Window window = this.getWindow();
        int n = this.getCustomWindowStyle();
        if (n < 0 || window == null) {
            this.disposeCustomWindowStyle();
            if (window != null) {
                this.configureWindow(window);
            }
        } else if (window.isDisplayable()) {
            int n2 = this.getTopMarginHeight();
            int n3 = this.getBottomMarginHeight();
            if (this.customStyledWindow != null && !this.customStyledWindow.isValid(n, n2, n3)) {
                this.customStyledWindow = this.customStyledWindow.reconfigure(n, n2, n3);
                this.configureWindow(window);
            } else if (this.customStyledWindow == null) {
                try {
                    this.customStyledWindow = new AquaCustomStyledWindow(window, n, n2, n3);
                    this.configureWindow(window);
                }
                catch (AquaCustomStyledWindow.RequiredToolBarNotFoundException requiredToolBarNotFoundException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    AquaUtils.syslog("Unable to install custom window style: " + illegalArgumentException.getMessage());
                }
            }
        } else {
            AquaCustomStyledWindow.preconfigureWindowStyle(window, n);
        }
    }

    private void disposeCustomWindowStyle() {
        if (this.customStyledWindow != null) {
            this.customStyledWindow.dispose();
            this.customStyledWindow = null;
        }
    }

    public AquaCustomStyledWindow getCustomStyledWindow() {
        return this.customStyledWindow;
    }

    @Nullable
    public static String getWindowStyleKey(@NotNull JRootPane jRootPane) {
        Object object = jRootPane.getClientProperty(AQUA_WINDOW_STYLE_KEY);
        return object instanceof String ? (String)object : null;
    }

    protected int getCustomWindowStyle() {
        String string = AquaRootPaneUI.getWindowStyleKey(this.rootPane);
        if (string != null) {
            if ("unifiedToolBar".equals(string)) {
                return 3;
            }
            if ("texturedToolBar".equals(string)) {
                return 4;
            }
            if ("combinedToolBar".equals(string)) {
                return 5;
            }
            if ("overlayTitleBar".equals(string)) {
                return 0;
            }
            if ("transparentTitleBar".equals(string)) {
                return 1;
            }
            if ("noTitleBar".equals(string)) {
                return 2;
            }
            if ("undecorated".equals(string)) {
                return 6;
            }
        }
        return -1;
    }

    protected int getTopMarginHeight() {
        Integer n = AquaUtils.getIntegerProperty(this.rootPane, AQUA_WINDOW_TOP_MARGIN_KEY);
        return n != null ? n : -1;
    }

    protected int getBottomMarginHeight() {
        Integer n = AquaUtils.getIntegerProperty(this.rootPane, AQUA_WINDOW_BOTTOM_MARGIN_KEY);
        return n != null ? n : -1;
    }

    private class MyContainerListener
    implements ContainerListener {
        private MyContainerListener() {
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            Window window;
            JMenuBar jMenuBar;
            MenuBarUI menuBarUI;
            if (containerEvent.getContainer() instanceof JRootPane) {
                JRootPane jRootPane = (JRootPane)containerEvent.getContainer();
                if (containerEvent.getChild() == jRootPane.getLayeredPane()) {
                    AquaRootPaneUI.this.configureLayeredPane();
                }
            } else if (containerEvent.getChild() instanceof JMenuBar && (menuBarUI = (jMenuBar = (JMenuBar)containerEvent.getChild()).getUI()).getClass().getName().equals("com.apple.laf.AquaMenuBarUI") && (window = SwingUtilities.getWindowAncestor(jMenuBar)) instanceof JFrame) {
                JFrame jFrame = (JFrame)window;
                AquaUtils.setScreenMenuBar(jFrame, menuBarUI);
            }
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            Window window;
            JMenuBar jMenuBar;
            MenuBarUI menuBarUI;
            if (containerEvent.getContainer() instanceof JRootPane) {
                JRootPane jRootPane = (JRootPane)containerEvent.getContainer();
                if (containerEvent.getChild() == jRootPane.getLayeredPane()) {
                    AquaRootPaneUI.this.unconfigureLayeredPane();
                }
            } else if (containerEvent.getChild() instanceof JMenuBar && (menuBarUI = (jMenuBar = (JMenuBar)containerEvent.getChild()).getUI()).getClass().getName().equals("com.apple.laf.AquaMenuBarUI") && (window = SwingUtilities.getWindowAncestor(jMenuBar)) instanceof JFrame) {
                JFrame jFrame = (JFrame)window;
                AquaUtils.clearScreenMenuBar(jFrame, menuBarUI);
            }
        }
    }

    protected class WindowHierarchyListener
    implements HierarchyListener {
        protected WindowHierarchyListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            long l = hierarchyEvent.getChangeFlags();
            if ((l & 2L) != 0L) {
                if (AquaRootPaneUI.this.rootPane.getParent() != null && AquaRootPaneUI.this.rootPane.getParent().isDisplayable()) {
                    AquaRootPaneUI.this.configureWindowIfPossible();
                    AquaRootPaneUI.this.configure();
                } else {
                    AquaRootPaneUI.this.unconfigure();
                }
            }
        }
    }

    protected class MyAncestorListener
    implements AncestorListener {
        protected MyAncestorListener() {
        }

        @Override
        public void ancestorAdded(AncestorEvent ancestorEvent) {
            Window window = AquaRootPaneUI.this.getWindow();
            if (window != null) {
                window.removeWindowListener(AquaRootPaneUI.this.windowListener);
                window.addWindowListener(AquaRootPaneUI.this.windowListener);
            }
        }

        @Override
        public void ancestorRemoved(AncestorEvent ancestorEvent) {
        }

        @Override
        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }
    }

    private class MyWindowListener
    extends WindowAdapter {
        private MyWindowListener() {
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            AquaRootPaneUI.updateWindowActivation(windowEvent, true);
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            AquaRootPaneUI.updateWindowActivation(windowEvent, false);
        }
    }
}

