/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Window;
import javax.swing.JRootPane;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaRootPaneUI;
import org.violetlib.aqua.AquaUtils;

public abstract class AquaPopupFactory
extends PopupFactory {
    protected boolean isActive;

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean bl) {
        this.isActive = bl;
    }

    @Override
    public Popup getPopup(Component component, Component component2, int n, int n2) throws IllegalArgumentException {
        if (this.isActive) {
            Popup popup = this.getHeavyweightPopup(component, component2, n, n2);
            return this.configure(component, popup, component2);
        }
        return super.getPopup(component, component2, n, n2);
    }

    protected abstract Popup getHeavyweightPopup(Component var1, Component var2, int var3, int var4);

    protected Popup getDefaultPopup(Component component, Component component2, int n, int n2) {
        return super.getPopup(component, component2, n, n2);
    }

    private Popup configure(Component component, Popup popup, Component component2) {
        Window window = SwingUtilities.getWindowAncestor(component2);
        AquaRootPaneUI aquaRootPaneUI = null;
        JRootPane jRootPane = AquaUtils.getRootPane(window);
        if (jRootPane != null && (aquaRootPaneUI = AquaUtils.getUI(jRootPane, AquaRootPaneUI.class)) == null) {
            jRootPane.updateUI();
            aquaRootPaneUI = AquaUtils.getUI(jRootPane, AquaRootPaneUI.class);
        }
        if (window.isDisplayable() && window.getWidth() > 0) {
            window.setSize(window.getPreferredSize());
            window.invalidate();
            window.validate();
        }
        if (aquaRootPaneUI != null) {
            String string = AppearanceManager.getSpecifiedAppearanceName(component);
            AppearanceManager.setSpecifiedAppearanceName(jRootPane, string);
        }
        AquaUtils.nativeFixPopupWindow((Window)window.getParent(), popup);
        return popup;
    }
}

