/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceContext;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaComponentUI;
import org.violetlib.aqua.AquaLookAndFeel;
import org.violetlib.aqua.AquaMenuSupport;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.BasicContextualColors;
import org.violetlib.aqua.MenuSelectionBoundsTracker;
import org.violetlib.aqua.OSXSystemProperties;

public class AquaMenuItemUI
extends BasicMenuItemUI
implements AquaComponentUI {
    static final int kPlain = 0;
    static final int kCheckBox = 1;
    static final int kRadioButton = 2;
    static final String[] sPropertyPrefixes = new String[]{"MenuItem", "CheckBoxMenuItem", "RadioButtonMenuItem"};
    boolean fIsIndeterminate = false;
    int fType;
    @NotNull
    protected BasicContextualColors colors;
    @Nullable
    protected AppearanceContext appearanceContext;
    static final String CLIENT_PROPERTY_KEY = "JMenuItem.selectedState";
    static final IndeterminateListener INDETERMINATE_LISTENER = new IndeterminateListener();

    public AquaMenuItemUI(int n) {
        this.fType = n;
        this.colors = AquaColors.getMenuColors();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        int n = 0;
        if (jComponent instanceof JCheckBoxMenuItem) {
            n = 1;
        }
        if (jComponent instanceof JRadioButtonMenuItem) {
            n = 2;
        }
        return new AquaMenuItemUI(n);
    }

    @Override
    protected String getPropertyPrefix() {
        return sPropertyPrefixes[this.fType];
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.configureAppearanceContext(null);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        IndeterminateListener.install(this.menuItem);
        AppearanceManager.installListeners(this.menuItem);
    }

    @Override
    protected void uninstallListeners() {
        AppearanceManager.uninstallListeners(this.menuItem);
        IndeterminateListener.uninstall(this.menuItem);
        super.uninstallListeners();
    }

    @Override
    public void appearanceChanged(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
        this.configureAppearanceContext(aquaAppearance);
    }

    @Override
    public void activeStateChanged(@NotNull JComponent jComponent, boolean bl) {
        this.configureAppearanceContext(null);
    }

    protected void configureAppearanceContext(@Nullable AquaAppearance aquaAppearance) {
        if (aquaAppearance == null) {
            aquaAppearance = AppearanceManager.ensureAppearance(this.menuItem);
        }
        this.appearanceContext = AquaMenuSupport.instance().getAppearanceContext(this.menuItem, aquaAppearance);
        AquaColors.installColors(this.menuItem, this.appearanceContext, this.colors);
        this.menuItem.repaint();
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        AppearanceManager.registerCurrentAppearance(jComponent);
        super.update(graphics, jComponent);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this.appearanceContext = AquaMenuSupport.instance().getAppearanceContext(this.menuItem, null);
        if (AquaLookAndFeel.USE_VIBRANT_MENU) {
            JPopupMenu jPopupMenu;
            Object object;
            Container container = jComponent.getParent();
            if (container instanceof JPopupMenu && (object = (jPopupMenu = (JPopupMenu)container).getClientProperty("Aqua.PopupMenu.Tracker")) instanceof MenuSelectionBoundsTracker) {
                MenuSelectionBoundsTracker menuSelectionBoundsTracker = (MenuSelectionBoundsTracker)object;
                menuSelectionBoundsTracker.paintingItem((JMenuItem)jComponent, this.appearanceContext);
            }
        } else if (jComponent.isOpaque()) {
            Color color = this.colors.getBackground(this.appearanceContext);
            graphics.setColor(color);
            if (OSXSystemProperties.useInsetViewStyle()) {
                AquaUtils.paintInsetMenuItemSelection((Graphics2D)graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
            } else {
                graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            }
        }
        AquaMenuSupport.instance().paintMenuItem((Graphics2D)graphics, this.menuItem, this.checkIcon, this.arrowIcon, this.appearanceContext, this.colors, this.defaultTextIconGap, this.acceleratorFont);
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n) {
        return AquaMenuSupport.instance().getPreferredMenuItemSize(jComponent, icon, icon2, n, this.acceleratorFont);
    }

    @Override
    protected void doClick(MenuSelectionManager menuSelectionManager) {
        final Dimension dimension = this.menuItem.getSize();
        AquaUtils.blinkMenu(new AquaUtils.Selectable(){
            final /* synthetic */ AquaMenuItemUI this$0;
            {
                this.this$0 = aquaMenuItemUI;
            }

            @Override
            public void paintSelected(boolean bl) {
                this.this$0.menuItem.setArmed(bl);
                this.this$0.menuItem.paintImmediately(0, 0, dimension.width, dimension.height);
            }
        });
        super.doClick(menuSelectionManager);
    }

    static class IndeterminateListener
    implements PropertyChangeListener {
        IndeterminateListener() {
        }

        static void install(JMenuItem jMenuItem) {
            jMenuItem.addPropertyChangeListener(AquaMenuItemUI.CLIENT_PROPERTY_KEY, INDETERMINATE_LISTENER);
            IndeterminateListener.apply(jMenuItem, jMenuItem.getClientProperty(AquaMenuItemUI.CLIENT_PROPERTY_KEY));
        }

        static void uninstall(JMenuItem jMenuItem) {
            jMenuItem.removePropertyChangeListener(AquaMenuItemUI.CLIENT_PROPERTY_KEY, INDETERMINATE_LISTENER);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (!AquaMenuItemUI.CLIENT_PROPERTY_KEY.equalsIgnoreCase(string)) {
                return;
            }
            Object object = propertyChangeEvent.getSource();
            if (!(object instanceof JMenuItem)) {
                return;
            }
            JMenuItem jMenuItem = (JMenuItem)object;
            IndeterminateListener.apply(jMenuItem, propertyChangeEvent.getNewValue());
        }

        static void apply(JMenuItem jMenuItem, Object object) {
            ButtonUI buttonUI = jMenuItem.getUI();
            if (!(buttonUI instanceof AquaMenuItemUI)) {
                return;
            }
            AquaMenuItemUI aquaMenuItemUI = (AquaMenuItemUI)buttonUI;
            aquaMenuItemUI.fIsIndeterminate = "indeterminate".equals(object);
            if (aquaMenuItemUI.fIsIndeterminate) {
                aquaMenuItemUI.checkIcon = UIManager.getIcon(aquaMenuItemUI.getPropertyPrefix() + ".dashIcon");
            } else {
                aquaMenuItemUI.checkIcon = UIManager.getIcon(aquaMenuItemUI.getPropertyPrefix() + ".checkIcon");
            }
        }

        public static boolean isIndeterminate(JMenuItem jMenuItem) {
            return "indeterminate".equals(jMenuItem.getClientProperty(AquaMenuItemUI.CLIENT_PROPERTY_KEY));
        }
    }
}

