/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicListUI;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceContext;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaComponentUI;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaListMouseBehavior;
import org.violetlib.aqua.AquaLookAndFeel;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.AquaViewStyleContainerUI;
import org.violetlib.aqua.ContainerContextualColors;
import org.violetlib.aqua.JListModel;
import org.violetlib.aqua.ListSelectionBoundsTracker;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.aqua.VisualEffectView;
import org.violetlib.jnr.aqua.AquaUIPainter;

public class AquaListUI
extends BasicListUI
implements AquaComponentUI,
AquaViewStyleContainerUI {
    public static final String LIST_STYLE_KEY = "JList.style";
    public static final String QUAQUA_LIST_STYLE_KEY = "Quaqua.List.style";
    public static final String LIST_VIEW_STYLE_KEY = "JList.viewStyle";
    private boolean isSideBar;
    private boolean isStriped;
    private boolean isInset;
    private boolean isMenu;
    private boolean isVibrantMenu;
    private boolean hasSelection;
    private boolean isDropActive;
    private boolean isSelectionMuted;
    private boolean hasDropOnTarget;
    private ListVibrantEffects vibrantEffects;
    @NotNull
    protected ContainerContextualColors colors = AquaColors.CONTAINER_COLORS;
    @Nullable
    protected AppearanceContext appearanceContext;
    private static final Border insetBorder = new BorderUIResource.EmptyBorderUIResource(5, 0, 5, 0);
    private DropTargetListener dropTargetListener;
    private DropTarget knownDropTarget;
    private static final int DROP_LINE_THICKNESS = 2;
    private int layoutOrientation;
    private boolean isLeftToRight;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaListUI();
    }

    public void configureAsMenu(boolean bl) {
        this.isMenu = true;
        this.isVibrantMenu = bl;
        this.updateVibrantEffects();
    }

    public void setColors(@NotNull ContainerContextualColors containerContextualColors) {
        if (containerContextualColors != this.colors) {
            this.colors = containerContextualColors;
            this.configureAppearanceContext(null);
        }
    }

    @Override
    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new AquaListMouseBehavior(new JListModel(this.list));
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.list.putClientProperty("JComponent.isCellContainer", true);
        this.isStriped = this.getStripedValue();
        this.isInset = this.getInsetValue();
        this.isSideBar = this.getSideBarValue();
        this.colors = this.determineColors();
        this.updateBorderForInset();
        this.updateOpaque();
        this.updateSideBarConfiguration();
        this.updateVibrantEffects();
        this.configureAppearanceContext(null);
    }

    @Override
    protected void uninstallDefaults() {
        this.disposeVibrantEffects();
        this.removeInsetBorder();
        super.uninstallDefaults();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        AppearanceManager.installListeners(this.list);
        AquaUtils.installInsetViewListener(this.list);
    }

    @Override
    protected void uninstallListeners() {
        if (this.knownDropTarget != null) {
            this.knownDropTarget.removeDropTargetListener(this.dropTargetListener);
            this.knownDropTarget = null;
        }
        AquaUtils.uninstallInsetViewListener(this.list);
        AppearanceManager.uninstallListeners(this.list);
        super.uninstallListeners();
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.list.getActionMap().put("aquaHome", new AquaHomeEndAction(true));
        this.list.getActionMap().put("aquaEnd", new AquaHomeEndAction(false));
    }

    protected void repaintDropTarget() {
        SwingUtilities.invokeLater(() -> this.list.repaint());
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new AquaPropertyChangeHandler();
    }

    private void configureDropTargetListener() {
        if (this.knownDropTarget != null) {
            this.knownDropTarget.removeDropTargetListener(this.dropTargetListener);
            this.knownDropTarget = null;
        }
        if (this.dropTargetListener == null) {
            this.dropTargetListener = new MyDropTargetListener();
        }
        this.knownDropTarget = this.list.getDropTarget();
        if (this.knownDropTarget != null) {
            try {
                this.knownDropTarget.addDropTargetListener(this.dropTargetListener);
            }
            catch (TooManyListenersException tooManyListenersException) {
                // empty catch block
            }
        }
    }

    @NotNull
    public ContainerContextualColors getColors() {
        return this.colors;
    }

    @Override
    public void appearanceChanged(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
        this.configureAppearanceContext(aquaAppearance);
    }

    @Override
    public void activeStateChanged(@NotNull JComponent jComponent, boolean bl) {
        this.configureAppearanceContext(null);
    }

    protected void configureAppearanceContext(@Nullable AquaAppearance aquaAppearance) {
        if (aquaAppearance == null) {
            aquaAppearance = AppearanceManager.ensureAppearance(this.list);
        }
        AquaUIPainter.State state = this.getState();
        this.appearanceContext = new AppearanceContext(aquaAppearance, state, false, false);
        this.colors.configureForContainer();
        AquaColors.installColors(this.list, this.appearanceContext, this.colors);
        this.updateOpaque();
        this.list.repaint();
    }

    @NotNull
    protected ContainerContextualColors determineColors() {
        if (this.isSideBar()) {
            return AquaColors.SIDEBAR_CONTAINER_COLORS;
        }
        if (this.isStriped) {
            return AquaColors.STRIPED_CONTAINER_COLORS;
        }
        return AquaColors.CONTAINER_COLORS;
    }

    protected AquaUIPainter.State getState() {
        return this.list.isEnabled() ? (this.shouldDisplayAsFocused() ? AquaUIPainter.State.ACTIVE_DEFAULT : AquaUIPainter.State.ACTIVE) : AquaUIPainter.State.DISABLED;
    }

    protected boolean shouldDisplayAsFocused() {
        return AquaFocusHandler.hasFocus(this.list);
    }

    protected void updateSideBarConfiguration() {
        if (this.isSideBar()) {
            this.list.setLayoutOrientation(0);
        }
        this.updateVibrantEffects();
        if (AquaUtils.isInsetViewSupported()) {
            this.updateInsetConfiguration();
        }
    }

    protected void updateVibrantEffects() {
        if (this.list.isDisplayable()) {
            if (this.isSideBar()) {
                this.ensureVibrantEffects(2);
                return;
            }
            if (this.isVibrantMenu && AquaLookAndFeel.USE_VIBRANT_MENU) {
                this.ensureVibrantEffects(4);
                return;
            }
        }
        this.disposeVibrantEffects();
    }

    protected void ensureVibrantEffects(int n) {
        JComponent jComponent = this.getComponentForVisualEffectView();
        if (this.vibrantEffects != null && (this.vibrantEffects.getComponent() != jComponent || this.vibrantEffects.style != n)) {
            this.disposeVibrantEffects();
        }
        if (this.vibrantEffects == null) {
            this.vibrantEffects = new ListVibrantEffects(jComponent, n);
        }
    }

    protected void disposeVibrantEffects() {
        if (this.vibrantEffects != null) {
            this.vibrantEffects.dispose();
            this.vibrantEffects = null;
        }
    }

    @NotNull
    protected JComponent getComponentForVisualEffectView() {
        Container container = this.list.getParent();
        if (container instanceof JViewport) {
            return (JViewport)container;
        }
        return this.list;
    }

    private void updateStyleProperties() {
        boolean bl = false;
        boolean bl2 = this.getStripedValue();
        if (bl2 != this.isStriped) {
            this.isStriped = bl2;
            bl = true;
        }
        boolean bl3 = false;
        boolean bl4 = this.getSideBarValue();
        if (bl4 != this.isSideBar) {
            this.isSideBar = bl4;
            bl3 = true;
        }
        if (bl || bl3) {
            this.colors = this.determineColors();
            this.configureAppearanceContext(null);
        }
        if (bl3) {
            this.updateSideBarConfiguration();
        }
    }

    private void updateStriped() {
        boolean bl = this.getStripedValue();
        if (bl != this.isStriped) {
            this.isStriped = bl;
            this.colors = this.isStriped ? AquaColors.STRIPED_CONTAINER_COLORS : AquaColors.CONTAINER_COLORS;
            this.updateOpaque();
            this.configureAppearanceContext(null);
        }
    }

    private boolean getStripedValue() {
        String string = this.getStyleProperty();
        return "striped".equals(string) && this.list.getLayoutOrientation() == 0 && this.isBackgroundClear();
    }

    @Override
    public void scrollPaneAncestorChanged(@Nullable JScrollPane jScrollPane) {
    }

    private void updateInset() {
        boolean bl = this.getInsetValue();
        if (bl != this.isInset) {
            this.isInset = bl;
            this.updateInsetConfiguration();
        }
    }

    private void updateInsetConfiguration() {
        this.updateBorderForInset();
        this.configureAppearanceContext(null);
        this.updateLayoutStateNeeded |= 0x40;
        this.list.revalidate();
        this.list.repaint();
    }

    private void updateBorderForInset() {
        this.updateBorder(this.isInset() && !this.isMenu ? insetBorder : null);
    }

    private void removeInsetBorder() {
        Border border = this.list.getBorder();
        if (border == insetBorder) {
            this.list.setBorder(null);
        }
    }

    private boolean getInsetValue() {
        if (AquaUtils.isInsetViewSupported()) {
            String string = this.getViewStyleProperty();
            return "inset".equals(string);
        }
        return false;
    }

    private boolean getSideBarValue() {
        String string = this.getStyleProperty();
        return string != null && (string.equals("sideBar") || string.equals("sourceList"));
    }

    private void updateBorder(@Nullable Border border) {
        Border border2 = this.list.getBorder();
        if (border2 != border && border2 == null || border2 instanceof UIResource) {
            this.list.setBorder(border);
        }
    }

    private void updateOpaque() {
        Color color = this.list.getBackground();
        this.list.setOpaque(!this.isStriped && (this.isVibrant() || color == null || color.getAlpha() == 255));
    }

    private boolean isBackgroundClear() {
        Color color = this.list.getBackground();
        return color == null || color.getAlpha() == 0 || color instanceof ColorUIResource;
    }

    public boolean isStriped() {
        return this.isStriped;
    }

    public boolean isSideBar() {
        return this.isSideBar;
    }

    public boolean isVibrant() {
        return this.isSideBar || AquaLookAndFeel.USE_VIBRANT_MENU && this.isVibrantMenu;
    }

    @Override
    public boolean isInset() {
        return this.isInset || this.isVibrant() && OSXSystemProperties.useInsetViewStyle();
    }

    protected boolean isStyleProperty(String string) {
        return AquaUtils.isProperty(string, LIST_STYLE_KEY, QUAQUA_LIST_STYLE_KEY);
    }

    @Nullable
    protected String getStyleProperty() {
        return AquaUtils.getProperty(this.list, LIST_STYLE_KEY, QUAQUA_LIST_STYLE_KEY);
    }

    protected boolean isViewStyleProperty(String string) {
        return AquaUtils.isProperty(string, LIST_VIEW_STYLE_KEY);
    }

    @Nullable
    protected String getViewStyleProperty() {
        return AquaUtils.getProperty(this.list, LIST_VIEW_STYLE_KEY);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        AppearanceManager.registerCurrentAppearance(jComponent);
        if (this.list.isOpaque()) {
            Color color = this.getBackgroundColor();
            int n = this.list.getWidth();
            int n2 = this.list.getHeight();
            AquaUtils.fillRect(graphics, color, 0, 0, n, n2);
        }
        this.paint(graphics, jComponent);
    }

    @Nullable
    private Color getBackgroundColor() {
        return this.isVibrant() ? null : this.list.getBackground();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.appearanceContext != null) {
            this.hasSelection = !this.list.getSelectionModel().isSelectionEmpty();
            this.isSelectionMuted = false;
            this.hasDropOnTarget = false;
            JList.DropLocation dropLocation = null;
            if (this.isDropActive && (dropLocation = this.list.getDropLocation()) != null) {
                this.hasDropOnTarget = !dropLocation.isInsert();
                this.isSelectionMuted = this.hasSelection;
            }
            if (this.vibrantEffects != null) {
                this.vibrantEffects.update();
            } else {
                this.paintStripes(graphics);
            }
            super.paint(graphics, jComponent);
            if (dropLocation != null && dropLocation.isInsert()) {
                Color color = this.appearanceContext.getAppearance().getColor("controlAccent");
                if (color == null) {
                    color = this.appearanceContext.getAppearance().isDark() ? Color.WHITE : Color.BLACK;
                }
                this.paintDropLine(graphics, dropLocation, color);
            }
        }
    }

    public void paintStripes(Graphics graphics) {
        if (this.isStriped && this.list.getModel() != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            assert (this.appearanceContext != null);
            Dimension dimension = this.list.getSize();
            Insets insets = this.list.getInsets();
            int n = this.list.getFixedCellHeight();
            int n2 = this.list.getModel().getSize();
            if (n <= 0) {
                n = n2 == 0 ? 12 : this.getCellBounds(this.list, (int)0, (int)0).height;
            }
            int n3 = (int)Math.ceil(Math.abs(dimension.getHeight() / (double)n));
            int n4 = 0;
            int n5 = insets.top;
            ListSelectionModel listSelectionModel = this.list.getSelectionModel();
            while (n4 < n3) {
                boolean bl = listSelectionModel.isSelectedIndex(n4);
                this.colors.configureForRow(n4, bl && !this.isInset());
                Color color = this.colors.getBackground(this.appearanceContext);
                graphics.setColor(color);
                if (this.isInset()) {
                    AquaUtils.paintInsetStripedRow(graphics2D, 0, n5, dimension.width, n);
                } else {
                    graphics.fillRect(0, n5, dimension.width, n);
                }
                ++n4;
                n5 += n;
            }
        }
    }

    protected void paintCell(Graphics graphics, int n, Rectangle rectangle, ListCellRenderer listCellRenderer, ListModel listModel, ListSelectionModel listSelectionModel, int n2) {
        Object object;
        Object object2;
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        assert (this.appearanceContext != null);
        boolean bl = listSelectionModel.isSelectedIndex(n);
        boolean bl2 = this.shouldDisplayAsFocused();
        boolean bl3 = bl2 && n == n2;
        boolean bl4 = this.list.getLayoutOrientation() != 0;
        boolean bl5 = false;
        AppearanceContext appearanceContext = this.appearanceContext;
        if (bl && this.isSelectionMuted) {
            appearanceContext = appearanceContext.withState(AquaUIPainter.State.ACTIVE);
        }
        if (this.isDropActive) {
            bl3 = false;
            if (this.hasDropOnTarget && (object2 = this.list.getDropLocation()) != null && ((JList.DropLocation)object2).getIndex() == n) {
                bl5 = true;
                appearanceContext = appearanceContext.withState(AquaUIPainter.State.ACTIVE_DEFAULT);
            }
        }
        this.colors.configureForRow(n, bl || bl5);
        if ((bl || bl5) && !this.isVibrant()) {
            if (bl5) {
                appearanceContext = appearanceContext.withSelected(true);
            }
            object2 = this.colors.getBackground(appearanceContext);
            graphics.setColor((Color)object2);
            if (!AquaColors.isPriority(this.list.getSelectionBackground())) {
                this.list.setSelectionBackground((Color)object2);
            }
            if (this.isInset() && !this.isVibrantMenu) {
                object = (Graphics2D)graphics;
                if (this.isMenu) {
                    AquaUtils.paintInsetMenuItemSelection((Graphics2D)object, n3, n4, n5, n6);
                } else if (bl4) {
                    AquaUtils.paintInsetCellSelection((Graphics2D)object, n3, n4, n5, n6);
                } else {
                    boolean bl6 = n > 0 && listSelectionModel.isSelectedIndex(n - 1) && !this.hasDropOnTarget;
                    boolean bl7 = n < this.list.getModel().getSize() - 1 && listSelectionModel.isSelectedIndex(n + 1) && !this.hasDropOnTarget;
                    AquaUtils.paintInsetCellSelection((Graphics2D)object, bl6, bl7, n3, n4, n5, n6);
                }
            } else if (!this.isStriped) {
                graphics.fillRect(n3, n4, n5, n6);
            }
        }
        if (bl5 && !this.isInset) {
            bl = true;
        }
        if ((object = listCellRenderer.getListCellRendererComponent(this.list, object2 = listModel.getElementAt(n), n, bl, bl3)) instanceof JTextComponent) {
            ((JTextComponent)object).putClientProperty("Aqua.componentColors", AquaColors.CELL_TEXT_COLORS);
        }
        if (this.isInset() && ((Component)object).isOpaque() && object instanceof JComponent) {
            JComponent jComponent = (JComponent)object;
            AquaUtils.setOpaqueCarefully(jComponent, false);
        }
        this.rendererPane.paintComponent(graphics, (Component)object, this.list, n3, n4, n5, n6, true);
        if (object instanceof JTextComponent) {
            ((JTextComponent)object).putClientProperty("Aqua.componentColors", null);
        }
    }

    private void paintDropLine(Graphics graphics, @NotNull JList.DropLocation dropLocation, @NotNull Color color) {
        this.layoutOrientation = this.list.getLayoutOrientation();
        this.isLeftToRight = this.list.getComponentOrientation().isLeftToRight();
        graphics.setColor(color);
        Rectangle rectangle = this.getDropLineRect(dropLocation);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private Rectangle getDropLineRect(JList.DropLocation dropLocation) {
        Rectangle rectangle;
        int n = this.list.getModel().getSize();
        if (n == 0) {
            Insets insets = this.list.getInsets();
            if (this.layoutOrientation == 2) {
                if (this.isLeftToRight) {
                    return new Rectangle(insets.left, insets.top, 2, 20);
                }
                return new Rectangle(this.list.getWidth() - 2 - insets.right, insets.top, 2, 20);
            }
            return new Rectangle(insets.left, insets.top, this.list.getWidth() - insets.left - insets.right, 2);
        }
        int n2 = dropLocation.getIndex();
        boolean bl = false;
        if (this.layoutOrientation == 2) {
            if (n2 == n) {
                bl = true;
            } else if (n2 != 0) {
                Rectangle rectangle2 = this.getCellBounds(n2 - 1);
                Rectangle rectangle3 = this.getCellBounds(n2);
                if (rectangle2.y != rectangle3.y) {
                    Point point = dropLocation.getDropPoint();
                    if (this.isLeftToRight) {
                        bl = Point2D.distance(rectangle2.x + rectangle2.width, rectangle2.y + (int)((double)rectangle2.height / 2.0), point.x, point.y) < Point2D.distance(rectangle3.x, rectangle3.y + (int)((double)rectangle3.height / 2.0), point.x, point.y);
                    } else {
                        boolean bl2 = bl = Point2D.distance(rectangle2.x, rectangle2.y + (int)((double)rectangle2.height / 2.0), point.x, point.y) < Point2D.distance(rectangle3.x + rectangle3.width, rectangle3.y + (int)((double)rectangle2.height / 2.0), point.x, point.y);
                    }
                }
            }
            if (bl) {
                rectangle = this.getCellBounds(--n2);
                rectangle.x = this.isLeftToRight ? (rectangle.x += rectangle.width) : (rectangle.x -= 2);
            } else {
                rectangle = this.getCellBounds(n2);
                if (!this.isLeftToRight) {
                    rectangle.x += rectangle.width - 2;
                }
            }
            if (rectangle.x >= this.list.getWidth()) {
                rectangle.x = this.list.getWidth() - 2;
            } else if (rectangle.x < 0) {
                rectangle.x = 0;
            }
            rectangle.width = 2;
        } else if (this.layoutOrientation == 1) {
            if (n2 == n) {
                rectangle = this.getCellBounds(--n2);
                rectangle.y += rectangle.height;
            } else if (n2 != 0) {
                Rectangle rectangle4 = this.getCellBounds(n2 - 1);
                Rectangle rectangle5 = this.getCellBounds(n2);
                if (rectangle4.x != rectangle5.x) {
                    Point point = dropLocation.getDropPoint();
                    if (Point2D.distance(rectangle4.x + (int)((double)rectangle4.width / 2.0), rectangle4.y + rectangle4.height, point.x, point.y) < Point2D.distance(rectangle5.x + (int)((double)rectangle5.width / 2.0), rectangle5.y, point.x, point.y)) {
                        rectangle = this.getCellBounds(--n2);
                        rectangle.y += rectangle.height;
                    } else {
                        rectangle = this.getCellBounds(n2);
                    }
                } else {
                    rectangle = this.getCellBounds(n2);
                }
            } else {
                rectangle = this.getCellBounds(n2);
            }
            if (rectangle.y >= this.list.getHeight()) {
                rectangle.y = this.list.getHeight() - 2;
            }
            rectangle.height = 2;
        } else {
            if (n2 == n) {
                rectangle = this.getCellBounds(--n2);
                rectangle.y += rectangle.height;
            } else {
                rectangle = this.getCellBounds(n2);
            }
            if (rectangle.y >= this.list.getHeight()) {
                rectangle.y = this.list.getHeight() - 2;
            }
            rectangle.height = 2;
        }
        return rectangle;
    }

    private Rectangle getCellBounds(int n) {
        return this.getCellBounds(this.list, n, n);
    }

    protected class FocusHandler
    implements FocusListener {
        protected FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.focusChanged();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.focusChanged();
        }

        private void focusChanged() {
            AquaListUI.this.configureAppearanceContext(null);
        }
    }

    static class AquaHomeEndAction
    extends AbstractAction {
        private boolean fHomeAction;

        protected AquaHomeEndAction(boolean bl) {
            this.fHomeAction = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JList jList = (JList)actionEvent.getSource();
            if (this.fHomeAction) {
                jList.ensureIndexIsVisible(0);
            } else {
                int n = jList.getModel().getSize();
                jList.ensureIndexIsVisible(n - 1);
            }
        }
    }

    class AquaPropertyChangeHandler
    extends BasicListUI.PropertyChangeHandler {
        AquaPropertyChangeHandler() {
            super(AquaListUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("enabled".equals(string)) {
                AquaListUI.this.configureAppearanceContext(null);
            } else if ("Aqua.displayAsFocused".equals(string)) {
                AquaListUI.this.configureAppearanceContext(null);
            } else {
                if (AquaListUI.this.isStyleProperty(string)) {
                    AquaListUI.this.updateStyleProperties();
                } else if ("layoutOrientation".equals(string)) {
                    AquaListUI.this.updateStriped();
                } else if (AquaListUI.this.isViewStyleProperty(string)) {
                    AquaListUI.this.updateInset();
                } else if ("ancestor".equals(string)) {
                    AquaListUI.this.updateSideBarConfiguration();
                } else if ("transferHandler".equals(string)) {
                    AquaListUI.this.configureDropTargetListener();
                } else if ("dropLocation".equals(string) && AquaListUI.this.hasSelection) {
                    AquaListUI.this.list.repaint();
                }
                super.propertyChange(propertyChangeEvent);
            }
        }
    }

    protected class MyDropTargetListener
    implements DropTargetListener {
        protected MyDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            AquaListUI.this.isDropActive = true;
            AquaListUI.this.repaintDropTarget();
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
            AquaListUI.this.isDropActive = false;
            AquaListUI.this.repaintDropTarget();
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            AquaListUI.this.isDropActive = false;
            AquaListUI.this.repaintDropTarget();
        }
    }

    protected class ListVibrantEffects
    extends VisualEffectView {
        @Nullable
        protected ListSelectionBoundsTracker bt;
        protected final int style;

        public ListVibrantEffects(final JComponent jComponent, int n) {
            super(jComponent, n, true);
            this.style = n;
            this.bt = new ListSelectionBoundsTracker(this, AquaListUI.this.list, this::updateSelectionBackgrounds){
                final /* synthetic */ ListVibrantEffects this$1;
                {
                    this.this$1 = listVibrantEffects;
                    super(jList, consumer);
                }

                @Override
                protected int convertRowYCoordinateToSelectionDescription(int n) {
                    if (jComponent != this.list) {
                        Point point = SwingUtilities.convertPoint(this.list, 0, n, jComponent);
                        return point.y;
                    }
                    return n;
                }
            };
        }

        public void update() {
            if (this.bt != null) {
                this.bt.update();
            }
        }

        @Override
        public void dispose() {
            super.dispose();
            if (this.bt != null) {
                this.bt.dispose();
                this.bt = null;
            }
        }

        @Override
        protected void windowChanged(Window window) {
            super.windowChanged(window);
            if (this.bt != null) {
                this.bt.reset();
            }
        }
    }
}

