/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.plaf.ComponentUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaComboBoxPopup;
import org.violetlib.aqua.AquaListUI;
import org.violetlib.aqua.AquaPopupMenuUI;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.BasicContextualColors;
import org.violetlib.aqua.ContainerContextualColors;
import org.violetlib.aqua.DelegatedContainerContextualColors;
import org.violetlib.aqua.OSXSystemProperties;

public class AquaComboBoxPopupMenuUI
extends AquaPopupMenuUI {
    @Nullable
    protected ContainerContextualColors colorsForList;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaComboBoxPopupMenuUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (jComponent instanceof AquaComboBoxPopup) {
            AquaComboBoxPopup aquaComboBoxPopup = (AquaComboBoxPopup)jComponent;
            aquaComboBoxPopup.updateContents(false);
        }
    }

    @Override
    @NotNull
    protected BasicContextualColors getMenuColors(Component component) {
        JComboBox jComboBox;
        if (component instanceof JComboBox && (jComboBox = (JComboBox)component).isEditable()) {
            return AquaColors.getComboBoxMenuColors();
        }
        return super.getMenuColors(component);
    }

    @Override
    protected boolean isVibrantSelectionSupportNeeded(Component component) {
        return false;
    }

    @Override
    protected int getContextualMenuStyle(Component component) {
        JComboBox jComboBox;
        if (component instanceof JComboBox && (jComboBox = (JComboBox)component).isEditable()) {
            return OSXSystemProperties.OSVersion >= 1014 ? 1 : 0;
        }
        return super.getContextualMenuStyle(component);
    }

    public void configure(@NotNull JComboBox<?> jComboBox, @NotNull JList<?> jList) {
        AquaListUI aquaListUI;
        if (this.colorsForList == null) {
            this.colorsForList = new DelegatedContainerContextualColors(this.getMenuColors(jComboBox));
        }
        if ((aquaListUI = AquaUtils.getUI(jList, AquaListUI.class)) != null) {
            aquaListUI.configureAsMenu(!jComboBox.isEditable());
            aquaListUI.setColors(this.colorsForList);
            jList.putClientProperty("JList.viewStyle", "inset");
        }
    }
}

