/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaButtonIcon;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaLookAndFeel;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.jnr.aqua.AquaUIPainter;

public class AquaButtonSupport {
    private static final AquaButtonIcon.ImageOperatorSupplier keySupplier = new MyImageOperatorSupplier();

    @NotNull
    public static AquaButtonIcon createIcon(@NotNull AbstractButton abstractButton) {
        boolean bl = AquaButtonSupport.determineTemplateIconStatus(abstractButton);
        return new AquaButtonIcon(abstractButton, bl, keySupplier);
    }

    @NotNull
    public static AquaUIPainter.State getState(@NotNull AbstractButton abstractButton) {
        boolean bl = AquaFocusHandler.isActive(abstractButton);
        if (!abstractButton.isEnabled()) {
            return bl ? AquaUIPainter.State.DISABLED : AquaUIPainter.State.DISABLED_INACTIVE;
        }
        if (!bl) {
            return AquaUIPainter.State.INACTIVE;
        }
        ButtonModel buttonModel = abstractButton.getModel();
        if (buttonModel.isArmed() && buttonModel.isPressed()) {
            return AquaButtonSupport.getPressedState(abstractButton);
        }
        if (abstractButton.isRolloverEnabled() && AquaButtonSupport.isRollover(abstractButton)) {
            return AquaUIPainter.State.ROLLOVER;
        }
        return AquaButtonSupport.getActiveState(abstractButton);
    }

    @NotNull
    public static AquaUIPainter.State getActiveState(@NotNull AbstractButton abstractButton) {
        return abstractButton instanceof JButton && ((JButton)abstractButton).isDefaultButton() ? AquaUIPainter.State.ACTIVE_DEFAULT : AquaUIPainter.State.ACTIVE;
    }

    @NotNull
    public static AquaUIPainter.State getPressedState(@NotNull AbstractButton abstractButton) {
        return abstractButton instanceof JButton && ((JButton)abstractButton).isDefaultButton() ? AquaUIPainter.State.PRESSED_DEFAULT : AquaUIPainter.State.PRESSED;
    }

    private static boolean isRollover(@NotNull AbstractButton abstractButton) {
        ButtonModel buttonModel = abstractButton.getModel();
        return buttonModel.isRollover();
    }

    public static boolean determineTemplateIconStatus(AbstractButton abstractButton) {
        Icon icon = abstractButton.getIcon();
        if (icon instanceof ImageIcon) {
            ImageIcon imageIcon = (ImageIcon)icon;
            Image image = imageIcon.getImage();
            return !AquaButtonSupport.isApplicationDefined(abstractButton.getPressedIcon()) && !AquaButtonSupport.isApplicationDefined(AquaButtonSupport.getDisabledIcon(abstractButton)) && !AquaButtonSupport.isApplicationDefined(abstractButton.getSelectedIcon()) && !AquaButtonSupport.isApplicationDefined(AquaButtonSupport.getDisabledSelectedIcon(abstractButton)) && !AquaButtonSupport.isApplicationDefined(abstractButton.getRolloverIcon()) && !AquaButtonSupport.isApplicationDefined(abstractButton.getRolloverSelectedIcon()) && AquaImageFactory.isTemplateImage(image);
        }
        return false;
    }

    private static boolean isApplicationDefined(Icon icon) {
        return icon != null && !(icon instanceof UIResource);
    }

    public static Icon getDisabledIcon(AbstractButton abstractButton) {
        boolean bl = AquaLookAndFeel.suppressCreationOfDisabledButtonIcons;
        AquaLookAndFeel.suppressCreationOfDisabledButtonIcons = true;
        try {
            Icon icon = abstractButton.getDisabledIcon();
            return icon;
        }
        finally {
            AquaLookAndFeel.suppressCreationOfDisabledButtonIcons = bl;
        }
    }

    public static Icon getDisabledSelectedIcon(AbstractButton abstractButton) {
        boolean bl = AquaLookAndFeel.suppressCreationOfDisabledButtonIcons;
        AquaLookAndFeel.suppressCreationOfDisabledButtonIcons = true;
        try {
            Icon icon = abstractButton.getDisabledSelectedIcon();
            return icon;
        }
        finally {
            AquaLookAndFeel.suppressCreationOfDisabledButtonIcons = bl;
        }
    }

    @Nullable
    public static Dimension getPreferredButtonSize(@NotNull AbstractButton abstractButton, int n, @Nullable Dimension dimension) {
        Object object;
        if (abstractButton.getComponentCount() > 0) {
            return null;
        }
        if (dimension == null && (object = abstractButton.getIcon()) != null) {
            dimension = new Dimension(object.getIconWidth(), object.getIconHeight());
        }
        object = abstractButton.getText();
        Font font = abstractButton.getFont();
        FontMetrics fontMetrics = abstractButton.getFontMetrics(font);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        AquaUtils.layoutCompoundLabel(abstractButton, fontMetrics, (String)object, dimension, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle3, rectangle, rectangle2, object == null ? 0 : n);
        Rectangle rectangle4 = rectangle.union(rectangle2);
        Insets insets = abstractButton.getInsets();
        rectangle4.width += insets.left + insets.right;
        rectangle4.height += insets.top + insets.bottom;
        return rectangle4.getSize();
    }

    public static Dimension getPreferredContentSize(AbstractButton abstractButton, Font font, int n) {
        Icon icon = abstractButton.getIcon();
        Dimension dimension = icon != null ? new Dimension(icon.getIconWidth(), icon.getIconHeight()) : null;
        String string = abstractButton.getText();
        FontMetrics fontMetrics = abstractButton.getFontMetrics(font);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        AquaUtils.layoutCompoundLabel(abstractButton, fontMetrics, string, dimension, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle3, rectangle, rectangle2, string == null ? 0 : n);
        Rectangle rectangle4 = rectangle.union(rectangle2);
        return rectangle4.getSize();
    }

    private static boolean shouldUseDisabledIcon(@NotNull AquaUIPainter.State state) {
        return state == AquaUIPainter.State.DISABLED || state == AquaUIPainter.State.DISABLED_INACTIVE;
    }

    private static class MyImageOperatorSupplier
    implements AquaButtonIcon.ImageOperatorSupplier {
        private MyImageOperatorSupplier() {
        }

        @Override
        @Nullable
        public Object getCurrentImageProcessingOperator(@NotNull AbstractButton abstractButton, boolean bl) {
            AquaUIPainter.State state = AquaButtonSupport.getState(abstractButton);
            if (state == AquaUIPainter.State.PRESSED) {
                AquaAppearance aquaAppearance = AppearanceManager.ensureAppearance(abstractButton);
                return aquaAppearance.isDark() ? AquaImageFactory.LIGHTEN_FOR_DISABLED : AquaImageFactory.DARKEN_FOR_PRESSED;
            }
            if (AquaButtonSupport.shouldUseDisabledIcon(state)) {
                AquaAppearance aquaAppearance = AppearanceManager.ensureAppearance(abstractButton);
                return aquaAppearance.isDark() ? AquaImageFactory.DARKEN_FOR_PRESSED : AquaImageFactory.LIGHTEN_FOR_DISABLED;
            }
            return null;
        }
    }
}

