/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.impl.JNR8MultiResolutionImage;
import org.violetlib.jnr.impl.JavaSupport;

public class Java8Support
implements JavaSupport.JavaSupportImpl {
    @NotNull
    private static final WeakHashMap<Graphics, Integer> scaleMap = new WeakHashMap();

    @Override
    public int getScaleFactor(@NotNull Graphics g) {
        int scaleFactor;
        Integer n = scaleMap.get(g);
        if (n != null) {
            return n;
        }
        if (g instanceof Graphics2D) {
            Graphics2D gg = (Graphics2D)g;
            GraphicsConfiguration gc = gg.getDeviceConfiguration();
            scaleFactor = Java8Support.getScaleFactor(gc);
        } else {
            scaleFactor = 1;
        }
        scaleMap.put(g, scaleFactor);
        return scaleFactor;
    }

    private static int getScaleFactor(@NotNull GraphicsConfiguration gc) {
        GraphicsDevice device = gc.getDevice();
        Object scale = null;
        try {
            Field field = device.getClass().getDeclaredField("scale");
            if (field != null) {
                field.setAccessible(true);
                scale = field.get(device);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (scale instanceof Integer) {
            return (Integer)scale;
        }
        return 1;
    }

    @Override
    public Image createMultiResolutionImage(int baseImageWidth, int baseImageHeight, @NotNull BufferedImage im) {
        return new JNR8MultiResolutionImage(baseImageWidth, baseImageHeight, im);
    }
}

