/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.impl.Insetter1;
import org.violetlib.jnr.impl.NonInvertibleInsetterBase;

public class CenteredInsetter1
extends NonInvertibleInsetterBase
implements Insetter1 {
    private final float regionSize;
    private final float alignmentRegionSize;
    private final float offset;

    @NotNull
    public static CenteredInsetter1 createCentered(float regionSize) {
        if (regionSize < 0.0f) {
            throw new IllegalArgumentException("Invalid negative region size");
        }
        return new CenteredInsetter1(regionSize, regionSize, 0.0f);
    }

    @NotNull
    public static CenteredInsetter1 createCentered(float regionSize, float offset) {
        if (regionSize < 0.0f) {
            throw new IllegalArgumentException("Invalid negative region size");
        }
        return new CenteredInsetter1(regionSize, regionSize, offset);
    }

    @NotNull
    public static CenteredInsetter1 createCentered(float regionSize, float alignmentRegionSize, float offset) {
        if (regionSize < 0.0f) {
            throw new IllegalArgumentException("Invalid negative region size");
        }
        return new CenteredInsetter1(regionSize, alignmentRegionSize, offset);
    }

    private CenteredInsetter1(float regionSize, float alignmentRegionSize, float offset) {
        this.regionSize = regionSize;
        this.alignmentRegionSize = alignmentRegionSize;
        this.offset = offset;
    }

    @Override
    public float getRegionOrigin(float componentSize) {
        float inset = (componentSize - this.alignmentRegionSize) / 2.0f;
        return inset + this.offset;
    }

    @Override
    public float getRegionSize(float componentSize) {
        return this.regionSize;
    }

    @Override
    public float getFixedRegionSize() {
        return this.regionSize;
    }
}

