/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jetbrains.annotations.NotNull;

public class BasicImageSupport {
    @NotNull
    private static final ColorModel colorModel = BasicImageSupport.createColorModel();

    @NotNull
    public static ColorModel getColorModel() {
        return colorModel;
    }

    @NotNull
    public static BufferedImage createImage(@NotNull int[] buffer, int w, int h) {
        return BasicImageSupport.createImage(buffer, w, h, w);
    }

    @NotNull
    public static BufferedImage createImage(@NotNull int[] buffer, int w, int h, int scan) {
        return BasicImageSupport.createBufferedImage(colorModel, buffer, w, h, scan);
    }

    @NotNull
    private static ColorModel createColorModel() {
        return new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, true, 3);
    }

    @NotNull
    private static BufferedImage createBufferedImage(@NotNull ColorModel cm, @NotNull int[] buffer, int w, int h, int scan) {
        DataBufferInt db = new DataBufferInt(buffer, buffer.length);
        int[] bandMasks = new int[]{0xFF0000, 65280, 255, -16777216};
        WritableRaster r = Raster.createPackedRaster(db, w, h, scan, bandMasks, null);
        return new BufferedImage(cm, r, true, null);
    }
}

