/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.impl.Colors;
import org.violetlib.jnr.impl.JNRPlatformUtils;
import org.violetlib.vappearances.VAppearance;

public class SliderCircularIndicatorPainter {
    protected final double x;
    protected final double y;
    protected final double radius;
    protected final double zeroAngle;
    protected final double p;
    @NotNull
    protected final Colors colors;

    public SliderCircularIndicatorPainter(double x, double y, double radius, double zeroAngle, double p, @Nullable VAppearance appearance) {
        this.x = x;
        this.y = y;
        this.radius = radius;
        this.zeroAngle = zeroAngle;
        this.p = p;
        this.colors = Colors.getColors(appearance);
    }

    public void paint(@NotNull Graphics2D g) {
        int platformVersion;
        double d = 6.0;
        double angle = this.zeroAngle - this.p * 2.0 * Math.PI;
        double x0 = this.x + Math.cos(angle) * this.radius;
        double y0 = this.y - Math.sin(angle) * this.radius;
        Ellipse2D.Double s = new Ellipse2D.Double(x0 - d / 2.0, y0 - d / 2.0, d, d);
        g.setColor(this.colors.get("circularSliderDimple"));
        g.fill(s);
        Color top = this.colors.getOptional("circularSliderDimpleTop");
        if (top != null && (platformVersion = JNRPlatformUtils.getPlatformVersion()) < 101400) {
            s = new Ellipse2D.Double(x0 - d / 4.0, y0 - d / 2.0, d / 2.0, d / 2.0);
            g.setColor(top);
            g.fill(s);
        }
    }
}

