/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.impl.BigSurLayoutInfo;
import org.violetlib.jnr.impl.BasicLayoutInfo;
import org.violetlib.jnr.impl.Insetters;
import org.violetlib.jnr.impl.JNRUtils;

public class MontereyLayoutInfo
extends BigSurLayoutInfo {
    @Override
    @NotNull
    protected LayoutInfo getButtonLayoutInfo(@NotNull ButtonLayoutConfiguration g) {
        AquaUIPainter.ButtonWidget bw = g.getButtonWidget();
        AquaUIPainter.Size sz = g.getSize();
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_BEVEL_ROUND) {
            switch (sz) {
                case LARGE: {
                    return BasicLayoutInfo.createMinimum(18.0f, 30.0f);
                }
                case REGULAR: {
                    return BasicLayoutInfo.createMinimum(18.0f, 22.0f);
                }
                case SMALL: {
                    return BasicLayoutInfo.createMinimum(14.0f, 18.0f);
                }
                case MINI: {
                    return BasicLayoutInfo.createMinimum(14.0f, 16.0f);
                }
            }
            throw new UnsupportedOperationException("Unsupported size");
        }
        return super.getButtonLayoutInfo(g);
    }

    @Override
    @Nullable
    public Insetter getButtonLabelInsets(@NotNull ButtonLayoutConfiguration g) {
        AquaUIPainter.ButtonWidget bw = g.getButtonWidget();
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_BEVEL_ROUND) {
            AquaUIPainter.Size sz = g.getSize();
            float top = JNRUtils.size(sz, 2, 2, 1, 1);
            float bottom = 2.0f;
            float side = JNRUtils.size(sz, 4, 4, 4, 3);
            LayoutInfo layoutInfo = this.getLayoutInfo(g);
            return Insetters.createFixed(top, side, bottom, side, layoutInfo);
        }
        return super.getButtonLabelInsets(g);
    }
}

